/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.BaseUtils;
import com.fr.base.GraphHelper;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Repository;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class GisMapPlotGlyph
extends PlotGlyph {
    private static final long serialVersionUID = -1382651172653550801L;
    private boolean gisType;
    private boolean addressType;
    private String googleKey = "";
    private String baiduKey = "";
    private String id4div = null;

    protected boolean skipDealPointHotAttr(DataPoint dataPoint) {
        return false;
    }

    public void draw(Graphics graphics, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        BufferedImage bufferedImage = BaseUtils.readImage((String)this.getImagePath());
        Rectangle2D rectangle2D = this.getBounds();
        double d = rectangle2D.getWidth();
        double d2 = rectangle2D.getHeight();
        GraphHelper.paintImage((Graphics)graphics2D, (int)((int)d), (int)((int)d2), (Image)bufferedImage, (int)4, (int)-1, (int)-1, (int)-1, (int)-1);
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
    }

    public String getImagePath() {
        return "/com/fr/chart/chartglyph/gisMap.png";
    }

    public void layoutAxisGlyph(int n) {
    }

    public void layoutDataSeriesGlyph(int n) {
    }

    public String getPlotGlyphType() {
        return "GisMapPlotGlyph";
    }

    public String getPlotDetailType() {
        if (this.gisType) {
            return "BaiduGisMapPlotGlyph";
        }
        return "GoogleGisMapPlotGlyph";
    }

    public void setAddressType(boolean bl) {
        this.addressType = bl;
    }

    public void setGisType(boolean bl) {
        this.gisType = bl;
    }

    public String getBaiduKey() {
        return this.baiduKey;
    }

    public void setBaiduKey(String string) {
        this.baiduKey = string;
    }

    public String getGoogleKey() {
        return this.googleKey;
    }

    public void setGoogleKey(String string) {
        this.googleKey = string;
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        jSONObject.put("gisType", this.gisType);
        jSONObject.put("addressType", this.addressType);
        String string = this.gisType ? this.baiduKey : this.googleKey;
        jSONObject.put("key", (Object)string);
        return jSONObject;
    }

    public boolean equals(Object object) {
        return object instanceof GisMapPlotGlyph && ((GisMapPlotGlyph)object).addressType == this.addressType && ((GisMapPlotGlyph)object).gisType == this.gisType && super.equals(object);
    }

    public String getChartType() {
        return "GisMap";
    }

    public boolean isSupportLegend() {
        return false;
    }
}

