/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.ScreenResolution;
import com.fr.chart.base.AttrContents;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataPoint4Funnel;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.chart.chartglyph.ShapeGlyph;
import com.fr.chart.chartglyph.TextGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.stable.StringUtils;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.List;

public class FunnelPlotGlyph
extends PlotGlyph {
    private static final double TOP_BOTTOM_GAP = 0.1;
    private static final double LEFT_RIGHT_GAP = 0.05;
    private static final double LABEL_GAP = 0.06;
    private static final double LEAD_LINE_GAP = 0.01;
    private static final double MAX_LABEL_WIDTH = 0.46;
    private static final double LABEL_VALUE_GAP = 0.02;
    private static final double SERIES_GAP = 1.0;
    private double[] seriesX;
    private double[] seriesY;
    private double[] seriesHeight;
    private double[] seriesWidth;
    private double labelWidth = 0.0;
    private double labelX = 0.0;
    private Point originalPoint;
    private boolean isShowLabel = true;

    private double getTotalValue(int n) {
        double d = 0.0;
        int n2 = this.getSeriesSize();
        for (int i = 0; i < n2; ++i) {
            DataSeries dataSeries = this.getSeries(i);
            DataPoint4Funnel dataPoint4Funnel = (DataPoint4Funnel)dataSeries.getDataPoint(n);
            d += Math.abs(dataPoint4Funnel.getValue());
        }
        return d;
    }

    private double getTotalHeight(int n) {
        double d = 0.0;
        for (int i = 1; i < this.getSeriesSize(); ++i) {
            DataPoint4Funnel dataPoint4Funnel = (DataPoint4Funnel)this.getSeries(i - 1).getDataPoint(n);
            DataPoint4Funnel dataPoint4Funnel2 = (DataPoint4Funnel)this.getSeries(i).getDataPoint(n);
            d += Math.abs(dataPoint4Funnel.getValue() - dataPoint4Funnel2.getValue());
        }
        return d;
    }

    private void initSeriesHeight(int n) {
        double d = this.getTotalHeight(n);
        double d2 = this.getBounds().getHeight() * 0.8;
        this.seriesHeight = new double[this.getSeriesSize()];
        this.seriesHeight[0] = 0.0;
        for (int i = 1; i < this.getSeriesSize(); ++i) {
            DataPoint4Funnel dataPoint4Funnel = (DataPoint4Funnel)this.getSeries(i - 1).getDataPoint(n);
            DataPoint4Funnel dataPoint4Funnel2 = (DataPoint4Funnel)this.getSeries(i).getDataPoint(n);
            this.seriesHeight[i] = Math.abs(dataPoint4Funnel.getValue() - dataPoint4Funnel2.getValue()) / d * d2;
        }
    }

    private void initSeriesWidth(int n) {
        double d = this.getBounds().getWidth() * 0.8200000000000001 - this.labelWidth;
        if (!this.isShowLabel) {
            d = this.getBounds().getWidth() * 0.9;
        }
        this.seriesWidth = new double[this.getSeriesSize()];
        DataPoint4Funnel dataPoint4Funnel = (DataPoint4Funnel)this.getSeries(0).getDataPoint(n);
        double d2 = this.getMaxValue(n);
        for (int i = 0; i < this.getSeriesSize(); ++i) {
            DataPoint4Funnel dataPoint4Funnel2 = (DataPoint4Funnel)this.getSeries(i).getDataPoint(n);
            this.seriesWidth[i] = Math.abs(dataPoint4Funnel2.getValue()) / d2 * d;
        }
    }

    private double getMaxValue(int n) {
        double d = Double.MIN_VALUE;
        for (int i = 0; i < this.getSeriesSize(); ++i) {
            DataSeries dataSeries = this.getSeries(i);
            d = Math.max(Math.abs(dataSeries.getDataPoint(n).getValue()), d);
        }
        return d;
    }

    private double getMaxSeriesWidth() {
        double d = 0.0;
        for (int i = 0; i < this.seriesWidth.length; ++i) {
            d = Math.max(d, this.seriesWidth[i]);
        }
        return d;
    }

    private void calculateOriginalPoint() {
        int n = (int)(this.getBounds().getWidth() * 0.05 + this.getMaxSeriesWidth() / 2.0);
        int n2 = (int)(this.getBounds().getHeight() * 0.1);
        this.originalPoint = new Point(n, n2);
    }

    private void calculateSeriesXY() {
        this.seriesX = new double[this.getSeriesSize()];
        this.seriesY = new double[this.getSeriesSize()];
        this.calculateOriginalPoint();
        double d = 0.0;
        for (int i = 0; i < this.getSeriesSize(); ++i) {
            this.seriesX[i] = this.originalPoint.getX() - this.seriesWidth[i] / 2.0;
            this.seriesY[i] = this.originalPoint.getY() + (d += this.seriesHeight[i]);
        }
    }

    private void initSeriesBounds(int n) {
        this.initSeriesHeight(n);
        this.initSeriesWidth(n);
        this.calculateSeriesXY();
    }

    private void calculateLabelWidth(int n, int n2) {
        TextGlyph textGlyph;
        DataPoint4Funnel dataPoint4Funnel;
        int n3;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = this.getBounds().getWidth() * 0.46;
        double d4 = this.getBounds().getWidth() * 0.02;
        for (n3 = 0; n3 < this.getSeriesSize(); ++n3) {
            dataPoint4Funnel = (DataPoint4Funnel)this.getSeries(n3).getDataPoint(n);
            textGlyph = dataPoint4Funnel.getDataLabel();
            if (textGlyph == null) {
                this.labelWidth = 0.0;
                this.isShowLabel = false;
                return;
            }
            dataPoint4Funnel.setValueGap(d4);
            String[] stringArray = dataPoint4Funnel.getSeriesValueString();
            TextAttr textAttr = textGlyph.getTextAttr();
            Dimension2D dimension2D = null;
            Dimension2D dimension2D2 = null;
            if (stringArray != null) {
                if (stringArray[0] != null && !StringUtils.isEmpty((String)stringArray[0])) {
                    dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation(stringArray[0], textAttr, n2);
                }
                if (stringArray[1] != null && !StringUtils.isEmpty((String)stringArray[1])) {
                    dimension2D2 = GlyphUtils.calculateTextDimensionWithNoRotation(stringArray[1], textAttr, n2);
                }
            }
            if (dimension2D != null && dimension2D.getWidth() > d) {
                d = dimension2D.getWidth();
            }
            if (dimension2D2 == null || !(dimension2D2.getWidth() > d2)) continue;
            d2 = dimension2D2.getWidth();
        }
        for (n3 = 0; n3 < this.getSeriesSize(); ++n3) {
            dataPoint4Funnel = (DataPoint4Funnel)this.getSeries(n3).getDataPoint(n);
            textGlyph = dataPoint4Funnel.getDataLabel();
            if (textGlyph == null) continue;
            dataPoint4Funnel.setValueWidth(d2);
        }
        this.labelWidth = Math.min(d + d2 + d4, d3);
        this.labelX = this.getBounds().getWidth() * 0.95 - this.labelWidth;
    }

    public void layoutAxisGlyph(int n) {
    }

    protected void initLabelData(int n, int n2) {
        this.calculateLabelWidth(n, n2);
    }

    public void layoutDataSeriesGlyph(int n) {
        for (int i = 0; i < this.getCategoryCount(); ++i) {
            this.deal4EachCategory(i, n);
        }
        this.dealLabelBoundsInOrder();
    }

    private int indexOfDataPoint(DataPoint dataPoint) {
        int n = this.getSeriesSize();
        for (int i = 0; i < n; ++i) {
            DataSeries dataSeries = this.getSeries(i);
            if (!ComparatorUtils.equals((Object)dataPoint, (Object)dataSeries.getDataPoint(0))) continue;
            return i;
        }
        return 0;
    }

    protected void dealLabelBoundsOutPlotBounds(Rectangle2D rectangle2D, GeneralPath generalPath, DataPoint dataPoint, List list, int n) {
        String string;
        double d;
        int n2;
        DataPoint4Funnel dataPoint4Funnel = (DataPoint4Funnel)dataPoint;
        if (!dataPoint4Funnel.isShowLabel()) {
            return;
        }
        if (dataPoint.getDataLabel() == null || StringUtils.isEmpty((String)dataPoint.getDataLabel().text)) {
            return;
        }
        if (rectangle2D.getX() >= this.getBounds().getX() && rectangle2D.getMaxX() <= this.getBounds().getMaxX()) {
            return;
        }
        double d2 = rectangle2D.getWidth();
        if (rectangle2D.getX() < this.getBounds().getX()) {
            d2 = rectangle2D.getMaxX() - this.getBounds().getX();
        } else if (rectangle2D.getMaxX() > this.getBounds().getMaxX()) {
            d2 = this.getBounds().getMaxX() - rectangle2D.getX();
        }
        AttrContents attrContents = (AttrContents)this.getConditionCollection().getDataSeriesCondition(AttrContents.class, dataPoint, null);
        TextAttr textAttr = attrContents.getTextAttr();
        String string2 = dataPoint4Funnel.getDataLabel().getText();
        int n3 = ScreenResolution.getScreenResolution();
        for (n2 = 0; n2 < string2.length() && !((d = GlyphUtils.calculateTextDimensionWithNoRotation(string = string2.substring(0, n2) + "\u2026", textAttr, n3).getWidth()) > d2); ++n2) {
        }
        if (n2 == 0) {
            dataPoint4Funnel.setShowText("\u2026");
        } else {
            dataPoint4Funnel.setShowText(string2.substring(0, n2 - 1) + "\u2026");
        }
        double d3 = GlyphUtils.calculateTextDimensionWithNoRotation(dataPoint4Funnel.getShowText(), textAttr, n3).getWidth();
        if (rectangle2D.getX() < this.getBounds().getX()) {
            rectangle2D.setRect(this.getBounds().getX(), rectangle2D.getY(), d3, rectangle2D.getHeight());
        } else {
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), d3, rectangle2D.getHeight());
        }
        dataPoint4Funnel.getDataLabel().setBounds(rectangle2D);
    }

    protected void deal4EachCategory(int n, int n2) {
        this.initLabelData(n, n2);
        this.initSeriesBounds(n);
        this.dealLabelBounds(n, n2);
        this.dealWithDataSeries(n, n2);
    }

    protected void dealWithDataSeries(int n, int n2) {
        int n3 = this.getSeriesSize();
        for (int i = 0; i < n3; ++i) {
            DataSeries dataSeries = this.getSeries(i);
            DataPoint4Funnel dataPoint4Funnel = (DataPoint4Funnel)dataSeries.getDataPoint(n);
            DataPoint4Funnel dataPoint4Funnel2 = i > 0 ? (DataPoint4Funnel)this.getSeries(i - 1).getDataPoint(n) : dataPoint4Funnel;
            if (dataPoint4Funnel.isValueIsNull()) continue;
            ShapeGlyph shapeGlyph = this.calculateShapeGlyph4DifferentSub(dataPoint4Funnel2, dataPoint4Funnel);
            dataPoint4Funnel.setDrawImpl(shapeGlyph);
        }
    }

    private ShapeGlyph calculateShapeGlyph4DifferentSub(DataPoint dataPoint, DataPoint dataPoint2) {
        int n;
        GeneralPath generalPath = new GeneralPath();
        int n2 = this.indexOfDataPoint(dataPoint);
        if (n2 != (n = this.indexOfDataPoint(dataPoint2))) {
            generalPath.moveTo(this.seriesX[n2], this.seriesY[n2] + 1.0);
            generalPath.lineTo(this.seriesX[n2] + this.seriesWidth[n2], this.seriesY[n2] + 1.0);
            generalPath.lineTo(this.seriesX[n] + this.seriesWidth[n], this.seriesY[n] - 1.0);
            generalPath.lineTo(this.seriesX[n], this.seriesY[n] - 1.0);
            generalPath.closePath();
        }
        ShapeGlyph shapeGlyph = new ShapeGlyph(generalPath);
        shapeGlyph.dealCondition(this.getConditionCollection(), dataPoint2, this.createColors4Series());
        return shapeGlyph;
    }

    protected boolean isGuideLineShow(DataPoint dataPoint) {
        TextGlyph textGlyph = dataPoint.getDataLabel();
        if (textGlyph == null) {
            return false;
        }
        AttrContents attrContents = (AttrContents)this.getConditionCollection().getDataSeriesCondition(AttrContents.class, dataPoint, null);
        String string = textGlyph.getText();
        return string != null && attrContents.isShowGuidLine() && textGlyph.getBounds() != null;
    }

    private boolean isCoverLabelBounds(GeneralPath generalPath, Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            return false;
        }
        if (!generalPath.intersects(rectangle2D)) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth() + 2.0, rectangle2D.getHeight());
            generalPath.append(double_, false);
            return false;
        }
        return true;
    }

    private boolean checkCoverLabelBounds(int n) {
        GeneralPath generalPath = new GeneralPath();
        for (int i = 0; i < this.getSeriesSize(); ++i) {
            String string;
            TextGlyph textGlyph;
            DataPoint4Funnel dataPoint4Funnel = (DataPoint4Funnel)this.getSeries(i).getDataPoint(n);
            if (dataPoint4Funnel == null || (textGlyph = dataPoint4Funnel.getDataLabel()) == null || (string = textGlyph.getText()) == null || string.length() <= 0 || !this.isCoverLabelBounds(generalPath, textGlyph.getBounds())) continue;
            return true;
        }
        return false;
    }

    private void adjustCoverLabelBounds(int n) {
        GeneralPath generalPath = new GeneralPath();
        for (int i = 0; i < this.getSeriesSize(); ++i) {
            String string;
            TextGlyph textGlyph;
            DataPoint4Funnel dataPoint4Funnel = (DataPoint4Funnel)this.getSeries(i).getDataPoint(n);
            if (dataPoint4Funnel == null || (textGlyph = dataPoint4Funnel.getDataLabel()) == null || (string = textGlyph.getText()) == null || string.length() <= 0 || !this.isCoverLabelBounds(generalPath, textGlyph.getBounds())) continue;
            textGlyph.setBounds(null);
            dataPoint4Funnel.setLeadLine(null);
        }
    }

    protected void dealLabelBounds(int n, int n2) {
        TextGlyph textGlyph;
        DataPoint4Funnel dataPoint4Funnel;
        int n3;
        for (n3 = 0; n3 < this.getSeriesSize(); ++n3) {
            dataPoint4Funnel = (DataPoint4Funnel)this.getSeries(n3).getDataPoint(n);
            if (dataPoint4Funnel == null) continue;
            textGlyph = dataPoint4Funnel.getDataLabel();
            if (textGlyph == null) {
                return;
            }
            String string = textGlyph.getText();
            if (string == null || string.length() <= 0) continue;
            this.dealOutsideLabelBounds(textGlyph, dataPoint4Funnel, this.indexOfDataPoint(dataPoint4Funnel), n2);
        }
        if (this.checkCoverLabelBounds(n)) {
            this.dealLabelBoundsWithCover(n, n2);
        }
        for (n3 = 0; n3 < this.getSeriesSize(); ++n3) {
            dataPoint4Funnel = (DataPoint4Funnel)this.getSeries(n3).getDataPoint(n);
            if (dataPoint4Funnel == null) continue;
            textGlyph = dataPoint4Funnel.getDataLabel();
            if (textGlyph == null) {
                return;
            }
            dataPoint4Funnel.initLabel(n2);
        }
    }

    protected void dealLabelBoundsWithCover(int n, int n2) {
        for (int i = 0; i < this.getSeriesSize(); ++i) {
            DataPoint4Funnel dataPoint4Funnel = (DataPoint4Funnel)this.getSeries(i).getDataPoint(n);
            if (dataPoint4Funnel == null) continue;
            TextGlyph textGlyph = dataPoint4Funnel.getDataLabel();
            if (textGlyph == null) {
                return;
            }
            String string = textGlyph.getText();
            if (string == null || string.length() <= 0) continue;
            this.dealOutsideLabelBoundsWithCover(textGlyph, dataPoint4Funnel, this.indexOfDataPoint(dataPoint4Funnel), n2);
        }
        this.adjustCoverLabelBounds(n);
    }

    private void dealOutsideLabelBounds(TextGlyph textGlyph, DataPoint4Funnel dataPoint4Funnel, int n, int n2) {
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation(textGlyph.getText(), textGlyph.getTextAttr(), n2);
        double d = this.seriesY[n] - dimension2D.getHeight() / 2.0;
        ((Rectangle2D)double_).setRect(this.labelX, d, this.labelWidth, dimension2D.getHeight());
        this.dealOutsideLabelBoundsWhenNormal(double_, dataPoint4Funnel, n);
    }

    private void dealOutsideLabelBoundsWithCover(TextGlyph textGlyph, DataPoint4Funnel dataPoint4Funnel, int n, int n2) {
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation(textGlyph.getText(), textGlyph.getTextAttr(), n2);
        double d = this.getBounds().getHeight() * 0.8 / (double)(this.seriesY.length - 1);
        double d2 = this.seriesY[0] + d * (double)n - dimension2D.getHeight() / 2.0;
        ((Rectangle2D)double_).setRect(this.labelX, d2, this.labelWidth, dimension2D.getHeight());
        this.dealOutsideLabelBoundsWhenNormal(double_, dataPoint4Funnel, n);
    }

    private void dealOutsideLabelBoundsWhenNormal(Rectangle2D rectangle2D, DataPoint4Funnel dataPoint4Funnel, int n) {
        dataPoint4Funnel.getDataLabel().setBounds(rectangle2D);
        if (this.isGuideLineShow(dataPoint4Funnel)) {
            this.dealWidthLine(dataPoint4Funnel, n);
        }
    }

    protected void dealWidthLine(DataPoint4Funnel dataPoint4Funnel, int n) {
        GeneralPath generalPath = new GeneralPath();
        double d = this.seriesX[n] + this.seriesWidth[n] + this.getBounds().getWidth() * 0.01;
        double d2 = this.seriesY[n];
        double d3 = this.labelX - this.getBounds().getWidth() * 0.06999999999999999;
        double d4 = this.labelX - this.getBounds().getWidth() * 0.01;
        double d5 = d2;
        if (dataPoint4Funnel.getDataLabel() != null) {
            d5 = dataPoint4Funnel.getDataLabel().getBounds().getCenterY();
        }
        generalPath.moveTo(d, d2);
        generalPath.lineTo(d3, d5);
        generalPath.lineTo(d4, d5);
        dataPoint4Funnel.setLeadLine(generalPath);
    }

    public void draw(Graphics graphics, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.drawInfo(graphics);
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
        super.draw(graphics, n);
    }

    public boolean equals(Object object) {
        return object instanceof FunnelPlotGlyph;
    }

    public String getPlotGlyphType() {
        return "FunnelPlotGlyph";
    }

    public String getChartType() {
        return "Funnel";
    }

    public boolean isSupportLegend() {
        return false;
    }
}

