/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.GraphHelper;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.chartglyph.CategoryAxisGlyph;
import com.fr.general.DateUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Repository;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateAxisGlyph
extends CategoryAxisGlyph {
    private static final long serialVersionUID = -317755190103222589L;
    private static final double MAXMOREVALUE = 10.0;
    private static final double FIVE = 5.0;
    private static final double MONTHDAY = 30.0;
    private static final double YEARDAY = 365.0;
    private static final double LABEL_WIDTH = 8.0;

    public void initMinMaxValue(double d, double d2) {
        this.makeSureMinValue(d);
        this.makeSureMaxValuePreliminary(d2);
        double d3 = this.getMinValue();
        double d4 = this.getMaxValue();
        this.calculate4Unit(d3, d4);
        this.makeSureMaxValueFinally(d3, d4);
    }

    protected int tickNumberChangeUponLabelLocation() {
        if (this.isDrawBetweenTick()) {
            return 0;
        }
        return -1;
    }

    private double getRealMinValue() {
        return this.getMinValue();
    }

    private double getRealMaxValue() {
        return this.getMaxValue() + 1.0;
    }

    protected void calculateAxisLengthUnit() {
        double d = this.getRealMaxValue() - this.getRealMinValue() + (double)this.tickNumberChangeUponLabelLocation();
        if (d <= 0.0) {
            this.unitLength = 1.0;
            return;
        }
        this.unitLength = this.axisLength / Math.max(1.0, d);
    }

    private void makeSureMinValue(double d) {
        if (this.isCustomMinValue()) {
            Date date = ChartBaseUtils.long2Date((long)this.getMinValue(), 6);
            double d2 = ChartBaseUtils.date2Int(date, this.getMainType());
            this.setMinValue(d2);
        } else {
            Date date = ChartBaseUtils.long2Date((long)d, 6);
            double d3 = ChartBaseUtils.date2Int(date, this.getMainType());
            this.setMinValue(d3);
        }
    }

    private void makeSureMaxValuePreliminary(double d) {
        if (this.isCustomMaxValue()) {
            Date date = ChartBaseUtils.long2Date((long)this.getMaxValue(), 6);
            double d2 = ChartBaseUtils.date2Int(date, this.getMainType());
            this.setMaxValue(d2);
        } else {
            Date date = ChartBaseUtils.long2Date((long)d, 6);
            double d3 = ChartBaseUtils.date2Int(date, this.getMainType());
            this.setMaxValue(d3);
        }
    }

    private void calculate4Unit(double d, double d2) {
        if (d2 <= d) {
            d2 = d + 10.0;
        }
        if (!this.isCustomMainUnit()) {
            this.setMainUnit(new BigDecimal("5"));
        }
        if (!this.isCustomSecUnit()) {
            this.setSecUnit((double)((int)this.getMainUnit()) / 5.0);
        }
    }

    private void makeSureMaxValueFinally(double d, double d2) {
        if ((d2 - d) % this.getMainUnit() != 0.0) {
            d2 = d2 + this.getMainUnit() - (d2 - d) % this.getMainUnit();
        }
        if (!this.isCustomMaxValue()) {
            this.setMaxValue(d2);
        }
        if (this.getMinValue() >= this.getMaxValue()) {
            this.setMaxValue(this.getMinValue() + 10.0);
        }
    }

    protected double getDateTypeNumber() {
        double d = 1.0;
        if (this.getMainType() == 2) {
            d = 30.0;
        } else if (this.getMainType() == 3) {
            d = 365.0;
        }
        return d;
    }

    public int getTickIndex4Value(int n) {
        return (int)ChartBaseUtils.date2Int(DateUtils.object2Date(this.categoryLabelList.get(n), (boolean)true), this.getMainType());
    }

    protected double getMaxLabelWidthAndInitStartEndLabelDim(int n) {
        int n2;
        if (!this.isShowAxisLabel) {
            return 0.0;
        }
        double d = 8.0;
        Date date = ChartBaseUtils.long2Date((long)this.minValue, this.getMainType());
        Date date2 = ChartBaseUtils.long2Date((long)this.maxValue, this.getMainType());
        int n3 = 0;
        int n4 = this.getTickNumber4CalDim();
        int n5 = n2 = this.getLabelNumber() > 0 ? this.getLabelNumber() : n4;
        while (this.isBeyondDateRange(date, date2, (int)this.getMainUnit() * n2)) {
            Cloneable cloneable;
            String string = "";
            if (this.format != null) {
                string = this.format.format(date);
            } else {
                cloneable = new SimpleDateFormat("yyyy-MM-dd");
                string = cloneable.format(date);
            }
            cloneable = this.getAxisLabelDim(string, n);
            if (n3 == 0) {
                this.startLabelDim = cloneable;
                ++n3;
            } else {
                this.endLabelDim = cloneable;
            }
            double d2 = this.getAxisLabelWidth(string, n);
            d = d2 < d ? d : d2;
            date = this.nextDate(date, this.getMainType(), (int)this.getMainUnit() * n2);
        }
        return d;
    }

    public Point2D getPoint2D(double d) {
        d -= this.getCrossValue();
        if (this.getPosition() == 2 || this.getPosition() == 4) {
            return new Point2D.Double(this.originPoint.getX(), this.originPoint.getY() - this.unitLength * d);
        }
        return new Point2D.Double(this.originPoint.getX() + this.unitLength * d, this.originPoint.getY());
    }

    public void drawAxisGrid(Graphics graphics) {
        if (this.needDrawMainAxisGrid()) {
            this.drawGridLine(graphics, this.getMainGridStyle(), this.getMainGridColor(), (int)this.getMainUnit(), this.getMainType());
        }
    }

    private boolean needDrawMainAxisGrid() {
        return this.getMainGridStyle() != 0 && this.getMainUnit() > 0.0 && this.getMainGridColor() != null;
    }

    private void drawGridLine(Graphics graphics, int n, Color color, int n2, int n3) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(color);
        graphics2D.setStroke(GraphHelper.getStroke((int)n));
        Date date = ChartBaseUtils.long2Date((long)this.minValue, this.getMainType());
        Date date2 = ChartBaseUtils.long2Date((long)this.maxValue, this.getMainType());
        int n4 = this.getTickSamplingTime();
        DateUtils.object2Date((Object)new Double(this.getMinValue()), (boolean)false);
        while (this.isBeyondDateRange(date, date2, n2 * n4)) {
            double d = ChartBaseUtils.date2Int(date, this.getMainType());
            Line2D[] line2DArray = this.getGridLine(d);
            for (int i = 0; i < line2DArray.length; ++i) {
                graphics2D.draw(line2DArray[i]);
            }
            date = this.nextDate(date, n3, n2 * n4);
        }
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
    }

    protected void drawAxisLine(Graphics graphics, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        Stroke stroke = graphics2D.getStroke();
        int n2 = this.getLineStyle();
        if (this.getLineColor() != null && n2 != 0) {
            graphics2D.setPaint(this.getLineColor());
            graphics2D.setStroke(GraphHelper.getStroke((int)n2));
            if (this.getMinValue() == this.getMaxValue()) {
                return;
            }
            Line2D.Double double_ = new Line2D.Double(this.getPoint2D(this.getRealMinValue()), this.getPoint2D(this.getRealMaxValue() + (double)this.tickNumberChangeUponLabelLocation()));
            graphics2D.draw(double_);
            this.drawArrow(graphics2D, this.getPoint2D(this.getMinValue()), this.getPoint2D(this.getMaxValue()));
        }
        this.drawTicks(graphics, n);
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
    }

    protected void drawTicks(Graphics graphics, int n) {
        Line2D line2D;
        double d;
        double d2;
        if (this.axisLength < 1.0) {
            return;
        }
        BasicStroke basicStroke = new BasicStroke(1.0f, 1, 0);
        Date date = ChartBaseUtils.long2Date((long)this.minValue, this.getMainType());
        Date date2 = ChartBaseUtils.long2Date((long)this.maxValue, this.getMainType());
        Format format = this.getFormat() == null ? new SimpleDateFormat("yyyy-MM-dd") : this.getFormat();
        int n2 = this.getTickSamplingTime();
        int n3 = this.getLabelNumber() > 0 ? this.getLabelNumber() : n2;
        double d3 = d2 = this.isDrawBetweenTick() ? 0.5 : 0.0;
        while (this.isBeyondDateRange(date, date2, (int)this.getMainUnit())) {
            d = ChartBaseUtils.date2Int(date, this.getMainType());
            line2D = this.getTickLine(d, 5, this.getTickMarkType());
            this.drawTickLine(graphics, line2D, basicStroke);
            date = this.nextDate(date, this.getMainType(), (int)this.getMainUnit() * n3);
        }
        date = ChartBaseUtils.long2Date((long)this.minValue, this.getMainType());
        if (n2 <= 1) {
            while (this.isBeyondDateRange(date, date2, (int)this.getSecUnit())) {
                d = ChartBaseUtils.date2Int(date, this.getSecondType());
                line2D = this.getTickLine(d, 3, this.getSecTickMarkType());
                this.drawTickLine(graphics, line2D, basicStroke);
                date = this.nextDate(date, this.getSecondType(), (int)this.getSecUnit() * n3);
            }
        }
        date = ChartBaseUtils.long2Date((long)this.minValue, this.getMainType());
        GeneralPath generalPath = new GeneralPath();
        while (this.isBeyondDateRange(date, date2, (int)this.getMainUnit())) {
            String string;
            double d4 = ChartBaseUtils.date2Int(date, this.getMainType());
            Rectangle2D rectangle2D = this.getLabelBounds(d4, d2, string = format.format(date), n);
            if (!generalPath.intersects(rectangle2D)) {
                this.drawLabel(graphics, d4, d2, string, n);
                generalPath.append(rectangle2D, false);
            }
            date = this.nextDate(date, this.getMainType(), (int)this.getMainUnit() * n3);
        }
    }

    private boolean isBeyondDateRange(Date date, Date date2, int n) {
        return date.getTime() <= date2.getTime() && n > 0;
    }

    public Date nextDate(Date date, int n, int n2) {
        if (n == 6) {
            date.setSeconds(date.getSeconds() + n2);
        } else if (n == 5) {
            date.setMinutes(date.getMinutes() + n2);
        } else if (n == 4) {
            date.setHours(date.getHours() + n2);
        } else if (n == 2) {
            date.setMonth(date.getMonth() + n2);
        } else if (n == 3) {
            date.setYear(date.getYear() + n2);
        } else if (n == 1) {
            date.setDate(date.getDate() + n2);
        }
        return date;
    }

    public double getCrossValue() {
        return this.getRealMinValue();
    }

    public double getArrowValue() {
        return this.getRealMaxValue();
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        jSONObject.put("mainType", this.getMainType());
        jSONObject.put("secondType", this.getSecondType());
        return jSONObject;
    }

    public String getJSAxisType() {
        return "DateAxisGlyph";
    }

    public String getAxisName() {
        return "DateAxis";
    }
}

