/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.Parameter;
import com.fr.base.ParameterMapNameSpace;
import com.fr.chart.base.AttrContents;
import com.fr.chart.chartdata.MapAreaValue;
import com.fr.chart.chartdata.MapTitleValue;
import com.fr.chart.chartglyph.ChartGlyph;
import com.fr.chart.chartglyph.ChartGlyphLayout;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.general.Inter;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.ParameterProvider;
import com.fr.stable.StringUtils;
import com.fr.stable.script.NameSpace;
import com.fr.stable.web.Repository;
import java.awt.Graphics;

public class DataPoint4Map
extends DataPoint {
    private static final long serialVersionUID = 7053559474060847835L;
    private boolean hasNextTo = false;
    private String nameLayerTo = "";
    private String nameFrom = "";
    private int layerIndex = 0;
    private MapAreaValue areaValue;
    private ChartGlyph combineGlyph;

    public String getType() {
        return "DataPoint4Map";
    }

    public void setHasNextTo(boolean bl) {
        this.hasNextTo = bl;
    }

    public boolean isHasNextTo() {
        return this.hasNextTo;
    }

    public void setLayerIndex(int n) {
        this.layerIndex = n;
    }

    public int getLayerIndex() {
        return this.layerIndex;
    }

    public void setNameLayerTo(String string) {
        this.nameLayerTo = string;
    }

    public String getNameLayerTo() {
        return this.nameLayerTo;
    }

    public void setAreaValue(MapAreaValue mapAreaValue) {
        this.areaValue = mapAreaValue;
    }

    public MapAreaValue getAreaValue() {
        return this.areaValue;
    }

    public void setNameFrom(String string) {
        this.nameFrom = string;
    }

    public String getNameFrom() {
        return this.nameFrom;
    }

    public void setCombineGlyph(ChartGlyph chartGlyph) {
        this.combineGlyph = chartGlyph;
    }

    public ChartGlyph getCombineGlyph() {
        return this.combineGlyph;
    }

    public void drawCombine(Graphics graphics, int n) {
        if (this.combineGlyph != null && this.combineGlyph.getPlotGlyph() != null) {
            ChartGlyphLayout.plotDoLayout(this.combineGlyph.getBounds(), this.combineGlyph, n);
            ((PlotGlyph)this.combineGlyph.getPlotGlyph()).draw(graphics, n);
        }
    }

    public NameSpace getParas4Hyperlink() {
        return ParameterMapNameSpace.create((ParameterProvider[])new ParameterProvider[]{new Parameter("AREA_NAME", (Object)this.getCategoryOriginalName()), new Parameter("AREA_VALUE", (Object)new Double(this.getValue())), new Parameter("BR", (Object)AttrContents.RelineSeparation), new Parameter("VALUE", (Object)new Double(this.getValue()))});
    }

    public ParameterProvider[] getParameters4Labels(AttrContents attrContents) {
        Parameter[] parameterArray = new Parameter[]{new Parameter("Category", (Object)this.getCategoryOriginalName()), new Parameter("Series", (Object)this.getSeriesName()), new Parameter("BR", (Object)AttrContents.RelineSeparation), new Parameter("PERCENT", (Object)this.getPercentParaString(attrContents)), new Parameter("Value", (Object)this.getValueParaString(this.getValue(), attrContents))};
        return parameterArray;
    }

    public String createHotTooltip(AttrContents attrContents) {
        if (this.areaValue == null) {
            return "";
        }
        String string = "";
        if (attrContents != null && StringUtils.isNotEmpty((String)attrContents.getSeriesLabel())) {
            String string2 = attrContents.getSeriesLabel();
            boolean bl = this.containsPara(string2, "${PERCENT}");
            string = string + this.getCategoryOriginalName() + AttrContents.RelineSeparation;
            if (this.containsPara(string2, "${VALUE}")) {
                if (!this.areaValue.isTitleValueNull()) {
                    int n = this.areaValue.titleValueSize();
                    for (int i = 0; i < n; ++i) {
                        MapTitleValue mapTitleValue = this.areaValue.getTitleValue(i);
                        if (i == 0) {
                            string = string + mapTitleValue.getTitle() + " : " + this.getValueParaString(mapTitleValue.getValue(), attrContents);
                        } else if (i == 1 && bl) {
                            MapTitleValue mapTitleValue2 = this.areaValue.getTitleValue(0);
                            string = string + mapTitleValue2.getTitle() + Inter.getLocText((String)"StyleFormat-Percent") + " : " + this.getPercentParaString(attrContents);
                        } else {
                            string = string + mapTitleValue.getTitle() + " : " + mapTitleValue.getValue();
                        }
                        string = string + AttrContents.RelineSeparation;
                    }
                }
            } else if (this.containsPara(string2, "${PERCENT}") && !this.areaValue.isTitleValueNull()) {
                int n = this.areaValue.titleValueSize();
                for (int i = 0; i < n; ++i) {
                    MapTitleValue mapTitleValue = this.areaValue.getTitleValue(i);
                    string = i == 0 ? string + mapTitleValue.getTitle() + Inter.getLocText((String)"StyleFormat-Percent") + " : " + this.getPercentParaString(attrContents) : string + mapTitleValue.getTitle() + " : " + mapTitleValue.getValue();
                    string = string + AttrContents.RelineSeparation;
                }
            }
            this.setTooltip(string);
        }
        return string;
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        jSONObject.put("hasNextTo", this.hasNextTo);
        jSONObject.put("nameLayerTo", (Object)this.getNameLayerTo());
        jSONObject.put("nameFrom", (Object)this.nameFrom);
        jSONObject.put("layerIndex", this.layerIndex);
        if (this.areaValue != null) {
            jSONObject.put("areaValue", (Object)this.areaValue.toJSONObject());
        }
        if (this.combineGlyph != null) {
            jSONObject.put("combineGlyph", (Object)this.combineGlyph.toJSONObject(repository));
        }
        return jSONObject;
    }
}

