/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.GraphHelper;
import com.fr.base.ScreenResolution;
import com.fr.base.Utils;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.TextAttr;
import com.fr.chart.base.TimeSwitchAttr;
import com.fr.chart.chartglyph.AxisGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.general.FRFont;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StringUtils;
import com.fr.stable.web.Repository;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryAxisGlyph
extends AxisGlyph {
    private static final long serialVersionUID = -6116809732597680006L;
    public static final double LABEL_OFFSET = 0.5;
    public static final double PRE_LABEL_HEIGHT = 20.0;
    private static final String ELLIPSIS = "\u2026";
    private static final double DE_LABEL_WIDTH = 8.0;
    protected ArrayList categoryLabelList = new ArrayList();
    private ArrayList secondLabels = new ArrayList();
    private ArrayList thirdLabels = new ArrayList();
    private int mainType = 1;
    private int secondType = 1;
    private ArrayList<TimeSwitchAttr> timeSwitchMap;

    public void setMainType(int n) {
        this.mainType = n;
    }

    public int getMainType() {
        return this.mainType;
    }

    public void setSecondType(int n) {
        this.secondType = n;
    }

    public int getSecondType() {
        return this.secondType;
    }

    public void setTimeSwitchMap(ArrayList<TimeSwitchAttr> arrayList) {
        this.timeSwitchMap = arrayList;
    }

    @Override
    public void initMinMaxValue(double d, double d2) {
        this.maxValue = d2;
        this.minValue = d;
        this.mainUnit = new BigDecimal("1");
        this.setSecUnit(0.2);
    }

    @Override
    protected double getMaxLabelWidthAndInitStartEndLabelDim(int n) {
        if (!this.isShowAxisLabel) {
            return 0.0;
        }
        double d = 8.0;
        Object[] objectArray = this.categoryLabelList.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            Dimension2D dimension2D = this.getAxisLabelDim(Utils.objectToString((Object)objectArray[i]), n);
            if (i == 0) {
                this.startLabelDim = dimension2D;
            } else {
                this.endLabelDim = dimension2D;
            }
            double d2 = this.getAxisLabelWidth(Utils.objectToString((Object)objectArray[i]), n);
            d = d2 < d ? d : d2;
        }
        return d;
    }

    private double getMaxLength(int n) {
        if (!this.isShowAxisLabel) {
            return 0.0;
        }
        double d = 0.0;
        Object[] objectArray = this.categoryLabelList.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            double d2 = this.getAxisLabelMoreWidth(Utils.objectToString((Object)objectArray[i]), n);
            d = d2 < d ? d : d2;
        }
        return d;
    }

    private double getAxisLabelMoreWidth(String string, int n) {
        Dimension2D dimension2D = this.getAxisLabelDim(string, n);
        Dimension2D dimension2D2 = GlyphUtils.calculateTextDimensionWithRotation("a", this.textAttr, n);
        if (this.textAttr.getAlignText() == 0) {
            if (this.shouldBeHeight()) {
                double d = this.unitLength - dimension2D2.getWidth();
                return dimension2D.getHeight() + (dimension2D.getHeight() + 4.0) * (double)this.calculateTimes4Horizontal(string, d, n);
            }
            return dimension2D.getWidth();
        }
        if (this.shouldBeHeight()) {
            return dimension2D.getHeight();
        }
        return this.calculateAllWidth4Vertical(string, this.unitLength - 6.0, n);
    }

    private double calculateAllWidth4Vertical(String string, double d, int n) {
        double d2 = -3.0;
        String string2 = string;
        double d3 = 4.0 + this.getTickLengthShow();
        block0: do {
            d2 += 3.0;
            for (int i = 1; i <= string2.length(); ++i) {
                boolean bl;
                Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithRotation(string2.substring(0, i), this.textAttr, n);
                boolean bl2 = bl = dimension2D.getWidth() >= this.axisLabelWidth - d3 || dimension2D.getHeight() > d;
                if (i == 1 && bl) {
                    string2 = "";
                    dimension2D = GlyphUtils.calculateTextDimensionWithRotation(ELLIPSIS, this.textAttr, n);
                    d2 += dimension2D.getWidth();
                    continue block0;
                }
                double d4 = dimension2D.getHeight();
                if (d4 > d && i != 1) {
                    d2 += dimension2D.getWidth();
                    string2 = string2.substring(i - 1);
                    continue;
                }
                if (i != string2.length()) continue;
                string2 = "";
                d2 += dimension2D.getWidth();
            }
        } while (StringUtils.isNotEmpty((String)string2));
        return d2;
    }

    private int calculateTimes4Horizontal(String string, double d, int n) {
        int n2 = 0;
        String string2 = string;
        block0: while (StringUtils.isNotEmpty((String)string2)) {
            for (int i = 1; i <= string2.length(); ++i) {
                Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithRotation(string2.substring(0, i), this.textAttr, n);
                if (dimension2D.getWidth() > d && i != 1) {
                    ++n2;
                    string2 = string2.substring(i - 1);
                    continue block0;
                }
                string2 = dimension2D.getWidth() > d && i == 1 ? "" : (i == string2.length() ? "" : string2);
            }
        }
        return n2;
    }

    @Override
    public double getPreLeftWidth4DataSheet(int n) {
        this.calculateTitleDimesion(n);
        double d = 0.0;
        if (this.titleDim.getWidth() > 0.0) {
            d = this.titleDim.getWidth() + 4.0;
        }
        double d2 = this.getMaxLabelWidthAndInitStartEndLabelDim(n);
        return this.position == 2 ? d2 + d : 0.0;
    }

    public void deletedRepeatLabel() {
        ArrayList arrayList = new ArrayList();
        for (Object e : this.categoryLabelList) {
            if (arrayList.contains(e)) continue;
            arrayList.add(e);
        }
        this.categoryLabelList.clear();
        this.categoryLabelList = arrayList;
        this.initMinMaxValue(0.0, this.categoryLabelList.size());
    }

    @Override
    protected void calculateAxisLengthUnit() {
        double d = this.getMaxValue() - this.getMinValue();
        if (d <= 0.0) {
            this.unitLength = 1.0;
            return;
        }
        this.unitLength = this.isDrawBetweenTick() ? this.axisLength / d : this.axisLength / Math.max(1.0, d - 1.0);
    }

    @Override
    protected double dealWithPlotBounds() {
        double d = this.getMaxLength(ScreenResolution.getScreenResolution());
        if (d > 0.0) {
            d += 4.0;
        }
        if ((d += this.getTickLengthShow()) <= this.axisLabelWidth) {
            return 0.0;
        }
        d = this.shouldBeHeight() ? Math.min(this.plotZeroBounds.getHeight() * 0.28 + 4.0 + this.getTickLengthShow(), d) : Math.min(this.plotZeroBounds.getWidth() * 0.28 + 4.0 + this.getTickLengthShow(), d);
        double d2 = d - this.axisLabelWidth;
        this.axisLabelWidth = d;
        return d2;
    }

    @Override
    protected Rectangle2D getBottomTitleBounds(Dimension2D dimension2D, int n) {
        double d = this.getAxisLabelWidth() + 4.0;
        if (!this.secondLabels.isEmpty()) {
            d += 20.0;
        }
        if (!this.thirdLabels.isEmpty()) {
            d += 20.0;
        }
        return new Rectangle2D.Double(this.getTopBottomX(n), d, dimension2D.getWidth(), dimension2D.getHeight());
    }

    @Override
    protected void calBoundsWithMoreLabel4Cate(Rectangle2D rectangle2D) {
        if (this.getPosition() == 3 && this.isShowAxisLabel) {
            double d = this.secondLabels.isEmpty() ? 0.0 : 20.0;
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight() - (d += this.thirdLabels.isEmpty() ? 0.0 : 20.0));
        }
    }

    public void addCategoryLabel(Object object) {
        this.categoryLabelList.add(object);
    }

    public void setCategoryLabelList(ArrayList arrayList) {
        this.categoryLabelList = arrayList;
    }

    public void addSecondLabel(Object object) {
        this.secondLabels.add(object);
    }

    public void addThirdLabel(Object object) {
        this.thirdLabels.add(object);
    }

    public int getTickNumber4CalDim() {
        int n = 1;
        double d = this.getMaxTickValue() - this.getMinValue();
        while (Math.ceil(d / ((double)n * this.getDateTypeNumber())) > 1.0) {
            ++n;
        }
        return n;
    }

    @Override
    public int getTickSamplingTime() {
        int n = 1;
        double d = this.getMaxTickValue() - this.getMinValue();
        if (d < 0.0) {
            return n;
        }
        while (this.axisLength > 1.0 && this.axisLength / Math.ceil(d / (this.getMainUnit() * (double)n * this.getDateTypeNumber())) < 1.0) {
            ++n;
        }
        return n;
    }

    protected double getDateTypeNumber() {
        return 1.0;
    }

    public int getLabelSamplingTime(int n, boolean bl, int n2, int n3, double d) {
        int n4 = n * n2;
        GeneralPath generalPath = new GeneralPath();
        int n5 = this.categoryLabelList.size();
        for (int i = 0; i < n5; i += n4) {
            String string = this.getLabelString(i, bl);
            Rectangle2D rectangle2D = this.getLabelBounds(i, d, string, n3);
            if (generalPath.intersects(rectangle2D)) {
                return this.getLabelSamplingTime(n, bl, ++n2, n3, d);
            }
            generalPath.append(rectangle2D, false);
        }
        return n2;
    }

    private boolean isToNumber() {
        boolean bl = true;
        int n = this.categoryLabelList.size();
        for (int i = 0; i < n; ++i) {
            Object[] objectArray = this.categoryLabelList.toArray();
            Number number = Utils.objectToNumber((Object)objectArray[i], (boolean)true);
            if (number == null) {
                bl = false;
            }
            if (!bl) break;
        }
        return bl;
    }

    public String getLabelString(int n, boolean bl) {
        Object e = this.categoryLabelList.get(n);
        String string = Utils.objectToString(e);
        if (this.format != null && StringUtils.isNotEmpty((String)string)) {
            Date date;
            string = bl ? this.format.format(Double.valueOf(string)) : ((date = DateUtils.object2Date(e, (boolean)true)) == null ? string : this.format.format(date));
        }
        return string;
    }

    @Override
    public void drawAxisGrid(Graphics graphics) {
        if (this.axisLength <= 1.0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d = this.getMaxTickValue();
        int n = this.getTickSamplingTime();
        if (this.getMainGridStyle() != 0 && this.getMainUnit() > 0.0 && this.getMainGridColor() != null) {
            Stroke stroke = graphics2D.getStroke();
            Paint paint = graphics2D.getPaint();
            graphics2D.setPaint(this.getMainGridColor());
            graphics2D.setStroke(GraphHelper.getStroke((int)this.getMainGridStyle()));
            for (double d2 = (this.getMainUnit() + this.getCrossValue()) * (double)n; d2 <= d; d2 += this.getMainUnit() * (double)n) {
                Line2D[] line2DArray = this.getGridLine(d2);
                for (int i = 0; i < line2DArray.length; ++i) {
                    graphics2D.draw(line2DArray[i]);
                }
            }
            graphics2D.setStroke(stroke);
            graphics2D.setPaint(paint);
        }
    }

    @Override
    protected void drawAxisLine(Graphics graphics, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        Stroke stroke = graphics2D.getStroke();
        int n2 = this.getLineStyle();
        if (this.getLineColor() != null && n2 != 0) {
            graphics2D.setStroke(GraphHelper.getStroke((int)n2));
            graphics2D.setPaint(this.lineColor);
            Line2D.Double double_ = new Line2D.Double(this.getPoint2D(this.getCrossValue()), this.getPoint2D(this.getMaxTickValue()));
            graphics2D.draw(double_);
            this.drawArrow(graphics2D, double_.getP1(), double_.getP2());
        }
        this.drawTicks(graphics2D, n);
        this.drawMoreTickLabel(graphics2D, n);
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
    }

    private void drawMoreTickLabel(Graphics graphics, int n) {
        if (!this.isShowAxisLabel) {
            return;
        }
        this.drawMore(graphics, this.secondLabels, 0, n);
        this.drawMore(graphics, this.thirdLabels, 1, n);
        this.drawMoreTicks(graphics, 0);
        this.drawMoreTicks(graphics, 1);
    }

    private void drawMore(Graphics graphics, ArrayList arrayList, int n, int n2) {
        GeneralPath generalPath = new GeneralPath();
        TextAttr textAttr = new TextAttr();
        textAttr.setFRFont(FRFont.getInstance((String)"Microsoft YaHei", (int)0, (float)9.0f));
        int n3 = arrayList.size();
        for (int i = 0; i < n3; ++i) {
            String string = Utils.objectToString(arrayList.get(i));
            Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithRotation(string, textAttr, n2);
            double d = this.getSecondX(i, n3);
            Rectangle2D.Double double_ = new Rectangle2D.Double(d - dimension2D.getWidth() / 2.0, this.axisLabelWidth + (double)n * 20.0, dimension2D.getWidth(), dimension2D.getHeight());
            if (generalPath.intersects(double_)) continue;
            generalPath.append(double_, false);
            GlyphUtils.drawStrings(graphics, string, textAttr, double_, n2);
        }
    }

    private void drawMoreTicks(Graphics graphics, int n) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = n == 0 ? this.secondLabels : this.thirdLabels;
        if (arrayList == null || arrayList.isEmpty()) {
            return;
        }
        BasicStroke basicStroke = new BasicStroke(1.0f, 1, 0);
        int n2 = (int)((double)(n + 1) * 20.0 + this.axisLabelWidth);
        int n3 = this.categoryLabelList.size() / arrayList.size();
        for (double d = 0.0; d <= (double)arrayList.size(); d += 1.0) {
            Line2D line2D = this.getTickLine(d * (double)n3, n2, this.getTickMarkType());
            this.drawTickLine(graphics, line2D, basicStroke);
        }
    }

    @Override
    public void draw4ThreeD(Graphics graphics, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        this.drawTickLable(graphics, n);
        this.drawMoreTickLabel(graphics, n);
        this.drawAxisTitle(graphics2D, n);
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
    }

    protected void drawTickLable(Graphics graphics, int n) {
        if (this.axisLength <= 1.0) {
            return;
        }
        int n2 = this.getTickSamplingTime();
        boolean bl = this.isToNumber();
        double d = this.isDrawBetweenTick() ? 0.5 : 0.0;
        int n3 = this.getLabelNumber() > 0 ? this.getLabelNumber() : this.getLabelSamplingTime(n2, bl, 1, n, d) * n2;
        int n4 = this.categoryLabelList.size();
        for (int i = 0; i < n4; i += n3) {
            this.drawLabel(graphics, i, d, this.getLabelString(i, bl), n);
        }
    }

    private double getSecondX(double d, double d2) {
        double d3 = this.getBounds().getWidth();
        return d3 * (d + 0.5) / d2;
    }

    @Override
    protected void drawTicks(Graphics graphics, int n) {
        int n2;
        Line2D line2D;
        double d;
        if (this.axisLength <= 1.0) {
            return;
        }
        BasicStroke basicStroke = new BasicStroke(1.0f, 1, 0);
        int n3 = this.getTickSamplingTime();
        double d2 = this.getMaxTickValue();
        int n4 = this.secondLabels.isEmpty() ? 5 : (int)this.axisLabelWidth;
        for (d = this.getCrossValue() + (double)n3; d <= d2; d += (double)n3) {
            line2D = this.getTickLine(d, n4, this.getTickMarkType());
            this.drawTickLine(graphics, line2D, basicStroke);
        }
        if (n3 <= 1) {
            for (d = this.getCrossValue() + this.getSecUnit(); d <= d2; d += this.getSecUnit()) {
                line2D = this.getTickLine(d, 3, this.getSecTickMarkType());
                this.drawTickLine(graphics, line2D, basicStroke);
            }
        }
        boolean bl = this.isToNumber();
        double d3 = this.isDrawBetweenTick() ? 0.5 : 0.0;
        int n5 = n2 = this.getLabelNumber() > 0 ? this.getLabelNumber() : this.getLabelSamplingTime(n3, bl, 1, n, d3) * n3;
        if (this.isLabelWrap && n2 == 1) {
            int n6 = this.categoryLabelList.size();
            for (int i = 0; i < n6; i += n2) {
                this.drawLabelWrapWhenNeed(graphics, i, d3, this.getLabelString(i, bl), n);
            }
        } else {
            int n7 = this.categoryLabelList.size();
            for (int i = 0; i < n7; i += n2) {
                this.drawLabel(graphics, i, d3, this.getLabelString(i, bl), n);
            }
        }
    }

    protected double getMaxTickValue() {
        double d = this.getMaxValue();
        if (!this.isDrawBetweenTick() && this.categoryLabelList != null && this.categoryLabelList.size() > 1) {
            d -= this.getMainUnit();
        }
        return d;
    }

    @Override
    public double getCrossValue() {
        return this.getMinValue();
    }

    @Override
    public double getArrowValue() {
        return this.getMaxValue();
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof CategoryAxisGlyph && super.equals(object) && ComparatorUtils.equals((Object)((CategoryAxisGlyph)object).categoryLabelList, (Object)this.categoryLabelList);
    }

    @Override
    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        if (!this.categoryLabelList.isEmpty()) {
            jSONObject.put("categoryLabelList", (Object)this.categoryLabelList.toArray());
        }
        if (!this.secondLabels.isEmpty()) {
            jSONObject.put("secondLabels", (Object)this.secondLabels.toArray());
        }
        if (!this.thirdLabels.isEmpty()) {
            jSONObject.put("thirdLabels", (Object)this.thirdLabels.toArray());
        }
        if (this.timeSwitchMap != null && !this.timeSwitchMap.isEmpty()) {
            JSONArray jSONArray = new JSONArray();
            for (TimeSwitchAttr timeSwitchAttr : this.timeSwitchMap) {
                jSONArray.put((Object)timeSwitchAttr.toJSONObject());
            }
            jSONObject.put("timeSwitchArray", (Object)jSONArray);
        }
        return jSONObject;
    }

    @Override
    public String getJSAxisType() {
        return "CategoryAxisGlyph";
    }

    @Override
    public String getAxisName() {
        return "CategoryAxis";
    }
}

