/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartdata;

import com.fr.data.AbstractDataModel;
import com.fr.general.FRLogger;
import com.fr.general.data.TableDataException;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StringUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JSONDataModel
extends AbstractDataModel {
    private String filePath;
    private List rowValueList = null;
    private List columnNameList = null;
    private int columnCount;
    private int rowCount = 0;

    public JSONDataModel(String string) {
        this.filePath = string;
    }

    private InputStream getfileInputStream() {
        if (StringUtils.isBlank((String)this.filePath)) {
            return null;
        }
        try {
            if (this.filePath.indexOf("http") != -1) {
                URL uRL = new URL(this.filePath);
                URLConnection uRLConnection = uRL.openConnection();
                return uRLConnection.getInputStream();
            }
            return new FileInputStream(this.filePath);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
            return null;
        }
    }

    private void readToInitData() {
        if (this.rowValueList == null && this.columnNameList == null) {
            this.rowValueList = new ArrayList();
            this.columnNameList = new ArrayList();
            try {
                InputStream inputStream = this.getfileInputStream();
                if (inputStream == null) {
                    return;
                }
                InputStreamReader inputStreamReader = new InputStreamReader(this.getfileInputStream());
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string = "";
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    string = string + string2;
                    string2 = bufferedReader.readLine();
                }
                bufferedReader.close();
                JSONObject jSONObject = new JSONObject(string);
                if (jSONObject != null) {
                    Iterator iterator = jSONObject.keys();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        this.columnNameList.add(e);
                        ++this.columnCount;
                    }
                }
                this.initRowData(jSONObject);
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private void initRowData(JSONObject jSONObject) throws JSONException {
        if (jSONObject != null) {
            this.rowCount = ((JSONArray)jSONObject.get((String)this.columnNameList.get(0))).length();
            for (int i = 0; i < this.rowCount; ++i) {
                Object[] objectArray = new Object[this.columnCount];
                for (int j = 0; j < this.columnCount; ++j) {
                    JSONArray jSONArray = (JSONArray)jSONObject.get((String)this.columnNameList.get(j));
                    objectArray[j] = jSONArray.get(i);
                }
                this.rowValueList.add(objectArray);
            }
        }
    }

    public int getColumnCount() {
        this.readToInitData();
        return this.columnCount;
    }

    public String getColumnName(int n) {
        this.readToInitData();
        return n >= 0 && n < this.columnCount ? this.columnNameList.get(n).toString() : null;
    }

    public int getRowCount() {
        this.readToInitData();
        return this.rowCount;
    }

    public Object getValueAt(int n, int n2) throws TableDataException {
        this.readToInitData();
        if (n >= 0 && n < this.rowCount) {
            Object[] objectArray = (Object[])this.rowValueList.get(n);
            if (n2 >= 0 && n2 < this.columnCount) {
                return objectArray[n2];
            }
        }
        return null;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void release() throws Exception {
    }
}

