/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.chart.chartdata.ChartData;
import com.fr.chart.chartattr.NumberAxis;
import com.fr.chart.chartglyph.AxisGlyph;
import com.fr.chart.chartglyph.RangeAxisGlyph;
import com.fr.chart.chartglyph.ValueAxisGlyph;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;

public class ValueAxis
extends NumberAxis {
    private static final long serialVersionUID = 6083137730386866219L;
    public static final String XML_TAG = "ValueAxis";
    private boolean alignZeroValue = false;

    public ValueAxis() {
        this(2);
    }

    public ValueAxis(int n) {
        this.position = n;
        this.setMainGridStyle(1);
        this.setMainGridColor(new Color(192, 192, 192));
    }

    public void setAlignZeroValue(boolean bl) {
        this.alignZeroValue = bl;
    }

    public boolean isAlignZeroValue() {
        return this.alignZeroValue;
    }

    public AxisGlyph createAxisGlyph(ChartData chartData) {
        ValueAxisGlyph valueAxisGlyph = new ValueAxisGlyph();
        this.initAxisGlyph(valueAxisGlyph);
        return valueAxisGlyph;
    }

    public RangeAxisGlyph createRangeAxisGlyph() {
        RangeAxisGlyph rangeAxisGlyph = new RangeAxisGlyph();
        this.initAxisGlyph(rangeAxisGlyph);
        return rangeAxisGlyph;
    }

    public void initAxisGlyph(ValueAxisGlyph valueAxisGlyph) {
        super.initAxisGlyph(valueAxisGlyph);
        valueAxisGlyph.setAlignZeroValue(this.alignZeroValue);
    }

    public boolean equals(Object object) {
        return object instanceof ValueAxis && ((ValueAxis)object).isAlignZeroValue() == this.isAlignZeroValue() && super.equals(object);
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("ValueAxisAttr201108")) {
            this.setAlignZeroValue(xMLableReader.getAttrAsBoolean("alignZeroValue", false));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        this.writeXML(xMLPrintWriter, XML_TAG);
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter, String string) {
        xMLPrintWriter.startTAG(string).attr("class", this.getClass().getName());
        xMLPrintWriter.startTAG("ValueAxisAttr201108").attr("alignZeroValue", this.alignZeroValue).end();
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }
}

