/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.Formula;
import com.fr.base.Utils;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.base.ChartConstants;
import com.fr.chart.chartattr.Axis;
import com.fr.chart.chartattr.ChartAlertValue;
import com.fr.chart.chartglyph.ChartAlertValueGlyph;
import com.fr.chart.chartglyph.NumberAxisGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.general.GeneralUtils;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.ModColumnRowProvider;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NumberAxis
extends Axis {
    private static final long serialVersionUID = 3873330991309244365L;
    private String showUnit = null;
    private String unitPadding = null;
    private boolean isLog = false;
    private Formula logBase = new Formula("10");
    private boolean isPercentage = false;
    private ChartAlertValue[] alertValues = new ChartAlertValue[0];
    private List alertValueList = new ArrayList();

    public void setAlertValues(ChartAlertValue[] chartAlertValueArray) {
        this.alertValues = chartAlertValueArray;
    }

    public ChartAlertValue[] getAlertValues() {
        return this.alertValues == null ? new ChartAlertValue[]{} : this.alertValues;
    }

    @Override
    public void checkSimpleAxis4PlotDemo() {
        this.setAlertValues(null);
    }

    public void setShowUnit(String string) {
        this.showUnit = string;
    }

    public String getShowUnit() {
        return this.showUnit;
    }

    public void setUnitPadding(String string) {
        this.unitPadding = string;
    }

    public String getUnitPadding() {
        return this.unitPadding;
    }

    public void setLogBase(Formula formula) {
        this.logBase = formula;
    }

    public Formula getLogBase() {
        return this.logBase;
    }

    @Override
    public void setLog(boolean bl) {
        this.isLog = bl;
    }

    @Override
    public boolean isLog() {
        return this.isLog;
    }

    @Override
    public void setPercentage(boolean bl) {
        this.isPercentage = bl;
    }

    @Override
    public boolean isPercentage() {
        return this.isPercentage;
    }

    public void initAxisGlyph(NumberAxisGlyph numberAxisGlyph) {
        super.initAxisGlyph(numberAxisGlyph);
        numberAxisGlyph.setLog(this.isLog);
        Number number = ChartBaseUtils.formula2Number(this.getLogBase());
        if (number != null) {
            numberAxisGlyph.setBaseLog(number.doubleValue());
        } else {
            numberAxisGlyph.setBaseLog(10.0);
        }
        numberAxisGlyph.setPercentage(this.isPercentage);
        numberAxisGlyph.setShowUnit(this.showUnit);
        numberAxisGlyph.setUnitPadding(this.unitPadding);
        this.installAlertValues(numberAxisGlyph);
    }

    private void installAlertValues(NumberAxisGlyph numberAxisGlyph) {
        if (this.alertValues != null) {
            ArrayList<ChartAlertValueGlyph> arrayList = new ArrayList<ChartAlertValueGlyph>();
            for (int i = 0; i < this.alertValues.length; ++i) {
                ChartAlertValueGlyph chartAlertValueGlyph = new ChartAlertValueGlyph();
                chartAlertValueGlyph.setAlertContent(this.alertValues[i].getAlertContent());
                chartAlertValueGlyph.setAlertFont(this.alertValues[i].getAlertFont());
                chartAlertValueGlyph.setAlertLineAlpha(this.alertValues[i].getAlertLineAlpha());
                chartAlertValueGlyph.setAlertPaneSelectName(this.alertValues[i].getAlertPaneSelectName());
                chartAlertValueGlyph.setAlertPosition(this.alertValues[i].getAlertPosition());
                chartAlertValueGlyph.setAlertValueFormula(this.alertValues[i].getAlertValueFormula());
                chartAlertValueGlyph.setLineColor(this.alertValues[i].getLineColor());
                chartAlertValueGlyph.setLineStyle(this.alertValues[i].getLineStyle());
                chartAlertValueGlyph.setIndex(i);
                chartAlertValueGlyph.setValuAxisGlyph(numberAxisGlyph);
                arrayList.add(chartAlertValueGlyph);
            }
            numberAxisGlyph.setAlertValues(arrayList.toArray(new ChartAlertValueGlyph[0]));
        }
    }

    public boolean isSurpportAxisTitle() {
        return true;
    }

    @Override
    public void dependence(CalculatorProvider calculatorProvider, List<String> list) {
        super.dependence(calculatorProvider, list);
        if (this.logBase != null) {
            list.addAll(Arrays.asList(this.logBase.dependence(calculatorProvider)));
        }
        for (ChartAlertValue chartAlertValue : this.alertValues) {
            chartAlertValue.dependence(calculatorProvider, list);
        }
    }

    @Override
    public void dealFormula(Calculator calculator) {
        super.dealFormula(calculator);
        if (this.logBase != null) {
            Utils.dealFormulaValue((Object)this.logBase, (Calculator)calculator);
        }
        for (int i = 0; i < this.alertValues.length; ++i) {
            this.alertValues[i].dealFormula(calculator);
        }
    }

    @Override
    public void buidExecuteSequenceList(List list, Calculator calculator) {
        super.buidExecuteSequenceList(list, calculator);
        if (this.logBase != null) {
            GeneralUtils.dealBuidExecuteSequence((Object)this.logBase, (List)list, (CalculatorProvider)calculator);
        }
        for (int i = 0; i < this.alertValues.length; ++i) {
            this.alertValues[i].buidExecuteSequenceList(list, calculator);
        }
    }

    @Override
    public void modFormulaString(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        super.modFormulaString(mOD_COLUMN_ROW);
        if (this.logBase != null) {
            this.logBase.modColumnRow((ModColumnRowProvider)mOD_COLUMN_ROW);
        }
        for (int i = 0; i < this.alertValues.length; ++i) {
            this.alertValues[i].modFormulaString(mOD_COLUMN_ROW);
        }
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof NumberAxis && super.equals(object) && ComparatorUtils.equals((String)((NumberAxis)object).showUnit, (String)this.showUnit) && ComparatorUtils.equals((String)((NumberAxis)object).unitPadding, (String)this.unitPadding) && ComparatorUtils.equals((Object)((NumberAxis)object).logBase, (Object)this.logBase) && ComparatorUtils.equals((Object[])((NumberAxis)object).alertValues, (Object[])this.alertValues) && ((NumberAxis)object).isLog == this.isLog && ((NumberAxis)object).isPercentage == this.isPercentage;
    }

    private void comBomShowUnit2Key(XMLableReader xMLableReader) {
        String string = "";
        string = xMLableReader.getAttrAsString("value", null);
        if (string != null) {
            Number number = Utils.string2Number((String)string);
            if (number != null) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("10000", "Unit_Ten_Thousand");
                hashMap.put("100000", "Unit_Hundred_Thousand");
                hashMap.put("10000000", "Unit_Ten_Million");
                hashMap.put("100000000", "Unit_Hundred_Million");
                string = Utils.objectToString(hashMap.get(string));
            }
            this.setShowUnit(ChartConstants.getUnitValueFromKey(string));
        }
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (ComparatorUtils.equals((String)"ShowUnitKey", (String)string)) {
                this.setShowUnit(xMLableReader.getAttrAsString("value", null));
                this.setUnitPadding(xMLableReader.getAttrAsString("unitPadding", null));
            } else if (ComparatorUtils.equals((String)"Percentage", (String)string)) {
                this.setPercentage(xMLableReader.getAttrAsBoolean("value", false));
            } else if (ComparatorUtils.equals((String)"Log", (String)string)) {
                this.setLog(xMLableReader.getAttrAsBoolean("value", false));
                if (xMLableReader.getAttrAsString("baseLog", null) != null) {
                    this.setLogBase(new Formula(xMLableReader.getAttrAsString("baseLog", "10")));
                } else {
                    this.setLogBase(new Formula("10"));
                }
            } else if (ComparatorUtils.equals((String)string, (String)"alertValueList")) {
                this.alertValueList.clear();
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("ChartAlertValue")) {
                            NumberAxis.this.alertValueList.add(xMLableReader.readXMLObject((XMLReadable)new ChartAlertValue()));
                            NumberAxis.access$102(NumberAxis.this, NumberAxis.this.list2Array(NumberAxis.this.alertValueList));
                        }
                    }
                });
            } else if (ComparatorUtils.equals((String)string, (String)"AxisRangeIncr")) {
                this.setCustomMainUnit(xMLableReader.getAttrAsBoolean("isCustomIncrement", false));
                this.setMainUnit(new Formula(xMLableReader.getAttrAsString("value", "0")));
                this.setLogBase(new Formula(xMLableReader.getAttrAsString("value", "10")));
            } else if (ComparatorUtils.equals((String)string, (String)"TickUnit")) {
                this.setCustomMainUnit(xMLableReader.getAttrAsBoolean("mainUnit", false));
                this.setMainUnit(new Formula(xMLableReader.getAttrAsString("mainUnitValue", "0")));
                this.setCustomSecUnit(xMLableReader.getAttrAsBoolean("secUnit", false));
                this.setSecUnit(new Formula(xMLableReader.getAttrAsString("secUnitValue", "0")));
            } else if (ComparatorUtils.equals((String)string, (String)"AxisAlert")) {
                this.combiAxisAlert(xMLableReader);
            } else if (ComparatorUtils.equals((String)"ShowUnit", (String)string)) {
                this.comBomShowUnit2Key(xMLableReader);
            }
        }
        super.readXML(xMLableReader);
    }

    private void combiAxisAlert(XMLableReader xMLableReader) {
        String string = "";
        this.alertValueList.clear();
        string = xMLableReader.getAttrAsString("startValue", null);
        if (string != null) {
            if (string.startsWith("=")) {
                string = string.substring(1);
            }
            this.alertValueList.add(new ChartAlertValue(new Formula("=[" + string + "]")));
        }
        if ((string = xMLableReader.getAttrAsString("endValue", null)) != null) {
            if (string.startsWith("=")) {
                string = string.substring(1);
            }
            this.alertValueList.add(new ChartAlertValue(new Formula("=[" + string + "]")));
        }
        if ((string = xMLableReader.getAttrAsString("alertValue", null)) != null) {
            this.alertValueList.add(new ChartAlertValue(new Formula(string)));
        }
        this.alertValues = this.list2Array(this.alertValueList);
    }

    private ChartAlertValue[] list2Array(List list) {
        return list.toArray(new ChartAlertValue[list.size()]);
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (this.isPercentage) {
            xMLPrintWriter.startTAG("Percentage").attr("value", this.isPercentage).end();
        }
        if (this.getShowUnit() != null) {
            xMLPrintWriter.startTAG("ShowUnitKey").attr("value", this.getShowUnit()).attr("unitPadding", this.getUnitPadding()).end();
        }
        if (this.isLog()) {
            xMLPrintWriter.startTAG("Log").attr("value", this.isLog).attr("baseLog", Utils.objectToString((Object)this.logBase)).end();
        }
        if (!ArrayUtils.isEmpty((Object[])this.alertValues)) {
            xMLPrintWriter.startTAG("alertValueList");
            for (int i = 0; i < this.alertValues.length; ++i) {
                this.alertValues[i].writeXML(xMLPrintWriter);
            }
            xMLPrintWriter.end();
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        NumberAxis numberAxis = (NumberAxis)super.clone();
        if (this.logBase != null) {
            numberAxis.logBase = (Formula)this.logBase.clone();
        }
        if (!ArrayUtils.isEmpty((Object[])this.alertValues)) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < this.alertValues.length; ++i) {
                arrayList.add(this.alertValues[i].clone());
            }
            numberAxis.setAlertValues(arrayList.toArray(new ChartAlertValue[arrayList.size()]));
        }
        return numberAxis;
    }

    static /* synthetic */ ChartAlertValue[] access$102(NumberAxis numberAxis, ChartAlertValue[] chartAlertValueArray) {
        numberAxis.alertValues = chartAlertValueArray;
        return chartAlertValueArray;
    }
}

