/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.CoreDecimalFormat;
import com.fr.chart.base.AttrAreaSeries;
import com.fr.chart.base.AttrAxisPosition;
import com.fr.chart.base.AttrBarSeries;
import com.fr.chart.base.AttrLineSeries;
import com.fr.chart.base.ChartAxisPosition;
import com.fr.chart.base.ChartConstants;
import com.fr.chart.base.ChartCustomRendererType;
import com.fr.chart.base.DataSeriesCondition;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartattr.Axis;
import com.fr.chart.chartattr.Bar2DPlot;
import com.fr.chart.chartattr.Bar3DPlot;
import com.fr.chart.chartattr.Chart;
import com.fr.chart.chartattr.CustomPlot;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartglyph.ConditionCollection;
import com.fr.chart.chartglyph.CustomAttr;
import com.fr.chart.charttypes.ChartTypeManager;
import com.fr.data.condition.AbstractCondition;
import com.fr.data.condition.CommonCondition;
import com.fr.data.condition.ListCondition;
import com.fr.general.FRFont;
import com.fr.general.Inter;
import com.fr.general.data.Condition;
import java.text.DecimalFormat;
import java.text.Format;

public abstract class ChartFactory {
    private static final double DEFAULT_OVER_GAP = -0.5;
    private static String[] CHART_BY_INDEX = new String[]{"FineReportColumnChart", "FineReportLineChart", "FineReportBarChart", "FineReportPieChart", "FineReportAreaChart", "FineReportScatterChart", "FineReportBubbleChart", "FineReportRadarChart", "FineReportStockChart", "FineReportMeterChart", "FineReportRangeChart", "FineReportCustomChart", "FineReportGanttChart", "FineReportDonutChart", "FineReportMapChart", "FineReportGisChart", "FineReportFunnelChart"};

    public static Chart[] getChartTypes(int n) {
        return ChartTypeManager.getInstance().getChartTypes(CHART_BY_INDEX[n %= CHART_BY_INDEX.length]);
    }

    public static void setChartFontAttr(Plot plot) {
        TextAttr textAttr;
        if (plot.getxAxis() != null) {
            textAttr = new TextAttr();
            textAttr.setFRFont(FRFont.getInstance((String)"Microsoft YaHei", (int)0, (float)9.0f));
            plot.getxAxis().setTextAttr(textAttr);
        }
        if (plot.getyAxis() != null) {
            textAttr = new TextAttr();
            textAttr.setFRFont(FRFont.getInstance((String)"Century Gothic", (int)0, (float)9.0f));
            plot.getyAxis().setTextAttr(textAttr);
            if (plot.getSecondAxis() != null) {
                plot.getSecondAxis().setTextAttr(textAttr);
            }
        }
        if (plot.getLegend() != null) {
            plot.getLegend().setFRFont(FRFont.getInstance((String)"Microsoft YaHei", (int)0, (float)9.0f));
        }
    }

    public static Bar2DPlot createBar2DPlot() {
        Bar2DPlot bar2DPlot = new Bar2DPlot();
        ChartFactory.setChartFontAttr(bar2DPlot);
        return bar2DPlot;
    }

    public static Bar2DPlot createStackBar2DPlot() {
        Bar2DPlot bar2DPlot = new Bar2DPlot();
        bar2DPlot.setStacked(true);
        ChartFactory.setChartFontAttr(bar2DPlot);
        bar2DPlot.setSeriesOverlapPercent(1.0);
        return bar2DPlot;
    }

    public static Bar2DPlot createPercentStackBar2DPlot() {
        Bar2DPlot bar2DPlot = new Bar2DPlot();
        ChartFactory.setChartFontAttr(bar2DPlot);
        bar2DPlot.setStacked(true);
        bar2DPlot.setSeriesOverlapPercent(1.0);
        Axis axis = bar2DPlot.getyAxis();
        axis.setPercentage(true);
        axis.setFormat((Format)new CoreDecimalFormat(new DecimalFormat("#0%"), "#0%"));
        return bar2DPlot;
    }

    public static Bar3DPlot createBar3DPlot() {
        Bar3DPlot bar3DPlot = new Bar3DPlot();
        ChartFactory.setChartFontAttr(bar3DPlot);
        bar3DPlot.setSeriesOverlapPercent(1.0);
        return bar3DPlot;
    }

    public static Bar3DPlot create3DHorizonDrawPlot() {
        Bar3DPlot bar3DPlot = new Bar3DPlot();
        ChartFactory.setChartFontAttr(bar3DPlot);
        bar3DPlot.setHorizontalDrawBar(true);
        bar3DPlot.setSeriesOverlapPercent(-0.5);
        return bar3DPlot;
    }

    public static Bar3DPlot create3DStackPlot() {
        Bar3DPlot bar3DPlot = new Bar3DPlot();
        ChartFactory.setChartFontAttr(bar3DPlot);
        bar3DPlot.setStacked(true);
        bar3DPlot.setSeriesOverlapPercent(1.0);
        return bar3DPlot;
    }

    public static Bar3DPlot create3DPercentStackPlot() {
        Bar3DPlot bar3DPlot = new Bar3DPlot();
        ChartFactory.setChartFontAttr(bar3DPlot);
        bar3DPlot.setStacked(true);
        bar3DPlot.setSeriesOverlapPercent(1.0);
        bar3DPlot.getyAxis().setPercentage(true);
        bar3DPlot.getyAxis().setFormat((Format)new CoreDecimalFormat(new DecimalFormat("#0%"), "#0%"));
        return bar3DPlot;
    }

    public static void createSeriesMap4CustomPlot(CustomPlot customPlot) {
        ConditionCollection conditionCollection = customPlot.getCustomTypeCondition();
        conditionCollection.clearConditionAttr();
        conditionCollection.setDefaultAttr(ChartFactory.createCustomAttrWithType(ChartCustomRendererType.BAR_RENDERER, ChartAxisPosition.AXIS_LEFT, 0, true));
        conditionCollection.addConditionAttr(ChartFactory.createCustomAttrWithType(ChartCustomRendererType.LINE_RENDERER, ChartAxisPosition.AXIS_RIGHT, 1, false));
    }

    public static CustomAttr createCustomAttrWithType(ChartCustomRendererType chartCustomRendererType, ChartAxisPosition chartAxisPosition, int n, boolean bl) {
        DataSeriesCondition dataSeriesCondition;
        CustomAttr customAttr = new CustomAttr(chartCustomRendererType);
        switch (chartCustomRendererType) {
            case AREA_RENDERER: 
            case LINE_RENDERER: {
                dataSeriesCondition = new AttrLineSeries(chartAxisPosition);
                break;
            }
            case AREA_STACK: {
                dataSeriesCondition = new AttrAreaSeries(chartAxisPosition);
                break;
            }
            case BAR3D: 
            case BAR3D_STACK: {
                dataSeriesCondition = new AttrAxisPosition(chartAxisPosition);
                break;
            }
            default: {
                dataSeriesCondition = new AttrBarSeries(chartAxisPosition);
            }
        }
        customAttr.addDataSeriesCondition(dataSeriesCondition);
        if (!bl) {
            ListCondition listCondition = new ListCondition();
            listCondition.addJoinCondition(0, (Condition)new CommonCondition(ChartConstants.SERIES_INDEX, 0, (Object)new Integer(n + 1)));
            customAttr.setCondition((AbstractCondition)listCondition);
            customAttr.setName(Inter.getLocText((String)"FR-Chart-Series_Setting") + n);
        }
        return customAttr;
    }
}

