/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.base;

import com.fr.base.BaseUtils;
import com.fr.base.DoubleDimension2D;
import com.fr.base.GraphHelper;
import com.fr.base.Style;
import com.fr.base.Utils;
import com.fr.chart.base.AttrContents;
import com.fr.chart.base.TextAttr;
import com.fr.general.FRFont;
import com.fr.general.Inter;
import com.fr.stable.CoreConstants;
import com.fr.stable.CoreGraphHelper;
import com.fr.stable.StringUtils;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.font.FontRenderContext;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public abstract class GlyphUtils {
    private static final double PIE_ANGLE = 180.0;
    private static final int CH_NUM = 127;

    public static void drawStrings(Graphics graphics, String string, TextAttr textAttr, Rectangle2D rectangle2D, int n) {
        if (rectangle2D == null || StringUtils.isEmpty((String)string)) {
            return;
        }
        Style style = GlyphUtils.createStyleFromTextAttr(textAttr);
        GlyphUtils.drawStringWithStyle(graphics, rectangle2D, string, style, n);
    }

    private static void drawStringWithStyle(Graphics graphics, Rectangle2D rectangle2D, String string, Style style, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(rectangle2D.getX(), rectangle2D.getY());
        String string2 = GlyphUtils.changeAllReline2Normal(string);
        String[] stringArray = string2.split(AttrContents.RelineSeparation);
        for (int i = 0; i < stringArray.length; ++i) {
            if (style.getVerticalText() == 1) {
                GlyphUtils.drawStringWhenVertical(graphics2D, stringArray[i], style, rectangle2D.getHeight(), n);
                continue;
            }
            BaseUtils.drawStringStyleInRotation((Graphics2D)graphics2D, (int)((int)rectangle2D.getWidth()), (int)((int)rectangle2D.getHeight()), (String)string, (Style)style, (int)n);
            if (style.getRotation() == 0) continue;
            BaseUtils.drawStringStyleInRotation((Graphics2D)graphics2D, (int)((int)rectangle2D.getWidth()), (int)((int)rectangle2D.getHeight()), (String)string, (Style)style, (int)n);
        }
        graphics2D.translate(-rectangle2D.getX(), -rectangle2D.getY());
    }

    private static void drawStringWhenVertical(Graphics2D graphics2D, String string, Style style, double d, int n) {
        Font font = graphics2D.getFont();
        Paint paint = graphics2D.getPaint();
        FRFont fRFont = style.getFRFont();
        graphics2D.setPaint(fRFont.getForeground());
        Font font2 = GlyphUtils.getFont4StringInSystem(fRFont.applyResolutionNP(n), string);
        graphics2D.setFont(font2);
        double d2 = (double)font2.getSize() * 0.8;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            String string2 = String.valueOf(string.charAt(i));
            Rectangle2D rectangle2D = font2.getStringBounds(string2, CoreConstants.DEFAULT_FRC);
            if (c > '\u007f' && c != '\u2026') {
                graphics2D.drawString(string2, (float)((double)(fRFont.getSize() / 2) - rectangle2D.getWidth() / 2.0), (float)d2);
                d2 += rectangle2D.getHeight();
                continue;
            }
            if (i == 0) {
                d2 = font2.getSize();
            }
            double d3 = (double)font2.getSize() * (c == '\u2026' ? 0.7 : 0.5);
            GraphHelper.drawRotatedString((Graphics)graphics2D, (String)String.valueOf(c), (double)d3, (double)(d2 - (double)font2.getSize() * 0.5), (int)90);
            d2 += rectangle2D.getWidth();
        }
        graphics2D.setPaint(paint);
        graphics2D.setFont(font);
    }

    private static Style createStyleNoRotationFormTextAttr(TextAttr textAttr) {
        if (textAttr == null) {
            textAttr = new TextAttr();
        }
        Style style = textAttr.getFRFont() != null ? Style.getInstance((FRFont)textAttr.getFRFont()) : Style.getInstance();
        style = style.deriveVerticalText(textAttr.getAlignText());
        style = style.derivePadding(0, 0);
        return style;
    }

    private static Style createStyleFromTextAttr(TextAttr textAttr) {
        if (textAttr == null) {
            textAttr = new TextAttr();
        }
        Style style = GlyphUtils.createStyleNoRotationFormTextAttr(textAttr);
        return style.deriveRotation(textAttr.getRotation());
    }

    public static Dimension2D calculateTextDimensionWithRotation(String string, TextAttr textAttr, int n) {
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation(string, textAttr, n);
        return GlyphUtils.calDimWithRotation(dimension2D, textAttr);
    }

    private static Dimension2D calDimWithRotation(Dimension2D dimension2D, TextAttr textAttr) {
        if (textAttr != null && textAttr.getRotation() != 0) {
            int n = textAttr.getRotation();
            double d = (double)n * Math.PI / 180.0;
            double d2 = Math.abs(Math.cos(d) * dimension2D.getWidth()) + Math.abs(Math.sin(d) * dimension2D.getHeight());
            double d3 = Math.abs(Math.cos(d) * dimension2D.getHeight()) + Math.abs(Math.sin(d) * dimension2D.getWidth());
            return new DoubleDimension2D(d2, d3);
        }
        return dimension2D;
    }

    public static void drawAxisVerticalTitle(Graphics graphics, String string, TextAttr textAttr, Rectangle2D rectangle2D, int n) {
        if (rectangle2D == null || StringUtils.isEmpty((String)string)) {
            return;
        }
        Style style = GlyphUtils.createStyleFromTextAttr(textAttr);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(rectangle2D.getX(), rectangle2D.getY());
        String string2 = GlyphUtils.changeAllReline2Normal(string);
        String[] stringArray = string2.split(AttrContents.RelineSeparation);
        Font font = graphics2D.getFont();
        Paint paint = graphics2D.getPaint();
        FRFont fRFont = style.getFRFont();
        TextAttr textAttr2 = new TextAttr();
        textAttr2.setRotation(textAttr.getRotation());
        textAttr2.setFRFont(fRFont);
        for (int i = 0; i < stringArray.length; ++i) {
            GlyphUtils.drawStrings(graphics2D, string, textAttr2, rectangle2D, n);
        }
        graphics2D.setPaint(paint);
        graphics2D.setFont(font);
        graphics2D.translate(-rectangle2D.getX(), -rectangle2D.getY());
    }

    public static Dimension2D calculateTextDimensionWithNoRotation(String string, TextAttr textAttr, int n) {
        FRFont fRFont;
        if (StringUtils.isEmpty((String)string)) {
            return new Dimension(0, 0);
        }
        if (textAttr == null) {
            textAttr = new TextAttr();
        }
        if ((fRFont = textAttr.getFRFont()) == null) {
            fRFont = FRFont.getInstance();
        }
        Font font = GlyphUtils.getFont4StringInSystem(fRFont.applyResolutionNP(n), string);
        double d = 0.0;
        double d2 = 0.0;
        if (textAttr.getAlignText() == 1) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                String string2 = String.valueOf(c);
                Rectangle2D rectangle2D = font.getStringBounds(string2, CoreConstants.DEFAULT_FRC);
                if (c > '\u007f' && c != '\u2026') {
                    d = Math.max(d, rectangle2D.getWidth());
                    d2 += rectangle2D.getHeight();
                    continue;
                }
                d = Math.max(d, rectangle2D.getHeight());
                d2 += rectangle2D.getWidth();
            }
        } else {
            BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage((int)10, (int)10, (int)6);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            String string3 = GlyphUtils.changeAllReline2Normal(string);
            String[] stringArray = string3.split(AttrContents.RelineSeparation);
            for (int i = 0; i < stringArray.length; ++i) {
                Dimension2D dimension2D = GraphHelper.stringDimensionWithRotation((String)stringArray[i], (Font)font, (int)0, (FontRenderContext)CoreConstants.DEFAULT_FRC);
                d = Math.max(d, GraphHelper.stringWidth((String)stringArray[i], (Font)font, (FontRenderContext)fontRenderContext));
                d2 += dimension2D.getHeight();
            }
        }
        return new DoubleDimension2D(d, d2);
    }

    public static Font getFont4StringInSystem(Font font, String string) {
        if (StringUtils.isEmpty((String)string)) {
            return font;
        }
        FRFont fRFont = FRFont.getInstance((String)Inter.getLocText((String)"Chart-Song_TypeFace"), (int)font.getStyle(), (float)font.getSize());
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (font.canDisplay(string.charAt(i))) continue;
            return fRFont;
        }
        return font;
    }

    public static String changeAllReline2Normal(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\\' && i + 1 < string.length() && string.charAt(i + 1) == 'n') {
                ++i;
                stringBuffer.append(AttrContents.RelineSeparation);
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return Utils.objectToString((Object)stringBuffer);
    }
}

