/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.base;

import com.fr.base.BaseUtils;
import com.fr.chart.base.CannyTest;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.stable.image4j.util.ImageUtil;
import ij.IJ;
import ij.ImagePlus;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;

public class ColorSelect4Shape {
    private static final int DIR_0 = 0;
    private static final int DIR_1 = 1;
    private static final int DIR_2 = 2;
    private static final int DIR_3 = 3;
    private static final int DIR_4 = 4;
    private static final int DIR_5 = 5;
    private static final int DIR_6 = 6;
    private static final int DIR_7 = 7;
    private static final int DIR_8 = 8;
    private static final int DIR_9 = 9;
    private static final int DIR_10 = 10;
    private static final int DIR_11 = 11;
    private static final int DIR_12 = 12;
    private static final int DIR_13 = 13;
    private static final int DIR_14 = 14;
    private static final int DIR_15 = 15;
    private static final int DIR_NUM = 16;
    private static final int TWO_DIR = 2;
    private static final double OFF_DIR = 0.5;
    private static final int FIVE_MOVE = 5;
    private static final int JION_SIZE = 6;
    private static final int SAFE_NUMBER = 3000;
    private static final int OFFSET = 10;
    private static final int SAFE_POINT = 400;
    private static final int NO_VALUE = -11;
    private static final int ERROR_DIR = -1;
    private static final int LINE_POINT_NUM = 50;
    private static final int SELECT_POINT_SIZE = 100;
    private static final Image QZIMAGE = BaseUtils.readImage((String)"com/fr/chart/base/quanzhoucom.png");
    private static int QWIDTH = QZIMAGE.getWidth(null);
    private static int QHEIGHT = QZIMAGE.getHeight(null);
    private static int[] QZINT = ImageUtil.image2Pixs((Image)QZIMAGE, (int)QWIDTH, (int)QHEIGHT);
    private int selectX;
    private int selectY;
    private int startX;
    private int startY;
    private int imageWidth;
    private int[] ai;
    private Image image;
    private ImagePlus imagePlus;
    private boolean useOldMethod4Com = false;

    public ColorSelect4Shape() {
    }

    public ColorSelect4Shape(int n, int n2, Image image) {
        this.makesureClickPoint(n, n2);
        this.makesureImage(image);
    }

    public void makesureImage(Image image) {
        this.check4UseOld(image);
        if (this.useOldMethod4Com) {
            int n = image.getWidth(null);
            int n2 = image.getHeight(null);
            this.imageWidth = n;
            CannyTest cannyTest = new CannyTest();
            cannyTest.setSourceImage(image);
            try {
                cannyTest.process();
            }
            catch (Exception exception) {
                FRLogger.getLogger().error("Error in Image to Edge");
            }
            byte[] byArray = ImageUtil.Thinner2((byte[])ImageUtil.toBinary((int[])CannyTest.image2pixels(cannyTest.getEdgeImage()), (int)n, (int)n2), (int)n, (int)n2);
            this.ai = ImageUtil.bin2Rgb((byte[])byArray, (int)n, (int)n2);
        } else if (this.imagePlus == null) {
            this.imagePlus = new ImagePlus("In", image);
        } else {
            this.imagePlus.setImage(image);
        }
        this.image = image;
    }

    private void check4UseOld(Image image) {
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        int[] nArray = ImageUtil.image2Pixs((Image)image, (int)n, (int)n2);
        this.useOldMethod4Com = ComparatorUtils.equals((int[])QZINT, (int[])nArray);
    }

    private boolean selectAll(GeneralPath generalPath) {
        if (generalPath.getBounds() != null && this.image != null) {
            double d = generalPath.getBounds().getWidth();
            double d2 = generalPath.getBounds().getHeight();
            double d3 = this.image.getWidth(new JPanel());
            double d4 = this.image.getHeight(new JPanel());
            return d == d3 && d2 == d4;
        }
        return false;
    }

    public void makesureClickPoint(double d, double d2) {
        this.selectX = (int)d;
        this.selectY = (int)d2;
    }

    public boolean hasLoadedImage(Image image) {
        return ComparatorUtils.equals((Object)image, (Object)this.image);
    }

    public GeneralPath getSelectedPath() {
        if (this.useOldMethod4Com) {
            return this.getOldPath();
        }
        GeneralPath generalPath = new GeneralPath();
        if (this.imagePlus != null) {
            generalPath = IJ.doWand4Path((ImagePlus)this.imagePlus, (int)this.selectX, (int)this.selectY);
        }
        if (!generalPath.contains(this.selectX, this.selectY) || this.selectAll(generalPath)) {
            return new GeneralPath();
        }
        return generalPath;
    }

    private GeneralPath getOldPath() {
        int n;
        int n2;
        GeneralPath generalPath = new GeneralPath(0);
        int n3 = this.getXYColorValue(this.selectX, this.selectY);
        if (!this.check4SelectInLine() || this.outOfMap()) {
            return new GeneralPath();
        }
        this.startX = this.selectX;
        this.startY = this.selectY;
        int n4 = 0;
        for (n2 = this.selectX; n2 > 0; --n2) {
            n = this.getXYColorValue(n2, this.selectY);
            if (n == n3) continue;
            n4 = n;
            this.startX = n2;
            break;
        }
        if (this.checkIn5(this.selectX, this.selectY, n3)) {
            return this.dealNotSelectPath(n4);
        }
        n2 = this.startX;
        n = this.startY;
        generalPath.moveTo(this.startX, this.startY);
        LinkedList<Point2D.Double> linkedList = new LinkedList<Point2D.Double>();
        ArrayList arrayList = new ArrayList();
        int n5 = -1;
        linkedList.add(new Point2D.Double(n2, n));
        for (int i = 0; i < 3000; ++i) {
            int[] nArray = this.getAllLinePoint(new Point2D.Double(n2, n), n4, n5, linkedList, arrayList);
            if (nArray == null) break;
            n5 = nArray[0];
            n2 = nArray[1];
            n = nArray[2];
        }
        for (int i = 0; i < linkedList.size(); ++i) {
            Point2D point2D = (Point2D)linkedList.get(i);
            generalPath.lineTo((float)point2D.getX(), (float)point2D.getY());
        }
        if (!generalPath.contains(new Point(this.selectX, this.selectY))) {
            return this.dealNotSelectPath(n4);
        }
        return generalPath;
    }

    private boolean checkIn5(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 6;
        for (n5 = 0; n5 < n10 && (n4 = this.getXYColorValue(n + n5, n2)) == n3; ++n5) {
            ++n8;
        }
        for (n5 = 0; n5 < n10 && (n4 = this.getXYColorValue(n - n5, n2)) == n3; ++n5) {
            ++n7;
        }
        for (n5 = 0; n5 < n10 && (n4 = this.getXYColorValue(n, n2 + n5)) == n3; ++n5) {
            ++n9;
        }
        for (n5 = 0; n5 < n10 && (n4 = this.getXYColorValue(n, n2 - n5)) == n3; ++n5) {
            ++n6;
        }
        return n9 < n10 && n6 < n10 && n7 < n10 && n8 < n10;
    }

    private GeneralPath dealNotSelectPath(int n) {
        try {
            return this.getScanPath(n);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error("Error In Select Shape");
            return new GeneralPath();
        }
    }

    private boolean check4SelectInLine() {
        int n = 1;
        int n2 = this.getXYColorValue(this.selectX, this.selectY);
        for (int i = this.selectX - 5; i < this.selectX + 5; ++i) {
            for (int j = this.selectY - 5; j < this.selectY + 5; ++j) {
                int n3 = this.getXYColorValue(i, j);
                if (n3 != n2) continue;
                ++n;
            }
        }
        return n > 50;
    }

    private boolean outOfMap() {
        int n;
        int n2;
        int n3;
        boolean bl = false;
        int n4 = this.getXYColorValue(this.selectX, this.selectY);
        for (n3 = this.selectX - 1; n3 > 0 && (n2 = this.getXYColorValue(n3, this.selectY)) == n4; --n3) {
            if (n3 != 1) continue;
            return true;
        }
        for (n3 = this.selectX + 1; n3 < this.imageWidth && (n2 = this.getXYColorValue(n3, this.selectY)) == n4; ++n3) {
            if (n3 != this.imageWidth - 1) continue;
            return true;
        }
        for (n3 = this.selectY - 1; n3 > 0 && (n2 = this.getXYColorValue(this.selectX, n3)) == n4; --n3) {
            if (n3 != 1) continue;
            return true;
        }
        n3 = this.image.getHeight(null);
        for (n2 = this.selectY + 1; n2 < n3 && (n = this.getXYColorValue(this.selectX, n2)) == n4; ++n2) {
            if (n2 != n3 - 1) continue;
            return true;
        }
        return bl;
    }

    private boolean isNotJoinOldPath(LinkedList linkedList, Point2D point2D) {
        int n = linkedList.size();
        if (n > 6) {
            Point2D point2D2 = (Point2D)linkedList.getLast();
            for (int i = 1; i < 6; ++i) {
                Point2D point2D3;
                Point2D point2D4 = (Point2D)linkedList.get(n - i);
                if (!this.isJoin(point2D4, point2D3 = (Point2D)linkedList.get(n - i - 1), point2D2, point2D)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isJoin(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4) {
        Point2D.Double double_ = new Point2D.Double(point2D.getX() - point2D3.getX(), point2D.getY() - point2D3.getY());
        Point2D.Double double_2 = new Point2D.Double(point2D2.getX() - point2D3.getX(), point2D2.getY() - point2D3.getY());
        Point2D.Double double_3 = new Point2D.Double(point2D4.getX() - point2D3.getX(), point2D4.getY() - point2D3.getY());
        double d = this.crossMul(double_, double_3) * this.crossMul(double_2, double_3);
        Point2D.Double double_4 = new Point2D.Double(point2D3.getX() - point2D.getX(), point2D3.getY() - point2D.getY());
        Point2D.Double double_5 = new Point2D.Double(point2D4.getX() - point2D.getX(), point2D4.getY() - point2D.getY());
        Point2D.Double double_6 = new Point2D.Double(point2D2.getX() - point2D.getX(), point2D2.getY() - point2D.getY());
        double d2 = this.crossMul(double_4, double_6) * this.crossMul(double_5, double_6);
        return d < 0.0 && d2 < 0.0;
    }

    private double crossMul(Point2D point2D, Point2D point2D2) {
        return point2D.getX() * point2D2.getY() - point2D.getY() * point2D2.getX();
    }

    private int[] getAllLinePoint(Point2D point2D, int n, int n2, LinkedList linkedList, List list) {
        int n3;
        int n4;
        int n5;
        int n6;
        ArrayList<Point2D.Double> arrayList = new ArrayList<Point2D.Double>();
        int n7 = (int)point2D.getX();
        int n8 = (int)point2D.getY();
        for (n6 = 0; n6 < 5; ++n6) {
            for (n5 = 0; n5 < 5; ++n5) {
                int n9;
                if (n6 == 0 && n5 == 0 || (n9 = this.getXYColorValue(n4 = n7 + n6 - 2, n3 = n8 + n5 - 2)) != n) continue;
                Point2D.Double double_ = new Point2D.Double(n4, n3);
                if (linkedList.size() > 100 && ComparatorUtils.equals((Object)new Point2D.Double(this.startX, this.startY), (Object)double_)) {
                    return null;
                }
                if (linkedList.contains(double_) || arrayList.contains(double_) || list.contains(double_) || !this.isNotJoinOldPath(linkedList, double_)) continue;
                arrayList.add(double_);
            }
        }
        if (arrayList.isEmpty()) {
            return this.whenListEmpty(point2D, n, n2, linkedList, list);
        }
        n6 = n2 == -1 ? -1 : (n2 + 8) % 16;
        n5 = 0;
        n4 = 16;
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            int n10;
            Point2D point2D2 = (Point2D)arrayList.get(n3);
            int n11 = this.getDirection(point2D, point2D2);
            if (n6 == -1) {
                n6 = n11 > 0 && n11 < 8 ? n11 : (n11 + 8) % 16;
            }
            if ((n10 = this.nextToDir(n11, n6)) >= n4 || n10 <= 2) continue;
            n4 = n10;
            n5 = n3;
        }
        n3 = (n6 - n4 + 16) % 16;
        Point2D point2D3 = (Point2D)arrayList.get(n5);
        linkedList.add(point2D3);
        return new int[]{n3, (int)point2D3.getX(), (int)point2D3.getY()};
    }

    private int[] whenListEmpty(Point2D point2D, int n, int n2, LinkedList linkedList, List list) {
        if (linkedList.size() > 3000) {
            return null;
        }
        Point2D point2D2 = (Point2D)linkedList.getLast();
        if (Point2D.distanceSq(this.startX, this.startY, point2D2.getX(), point2D2.getY()) < 5.0) {
            return null;
        }
        list.add(point2D);
        linkedList.remove(point2D);
        Point2D point2D3 = (Point2D)linkedList.get(linkedList.size() - 1);
        Point2D point2D4 = (Point2D)linkedList.get(linkedList.size() - 2);
        n2 = this.getDirection(point2D3, point2D4);
        return this.getAllLinePoint(point2D3, n, n2, linkedList, list);
    }

    private int nextToDir(int n, int n2) {
        int n3;
        for (n3 = 1; n3 < 16 && (n2 - n3 + 16) % 16 != n; ++n3) {
        }
        return n3;
    }

    private int getDirection(Point2D point2D, Point2D point2D2) {
        double d = point2D2.getX() - point2D.getX();
        double d2 = point2D2.getY() - point2D.getY();
        if (d > 0.0 && d2 == 0.0) {
            return 0;
        }
        if (d > 0.0 && d2 > 0.0 && d2 / d == 0.5) {
            return 15;
        }
        if (d > 0.0 && d2 > 0.0 && d == d2) {
            return 14;
        }
        if (d > 0.0 && d2 > 0.0 && d2 / d == 2.0) {
            return 13;
        }
        if (d == 0.0 && d2 > 0.0) {
            return 12;
        }
        if (d < 0.0 && d2 > 0.0 && d2 / d == -2.0) {
            return 11;
        }
        if (d < 0.0 && d2 > 0.0 && d2 == -d) {
            return 10;
        }
        if (d < 0.0 && d2 > 0.0 && d2 / d == -0.5) {
            return 9;
        }
        if (d < 0.0 && d2 == 0.0) {
            return 8;
        }
        if (d < 0.0 && d2 < 0.0 && d2 / d == 0.5) {
            return 7;
        }
        if (d < 0.0 && d2 < 0.0 && d2 == d) {
            return 6;
        }
        if (d < 0.0 && d2 < 0.0 && d2 / d == 2.0) {
            return 5;
        }
        if (d == 0.0 && d2 < 0.0) {
            return 4;
        }
        if (d > 0.0 && d2 < 0.0 && d2 / d == -2.0) {
            return 3;
        }
        if (d > 0.0 && d2 < 0.0 && d2 == -d) {
            return 2;
        }
        if (d > 0.0 && d2 < 0.0 && d2 / d == -0.5) {
            return 1;
        }
        return -1;
    }

    private int getXYColorValue(int n, int n2) {
        if (n < 0 || n2 < 0) {
            return -11;
        }
        if (n2 * this.imageWidth + n < this.ai.length) {
            return this.ai[n2 * this.imageWidth + n];
        }
        return -11;
    }

    private GeneralPath getScanPath(int n) {
        ArrayList arrayList = new ArrayList();
        int n2 = this.selectX;
        int n3 = this.selectY;
        int n4 = this.getLeftLineXInSameY(n2, n3, n);
        int n5 = this.getRightLineXInSameY(n2, n3, n);
        this.dealPointInLowWave(n4, n5, n3, arrayList, n);
        this.dealPointInLowWave(n5, n4, n3, arrayList, n);
        GeneralPath generalPath = new GeneralPath(0);
        int n6 = arrayList.size();
        for (int i = 0; i < n6; ++i) {
            Point2D point2D = (Point2D)arrayList.get(i);
            if (i == 0) {
                generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
                continue;
            }
            generalPath.lineTo((float)point2D.getX(), (float)point2D.getY());
        }
        generalPath.closePath();
        return generalPath;
    }

    private void dealPointInLowWave(int n, int n2, int n3, List list, int n4) {
        if (list.size() > 400) {
            return;
        }
        int n5 = (n + n2) / 2;
        int n6 = n;
        list.add(new Point2D.Double(n, n3));
        int n7 = 10;
        if (n < n5) {
            this.dealLowScan(n3, n5, n6, list, n4, n7);
        } else {
            this.dealHighScan(n3, n5, n6, list, n4, n7);
        }
    }

    private void dealLowScan(int n, int n2, int n3, List list, int n4, int n5) {
        int n6;
        int n7;
        int n8 = this.getScanBottomEndY(n2, n, n4);
        for (n7 = n; n7 <= n8; ++n7) {
            n6 = this.getLeftLineXInSameY(n2, n7, n4);
            if (Math.abs(n3 - n6) >= n5) continue;
            n3 = n6;
            list.add(new Point2D.Double(n6 - 1, n7));
        }
        if (n3 != n2) {
            // empty if block
        }
        for (n7 = n8; n7 >= n; --n7) {
            n6 = this.getRightLineXInSameY(n2, n7, n4);
            if (Math.abs(n3 - n6) >= n5 && n7 != n8) continue;
            n3 = n6;
            list.add(new Point2D.Double(n6 + 1, n7));
        }
    }

    private void dealHighScan(int n, int n2, int n3, List list, int n4, int n5) {
        int n6;
        int n7;
        int n8 = this.getScanTopEndY(n2, n, n4);
        for (n7 = n; n7 >= n8; --n7) {
            n6 = this.getRightLineXInSameY(n2, n7, n4);
            if (Math.abs(n3 - n6) >= n5) continue;
            n3 = n6;
            list.add(new Point2D.Double(n6 + 1, n7));
        }
        if (n2 != n3) {
            // empty if block
        }
        for (n7 = n8; n7 <= n; ++n7) {
            n6 = this.getLeftLineXInSameY(n2, n7, n4);
            if (Math.abs(n3 - n6) >= n5 && n7 != n8) continue;
            n3 = n6;
            list.add(new Point2D.Double(n6 - 1, n7));
        }
    }

    private int getScanBottomEndY(int n, int n2, int n3) {
        for (int i = n2; i > 0; ++i) {
            int n4 = this.getXYColorValue(n, i);
            if (n4 != n3) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    private int getScanTopEndY(int n, int n2, int n3) {
        for (int i = n2; i > 0; --i) {
            int n4 = this.getXYColorValue(n, i);
            if (n4 != n3) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    private int getLeftLineXInSameY(int n, int n2, int n3) {
        int n4 = n;
        for (int i = n; i > 0; --i) {
            int n5 = this.getXYColorValue(i, n2);
            if (n5 != n3) continue;
            n4 = i;
            break;
        }
        return n4;
    }

    private int getRightLineXInSameY(int n, int n2, int n3) {
        int n4 = n;
        for (int i = n; i > 0; ++i) {
            int n5 = this.getXYColorValue(i, n2);
            if (n5 != n3) continue;
            n4 = i;
            break;
        }
        return n4;
    }
}

