/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.base;

import com.fr.base.Base64;
import com.fr.base.ChartPreStyleManagerProvider;
import com.fr.base.ChartPreStyleServerManager;
import com.fr.base.ConfigManager;
import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.TextFormat;
import com.fr.base.Utils;
import com.fr.base.background.ImageBackground;
import com.fr.base.background.PatternBackground;
import com.fr.base.background.TextureBackground;
import com.fr.base.chart.ChartWebSource;
import com.fr.cache.Attachment;
import com.fr.cache.AttachmentSource;
import com.fr.chart.base.AttrFillStyle;
import com.fr.chart.base.ChartConstants;
import com.fr.chart.base.ChartPreStyle;
import com.fr.chart.base.ChartUtils;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.TextAttr;
import com.fr.general.Background;
import com.fr.general.DateUtils;
import com.fr.general.FRFont;
import com.fr.general.IOUtils;
import com.fr.general.Inter;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.core.UUID;
import com.fr.stable.web.Repository;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ChartBaseUtils {
    private static final int COINT = 6;
    private static final double BAOHE = 0.3;
    private static final double GAP = 0.8;
    private static final double MORE_BAO = 0.9;
    private static final double CHART_BOUNDER = 10.0;
    public static final String PT = "pt";
    public static final String BOLD = "bold";
    public static final String ITALIC = "italic";

    public static String dealLabelStringAutoWrap(String string, TextAttr textAttr, int n, double d) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            stringBuffer2.append(c);
            Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation(stringBuffer2 + " ", textAttr, n);
            if (!(dimension2D.getWidth() > d) || c == '\\') continue;
            stringBuffer.append(stringBuffer2 + "\n");
            stringBuffer2.delete(0, stringBuffer2.length());
        }
        stringBuffer.append(stringBuffer2);
        return Utils.objectToString((Object)stringBuffer);
    }

    public static JSONObject getCSSFontJSONWithFont(FRFont fRFont) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (fRFont == null) {
            return jSONObject;
        }
        jSONObject.put("fontFamily", (Object)fRFont.getName());
        jSONObject.put("fontSize", (Object)(fRFont.getSize() + PT));
        jSONObject.put("color", (Object)StableUtils.javaColor2JSColorWithAlpha((Color)fRFont.getForeground()));
        if (StringUtils.contains((String)fRFont.getStyleName(), (String)Inter.getLocText((String)"FR-Designer-FRFont_Bold"))) {
            jSONObject.put("fontWeight", (Object)BOLD);
        } else {
            jSONObject.put("fontWeight", (Object)"");
        }
        if (StringUtils.contains((String)fRFont.getStyleName(), (String)Inter.getLocText((String)"FR-Designer-FRFont_Italic"))) {
            jSONObject.put("fontStyle", (Object)ITALIC);
        }
        return jSONObject;
    }

    public static JSONObject getCSSFontJSON(FRFont fRFont, Repository repository) throws JSONException {
        JSONObject jSONObject = ChartBaseUtils.getCSSFontJSONWithFont(fRFont);
        if (fRFont != null) {
            double d = repository == null ? 1.0 : repository.getFontScale();
            double d2 = (double)fRFont.getSize() * d;
            jSONObject.put("fontSize", (Object)(d2 + PT));
        }
        return jSONObject;
    }

    public static Number formula2Number(Formula formula) {
        if (formula == null) {
            return null;
        }
        if (formula.getResult() != null) {
            Date date;
            String string = Utils.objectToString((Object)formula.getResult());
            Number number = Utils.string2Number((String)string);
            if (number == null && (date = DateUtils.string2Date((String)string, (boolean)true)) != null) {
                return new Double(ChartBaseUtils.date2Int(date, 6));
            }
            return number;
        }
        String string = formula.getContent();
        if (string.startsWith("=")) {
            string = string.substring(1);
        }
        return Utils.string2Number((String)string);
    }

    public static JSONObject generalPath2JS(GeneralPath generalPath) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        JSONArray jSONArray2 = new JSONArray();
        JSONArray jSONArray3 = new JSONArray();
        JSONArray jSONArray4 = new JSONArray();
        double[] dArray = new double[6];
        int n = -1;
        PathIterator pathIterator = generalPath.getPathIterator(new AffineTransform());
        while (!pathIterator.isDone()) {
            JSONObject jSONObject2;
            n = pathIterator.currentSegment(dArray);
            if (n == 0 || n == 1) {
                jSONArray.put(dArray[0]);
                jSONArray2.put(dArray[1]);
                jSONArray3.put(n);
                jSONArray4.put((Object)"");
            } else if (n == 4) {
                jSONArray.put(0);
                jSONArray2.put(0);
                jSONArray3.put(n);
                jSONArray4.put((Object)"");
            } else if (n == 2) {
                jSONArray.put(dArray[2]);
                jSONArray2.put(dArray[3]);
                jSONArray3.put(n);
                jSONObject2 = new JSONObject();
                jSONObject2.put("x", dArray[0]);
                jSONObject2.put("y", dArray[1]);
                jSONArray4.put((Object)jSONObject2);
            } else if (n == 3) {
                jSONArray.put(dArray[4]);
                jSONArray2.put(dArray[5]);
                jSONArray3.put(n);
                jSONObject2 = new JSONObject();
                jSONObject2.put("x0", dArray[0]);
                jSONObject2.put("y0", dArray[1]);
                jSONObject2.put("x1", dArray[2]);
                jSONObject2.put("y1", dArray[3]);
                jSONArray4.put((Object)jSONObject2);
            }
            pathIterator.next();
        }
        jSONObject.put("x", (Object)jSONArray);
        jSONObject.put("y", (Object)jSONArray2);
        jSONObject.put("type", (Object)jSONArray3);
        jSONObject.put("ctrl", (Object)jSONArray4);
        return jSONObject;
    }

    public static String generalPath2Android(GeneralPath generalPath) {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "_";
        double[] dArray = new double[6];
        int n = -1;
        Object object = generalPath.getPathIterator(new AffineTransform());
        while (!object.isDone()) {
            n = object.currentSegment(dArray);
            if (n == 0 || n == 1) {
                string = string + dArray[0] + string5;
                string2 = string2 + dArray[1] + string5;
                string3 = string3 + n + string5;
                string4 = string4 + " " + string5;
            } else if (n == 4) {
                string = string + 0 + string5;
                string2 = string2 + 0 + string5;
                string3 = string3 + n + string5;
                string4 = string4 + "" + string5;
            } else if (n == 2) {
                string = string + dArray[2] + string5;
                string2 = string2 + dArray[3] + string5;
                string3 = string3 + n + string5;
                string4 = string4 + dArray[0] + "qt" + dArray[1] + string5;
            } else if (n == 3) {
                string = string + dArray[4] + string5;
                string2 = string2 + dArray[5] + string5;
                string3 = string3 + n + string5;
                string4 = string4 + dArray[0] + "ct" + dArray[1] + "ct" + dArray[2] + "ct" + dArray[3] + string5;
            }
            object.next();
        }
        object = "_pt_";
        return string + (String)object + string2 + (String)object + string3 + (String)object + string4;
    }

    public static Color saturationDown(Color color) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), new float[3]);
        fArray[1] = (float)((double)fArray[1] * 0.3);
        return Color.getHSBColor(fArray[0], fArray[1], fArray[2]);
    }

    public static Color[] createFillColorArray(AttrFillStyle attrFillStyle, int n) {
        Color[] colorArray;
        block4: {
            block5: {
                block3: {
                    colorArray = new Color[n];
                    AttrFillStyle attrFillStyle2 = attrFillStyle = attrFillStyle != null && attrFillStyle.isCustomFillStyle() ? attrFillStyle : ChartBaseUtils.getServerFillStyle(attrFillStyle);
                    if (attrFillStyle != null && attrFillStyle.getColorStyle() != 0) break block3;
                    for (int i = 0; i < n; ++i) {
                        colorArray[i] = ChartConstants.CHART_COLOR_ARRAY[i % ChartConstants.CHART_COLOR_ARRAY.length];
                    }
                    break block4;
                }
                if (attrFillStyle.getColorStyle() != 1) break block5;
                for (int i = 0; i < n; ++i) {
                    colorArray[i] = attrFillStyle.getColorIndex(i);
                }
                break block4;
            }
            if (attrFillStyle.getColorStyle() != 2 || attrFillStyle.getColorSize() != 2) break block4;
            for (int i = 0; i < n; ++i) {
                colorArray[i] = ChartBaseUtils.getSeriesColor(attrFillStyle.getColorIndex(0), attrFillStyle.getColorIndex(1), i, n);
            }
        }
        return colorArray;
    }

    public static Color[] createColorsWithAlpha(Color color, int n) {
        Color[] colorArray = new Color[n];
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        if (n == 1) {
            colorArray[0] = color;
            return colorArray;
        }
        double d = 0.8 / (double)(n - 1);
        for (int i = 0; i < n; ++i) {
            int n5 = (int)(255.0 * (1.0 - (double)i * d));
            if (n5 < 0) {
                n5 = 0;
            } else if (n5 > 255) {
                n5 = 255;
            }
            colorArray[i] = new Color(n2, n3, n4, n5);
        }
        return colorArray;
    }

    public static Color[] createColorsWithHSB(Color color, int n) {
        Color[] colorArray = new Color[n];
        if (color == null) {
            return colorArray;
        }
        if (n <= 0) {
            return colorArray;
        }
        if (n == 1) {
            colorArray[0] = color;
            return colorArray;
        }
        float[] fArray = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        for (int i = 0; i < n; ++i) {
            float f4 = f2 * (1.0f - (float)i / ((float)n + 0.0f));
            float f5 = f3 + (float)i * (1.0f - f3) / ((float)n + 0.0f);
            colorArray[i] = Color.getHSBColor(f, f4, f5);
        }
        return colorArray;
    }

    private static Color getSaturationSeriesColor(Color color, int n, int n2) {
        if (n2 <= 1) {
            return color;
        }
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), new float[3]);
        if (color.getRed() == color.getBlue() && color.getBlue() == color.getGreen()) {
            fArray[2] = (float)(0.9 - 0.8 / (double)(n2 - 1) * (double)n);
        } else {
            fArray[1] = (float)(1.0 - 0.9 / (double)(n2 - 1) * (double)n);
        }
        return Color.getHSBColor(fArray[0], fArray[1], fArray[2]);
    }

    private static Color getSeriesColor(Color color, Color color2, int n, int n2) {
        if (n2 <= 1) {
            return color;
        }
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), new float[3]);
        float[] fArray2 = Color.RGBtoHSB(color2.getRed(), color2.getGreen(), color2.getBlue(), new float[3]);
        float[] fArray3 = new float[3];
        for (int i = 0; i < 3; ++i) {
            fArray3[i] = fArray[i] - (fArray[i] - fArray2[i]) / (float)(n2 - 1) * (float)n;
        }
        return Color.getHSBColor(fArray3[0] - (float)((int)fArray3[0]), fArray3[1], fArray3[2]);
    }

    public static String generalFormat(double d) {
        String string = "";
        string = d == (double)((int)d) ? "" + (int)d : "" + d;
        return string;
    }

    public static double date2Int(Date date, int n) {
        if (date == null) {
            date = new Date();
        }
        Date date2 = DateUtils.createDate((int)1970, (int)1, (int)1);
        return ChartBaseUtils.getTwoDateLength(date, date2, n);
    }

    private static double getTwoDateLength(Date date, Date date2, int n) {
        long l = 86400000L;
        if (n == 6) {
            l = 1000L;
        } else if (n == 5) {
            l = 60000L;
        } else if (n == 4) {
            l = 3600000L;
        }
        return (date.getTime() - date2.getTime()) / l;
    }

    public static Date long2Date(long l, int n) {
        Date date = DateUtils.createDate((int)1970, (int)1, (int)1);
        long l2 = 86400000L;
        if (n == 6) {
            l2 = 1000L;
        } else if (n == 5) {
            l2 = 60000L;
        } else if (n == 4) {
            l2 = 3600000L;
        }
        long l3 = l * l2 + date.getTime();
        return new Date(l3);
    }

    public static Object getObject(int n, Object[] objectArray) {
        if (objectArray == null || objectArray.length <= 0) {
            return null;
        }
        int n2 = n % objectArray.length;
        return objectArray[n2];
    }

    public static RectangularShape rectangle2RoundRectangle(Rectangle2D rectangle2D, boolean bl) {
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight(), 10.0, 10.0);
        return bl ? double_ : rectangle2D;
    }

    public static RectangularShape rectangle2RoundRectangle(Rectangle2D rectangle2D, double d) {
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight(), d, d);
        return double_;
    }

    public static JSONObject background2JS(Repository repository, Background background) {
        JSONObject jSONObject = null;
        try {
            jSONObject = background.toJSONObject();
            if (background instanceof ImageBackground) {
                ImageBackground imageBackground = (ImageBackground)background;
                ChartBaseUtils.image2JS(repository, jSONObject, imageBackground.getImage());
            } else if (background instanceof PatternBackground) {
                PatternBackground patternBackground = (PatternBackground)background;
                ChartBaseUtils.image2JS(repository, jSONObject, patternBackground.getImage());
            } else if (background instanceof TextureBackground) {
                TextureBackground textureBackground = (TextureBackground)background;
                ChartBaseUtils.image2JS(repository, jSONObject, textureBackground.getImage());
            }
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().error(jSONException.getMessage(), (Throwable)jSONException);
        }
        return jSONObject;
    }

    public static void image2JS(Repository repository, JSONObject jSONObject, Image image) throws JSONException {
        if (image == null) {
            return;
        }
        if (repository != null && repository.getDevice().isMobile()) {
            jSONObject.put("src", (Object)Base64.encode((Image)image, (String)"png"));
        } else if (repository != null && repository.getBrowser().isIE()) {
            jSONObject.put("iesrc", (Object)ChartBaseUtils.addImageAsEmb(image));
        } else {
            jSONObject.put("src", (Object)("data:image/png;base64," + Base64.encode((Image)image, (String)"png")));
        }
    }

    public static String addImageAsEmb(Image image) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.writeImage((Image)image, (String)"png", (OutputStream)byteArrayOutputStream);
        String string = UUID.randomUUID().toString();
        Attachment attachment = new Attachment(string, "image", "attach.png", byteArrayOutputStream.toByteArray());
        AttachmentSource.putAttachment((String)string, (Attachment)attachment);
        return string;
    }

    public static String addImageAsEmb(Image image, String string) {
        String string2 = ChartBaseUtils.addImageAsEmb(image);
        if (string != null) {
            ChartWebSource.putAttachment((String)string, (String)string2);
        }
        return string2;
    }

    public static String format2JS(Format format, Repository repository) {
        if (format == null) {
            return null;
        }
        String string = "";
        if (format instanceof SimpleDateFormat) {
            string = "D" + ((SimpleDateFormat)format).toPattern().trim();
        } else if (format instanceof DecimalFormat) {
            string = ((DecimalFormat)format).toPattern().trim();
        } else if (format instanceof TextFormat) {
            string = "T";
        }
        if (repository == null) {
            return string;
        }
        try {
            return repository.getDevice().isMobile() ? Base64.encode((byte[])string.getBytes(ConfigManager.getProviderInstance().getServerCharset())) : string;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return repository.getDevice().isMobile() ? Base64.encode((byte[])string.getBytes()) : string;
        }
    }

    public static String format2JS(Format format) {
        return ChartBaseUtils.format2JS(format, null);
    }

    public static BufferedImage shapeToImage(Shape shape, int n) {
        BufferedImage bufferedImage = new BufferedImage((int)shape.getBounds().getWidth() + 2 * n, (int)shape.getBounds().getHeight() + 2 * n, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(Color.BLACK);
        graphics2D.translate(-shape.getBounds().getX(), -shape.getBounds().getY());
        if (n <= 0) {
            graphics2D.fill(shape);
        } else {
            graphics2D.translate(n, n);
            graphics2D.setStroke(new BasicStroke(n));
            graphics2D.draw(shape);
            graphics2D.translate(-n, -n);
        }
        graphics2D.translate(shape.getBounds().getX(), shape.getBounds().getY());
        bufferedImage.flush();
        graphics2D.dispose();
        return bufferedImage;
    }

    public static Object cloneObject(Object object) throws CloneNotSupportedException {
        if (object instanceof Formula) {
            return ((Formula)object).clone();
        }
        return null;
    }

    public static AttrFillStyle getServerFillStyle(AttrFillStyle attrFillStyle) {
        if (attrFillStyle == null || attrFillStyle.getColorStyle() == 0) {
            return ChartUtils.getColorFillStyleInPre();
        }
        ChartPreStyleManagerProvider chartPreStyleManagerProvider = ChartPreStyleServerManager.getProviderInstance();
        Object object = chartPreStyleManagerProvider.getPreStyle((Object)attrFillStyle.getFillStyleName());
        AttrFillStyle attrFillStyle2 = attrFillStyle != null ? attrFillStyle : ChartUtils.getColorFillStyleInPre();
        return object != null ? ((ChartPreStyle)object).getAttrFillStyle() : attrFillStyle2;
    }
}

