/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.base;

import com.fr.base.BaseXMLUtils;
import com.fr.base.background.ColorBackground;
import com.fr.chart.base.DataSeriesCondition;
import com.fr.general.Background;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StableUtils;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;

public class AttrBorder
extends DataSeriesCondition {
    private static final long serialVersionUID = -3059717142253632161L;
    public static final String XML_TAG = "AttrBorder";
    private int borderStyle = 0;
    private Color borderColor = Color.black;
    private boolean isRoundBorder = false;
    private int roundRadius = 0;

    public AttrBorder() {
    }

    public AttrBorder(Color color, int n) {
        this.borderColor = color;
        this.borderStyle = n;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderStyle(int n) {
        this.borderStyle = n;
    }

    public int getBorderStyle() {
        return this.borderStyle;
    }

    public void setRoundBorder(boolean bl) {
        this.isRoundBorder = bl;
    }

    public boolean isRoundBorder() {
        return this.isRoundBorder;
    }

    public void setRoundRadius(int n) {
        this.roundRadius = n;
    }

    public int getRoundRadius() {
        return this.roundRadius;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            Background background;
            String string = xMLableReader.getTagName();
            if (string.equals("Attr")) {
                this.setBorderStyle(xMLableReader.getAttrAsInt("lineStyle", 0));
                this.setRoundBorder(xMLableReader.getAttrAsBoolean("isRoundBorder", false));
                this.setRoundRadius(xMLableReader.getAttrAsInt("roundRadius", 0));
            } else if (string.equals("newColor")) {
                this.borderColor = xMLableReader.getAttrAsColor("borderColor", null);
            } else if (string.equals("Background") && (background = BaseXMLUtils.readBackground((XMLableReader)xMLableReader)) instanceof ColorBackground) {
                this.borderColor = ((ColorBackground)background).getColor();
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("Attr").attr("lineStyle", this.borderStyle).attr("isRoundBorder", this.isRoundBorder).attr("roundRadius", this.roundRadius).end();
        xMLPrintWriter.startTAG("newColor");
        if (this.borderColor != null) {
            xMLPrintWriter.attr("borderColor", this.borderColor.getRGB());
        }
        xMLPrintWriter.end();
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        return object instanceof AttrBorder && ((AttrBorder)object).borderStyle == this.borderStyle && ((AttrBorder)object).isRoundBorder == this.isRoundBorder && ((AttrBorder)object).roundRadius == this.roundRadius && ComparatorUtils.equals((Object)((AttrBorder)object).borderColor, (Object)this.borderColor);
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("borderStyle", this.borderStyle);
        jSONObject.put("isRoundBorder", this.isRoundBorder);
        if (this.borderColor != null) {
            jSONObject.put("borderColor", (Object)StableUtils.javaColorToCSSColor((Color)this.borderColor));
        }
        return jSONObject;
    }

    public String getConditionType() {
        return XML_TAG;
    }
}

