/*
 * Decompiled with CFR 0.152.
 */
package net.fckeditor.response;

import net.fckeditor.localization.LocalizedMessages;
import net.fckeditor.requestcycle.ThreadLocalData;
import net.fckeditor.tool.Utils;

public class UploadResponse {
    protected Object[] parameters;
    public static final int EN_OK = 0;
    public static final int EN_CUSTOM_ERROR = 1;
    public static final int EN_CUSTOM_WARNING = 101;
    public static final int EN_FILE_RENAMED_WARNING = 201;
    public static final int EN_INVALID_FILE_TYPE_ERROR = 202;
    public static final int EN_SECURITY_ERROR = 203;

    public UploadResponse(Object[] arguments) {
        if (arguments.length < 1 || arguments.length > 4) {
            throw new IllegalArgumentException("The amount of arguments has to be between 1 and 4");
        }
        this.parameters = new Object[arguments.length];
        if (!(arguments[0] instanceof Integer)) {
            throw new IllegalArgumentException("The first argument has to be an error number (int)");
        }
        System.arraycopy(arguments, 0, this.parameters, 0, arguments.length);
    }

    public void setCustomMessage(String customMassage) {
        if (Utils.isNotEmpty(customMassage)) {
            if (this.parameters.length == 1) {
                Object errorNumber = this.parameters[0];
                this.parameters = new Object[4];
                this.parameters[0] = errorNumber;
                this.parameters[1] = null;
                this.parameters[2] = null;
            }
            this.parameters[3] = customMassage;
        }
    }

    public static UploadResponse getOK(String fileUrl) {
        return new UploadResponse(new Object[]{new Integer(0), fileUrl});
    }

    public static UploadResponse getFileRenamedWarning(String fileUrl, String newFileName) {
        LocalizedMessages lm = LocalizedMessages.getInstance(ThreadLocalData.getRequest());
        return new UploadResponse(new Object[]{new Integer(201), fileUrl, newFileName, lm.getFileRenamedWarning(newFileName)});
    }

    public static UploadResponse getInvalidFileTypeError() {
        LocalizedMessages lm = LocalizedMessages.getInstance(ThreadLocalData.getRequest());
        return new UploadResponse(new Object[]{new Integer(202), lm.getInvalidFileTypeSpecified()});
    }

    public static UploadResponse getInvalidCommandError() {
        LocalizedMessages lm = LocalizedMessages.getInstance(ThreadLocalData.getRequest());
        return new UploadResponse(new Object[]{new Integer(1), null, null, lm.getInvalidCommandSpecified()});
    }

    public static UploadResponse getInvalidResourceTypeError() {
        LocalizedMessages lm = LocalizedMessages.getInstance(ThreadLocalData.getRequest());
        return new UploadResponse(new Object[]{new Integer(1), null, null, lm.getInvalidResouceTypeSpecified()});
    }

    public static UploadResponse getInvalidCurrentFolderError() {
        LocalizedMessages lm = LocalizedMessages.getInstance(ThreadLocalData.getRequest());
        return new UploadResponse(new Object[]{new Integer(1), null, null, lm.getInvalidCurrentFolderSpecified()});
    }

    public static UploadResponse getFileUploadDisabledError() {
        LocalizedMessages lm = LocalizedMessages.getInstance(ThreadLocalData.getRequest());
        return new UploadResponse(new Object[]{new Integer(203), null, null, lm.getFileUploadDisabled()});
    }

    public static UploadResponse getFileUploadWriteError() {
        LocalizedMessages lm = LocalizedMessages.getInstance(ThreadLocalData.getRequest());
        return new UploadResponse(new Object[]{new Integer(1), null, null, lm.getFileUploadWriteError()});
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(400);
        sb.append("<script type=\"text/javascript\">\n");
        sb.append("(function(){var d=document.domain;while (true){try{var A=window.parent.document.domain;break;}catch(e) {};d=d.replace(/.*?(?:\\.|$)/,'');if (d.length==0) break;try{document.domain=d;}catch (e){break;}}})();\n");
        sb.append("window.parent.OnUploadCompleted(");
        Object[] arr$ = this.parameters;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Object parameter = arr$[i$];
            if (parameter instanceof Integer) {
                sb.append(parameter);
            } else {
                sb.append("'");
                if (parameter != null) {
                    sb.append(parameter);
                }
                sb.append("'");
            }
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(");\n");
        sb.append("</script>");
        return sb.toString();
    }
}

