/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jshx.smgp.server.sample;

import cn.com.jshx.smgp.bean.Deliver;
import cn.com.jshx.smgp.bean.Login;
import cn.com.jshx.smgp.bean.Submit;
import cn.com.jshx.smgp.protocol.Tlv;
import cn.com.jshx.smgp.protocol.TlvId;
import cn.com.jshx.smgp.server.Server;
import cn.com.jshx.smgp.server.inf.ServerEventInterface;
import cn.com.jshx.smgp.server.result.LoginResult;
import cn.com.jshx.smgp.server.result.SubmitResult;
import cn.com.jshx.smgp.server.sample.ServerConsole;
import cn.com.jshx.smgp.server.sample.config.ServerAccountConfFromFile;
import cn.com.jshx.smgp.server.sample.config.ServerAccountConfig;
import cn.com.jshx.smgp.server.util.CheckValid;
import cn.com.jshx.smgp.server.util.Display;
import cn.com.jshx.util.Key;
import java.io.IOException;

public class SampleServer {
    private static ServerAccountConfig accountconfig;
    private static String ServerVersion;

    static {
        ServerVersion = "3.0";
    }

    public static void main(String[] args) {
        try {
            accountconfig = new ServerAccountConfFromFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        server sv = new server(8890);
    }

    private static class server
    implements ServerEventInterface {
        private Server serverSimulate;
        private ServerConsole serverConsole;

        public server(int port) {
            this.serverSimulate = new Server(this, port);
            this.serverSimulate.start();
            this.serverConsole = new ServerConsole(this);
            this.serverConsole.start();
        }

        @Override
        public void SendDeliver(Deliver deliver) {
            this.serverSimulate.SendDeliver(deliver);
        }

        @Override
        public LoginResult onLogin(Login login) {
            Display.DisplayLogin(login, accountconfig);
            if (accountconfig.getPassword(login.Account) == null) {
                return new LoginResult(52, "", ServerVersion, "");
            }
            if (!Key.checkAuth(login.AuthenticatorClient, login.Account, accountconfig.getPassword(login.Account), String.valueOf(login.timestamp))) {
                return new LoginResult(21, "", ServerVersion, "");
            }
            if (!accountconfig.getIpAddress(login.Account).equals(login.ipaddress)) {
                return new LoginResult(20, "", ServerVersion, "");
            }
            return new LoginResult(0, accountconfig.getPassword(login.Account), ServerVersion, accountconfig.getSPNum(login.Account));
        }

        @Override
        public SubmitResult onSumit(Submit submit, String account) {
            int checkvalue = 0;
            Display.DisplaySubmit(submit);
            if (accountconfig.getSPId(account) != null) {
                boolean findTlv = false;
                Tlv[] otherTlv = submit.getOtherTlvArray();
                int i = 0;
                while (i < otherTlv.length) {
                    if (otherTlv[i].Tag == TlvId.MsgSrc) {
                        if (otherTlv[i].Value.equals(accountconfig.getSPId(account))) {
                            findTlv = true;
                        } else {
                            checkvalue = 8200;
                        }
                    }
                    ++i;
                }
                if (!findTlv) {
                    checkvalue = 8200;
                }
            }
            if (submit.getSrcTermid().indexOf(accountconfig.getSPNum(account)) != 0) {
                checkvalue = 46;
            }
            if (checkvalue == 0) {
                checkvalue = CheckValid.CheckSubmit(submit);
            }
            System.out.println("SubmitResult:" + checkvalue);
            return new SubmitResult(checkvalue);
        }

        @Override
        public void ListConnected() {
            Display.DisplayClientList(this.serverSimulate.getClientlist(), accountconfig);
        }

        @Override
        public void Exit() {
            this.serverSimulate.stop();
            this.serverConsole.stop();
        }
    }
}

