/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jshx.smgp.message;

import cn.com.jshx.smgp.message.Message;
import cn.com.jshx.smgp.protocol.RequestId;
import cn.com.jshx.util.Key;
import cn.com.jshx.util.TypeConvert;
import java.security.NoSuchAlgorithmException;

public class LoginRespMessage
extends Message {
    private int Status = 0;
    private byte[] AuthenticatorServer = null;
    private String Version = "";

    public LoginRespMessage(int sequence_Id, int status, byte[] authenticatorsclient, String sharekey, String serverversion) {
        try {
            int len = 33;
            this.buf = new byte[len];
            TypeConvert.int2byte(len, this.buf, 0);
            TypeConvert.int2byte(RequestId.Login_Resp, this.buf, 4);
            TypeConvert.int2byte(sequence_Id, this.buf, 8);
            TypeConvert.int2byte(status, this.buf, 12);
            byte[] authorityserver = Key.GenerateAuthenticatorServer(status, authenticatorsclient, sharekey);
            System.arraycopy(authorityserver, 0, this.buf, 16, authorityserver.length);
            TypeConvert.int2byte3(this.getVersion(serverversion), this.buf, 16 + authorityserver.length);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    private int getVersion(String version) {
        return Integer.parseInt(version.substring(0, version.indexOf("."))) * 16 + Integer.parseInt(version.substring(version.indexOf(".") + 1));
    }

    public LoginRespMessage(byte[] buffer) {
        if (buffer.length != 25) {
            throw new IllegalArgumentException("LoginResp Package resolv Error");
        }
        this.sequence_Id = TypeConvert.byte2int(buffer, 0);
        this.Status = TypeConvert.byte2int(buffer, 4);
        this.AuthenticatorServer = new byte[16];
        System.arraycopy(buffer, 8, this.AuthenticatorServer, 0, this.AuthenticatorServer.length);
        this.Version = String.valueOf(buffer[24] / 16) + "." + buffer[24] % 16;
    }

    public String getServerVersion() {
        return this.Version;
    }

    public int getSequenceId() {
        return this.sequence_Id;
    }

    public int getStatus() {
        return this.Status;
    }

    public byte[] getAuthenticatorServer() {
        return this.AuthenticatorServer;
    }
}

