/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jshx.smgp.message;

import cn.com.jshx.smgp.message.Message;
import cn.com.jshx.smgp.protocol.RequestId;
import cn.com.jshx.util.DateUtil;
import cn.com.jshx.util.Key;
import cn.com.jshx.util.TypeConvert;
import java.security.NoSuchAlgorithmException;

public class LoginMessage
extends Message {
    private String clientID;
    private byte[] authenticatorClient;
    private String sharedKey;
    private int loginMode;
    private String clientVersion;
    private int timeStamp;

    public LoginMessage(byte[] buffer) {
        int len = buffer.length;
        this.buf = new byte[len + 4];
        TypeConvert.int2byte(len, this.buf, 0);
        System.arraycopy(buffer, 0, this.buf, 4, len);
        this.sequence_Id = TypeConvert.byte2int(buffer, 4);
        this.clientID = TypeConvert.getString(buffer, 8, 0, 8);
        this.authenticatorClient = new byte[16];
        System.arraycopy(buffer, 16, this.authenticatorClient, 0, 16);
        this.loginMode = buffer[32];
        this.clientVersion = LoginMessage.getVersion(buffer[37]);
        this.setTimeStamp(TypeConvert.byte2int(buffer, 33));
    }

    private static String getVersion(int version) {
        return String.valueOf(version / 16) + "." + (version - version / 16 * 16);
    }

    public LoginMessage(String ClientID, String shared_Secret, int LoginMode) throws IllegalArgumentException, NoSuchAlgorithmException {
        this.clientID = ClientID;
        this.loginMode = LoginMode;
        this.sharedKey = shared_Secret;
        if (ClientID == null) {
            throw new IllegalArgumentException("ClientID isNull");
        }
        if (ClientID.length() > 8) {
            throw new IllegalArgumentException("ClientID is length is great then 8");
        }
        if (ClientID.length() > 8) {
            throw new IllegalArgumentException("ClientID is length is great then 8");
        }
        int len = 42;
        this.buf = new byte[len];
        TypeConvert.int2byte(len, this.buf, 0);
        TypeConvert.int2byte(RequestId.Login, this.buf, 4);
        System.arraycopy(ClientID.getBytes(), 0, this.buf, 12, ClientID.length());
        String timeStamp = DateUtil.GetTimeString();
        byte[] sharekey = Key.GenerateAuthenticatorClient(ClientID, shared_Secret, timeStamp);
        System.arraycopy(sharekey, 0, this.buf, 20, sharekey.length);
        this.buf[36] = (byte)LoginMode;
        TypeConvert.int2byte(Integer.parseInt(timeStamp), this.buf, 37);
        this.buf[41] = 48;
    }

    public String getClientID() {
        return this.clientID;
    }

    public byte[] getAuthenticatorClient() {
        return this.authenticatorClient;
    }

    public String getSharedKey() {
        return this.sharedKey;
    }

    public int getLoginMode() {
        return this.loginMode;
    }

    public String getClientVersion() {
        return this.clientVersion;
    }

    public void setTimeStamp(int timeStamp) {
        this.timeStamp = timeStamp;
    }

    public int getTimeStamp() {
        return this.timeStamp;
    }
}

