/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jshx.smgp;

import cn.com.jshx.smgp.Exception.SubmitException;
import cn.com.jshx.smgp.bean.Result;
import cn.com.jshx.smgp.bean.Submit;
import cn.com.jshx.smgp.bean.SubmitBatch;
import cn.com.jshx.smgp.connect.PConnectEvent;
import cn.com.jshx.smgp.inf.ClientEventInterface;
import java.io.IOException;
import java.util.Date;

public class ClientEvent {
    private PConnectEvent pconnect;
    private Result LoginResult;
    private ClientEventInterface clientEventInterface;
    private Long LongLastSubmit = 0L;
    private int sleeptime = 100;

    public ClientEvent(ClientEventInterface clientparent, String host, int port, int loginmode, String clientid, String clientpasswd, String spid, int displaymode) {
        this.clientEventInterface = clientparent;
        this.pconnect = new PConnectEvent(this.clientEventInterface, host, port, loginmode, clientid, clientpasswd, spid, displaymode);
        this.pconnect.start();
        this.LoginResult = this.pconnect.Login();
        if (this.LoginResult.ErrorCode != 0) {
            this.pconnect.stop();
        }
    }

    public ClientEvent(ClientEventInterface clientparent, String host, int port, int loginmode, String clientid, String clientpasswd, String spid) {
        this.clientEventInterface = clientparent;
        this.pconnect = new PConnectEvent(this.clientEventInterface, host, port, loginmode, clientid, clientpasswd, spid);
        this.pconnect.start();
        this.LoginResult = this.pconnect.Login();
        if (this.LoginResult.ErrorCode != 0) {
            this.pconnect.stop();
        }
    }

    public void SetLogFile(String LogFile) throws IOException {
        this.pconnect.SetLogFile(LogFile);
    }

    public void Close() {
        this.pconnect.LogOut();
    }

    public void setDisplayMode(int displaymode) {
        this.pconnect.setDisplayMode(displaymode);
    }

    public int Send(Submit submit) throws SubmitException {
        Long cur = ClientEvent.getTimeStamp();
        if (cur - this.LongLastSubmit < (long)this.sleeptime) {
            try {
                Thread.sleep((long)this.sleeptime - (cur - this.LongLastSubmit));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.LongLastSubmit = ClientEvent.getTimeStamp();
        if (this.LoginResult.ErrorCode == 0) {
            return this.pconnect.Send(submit);
        }
        throw new SubmitException(this.LoginResult);
    }

    public Integer[] SendLong(Submit submit) throws SubmitException {
        if (this.LoginResult.ErrorCode == 0) {
            return this.pconnect.SendLong(submit);
        }
        throw new SubmitException(this.LoginResult);
    }

    public void setLSmsOverTime(int second) {
        this.pconnect.setLSmsOverTime(second);
    }

    public Result SendBatch(SubmitBatch submit) {
        if (this.LoginResult.ErrorCode == 0) {
            return this.pconnect.SendBatch(submit);
        }
        return this.LoginResult;
    }

    public Result Login() {
        return this.LoginResult;
    }

    public void setSpeed(int persecond) {
        this.sleeptime = 1000 / persecond;
    }

    private static Long getTimeStamp() {
        return new Date().getTime();
    }
}

