/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.vanchart;

import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.chartglyph.ChartGlyph;
import com.fr.chart.chartglyph.ChartGlyphLayout;
import com.fr.chart.chartglyph.LegendGlyph;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.chart.chartglyph.TitleGlyph;
import com.fr.plugin.chart.glyph.VanChartDataSheetGlyph;
import com.fr.plugin.chart.glyph.VanChartDataSheetPlotGlyphInterface;
import com.fr.plugin.chart.glyph.VanChartPlotGlyph;
import com.fr.plugin.chart.glyph.VanChartPlotGlyphInterface;
import com.fr.plugin.chart.vanchart.VanChartGlyph;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class VanChartGlyphLayout {
    private static final double WIDTH_GAP = 8.0;
    private static final double HEIGHT_GAP = 8.0;
    private static final double GAP_BETWEEN_AXIS = 10.0;

    public static void doLayout(VanChartGlyph vanChartGlyph, int n) {
        if (vanChartGlyph == null || vanChartGlyph.getBounds() == null) {
            return;
        }
        Rectangle2D rectangle2D = vanChartGlyph.getBounds();
        Rectangle2D rectangle2D2 = vanChartGlyph.getBounds();
        ChartGlyphLayout.preGap4ChartBorder((ChartGlyph)vanChartGlyph, (Rectangle2D)rectangle2D2);
        ChartGlyphLayout.preGap4ChartInPadding((Rectangle2D)rectangle2D2);
        ChartGlyphLayout.titleGlyphDoLayout((Rectangle2D)rectangle2D2, (TitleGlyph)vanChartGlyph.getTitleGlyph(), (int)n);
        VanChartGlyphLayout.legendDoLayoutWithLeftBounds(rectangle2D, rectangle2D2, vanChartGlyph, n);
        VanChartGlyphLayout.plotDoLayout(rectangle2D, rectangle2D2, vanChartGlyph, n);
    }

    private static void dataSheetDoLayoutWithLeftBounds(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, VanChartGlyph vanChartGlyph, VanChartDataSheetPlotGlyphInterface vanChartDataSheetPlotGlyphInterface, int n) {
        double d;
        VanChartDataSheetGlyph vanChartDataSheetGlyph = (VanChartDataSheetGlyph)vanChartGlyph.getDataSheetGlyph();
        if (vanChartDataSheetGlyph == null) {
            return;
        }
        vanChartDataSheetGlyph.initDataSheet(vanChartGlyph.getLegendGlyph(), vanChartDataSheetPlotGlyphInterface);
        vanChartDataSheetGlyph.calculateSeriesWidth(rectangle2D, n);
        double d2 = vanChartDataSheetGlyph.getLeftWidth();
        double d3 = vanChartDataSheetPlotGlyphInterface.getBounds().getX() - rectangle2D2.getX();
        if (d2 > d3) {
            d = d2 - d3;
            vanChartDataSheetPlotGlyphInterface.setBounds(new Rectangle2D.Double(vanChartDataSheetPlotGlyphInterface.getBounds().getX() + d, vanChartDataSheetPlotGlyphInterface.getBounds().getY(), vanChartDataSheetPlotGlyphInterface.getBounds().getWidth() - d, vanChartDataSheetPlotGlyphInterface.getBounds().getHeight()));
            vanChartDataSheetPlotGlyphInterface.adjustAxisGlyphWithLeftGap(d);
        }
        vanChartDataSheetGlyph.calculateOtherWidthAndHeight(n);
        d = vanChartDataSheetGlyph.getBottomHeight();
        vanChartDataSheetPlotGlyphInterface.setBounds(new Rectangle2D.Double(vanChartDataSheetPlotGlyphInterface.getBounds().getX(), vanChartDataSheetPlotGlyphInterface.getBounds().getY(), vanChartDataSheetPlotGlyphInterface.getBounds().getWidth(), vanChartDataSheetPlotGlyphInterface.getBounds().getHeight() - d));
        vanChartDataSheetPlotGlyphInterface.adjustAxisGlyphWithBottomGap(d);
        double d4 = rectangle2D2.getMaxY() - d;
        if (vanChartDataSheetPlotGlyphInterface.getBottomXAxisCount() == 1) {
            d4 -= 10.0;
        }
        vanChartDataSheetGlyph.setBounds(new Rectangle2D.Double(vanChartDataSheetPlotGlyphInterface.getBounds().getX() - d2, d4, vanChartDataSheetGlyph.getWholeWidth(), d));
    }

    private static void plotDoLayout(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, VanChartGlyph vanChartGlyph, int n) {
        PlotGlyph plotGlyph = vanChartGlyph.getPlotGlyph();
        if (plotGlyph == null) {
            return;
        }
        plotGlyph.setBounds((RectangularShape)rectangle2D2);
        if (plotGlyph instanceof VanChartPlotGlyphInterface) {
            VanChartPlotGlyphInterface vanChartPlotGlyphInterface = (VanChartPlotGlyphInterface)plotGlyph;
            vanChartPlotGlyphInterface.layoutAxisGlyph(rectangle2D, n);
        }
        if (plotGlyph instanceof VanChartDataSheetPlotGlyphInterface) {
            VanChartGlyphLayout.dataSheetDoLayoutWithLeftBounds(rectangle2D, rectangle2D2, vanChartGlyph, (VanChartDataSheetPlotGlyphInterface)plotGlyph, n);
        }
        plotGlyph.layoutDataSeriesGlyph(n);
        if (plotGlyph.getRoundRadius() > 0) {
            plotGlyph.setBounds(ChartBaseUtils.rectangle2RoundRectangle((Rectangle2D)plotGlyph.getBounds(), (double)plotGlyph.getRoundRadius()));
        } else {
            plotGlyph.setBounds(ChartBaseUtils.rectangle2RoundRectangle((Rectangle2D)plotGlyph.getBounds(), (boolean)plotGlyph.isRoundBorder()));
        }
    }

    private static void legendDoLayoutWithLeftBounds(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, VanChartGlyph vanChartGlyph, int n) {
        LegendGlyph legendGlyph = vanChartGlyph.getLegendGlyph();
        if (legendGlyph == null || !legendGlyph.isVisible()) {
            return;
        }
        VanChartPlotGlyph vanChartPlotGlyph = (VanChartPlotGlyph)vanChartGlyph.getPlotGlyph();
        if (vanChartPlotGlyph == null) {
            return;
        }
        legendGlyph.setItems(vanChartPlotGlyph.createLegendItems());
        legendGlyph.layoutLegendAndRefreshChartBounds(rectangle2D, rectangle2D2, 8.0, 8.0, n);
    }
}

