/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.scatter;

import com.fr.chart.chartglyph.GeneralInfo;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.plugin.chart.attr.VanChartLegend;
import com.fr.plugin.chart.glyph.VanChartLegendGlyph;
import com.fr.plugin.chart.range.GradualLegend;
import com.fr.plugin.chart.range.LegendType;
import com.fr.plugin.chart.range.SectionLegend;
import com.fr.plugin.chart.scatter.VanChartScatterLegendGlyph;
import com.fr.script.Calculator;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.util.List;

public class VanChartScatterLegend
extends VanChartLegend {
    private static final long serialVersionUID = -338653804642389848L;
    private LegendType legendType = LegendType.GRADUAL;
    private GradualLegend gradualLegend = new GradualLegend();
    private SectionLegend sectionLegend = new SectionLegend();

    public LegendType getLegendType() {
        return this.legendType;
    }

    public void setLegendType(LegendType legendType) {
        this.legendType = legendType;
    }

    public void setLegendType(int n) {
        switch (n) {
            case 0: {
                this.legendType = LegendType.ORDINARY;
                break;
            }
            case 1: {
                this.legendType = LegendType.GRADUAL;
                break;
            }
            case 2: {
                this.legendType = LegendType.SECTION;
            }
        }
    }

    @Override
    public VanChartLegendGlyph createLegendGlyph(PlotGlyph plotGlyph) {
        VanChartScatterLegendGlyph vanChartScatterLegendGlyph = new VanChartScatterLegendGlyph();
        vanChartScatterLegendGlyph.setFont(this.getFRFont());
        vanChartScatterLegendGlyph.setGeneralInfo((GeneralInfo)this);
        vanChartScatterLegendGlyph.setPosition(this.getPosition());
        vanChartScatterLegendGlyph.setVisible(this.isLegendVisible());
        vanChartScatterLegendGlyph.setFloating(this.isFloating());
        vanChartScatterLegendGlyph.setFloatPercentX(this.getFloatPercentX());
        vanChartScatterLegendGlyph.setFloatPercentY(this.getFloatPercentY());
        vanChartScatterLegendGlyph.setMaxHeight(this.getMaxHeight());
        vanChartScatterLegendGlyph.setLimitSize(this.isLimitSize());
        vanChartScatterLegendGlyph.setLegendType(this.getLegendType());
        vanChartScatterLegendGlyph.setGradualLegendGlyph(this.getGradualLegend().createGradualLegendGlyph(plotGlyph));
        vanChartScatterLegendGlyph.setSectionLegendGlyph(this.getSectionLegend().createSectionLegendGlyph(plotGlyph));
        return vanChartScatterLegendGlyph;
    }

    public GradualLegend getGradualLegend() {
        return this.gradualLegend;
    }

    public void setGradualLegend(GradualLegend gradualLegend) {
        this.gradualLegend = gradualLegend;
    }

    public SectionLegend getSectionLegend() {
        return this.sectionLegend;
    }

    public void setSectionLegend(SectionLegend sectionLegend) {
        this.sectionLegend = sectionLegend;
    }

    @Override
    protected void readAttrXML(XMLableReader xMLableReader) {
        String string = xMLableReader.getTagName();
        if ("Attr4VanChart".equals(string)) {
            this.setFloating(xMLableReader.getAttrAsBoolean("floating", false));
            this.setFloatPercentX(xMLableReader.getAttrAsInt("x", 0));
            this.setFloatPercentY(xMLableReader.getAttrAsInt("y", 0));
            this.setLimitSize(xMLableReader.getAttrAsBoolean("limitSize", false));
            this.setMaxHeight(xMLableReader.getAttrAsFloat("maxHeight", 0.0f));
        }
        if ("Attr4VanChartScatter".equals(string)) {
            xMLableReader.readXMLObject(new XMLReadable(){

                public void readXML(XMLableReader xMLableReader) {
                    VanChartScatterLegend.this.readerAttr4Scatter(xMLableReader);
                }
            });
        }
    }

    private void readerAttr4Scatter(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Type".equals(string)) {
                this.setLegendType(xMLableReader.getAttrAsInt("rangeLegendType", 1));
            }
            if ("GradualLegend".equals(string)) {
                this.setGradualLegend((GradualLegend)xMLableReader.readXMLObject((XMLReadable)new GradualLegend()));
            } else if ("SectionLegend".equals(string)) {
                this.setSectionLegend((SectionLegend)xMLableReader.readXMLObject((XMLReadable)new SectionLegend()));
            }
        }
    }

    @Override
    protected void writeAttrXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Attr4VanChart").attr("floating", this.isFloating()).attr("x", this.getFloatPercentX()).attr("y", this.getFloatPercentY()).attr("limitSize", this.isLimitSize()).attr("maxHeight", this.getMaxHeight()).end();
        this.writerAttr4Scatter(xMLPrintWriter);
    }

    private void writerAttr4Scatter(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Attr4VanChartScatter");
        xMLPrintWriter.startTAG("Type").attr("rangeLegendType", this.getLegendType().getIndex()).end();
        this.writeRangeLegendXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    private void writeRangeLegendXML(XMLPrintWriter xMLPrintWriter) {
        switch (this.getLegendType()) {
            case ORDINARY: {
                break;
            }
            case GRADUAL: {
                this.getGradualLegend().writeXML(xMLPrintWriter);
                break;
            }
            case SECTION: {
                this.getSectionLegend().writeXML(xMLPrintWriter);
            }
        }
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof VanChartScatterLegend && super.equals(object) && ((VanChartScatterLegend)((Object)object)).getLegendType() == this.getLegendType() && ComparatorUtils.equals((Object)((VanChartScatterLegend)((Object)object)).getGradualLegend(), (Object)this.getGradualLegend()) && ComparatorUtils.equals((Object)((VanChartScatterLegend)((Object)object)).getSectionLegend(), (Object)this.getSectionLegend());
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        VanChartScatterLegend vanChartScatterLegend = (VanChartScatterLegend)((Object)super.clone());
        vanChartScatterLegend.setGradualLegend((GradualLegend)this.getGradualLegend().clone());
        vanChartScatterLegend.setSectionLegend((SectionLegend)this.getSectionLegend().clone());
        vanChartScatterLegend.setLegendType(this.getLegendType());
        return vanChartScatterLegend;
    }

    public void dealFormula(Calculator calculator) {
        if (this.gradualLegend != null) {
            this.gradualLegend.dealFormula(calculator);
        }
        if (this.sectionLegend != null) {
            this.sectionLegend.dealFormula(calculator);
        }
    }

    public void buidExecuteSequenceList(List list, Calculator calculator) {
        if (this.gradualLegend != null) {
            this.gradualLegend.buidExecuteSequenceList(list, calculator);
        }
    }

    public void modFormulaString(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        if (this.gradualLegend != null) {
            this.gradualLegend.modFormulaString(mOD_COLUMN_ROW);
        }
    }
}

