/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.scatter;

import com.fr.base.background.ColorBackground;
import com.fr.chart.base.ChartConstants;
import com.fr.chart.base.TextAttr;
import com.fr.data.condition.CommonCondition;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRFont;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.plugin.chart.attr.VanChartAttrHelper;
import com.fr.plugin.chart.line.VanChartLineDataPoint;
import com.fr.stable.ArrayUtils;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.web.Repository;
import java.awt.Color;
import java.awt.Graphics;

public class VanChartScatterDataPoint
extends VanChartLineDataPoint {
    private static final long serialVersionUID = -7198809115831695586L;
    private double sizeValue = 0.0;
    private boolean sizeIsNull = false;

    public double getSizeValue() {
        return this.sizeValue;
    }

    public void setSizeValue(double d) {
        this.sizeValue = d;
    }

    public Object toResult(CommonCondition commonCondition) {
        String string = commonCondition.getColumnName();
        if (ComparatorUtils.equals((Object)string, (Object)ChartConstants.SERIES_INDEX) || ArrayUtils.contains((Object[])ChartConstants.SERIES_INDEX_KEYS, (Object)string)) {
            return this.getSeriesIndex() + 1;
        }
        if (this.isUseY(string)) {
            return this.getValue();
        }
        if (this.isUseValue(string)) {
            return this.sizeValue;
        }
        if (this.isUseX(string)) {
            return Double.parseDouble(this.getCategoryName());
        }
        if (ComparatorUtils.equals((Object)string, (Object)ChartConstants.SERIES_NAME) || ArrayUtils.contains((Object[])ChartConstants.SERIES_NAME_KEYS, (Object)string)) {
            return this.getSeriesName();
        }
        return this;
    }

    protected boolean isUseValue(String string) {
        return ComparatorUtils.equals((Object)string, (Object)ChartConstants.VALUE) || ArrayUtils.contains((Object[])ChartConstants.VALUE_KEYS, (Object)string);
    }

    protected boolean isUseY(String string) {
        return ComparatorUtils.equals((Object)string, (Object)"Y");
    }

    private boolean isUseX(String string) {
        return ComparatorUtils.equals((Object)string, (Object)"X");
    }

    @Override
    public void drawAutoFontLabelText(Graphics graphics, int n) {
        String string = this.getDataLabel().getText();
        TextAttr textAttr = this.getDataLabel().getTextAttr();
        String string2 = VanChartAttrHelper.getScatterSeries(this.label == null ? this.defaultAttrLabel.getContent() : this.label.getContent(), this);
        String string3 = VanChartAttrHelper.getScatterXAndYAndSize(this.label == null ? this.defaultAttrLabel.getContent() : this.label.getContent(), this);
        TextAttr textAttr2 = new TextAttr();
        this.getDataLabel().setTextAttr(textAttr2);
        FRFont fRFont = this.isOutside() ? this.getOutSideCateAndSeriesFont() : this.getInSideCateAndSeriesFont();
        FRFont fRFont2 = this.isOutside() ? this.getOutSideValueAndPercentFont() : this.getInSideValueAndPercentFont();
        this.drawTextWithFont(string, textAttr2, string2, fRFont, graphics, n);
        this.drawTextWithFont(string, textAttr2, string3, fRFont2, graphics, n);
        this.getDataLabel().setTextAttr(textAttr);
    }

    protected void drawTextWithFont(String string, TextAttr textAttr, String string2, FRFont fRFont, Graphics graphics, int n) {
        if (StringUtils.isNotEmpty((String)string2) && StringUtils.contains((String)string, (String)string2)) {
            textAttr.setFRFont(fRFont);
            this.getDataLabel().setText(string2);
            this.getDataLabel().draw(graphics, n);
        }
    }

    public boolean isSizeIsNull() {
        return this.sizeIsNull;
    }

    public void setSizeIsNull(boolean bl) {
        this.sizeIsNull = bl;
    }

    @Override
    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        jSONObject.put("size", this.isSizeIsNull() ? "-" : Double.valueOf(this.getSizeValue()));
        return jSONObject;
    }

    @Override
    protected void addColorAndAlphaJSON(JSONObject jSONObject) throws JSONException {
        if (this.color != null) {
            ColorBackground colorBackground = (ColorBackground)this.color.getSeriesBackground();
            jSONObject.put("color", (Object)StableUtils.javaColorToCSSColor((Color)colorBackground.getColor()));
        }
        if (this.getAlpha() != null) {
            jSONObject.put("fillColorOpacity", (double)this.getAlpha().getAlpha());
        }
    }
}

