/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.radar;

import com.fr.base.chart.Glyph;
import com.fr.chart.base.AttrAlpha;
import com.fr.chart.base.AttrLineStyle;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.LineMarkerIcon;
import com.fr.chart.chartglyph.ShapeGlyph;
import com.fr.chart.chartglyph.TextGlyph;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.plugin.chart.area.VanChartAreaPlotGlyph;
import com.fr.plugin.chart.glyph.VanChartDataPoint;
import com.fr.plugin.chart.glyph.VanChartDataSeries;
import com.fr.plugin.chart.glyph.axis.VanChartBaseAxisGlyph;
import com.fr.plugin.chart.glyph.axis.VanChartRadarAxisGlyph;
import com.fr.plugin.chart.radar.RadarType;
import com.fr.plugin.chart.radar.VanChartRadarDataPoint;
import com.fr.stable.web.Repository;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.List;
import java.util.Map;

public class VanChartRadarPlotGlyph
extends VanChartAreaPlotGlyph {
    private static final long serialVersionUID = 3690467196318699246L;
    private VanChartRadarAxisGlyph radarAxisGlyph;
    private RadarType radarType;
    private boolean isColumnType;

    public void setRadarAxisGlyph(VanChartRadarAxisGlyph vanChartRadarAxisGlyph) {
        this.radarAxisGlyph = vanChartRadarAxisGlyph;
    }

    public void setRadarType(RadarType radarType) {
        this.radarType = radarType;
    }

    public void setColumnType(boolean bl) {
        this.isColumnType = bl;
    }

    @Override
    protected void setSeriesColor(VanChartDataPoint vanChartDataPoint, VanChartDataSeries vanChartDataSeries) {
        if (!this.isColumnType) {
            vanChartDataPoint.setColor(vanChartDataSeries.getColor());
        }
    }

    @Override
    public void layoutAxisGlyph(Rectangle2D rectangle2D, int n) {
        this.initYAxisGlyphMinMaxValue(0, this.radarAxisGlyph.getDataSeriesValueAxisGlyph());
        this.radarAxisGlyph.doLayout(new Rectangle2D.Double(0.0, 0.0, this.getBounds().getWidth(), this.getBounds().getHeight()), n);
    }

    @Override
    protected LineMarkerIcon getLegendMarkerIcon(VanChartDataSeries vanChartDataSeries, Color[] colorArray) {
        if (this.isColumnType) {
            LineMarkerIcon lineMarkerIcon = new LineMarkerIcon();
            this.dealMarkerIconCondition(lineMarkerIcon, vanChartDataSeries, colorArray);
            return lineMarkerIcon;
        }
        return super.getLegendMarkerIcon(vanChartDataSeries, colorArray);
    }

    @Override
    protected void initDataSeriesBandsDefaultMinMaxValue(double d, double d2, List<Number> list) {
    }

    @Override
    protected void initDataSeriesGlyph(VanChartDataSeries vanChartDataSeries, GeneralPath generalPath, GeneralPath generalPath2, Color color, VanChartBaseAxisGlyph vanChartBaseAxisGlyph, int[] nArray, Point2D[] point2DArray, Point2D[] point2DArray2, Point2D[] point2DArray3) {
        this.dealLinePath(generalPath2, generalPath, vanChartDataSeries, color, vanChartBaseAxisGlyph);
    }

    @Override
    protected void dealBands(GeneralPath generalPath, GeneralPath generalPath2, VanChartDataSeries vanChartDataSeries, Color color, VanChartBaseAxisGlyph vanChartBaseAxisGlyph, AttrLineStyle attrLineStyle) {
    }

    @Override
    protected void dealLine4AllSeries(VanChartDataSeries vanChartDataSeries, VanChartBaseAxisGlyph vanChartBaseAxisGlyph, VanChartBaseAxisGlyph vanChartBaseAxisGlyph2, Map<String, Number> map, Map<String, Number> map2, Point2D[] point2DArray, Point2D[] point2DArray2, Color color, GeneralPath generalPath, GeneralPath generalPath2, int[] nArray, int n) {
        if (this.isColumnType) {
            this.dealStackColumn4AllSeries(vanChartDataSeries, map, map2, nArray, n);
        } else {
            double d = vanChartBaseAxisGlyph2.getMinValue();
            this.dealNormalLine4AllSeries(vanChartDataSeries, color, generalPath, generalPath2, nArray, d, n);
        }
    }

    private void dealNormalLine4AllSeries(VanChartDataSeries vanChartDataSeries, Color color, GeneralPath generalPath, GeneralPath generalPath2, int[] nArray, double d, int n) {
        this.isStartPoint = true;
        boolean bl = this.isNullValueBreak(vanChartDataSeries);
        Point2D point2D = null;
        for (int n2 : nArray) {
            VanChartRadarDataPoint vanChartRadarDataPoint = (VanChartRadarDataPoint)vanChartDataSeries.getDataPoint(n2);
            double d2 = vanChartRadarDataPoint.getValue();
            if (vanChartRadarDataPoint.isValueIsNull()) {
                d2 = d;
            }
            Point2D point2D2 = this.radarAxisGlyph.getPoint2DWithCateIndexAndValue(n2, d2);
            this.dealAreaPoint4EveryPoint(generalPath2, point2D2, point2D);
            if (vanChartRadarDataPoint.isValueIsNull()) {
                if (!bl) continue;
                this.isStartPoint = true;
                continue;
            }
            if (point2D == null) {
                point2D = point2D2;
            }
            this.dealLinePoint4EveryDataPoint(generalPath, new GeneralPath(), (float)point2D2.getX(), (float)point2D2.getY(), false, false, 0.0f);
            this.initMarkerGlyph(vanChartRadarDataPoint, (float)point2D2.getX(), (float)point2D2.getY(), color);
            this.dealDataPointLabel(vanChartRadarDataPoint, d2, n);
        }
        if (point2D != null) {
            this.dealAreaPoint4EveryPoint(generalPath2, point2D, point2D);
            this.dealLinePoint4EveryDataPoint(generalPath, new GeneralPath(), (float)point2D.getX(), (float)point2D.getY(), false, false, 0.0f);
        }
    }

    private void dealAreaPoint4EveryPoint(GeneralPath generalPath, Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            generalPath.moveTo(point2D.getX(), point2D.getY());
        } else {
            generalPath.lineTo(point2D.getX(), point2D.getY());
        }
    }

    private void dealStackColumn4AllSeries(VanChartDataSeries vanChartDataSeries, Map<String, Number> map, Map<String, Number> map2, int[] nArray, int n) {
        for (int n2 : nArray) {
            VanChartRadarDataPoint vanChartRadarDataPoint = (VanChartRadarDataPoint)vanChartDataSeries.getDataPoint(n2);
            double d = vanChartRadarDataPoint.getValue();
            double d2 = this.getLastSumValue(n2, d, map, map2);
            double d3 = this.getAndUpdateSumValue(n2, d, map, map2);
            Shape shape = this.radarAxisGlyph.getArcShapeBetweenTwoValues(d2, d3, n2);
            ShapeGlyph shapeGlyph = new ShapeGlyph(shape);
            this.changeInfoWithCondition(shapeGlyph.getGeneralInfo(), vanChartRadarDataPoint);
            vanChartRadarDataPoint.setDrawImpl((Glyph)shapeGlyph);
            this.dealDataPointLabel(vanChartRadarDataPoint, d3, n);
        }
    }

    private void dealDataPointLabel(DataPoint dataPoint, double d, int n) {
        TextGlyph textGlyph = dataPoint.getDataLabel();
        if (textGlyph == null) {
            return;
        }
        if (this.notDealDataPointLabel(dataPoint, textGlyph)) {
            textGlyph.setBounds(null);
        } else {
            Dimension2D dimension2D = textGlyph.preferredDimension(n);
            Rectangle2D rectangle2D = this.isColumnType ? this.radarAxisGlyph.getColumnTypeLabelBounds(dimension2D, dataPoint.getCategoryIndex(), d) : this.radarAxisGlyph.getNormalLabelBounds(dimension2D, dataPoint.getCategoryIndex(), d);
            textGlyph.setBounds((RectangularShape)rectangle2D);
        }
    }

    private double getLastSumValue(double d, double d2, Map<String, Number> map, Map<String, Number> map2) {
        if (d2 > 0.0) {
            Number number = map.get(String.valueOf(d));
            return number == null ? 0.0 : number.doubleValue();
        }
        Number number = map2.get(String.valueOf(d));
        return number == null ? 0.0 : number.doubleValue();
    }

    protected void trendLineFitting(double[] dArray, double[] dArray2, DataSeries dataSeries) {
    }

    public void drawShape4Series(Graphics graphics, int n) {
        Shape shape = graphics.getClip();
        graphics.setClip(this.radarAxisGlyph.getShape());
        super.drawShape4Series(graphics, n);
        graphics.setClip(shape);
    }

    @Override
    protected void drawAxis(Graphics graphics, int n) {
        this.radarAxisGlyph.draw(graphics, n);
    }

    @Override
    public String getChartType() {
        return "radar";
    }

    @Override
    public JSONObject getPlotOptionsJSON(Repository repository, boolean bl) throws JSONException {
        JSONObject jSONObject = super.getPlotOptionsJSON(repository, bl);
        jSONObject.put("type", (Object)this.radarType.getType());
        jSONObject.put("columnType", this.isColumnType);
        AttrAlpha attrAlpha = this.getDefaultAttrAlpha();
        if (attrAlpha != null) {
            jSONObject.put("fillColorOpacity", (double)attrAlpha.getAlpha());
        }
        return jSONObject;
    }

    @Override
    protected void addLargeDataJSON(JSONObject jSONObject) throws JSONException {
    }
}

