/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.pie;

import com.fr.chart.chartglyph.TopDownShadeChart;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;

public class RoseTopDownShadeStyle
extends TopDownShadeChart {
    private double innerRadius;
    private double outerRadius;
    private Point2D centerPoint;
    private Shape shape;
    private static final double NUM = 0.8;

    public RoseTopDownShadeStyle(double d, double d2, Point2D point2D, Color color, Shape shape, boolean bl) {
        this.baseColor = color;
        this.innerRadius = d;
        this.outerRadius = d2;
        this.centerPoint = point2D;
        this.shape = shape;
        this.avoidOriginDraw = bl;
    }

    protected Color getEndColor() {
        this.baseColor = this.baseColor == null ? new Color(255, 255, 255, 0) : this.baseColor;
        return new Color(Math.min(255, (int)((double)this.baseColor.getRed() / 0.8)), Math.min(255, (int)((double)this.baseColor.getGreen() / 0.8)), Math.min(255, (int)((double)this.baseColor.getBlue() / 0.8)), this.baseColor.getAlpha());
    }

    public void paintStyle(Graphics graphics) {
        if (this.outerRadius <= 0.0 || this.innerRadius == this.outerRadius) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color = this.getEndColor();
        Color color2 = this.getStartColor();
        Paint paint = graphics2D.getPaint();
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.alpha >= 0.0f ? this.alpha : 1.0f));
        float[] fArray = new float[]{(float)(this.innerRadius / this.outerRadius), 1.0f};
        Color[] colorArray = new Color[]{color, color2};
        RadialGradientPaint radialGradientPaint = new RadialGradientPaint((float)this.centerPoint.getX(), (float)this.centerPoint.getY(), (float)this.outerRadius, fArray, colorArray);
        graphics2D.setPaint(radialGradientPaint);
        graphics2D.fill(this.shape);
        graphics2D.setComposite(composite);
        graphics2D.setPaint(paint);
        Stroke stroke = graphics2D.getStroke();
        BasicStroke basicStroke = new BasicStroke((int)this.borderWidth, 0, 1);
        graphics2D.setStroke(basicStroke);
        graphics2D.setPaint(this.borderColor);
        graphics2D.draw(this.shape);
        graphics2D.setStroke(stroke);
    }
}

