/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.line;

import com.fr.base.background.ColorBackground;
import com.fr.base.chart.Glyph;
import com.fr.chart.base.AttrColor;
import com.fr.chart.base.AttrLineStyle;
import com.fr.chart.base.ChartUtils;
import com.fr.chart.base.LineStyleInfo;
import com.fr.chart.chartglyph.ConditionAttr;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.FoldLine;
import com.fr.chart.chartglyph.LineMarkerIcon;
import com.fr.chart.chartglyph.Marker;
import com.fr.chart.chartglyph.MarkerFactory;
import com.fr.chart.chartglyph.MarkerGlyph;
import com.fr.general.Background;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.plugin.chart.attr.AttrBand;
import com.fr.plugin.chart.attr.LineStyle;
import com.fr.plugin.chart.base.VanChartAttrLine;
import com.fr.plugin.chart.base.VanChartAttrMarker;
import com.fr.plugin.chart.glyph.VanChartBandGlyph;
import com.fr.plugin.chart.glyph.VanChartDataPoint;
import com.fr.plugin.chart.glyph.VanChartDataSeries;
import com.fr.plugin.chart.glyph.VanChartLineMarkerIcon;
import com.fr.plugin.chart.glyph.VanChartRectanglePlotGlyph;
import com.fr.plugin.chart.glyph.axis.VanChartBaseAxisGlyph;
import com.fr.plugin.chart.glyph.marker.CustomImageMarker;
import com.fr.plugin.chart.line.VanChartLineDataPoint;
import com.fr.stable.web.Repository;
import java.awt.Color;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VanChartLinePlotGlyph
extends VanChartRectanglePlotGlyph {
    private static final long serialVersionUID = 3936503431906562228L;
    protected boolean isStartPoint = true;
    private double XMinInterval = 0.0;
    private double YMinInterval = 0.0;
    private VanChartAttrLine defaultAttrLine;
    protected VanChartAttrMarker defaultAttrMarker;

    protected VanChartAttrLine getDefaultAttrLine() {
        if (this.defaultAttrLine == null) {
            ConditionAttr conditionAttr = this.getConditionCollection().getDefaultAttr();
            this.defaultAttrLine = (VanChartAttrLine)conditionAttr.getExisted(VanChartAttrLine.class);
        }
        return this.defaultAttrLine;
    }

    protected VanChartAttrMarker getDefaultAttrMarker() {
        if (this.defaultAttrMarker == null) {
            ConditionAttr conditionAttr = this.getConditionCollection().getDefaultAttr();
            this.defaultAttrMarker = (VanChartAttrMarker)conditionAttr.getExisted(VanChartAttrMarker.class);
        }
        return this.defaultAttrMarker;
    }

    protected boolean isCurve(VanChartDataSeries vanChartDataSeries) {
        VanChartAttrLine vanChartAttrLine = vanChartDataSeries.getAttrLine();
        if (vanChartAttrLine == null) {
            vanChartAttrLine = this.getDefaultAttrLine();
        }
        return vanChartAttrLine != null && ComparatorUtils.equals((Object)((Object)vanChartAttrLine.getLineStyle()), (Object)((Object)LineStyle.CURVE));
    }

    protected boolean isStep(VanChartDataSeries vanChartDataSeries) {
        VanChartAttrLine vanChartAttrLine = vanChartDataSeries.getAttrLine();
        if (vanChartAttrLine == null) {
            vanChartAttrLine = this.getDefaultAttrLine();
        }
        return vanChartAttrLine != null && ComparatorUtils.equals((Object)((Object)vanChartAttrLine.getLineStyle()), (Object)((Object)LineStyle.STEP));
    }

    protected boolean isNullValueBreak(VanChartDataSeries vanChartDataSeries) {
        VanChartAttrLine vanChartAttrLine = vanChartDataSeries.getAttrLine();
        if (vanChartAttrLine == null) {
            vanChartAttrLine = this.getDefaultAttrLine();
        }
        return vanChartAttrLine == null || vanChartAttrLine.isNullValueBreak();
    }

    protected int getAttrLineWidth(VanChartDataSeries vanChartDataSeries) {
        VanChartAttrLine vanChartAttrLine = vanChartDataSeries.getAttrLine();
        if (vanChartAttrLine == null) {
            vanChartAttrLine = this.getDefaultAttrLine();
        }
        if (vanChartAttrLine == null) {
            vanChartAttrLine = new VanChartAttrLine();
        }
        return vanChartAttrLine.getLineWidth();
    }

    protected Color getAttrLineColor(VanChartDataSeries vanChartDataSeries) {
        Color[] colorArray = this.createColors4Series();
        return this.getAttrLineColor(vanChartDataSeries, colorArray);
    }

    protected VanChartAttrMarker getAttrMarker(VanChartLineDataPoint vanChartLineDataPoint) {
        VanChartAttrMarker vanChartAttrMarker = vanChartLineDataPoint.getAttrMarker();
        if (vanChartAttrMarker == null) {
            vanChartAttrMarker = this.getDefaultAttrMarker();
        }
        return vanChartAttrMarker;
    }

    protected VanChartAttrMarker getAttrMarker(VanChartDataSeries vanChartDataSeries) {
        VanChartAttrMarker vanChartAttrMarker = vanChartDataSeries.getMarker();
        if (vanChartAttrMarker == null) {
            vanChartAttrMarker = this.getDefaultAttrMarker();
        }
        return vanChartAttrMarker;
    }

    @Override
    protected void initDataSeriesBandsDefaultMinMaxValue(double d, double d2, List<Number> list) {
        for (Number number : list) {
            VanChartDataSeries vanChartDataSeries = (VanChartDataSeries)this.getSeries(number.intValue());
            vanChartDataSeries.initBandsDefaultMinMaxValue(d, d2);
        }
    }

    @Override
    protected LineMarkerIcon getLegendMarkerIcon(VanChartDataSeries vanChartDataSeries, Color[] colorArray) {
        VanChartLineMarkerIcon vanChartLineMarkerIcon = new VanChartLineMarkerIcon();
        this.dealMarkerStyle(vanChartLineMarkerIcon, vanChartDataSeries, colorArray);
        return vanChartLineMarkerIcon;
    }

    protected void dealMarkerStyle(VanChartLineMarkerIcon vanChartLineMarkerIcon, VanChartDataSeries vanChartDataSeries, Color[] colorArray) {
        VanChartAttrMarker vanChartAttrMarker = this.getAttrMarker(vanChartDataSeries);
        Marker marker = MarkerFactory.createMarker((String)vanChartAttrMarker.getMarkerType().getType());
        marker.setPlotBackground((Background)Marker.SCATTER_PLOT_BACKROUNG);
        ColorBackground colorBackground = ColorBackground.getInstance((Color)this.getAttrLineColor(vanChartDataSeries, colorArray));
        if (vanChartAttrMarker.isCommon()) {
            marker.setBackground((Background)colorBackground);
        }
        vanChartLineMarkerIcon.setLineStyle(2);
        vanChartLineMarkerIcon.setBackground((Background)colorBackground);
        vanChartLineMarkerIcon.setMarker(marker);
    }

    @Override
    protected void createDataLabel4DataPointWithCondition(VanChartDataPoint vanChartDataPoint, VanChartDataSeries vanChartDataSeries) {
        this.setSeriesColor(vanChartDataPoint, vanChartDataSeries);
        super.createDataLabel4DataPointWithCondition(vanChartDataPoint, vanChartDataSeries);
    }

    protected void setSeriesColor(VanChartDataPoint vanChartDataPoint, VanChartDataSeries vanChartDataSeries) {
        vanChartDataPoint.setColor(vanChartDataSeries.getColor());
    }

    @Override
    public void layoutDataSeriesGlyph(int n) {
        super.layoutDataSeriesGlyph(n);
        Map<String, List<List<Number>>> map = this.buildAxisMap(false);
        for (String string : map.keySet()) {
            this.buildSingleAxisLines(map.get(string), n);
        }
    }

    protected void buildSingleAxisLines(List<List<Number>> list, int n) {
        for (List<Number> list2 : list) {
            HashMap<String, Number> hashMap = new HashMap<String, Number>();
            HashMap<String, Number> hashMap2 = new HashMap<String, Number>();
            Point2D[] point2DArray = null;
            Point2D[] point2DArray2 = null;
            VanChartBaseAxisGlyph vanChartBaseAxisGlyph = null;
            VanChartBaseAxisGlyph vanChartBaseAxisGlyph2 = null;
            for (Number number : list2) {
                VanChartDataSeries vanChartDataSeries = (VanChartDataSeries)this.getSeries(number.intValue());
                if (vanChartBaseAxisGlyph == null) {
                    vanChartBaseAxisGlyph = this.getDataSeriesCateAxisGlyph(vanChartDataSeries);
                    this.XMinInterval = (vanChartBaseAxisGlyph.getMaxValue() - vanChartBaseAxisGlyph.getMinValue()) / this.getBounds().getWidth();
                }
                if (vanChartBaseAxisGlyph2 == null) {
                    vanChartBaseAxisGlyph2 = this.getDataSeriesValueAxisGlyph(vanChartDataSeries);
                    this.YMinInterval = (vanChartBaseAxisGlyph2.getMaxValue() - vanChartBaseAxisGlyph2.getMinValue()) / this.getBounds().getHeight();
                }
                if (point2DArray == null) {
                    point2DArray = new Point2D[vanChartDataSeries.getDataPointCount()];
                }
                if (point2DArray2 == null) {
                    point2DArray2 = new Point2D[vanChartDataSeries.getDataPointCount()];
                }
                int[] nArray = this.sortCateValue(vanChartBaseAxisGlyph, vanChartDataSeries);
                this.buildSingleLine(vanChartDataSeries, vanChartBaseAxisGlyph, vanChartBaseAxisGlyph2, point2DArray, point2DArray2, hashMap, hashMap2, nArray, n);
            }
        }
    }

    protected void buildSingleLine(VanChartDataSeries vanChartDataSeries, VanChartBaseAxisGlyph vanChartBaseAxisGlyph, VanChartBaseAxisGlyph vanChartBaseAxisGlyph2, Point2D[] point2DArray, Point2D[] point2DArray2, Map<String, Number> map, Map<String, Number> map2, int[] nArray, int n) {
        Color color = this.getAttrLineColor(vanChartDataSeries);
        GeneralPath generalPath = new GeneralPath(1);
        GeneralPath generalPath2 = new GeneralPath(1);
        Point2D[] point2DArray3 = (Point2D[])point2DArray.clone();
        Point2D[] point2DArray4 = (Point2D[])point2DArray2.clone();
        this.dealLine4AllSeries(vanChartDataSeries, vanChartBaseAxisGlyph, vanChartBaseAxisGlyph2, map, map2, point2DArray, point2DArray2, color, generalPath, generalPath2, nArray, n);
        this.initDataSeriesGlyph(vanChartDataSeries, generalPath, generalPath2, color, vanChartBaseAxisGlyph2, nArray, point2DArray, point2DArray3, point2DArray4);
    }

    protected void initDataSeriesGlyph(VanChartDataSeries vanChartDataSeries, GeneralPath generalPath, GeneralPath generalPath2, Color color, VanChartBaseAxisGlyph vanChartBaseAxisGlyph, int[] nArray, Point2D[] point2DArray, Point2D[] point2DArray2, Point2D[] point2DArray3) {
        if (this.isCurve(vanChartDataSeries)) {
            ChartUtils.curveTo((GeneralPath)generalPath, (GeneralPath)generalPath2);
        }
        this.dealLinePath(generalPath, vanChartDataSeries, color, vanChartBaseAxisGlyph);
    }

    protected int[] sortCateValue(VanChartBaseAxisGlyph vanChartBaseAxisGlyph, VanChartDataSeries vanChartDataSeries) {
        int n;
        if (this.getSeriesSize() < 1) {
            return new int[0];
        }
        int n2 = vanChartDataSeries.getDataPointCount();
        int[] nArray = new int[n2];
        double[] dArray = new double[n2];
        for (n = 0; n < n2; ++n) {
            DataPoint dataPoint = vanChartDataSeries.getDataPoint(n);
            double d = this.getCateValue(vanChartBaseAxisGlyph, dataPoint, false);
            nArray[n] = n;
            dArray[n] = d;
        }
        int n3 = n2 - 1;
        for (n = 0; n < n3; ++n) {
            int n4;
            int n5;
            for (n5 = n; n5 < n3; ++n5) {
                if (!(dArray[nArray[n5]] > dArray[nArray[n5 + 1]])) continue;
                n4 = nArray[n5];
                nArray[n5] = nArray[n5 + 1];
                nArray[n5 + 1] = n4;
            }
            for (n5 = --n3; n5 > n; --n5) {
                if (!(dArray[nArray[n5]] < dArray[nArray[n5 - 1]])) continue;
                n4 = nArray[n5];
                nArray[n5] = nArray[n5 - 1];
                nArray[n5 - 1] = n4;
            }
        }
        return nArray;
    }

    private void dealLinePath(GeneralPath generalPath, VanChartDataSeries vanChartDataSeries, Color color, VanChartBaseAxisGlyph vanChartBaseAxisGlyph) {
        FoldLine foldLine = new FoldLine(generalPath);
        vanChartDataSeries.setDrawImpl((Glyph)foldLine);
        LineStyleInfo lineStyleInfo = foldLine.getLineStyleInfo();
        AttrLineStyle attrLineStyle = new AttrLineStyle(this.getAttrLineWidth(vanChartDataSeries));
        lineStyleInfo.changeStyleAttrLineStyle(attrLineStyle);
        lineStyleInfo.changeStyleAttrColor(new AttrColor(color));
        List<AttrBand> list = vanChartDataSeries.getBands();
        for (AttrBand attrBand : list) {
            double d = vanChartBaseAxisGlyph.getPointInBounds(attrBand.getMinEval()).getY();
            double d2 = vanChartBaseAxisGlyph.getPointInBounds(attrBand.getMaxEval()).getY();
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, Math.min(d, d2), this.getBounds().getWidth(), Math.abs(d - d2));
            VanChartBandGlyph vanChartBandGlyph = new VanChartBandGlyph(generalPath, double_);
            LineStyleInfo lineStyleInfo2 = vanChartBandGlyph.getLineStyleInfo();
            lineStyleInfo2.changeStyleAttrLineStyle(attrLineStyle);
            lineStyleInfo2.changeStyleAttrColor(new AttrColor(attrBand.getColor()));
            vanChartDataSeries.addBandGlyph(vanChartBandGlyph);
        }
    }

    protected void dealLine4AllSeries(VanChartDataSeries vanChartDataSeries, VanChartBaseAxisGlyph vanChartBaseAxisGlyph, VanChartBaseAxisGlyph vanChartBaseAxisGlyph2, Map<String, Number> map, Map<String, Number> map2, Point2D[] point2DArray, Point2D[] point2DArray2, Color color, GeneralPath generalPath, GeneralPath generalPath2, int[] nArray, int n) {
        VanChartBaseAxisGlyph vanChartBaseAxisGlyph3 = this.getDataSeriesValueAxisGlyph(vanChartDataSeries);
        boolean bl = vanChartBaseAxisGlyph3.isPercentage();
        int n2 = this.calculateLineDataCount(vanChartDataSeries);
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        n2 = 0;
        this.isStartPoint = true;
        boolean bl2 = this.isCurve(vanChartDataSeries);
        boolean bl3 = this.isStep(vanChartDataSeries);
        boolean bl4 = this.isNullValueBreak(vanChartDataSeries);
        double d = vanChartBaseAxisGlyph2.getPoint2D(0.0).getY();
        double d2 = 0.0;
        double d3 = 0.0;
        for (int n3 : nArray) {
            double d4;
            VanChartLineDataPoint vanChartLineDataPoint = (VanChartLineDataPoint)vanChartDataSeries.getDataPoint(n3);
            if (!this.isDisplayDataPoint(vanChartLineDataPoint)) continue;
            double d5 = this.getCateValue(vanChartBaseAxisGlyph, vanChartLineDataPoint, true);
            float f = (float)vanChartBaseAxisGlyph.getPoint2D(d5).getX();
            this.initLastPoints(n3, f, d, point2DArray2, point2DArray);
            if (vanChartLineDataPoint.isValueIsNull()) {
                if (!bl4) continue;
                this.isStartPoint = true;
                continue;
            }
            double d6 = d4 = bl ? vanChartLineDataPoint.getPercentValue() : vanChartLineDataPoint.getValue();
            if (this.isDataPointXNotInPlotBounds(f)) {
                vanChartLineDataPoint.setDataLabel(null);
                continue;
            }
            double d7 = this.getAndUpdateSumValue(d5, d4, map, map2);
            if (this.largeDataModel() && this.samePoint(d7, d2, d5, d3)) continue;
            float f2 = (float)vanChartBaseAxisGlyph2.getBounds().getY() + (float)vanChartBaseAxisGlyph2.getPoint2D(this.getPointPresentValue(d4, d7)).getY();
            dArray[n2] = f;
            dArray2[n2] = f2;
            if (d4 < 0.0) {
                point2DArray2[n3] = new Point2D.Double(f, f2);
            } else {
                point2DArray[n3] = new Point2D.Double(f, f2);
            }
            float f3 = (float)(this.isStartPoint ? 0.0 : dArray2[n2 - 1]);
            ++n2;
            this.dealLinePoint4EveryDataPoint(generalPath, generalPath2, f, f2, bl2, bl3, f3);
            this.initMarkerGlyph(vanChartLineDataPoint, f, f2, color);
            this.dealDataPointLabel(vanChartLineDataPoint, n);
            d2 = d7;
            d3 = d5;
        }
        this.trendLineFitting(dArray, dArray2, vanChartDataSeries);
    }

    private boolean largeDataModel() {
        return this.getDataProcessor().getMark() == 1;
    }

    protected double getPointPresentValue(double d, double d2) {
        return d2;
    }

    protected boolean samePoint(double d, double d2, double d3, double d4) {
        if (this.isStartPoint) {
            return false;
        }
        return Math.abs(d - d2) < this.YMinInterval && Math.abs(d3 - d4) < this.XMinInterval;
    }

    protected void initLastPoints(int n, double d, double d2, Point2D[] point2DArray, Point2D[] point2DArray2) {
        if (point2DArray[n] == null) {
            point2DArray[n] = new Point2D.Double(d, d2);
        }
        if (point2DArray2[n] == null) {
            point2DArray2[n] = new Point2D.Double(d, d2);
        }
    }

    protected double getAndUpdateSumValue(double d, double d2, Map<String, Number> map, Map<String, Number> map2) {
        double d3;
        if (d2 > 0.0) {
            Number number = map.get(String.valueOf(d));
            d3 = d2 + (number == null ? 0.0 : number.doubleValue());
            map.put(String.valueOf(d), d3);
        } else {
            Number number = map2.get(String.valueOf(d));
            d3 = d2 + (number == null ? 0.0 : number.doubleValue());
            map2.put(String.valueOf(d), d3);
        }
        return d3;
    }

    protected void dealLinePoint4EveryDataPoint(GeneralPath generalPath, GeneralPath generalPath2, float f, float f2, boolean bl, boolean bl2, float f3) {
        if (bl) {
            if (this.isStartPoint) {
                ChartUtils.curveTo((GeneralPath)generalPath, (GeneralPath)generalPath2);
                generalPath2.reset();
                generalPath2.moveTo(f, f2);
                generalPath.moveTo(f, f2);
                this.isStartPoint = false;
            } else {
                generalPath2.lineTo(f, f2);
            }
        } else if (bl2) {
            if (this.isStartPoint) {
                generalPath.moveTo(f, f2);
                this.isStartPoint = false;
            } else {
                generalPath.lineTo(f, f3);
                generalPath.lineTo(f, f2);
            }
        } else if (this.isStartPoint) {
            generalPath.moveTo(f, f2);
            this.isStartPoint = false;
        } else {
            generalPath.lineTo(f, f2);
        }
    }

    protected MarkerGlyph createMarkerGlyph() {
        return new MarkerGlyph();
    }

    protected void initMarkerGlyph(VanChartLineDataPoint vanChartLineDataPoint, float f, float f2, Color color) {
        MarkerGlyph markerGlyph = this.createMarkerGlyph();
        VanChartAttrMarker vanChartAttrMarker = this.getAttrMarker(vanChartLineDataPoint);
        Marker marker = vanChartAttrMarker.getMarkerType().getMarker();
        if (vanChartAttrMarker.isCommon()) {
            if (vanChartAttrMarker.getColorBackground() != null) {
                marker.setBackground((Background)vanChartAttrMarker.getColorBackground());
            } else {
                marker.setBackground((Background)ColorBackground.getInstance((Color)color));
            }
            double d = vanChartAttrMarker.getRadius();
            marker.setSize(d);
            markerGlyph.setShape((Rectangle2D)new Rectangle2D.Double((double)f - d, (double)f2 - d, d * 2.0, d * 2.0));
        } else if (vanChartAttrMarker.getImageBackground() != null) {
            double d = vanChartAttrMarker.getWidth();
            double d2 = vanChartAttrMarker.getHeight();
            marker = new CustomImageMarker(d, d2);
            marker.setBackground((Background)vanChartAttrMarker.getImageBackground());
            markerGlyph.setShape((Rectangle2D)new Rectangle2D.Double((double)f - d / 2.0, (double)f2 - d2 / 2.0, d, d2));
        }
        marker.setPlotBackground(this.getMarkerBackground());
        markerGlyph.setMarker(marker);
        this.dealAlpha4MakerGlyph(markerGlyph, vanChartLineDataPoint);
        vanChartLineDataPoint.setDrawImpl((Glyph)markerGlyph);
    }

    protected void dealAlpha4MakerGlyph(MarkerGlyph markerGlyph, VanChartLineDataPoint vanChartLineDataPoint) {
    }

    protected Background getMarkerBackground() {
        if (this.getBackground() instanceof ColorBackground) {
            return this.getBackground();
        }
        if (this.getBackground() == null && this.getWholeChartBackground() instanceof ColorBackground) {
            return this.getWholeChartBackground();
        }
        return null;
    }

    public String getChartType() {
        return "line";
    }

    @Override
    public JSONObject getPlotOptionsJSON(Repository repository, boolean bl) throws JSONException {
        JSONObject jSONObject = super.getPlotOptionsJSON(repository, bl);
        VanChartAttrLine vanChartAttrLine = this.getDefaultAttrLine();
        VanChartAttrMarker vanChartAttrMarker = this.getDefaultAttrMarker();
        if (vanChartAttrLine != null) {
            vanChartAttrLine.addToJSONObject(jSONObject);
        }
        if (vanChartAttrMarker != null) {
            jSONObject.put("marker", (Object)vanChartAttrMarker.toJSONObject(repository));
        }
        return jSONObject;
    }

    @Override
    protected void addLargeDataJSON(JSONObject jSONObject) throws JSONException {
        jSONObject.put("large", this.largeDataModel());
    }

    protected boolean isDisplayDataPoint(VanChartLineDataPoint vanChartLineDataPoint) {
        return true;
    }
}

