/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.line;

import com.fr.base.Utils;
import com.fr.base.background.ColorBackground;
import com.fr.base.chart.chartdata.ChartData;
import com.fr.chart.base.AttrBackground;
import com.fr.chart.base.ChartConstants;
import com.fr.chart.base.ChartFunctionProcessor;
import com.fr.chart.base.ChartUtils;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartdata.NormalChartData;
import com.fr.chart.chartglyph.ConditionAttr;
import com.fr.chart.chartglyph.ConditionCollection;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.data.condition.AbstractCondition;
import com.fr.data.condition.CommonCondition;
import com.fr.data.condition.JoinCondition;
import com.fr.data.condition.ListCondition;
import com.fr.data.condition.Result;
import com.fr.data.core.Compare;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.general.Inter;
import com.fr.general.data.Condition;
import com.fr.plugin.chart.attr.AttrBand;
import com.fr.plugin.chart.attr.VanChartPlotType;
import com.fr.plugin.chart.attr.axis.AxisType;
import com.fr.plugin.chart.attr.axis.VanChartAxis;
import com.fr.plugin.chart.attr.plot.VanChartRectanglePlot;
import com.fr.plugin.chart.base.AttrAreaSeriesFillColorBackground;
import com.fr.plugin.chart.base.AttrLabel;
import com.fr.plugin.chart.base.AttrSeriesStackAndAxis;
import com.fr.plugin.chart.glyph.VanChartDataPoint;
import com.fr.plugin.chart.glyph.VanChartDataSeries;
import com.fr.plugin.chart.line.VanChartLineDataPoint;
import com.fr.plugin.chart.line.VanChartLinePlotGlyph;
import com.fr.stable.ArrayUtils;
import com.fr.stable.FormulaProvider;
import com.fr.stable.ParameterProvider;
import com.fr.stable.fun.FunctionProcessor;
import java.awt.Color;
import java.util.List;

public class VanChartLinePlot
extends VanChartRectanglePlot {
    private static final long serialVersionUID = 2733137397945843905L;
    public static final String VAN_CHART_LINE_PLOT = "VanChartLinePlot";
    protected static final Object[] LINE_SERIES_NAME = new Object[]{Inter.getLocText((String)"FR-Chart-Data_Series") + "1", Inter.getLocText((String)"FR-Chart-Data_Series") + "2"};
    protected static final Object[][] LINE_VALUE = new Object[][]{{"5", "40", "18", "14", "70", "85"}, {"36", "75", "53", "57", "40", "45"}};
    public static final Object[] AXIS_DATE = new Object[]{DateUtils.createDate((int)2001, (int)1, (int)3), DateUtils.createDate((int)2001, (int)1, (int)1), DateUtils.createDate((int)2001, (int)1, (int)7), DateUtils.createDate((int)2001, (int)1, (int)13), DateUtils.createDate((int)2001, (int)1, (int)5), DateUtils.createDate((int)2001, (int)1, (int)11)};
    public static final Object[] AXIS_VALUE = new Object[]{"10", "20", "30", "35", "26", "55"};
    public static final Object[] AXIS_CATEGORY = ChartUtils.LONG_CATEGORY_STRING;

    public VanChartLinePlot() {
    }

    public VanChartLinePlot(VanChartPlotType vanChartPlotType) {
        super(vanChartPlotType);
    }

    public PlotGlyph createPlotGlyph(ChartData chartData) {
        VanChartLinePlotGlyph vanChartLinePlotGlyph = new VanChartLinePlotGlyph();
        this.install4PlotGlyph(vanChartLinePlotGlyph, chartData);
        this.installAxisGlyph(vanChartLinePlotGlyph, chartData);
        return vanChartLinePlotGlyph;
    }

    @Override
    public AttrLabel getDefaultAttrLabel() {
        AttrLabel attrLabel = new AttrLabel();
        attrLabel.getAttrLabelDetail().setPosition(6);
        return attrLabel;
    }

    @Override
    protected DataPoint createDataPoint() {
        return new VanChartLineDataPoint();
    }

    @Override
    protected void dealDataSeriesCustomCondition(VanChartDataSeries vanChartDataSeries, ConditionCollection conditionCollection) {
        this.dealDataSeriesAttrTrendLineCustomCondition(vanChartDataSeries, conditionCollection);
        this.dealDataSeriesAttrBackgroundCustomCondition(vanChartDataSeries, conditionCollection);
        this.dealDataSeriesAttrLineCustomCondition(vanChartDataSeries, conditionCollection);
        this.dealDataSeriesAttrMarkerCustomCondition(vanChartDataSeries, conditionCollection);
        this.dealDataSeriesAttrBandsCustomCondition(vanChartDataSeries, conditionCollection);
    }

    @Override
    protected void dealDataSeriesStackAndAxisCondition(VanChartDataSeries vanChartDataSeries, ConditionCollection conditionCollection) {
        if (this.isStackChart()) {
            AttrSeriesStackAndAxis attrSeriesStackAndAxis = new AttrSeriesStackAndAxis();
            vanChartDataSeries.setAttrSeriesStackAndAxis(attrSeriesStackAndAxis);
        } else if (this.isCustomChart()) {
            AttrSeriesStackAndAxis attrSeriesStackAndAxis = (AttrSeriesStackAndAxis)conditionCollection.getCustomDataSeriesCondition(AttrSeriesStackAndAxis.class, (Result)vanChartDataSeries);
            vanChartDataSeries.setAttrSeriesStackAndAxis(attrSeriesStackAndAxis);
        }
    }

    protected void dealDataSeriesAttrBandsCustomCondition(VanChartDataSeries vanChartDataSeries, ConditionCollection conditionCollection) {
        ConditionAttr conditionAttr = conditionCollection.getDefaultAttr();
        vanChartDataSeries.setEvalValue(true);
        List list = conditionCollection.getAllAttrByResult((Result)vanChartDataSeries, null);
        vanChartDataSeries.setEvalValue(false);
        for (ConditionAttr conditionAttr2 : list) {
            boolean bl;
            if (conditionAttr2 == null || ComparatorUtils.equals((Object)conditionAttr2, (Object)conditionAttr)) continue;
            AttrBackground attrBackground = (AttrBackground)conditionAttr2.getExisted(AttrBackground.class);
            AttrAreaSeriesFillColorBackground attrAreaSeriesFillColorBackground = (AttrAreaSeriesFillColorBackground)conditionAttr2.getExisted(AttrAreaSeriesFillColorBackground.class);
            boolean bl2 = bl = attrBackground != null && attrBackground.getSeriesBackground() instanceof ColorBackground;
            if (!bl && attrAreaSeriesFillColorBackground == null) continue;
            this.dealSingleBands(vanChartDataSeries, conditionAttr2, attrBackground, attrAreaSeriesFillColorBackground);
        }
    }

    private void dealSingleBands(VanChartDataSeries vanChartDataSeries, ConditionAttr conditionAttr, AttrBackground attrBackground, AttrAreaSeriesFillColorBackground attrAreaSeriesFillColorBackground) {
        AbstractCondition abstractCondition = conditionAttr.getCondition();
        MinMaxEval minMaxEval = new MinMaxEval();
        if (abstractCondition instanceof ListCondition) {
            int n = ((ListCondition)abstractCondition).getJoinConditionCount();
            if (n <= 0) {
                return;
            }
            for (int i = 0; i < n; ++i) {
                JoinCondition joinCondition = ((ListCondition)abstractCondition).getJoinCondition(i);
                int n2 = joinCondition.getJoin();
                if (!(joinCondition.getCondition() instanceof CommonCondition)) continue;
                if (i == 0 || n2 == 0) {
                    this.dealCommonCondition(joinCondition.getCondition(), minMaxEval);
                    continue;
                }
                if (n2 != 1) continue;
                MinMaxEval minMaxEval2 = new MinMaxEval();
                this.dealCommonCondition(joinCondition.getCondition(), minMaxEval2);
                this.addBands2DataSeries(minMaxEval2, attrAreaSeriesFillColorBackground, attrBackground, vanChartDataSeries);
            }
        } else if (abstractCondition instanceof CommonCondition) {
            this.dealCommonCondition((Condition)abstractCondition, minMaxEval);
        }
        this.addBands2DataSeries(minMaxEval, attrAreaSeriesFillColorBackground, attrBackground, vanChartDataSeries);
    }

    private void addBands2DataSeries(MinMaxEval minMaxEval, AttrAreaSeriesFillColorBackground attrAreaSeriesFillColorBackground, AttrBackground attrBackground, VanChartDataSeries vanChartDataSeries) {
        if (minMaxEval.hasMaxEval || minMaxEval.hasMinEval) {
            if (minMaxEval.maxEval == minMaxEval.minEval) {
                return;
            }
            AttrBand attrBand = new AttrBand(minMaxEval.hasMinEval, minMaxEval.hasMaxEval, minMaxEval.minEval, minMaxEval.maxEval);
            if (attrAreaSeriesFillColorBackground != null) {
                attrBand.setFillColorBackground(attrAreaSeriesFillColorBackground);
            }
            if (attrBackground != null && attrBackground.getSeriesBackground() instanceof ColorBackground) {
                Color color = ((ColorBackground)attrBackground.getSeriesBackground()).getColor();
                attrBand.setColor(color);
            }
            vanChartDataSeries.addAttrBands(attrBand);
        }
    }

    private void dealCommonCondition(Condition condition, MinMaxEval minMaxEval) {
        CommonCondition commonCondition = (CommonCondition)condition;
        String string = commonCondition.getColumnName();
        if (ComparatorUtils.equals((Object)string, (Object)ChartConstants.VALUE) || ArrayUtils.contains((Object[])ChartConstants.PROJECT_ID_KEYS, (Object)string)) {
            Number number;
            Compare compare = commonCondition.getCompare();
            Object object = compare.getValue();
            if (object instanceof ParameterProvider) {
                object = ((ParameterProvider)object).getValue();
            }
            if (object instanceof FormulaProvider) {
                object = ((FormulaProvider)object).getResult();
            }
            if ((number = Utils.objectToNumber((Object)object, (boolean)false)) == null) {
                return;
            }
            if (compare.getOp() == 4 || compare.getOp() == 5) {
                minMaxEval.minEval = number.doubleValue();
                minMaxEval.hasMinEval = true;
            } else if (compare.getOp() == 2 || compare.getOp() == 3) {
                minMaxEval.maxEval = number.doubleValue();
                minMaxEval.hasMaxEval = true;
            }
        }
    }

    @Override
    protected void dealDataPointCustomCondition(VanChartDataPoint vanChartDataPoint, ConditionCollection conditionCollection) {
        this.dealDataPointAttrLabelCustomCondition(vanChartDataPoint, conditionCollection);
        this.dealDataPointAttrTooltipCustomCondition(vanChartDataPoint, conditionCollection);
        this.dealDataPointAttrMarkerCustomCondition(vanChartDataPoint, conditionCollection);
        this.dealDataPointAttrBackgroundCustomCondition(vanChartDataPoint, conditionCollection);
    }

    public ChartData defaultChartData() {
        VanChartAxis vanChartAxis = this.getDefaultXAxis();
        if (ComparatorUtils.equals((Object)((Object)vanChartAxis.getAxisType()), (Object)((Object)AxisType.AXIS_CATEGORY))) {
            return new NormalChartData(AXIS_CATEGORY, LINE_SERIES_NAME, LINE_VALUE);
        }
        if (ComparatorUtils.equals((Object)((Object)vanChartAxis.getAxisType()), (Object)((Object)AxisType.AXIS_VALUE))) {
            return new NormalChartData(AXIS_VALUE, LINE_SERIES_NAME, LINE_VALUE);
        }
        return new NormalChartData(AXIS_DATE, LINE_SERIES_NAME, LINE_VALUE);
    }

    public String getPlotName() {
        return Inter.getLocText((String)"Plugin-ChartF_NewLine");
    }

    public String getPlotID() {
        return VAN_CHART_LINE_PLOT;
    }

    public boolean matchPlotType(Plot plot) {
        return plot instanceof VanChartLinePlot;
    }

    public boolean accept(Class<? extends Plot> clazz) {
        return ComparatorUtils.equals(VanChartLinePlot.class, clazz);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof VanChartLinePlot && super.equals(object);
    }

    public FunctionProcessor getFunctionToRecord() {
        return ChartFunctionProcessor.LINE_VAN_CHARTS;
    }

    private class MinMaxEval {
        double minEval = Double.MAX_VALUE;
        double maxEval = -1.7976931348623157E308;
        boolean hasMinEval = false;
        boolean hasMaxEval = false;

        private MinMaxEval() {
        }
    }
}

