/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.glyph.axis;

import com.fr.base.GraphHelper;
import com.fr.base.chart.chartdata.ChartData;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartglyph.ChartAlertValueGlyph;
import com.fr.chart.chartglyph.SpecialGlyph;
import com.fr.chart.chartglyph.TitleGlyph;
import com.fr.plugin.chart.attr.axis.VanChartAxis;
import com.fr.plugin.chart.attr.axis.VanChartValueAxis;
import com.fr.plugin.chart.gauge.glyph.GaugeGlyphHelper;
import com.fr.plugin.chart.glyph.VanChartAlertValueGlyph;
import com.fr.plugin.chart.glyph.axis.VanChartBaseAxisGlyph;
import com.fr.plugin.chart.glyph.axis.VanChartCategoryAxisGlyph;
import com.fr.plugin.chart.glyph.axis.VanChartValueAxisGlyph;
import com.fr.plugin.chart.radar.RadarType;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class VanChartRadarAxisGlyph
extends SpecialGlyph {
    private static final long serialVersionUID = 6463436295139097829L;
    public static final double RADAR_TICK_COUNT = 4.0;
    private static final int POLYGON = 3;
    private static final double WHOLE_ANGLE = 360.0;
    private static final double START_ANGLE = 90.0;
    private static final double PIE = 180.0;
    private static final double ANGLE1 = 90.0;
    private static final double ANGLE2 = -90.0;
    private static final int CATE_AXIS_LABEL_GAP = 10;
    private static final int LABEL_GAP = 8;
    private static final double MIN_R = 0.3333333333333333;
    private static final double ARC_ANGLE = 0.4;
    private Rectangle2D bounds;
    private double radius;
    private Point2D centerPoint;
    private double eachAngle;
    private Shape outerPath;
    private VanChartRadarXAxisGlyph xAxisGlyph;
    private VanChartRadarYAxisGlyph yAxisGlyph;
    private RadarType radarType;

    public VanChartRadarAxisGlyph(ChartData chartData, VanChartAxis vanChartAxis, VanChartValueAxis vanChartValueAxis, RadarType radarType) {
        this.xAxisGlyph = this.createRadarXAxisGlyph(chartData, vanChartAxis);
        this.yAxisGlyph = this.createRadarYAxisGlyph(vanChartValueAxis);
        this.radarType = radarType;
    }

    public VanChartBaseAxisGlyph getDataSeriesValueAxisGlyph() {
        return this.yAxisGlyph;
    }

    public VanChartBaseAxisGlyph getDataSeriesCateAxisGlyph() {
        return this.xAxisGlyph;
    }

    public void doLayout(Rectangle2D rectangle2D, int n) {
        this.bounds = rectangle2D;
        this.centerPoint = new Point2D.Double(rectangle2D.getCenterX(), rectangle2D.getCenterY());
        this.radius = Math.min(rectangle2D.getWidth(), rectangle2D.getHeight()) / 2.0 - 10.0;
        this.xAxisGlyph.adjustRadius(n);
        this.radius = Math.max(this.radius, Math.min(rectangle2D.getWidth(), rectangle2D.getHeight()) * 0.3333333333333333);
        this.yAxisGlyph.setAxisLength(this.radius);
        this.xAxisGlyph.setBounds(rectangle2D);
        this.yAxisGlyph.setBounds(rectangle2D);
    }

    public void draw(Graphics graphics, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.xAxisGlyph.drawInfo(graphics2D, n);
        this.yAxisGlyph.drawInfo(graphics2D, n);
    }

    public Shape getShape() {
        return new Arc2D.Double(this.centerPoint.getX() - this.radius, this.centerPoint.getY() - this.radius, 2.0 * this.radius, 2.0 * this.radius, 0.0, 360.0, 2);
    }

    private VanChartRadarXAxisGlyph createRadarXAxisGlyph(ChartData chartData, VanChartAxis vanChartAxis) {
        VanChartRadarXAxisGlyph vanChartRadarXAxisGlyph = new VanChartRadarXAxisGlyph();
        vanChartAxis.initAxisGlyphWithChartData(chartData, vanChartRadarXAxisGlyph);
        return vanChartRadarXAxisGlyph;
    }

    private VanChartRadarYAxisGlyph createRadarYAxisGlyph(VanChartValueAxis vanChartValueAxis) {
        VanChartRadarYAxisGlyph vanChartRadarYAxisGlyph = new VanChartRadarYAxisGlyph();
        vanChartValueAxis.initAxisGlyphWithChartData(vanChartRadarYAxisGlyph);
        return vanChartRadarYAxisGlyph;
    }

    public Point2D getPoint2DWithCateIndexAndValue(int n, double d) {
        double d2 = this.xAxisGlyph.getAngleWithCateIndex(n);
        double d3 = this.yAxisGlyph.getRadiusWithValue(d);
        return this.getPoint2DWithAngleAndRadius(d2, d3);
    }

    public Shape getArcShapeBetweenTwoValues(double d, double d2, int n) {
        double d3 = this.xAxisGlyph.getAngleWithCateIndex(n);
        double d4 = d3 - this.eachAngle * 0.4;
        double d5 = this.eachAngle * 0.4 * 2.0;
        return this.yAxisGlyph.getCircleBackgroundShape(d, d2, d4, d5);
    }

    public Rectangle2D getNormalLabelBounds(Dimension2D dimension2D, int n, double d) {
        double d2 = this.yAxisGlyph.getRadiusWithValue(d) + 8.0;
        return this.xAxisGlyph.getLabelBoundsOut(dimension2D, n, d2);
    }

    public Rectangle2D getColumnTypeLabelBounds(Dimension2D dimension2D, int n, double d) {
        double d2 = this.yAxisGlyph.getRadiusWithValue(d) - 8.0;
        d2 = d2 > 0.0 ? d2 : 0.0;
        return this.xAxisGlyph.getLabelBoundsIn(dimension2D, n, d2);
    }

    private Point2D getPoint2DWithCateIndexAndRadius(int n, double d) {
        double d2 = this.xAxisGlyph.getAngleWithCateIndex(n);
        return this.getPoint2DWithAngleAndRadius(d2, d);
    }

    private Point2D getPoint2DWithAngleAndRadius(double d, double d2) {
        double d3 = this.centerPoint.getX() + d2 * Math.cos(Math.PI * (d / 180.0));
        double d4 = this.centerPoint.getY() - d2 * Math.sin(Math.PI * (d / 180.0));
        return new Point2D.Double(d3, d4);
    }

    private Shape getCircleOrPolygonGridLine(double d) {
        double d2 = this.yAxisGlyph.getRadiusWithValue(d);
        switch (this.radarType) {
            case CIRCLE: {
                return new Arc2D.Double(this.centerPoint.getX() - d2, this.centerPoint.getY() - d2, 2.0 * d2, 2.0 * d2, 0.0, 360.0, 0);
            }
        }
        GeneralPath generalPath = new GeneralPath();
        this.completePolygonLine(generalPath, d);
        return generalPath;
    }

    private void completePolygonLine(GeneralPath generalPath, double d) {
        Point2D point2D = this.getPoint2DWithCateIndexAndValue(0, d);
        int n = this.xAxisGlyph.getCategoryCount();
        generalPath.moveTo(point2D.getX(), point2D.getY());
        for (int i = 1; i < n; ++i) {
            Point2D point2D2 = this.getPoint2DWithCateIndexAndValue(i, d);
            generalPath.lineTo(point2D2.getX(), point2D2.getY());
        }
        generalPath.lineTo(point2D.getX(), point2D.getY());
    }

    private void completePolygonLineReversed(GeneralPath generalPath, double d) {
        Point2D point2D = this.getPoint2DWithCateIndexAndValue(0, d);
        int n = this.xAxisGlyph.getCategoryCount();
        generalPath.moveTo(point2D.getX(), point2D.getY());
        for (int i = n - 1; i > 0; --i) {
            Point2D point2D2 = this.getPoint2DWithCateIndexAndValue(i, d);
            generalPath.lineTo(point2D2.getX(), point2D2.getY());
        }
        generalPath.lineTo(point2D.getX(), point2D.getY());
    }

    private Shape getXAxisLine() {
        return this.getCircleOrPolygonGridLine(this.yAxisGlyph.getMaxValue());
    }

    private Line2D[] getYAxisLine() {
        int n = this.xAxisGlyph.getCategoryCount();
        Line2D[] line2DArray = new Line2D[n];
        for (int i = 0; i < n; ++i) {
            Point2D point2D = this.getPoint2DWithCateIndexAndRadius(i, this.radius);
            line2DArray[i] = new Line2D.Double(this.centerPoint, point2D);
        }
        return line2DArray;
    }

    private class VanChartRadarYAxisGlyph
    extends VanChartValueAxisGlyph {
        private static final long serialVersionUID = -8745777455132242370L;
        private static final double GAP = 2.0;

        private VanChartRadarYAxisGlyph() {
        }

        @Override
        public double getDefaultTickCount() {
            return 4.0;
        }

        private double getRadiusWithValue(double d) {
            double d2;
            if (this.isLog() && this.getCrossValue() > 0.0) {
                if (d <= 1.0E-10) {
                    d = this.getCrossValue();
                }
                d = (Math.log(d) - Math.log(this.getCrossValue())) / Math.log(this.getMainUnit());
                d2 = (Math.log(this.getArrowValue()) - Math.log(this.getCrossValue())) / Math.log(this.getMainUnit());
            } else {
                if (d < this.getCrossValue()) {
                    d = this.getCrossValue();
                }
                d -= this.getCrossValue();
                d2 = this.getArrowValue() - this.getCrossValue();
            }
            return d / d2 * VanChartRadarAxisGlyph.this.radius;
        }

        private double getRadiusWithValueInSideAxis(double d) {
            double d2 = this.getRadiusWithValue(d);
            return Math.min(d2, VanChartRadarAxisGlyph.this.radius);
        }

        @Override
        protected Rectangle2D getLabelBounds(double d, double d2, String string, int n) {
            Point2D point2D = VanChartRadarAxisGlyph.this.getPoint2DWithAngleAndRadius(90.0, this.getRadiusWithValue(d));
            Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithRotation((String)string, (TextAttr)this.getTextAttr(), (int)n);
            Rectangle2D.Double double_ = new Rectangle2D.Double(point2D.getX() - 2.0 - dimension2D.getWidth(), point2D.getY() - dimension2D.getHeight(), dimension2D.getWidth(), dimension2D.getHeight());
            if (VanChartRadarAxisGlyph.this.outerPath.contains(double_) || VanChartRadarAxisGlyph.this.xAxisGlyph.getCategoryCount() < 3) {
                return double_;
            }
            return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }

        @Override
        public void draw(Graphics graphics, int n) {
        }

        private void drawInfo(Graphics graphics, int n) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            this.drawIntervalBackground(graphics);
            this.drawAxisGrid(graphics);
            this.drawAxisLine(graphics, n);
            this.drawTickLable(graphics, n);
            this.drawAlertValueGlyph(graphics2D, n);
        }

        @Override
        protected void drawMainGridLineWithValue(Graphics2D graphics2D, double d) {
            if (d == this.getMaxValue()) {
                return;
            }
            graphics2D.draw(VanChartRadarAxisGlyph.this.getCircleOrPolygonGridLine(d));
        }

        @Override
        protected void drawAxisLine(Graphics graphics, int n) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Paint paint = graphics2D.getPaint();
            Stroke stroke = graphics2D.getStroke();
            int n2 = this.getLineStyle();
            Color color = this.getLineColor();
            if (color != null && n2 != 0) {
                Line2D[] line2DArray;
                graphics2D.setStroke(GraphHelper.getStroke((int)n2));
                graphics2D.setPaint(color);
                for (Line2D line2D : line2DArray = VanChartRadarAxisGlyph.this.getYAxisLine()) {
                    graphics2D.draw(line2D);
                }
            }
            graphics2D.setStroke(stroke);
            graphics2D.setPaint(paint);
        }

        @Override
        protected Shape getCustomBackgroundShape(double d, double d2, boolean bl) {
            switch (VanChartRadarAxisGlyph.this.radarType) {
                case CIRCLE: {
                    return this.getCircleBackgroundShape(d, d2, 0.0, 360.0);
                }
            }
            GeneralPath generalPath = new GeneralPath();
            VanChartRadarAxisGlyph.this.completePolygonLine(generalPath, d);
            VanChartRadarAxisGlyph.this.completePolygonLineReversed(generalPath, d2);
            return generalPath;
        }

        private Shape getCircleBackgroundShape(double d, double d2, double d3, double d4) {
            double d5 = this.getRadiusWithValueInSideAxis(d);
            double d6 = this.getRadiusWithValueInSideAxis(d2);
            if (d5 == 0.0 || d6 == 0.0) {
                double d7 = d5 + d6;
                return new Arc2D.Double(VanChartRadarAxisGlyph.this.centerPoint.getX() - d7, VanChartRadarAxisGlyph.this.centerPoint.getY() - d7, 2.0 * d7, 2.0 * d7, d3, d4, 2);
            }
            return GaugeGlyphHelper.getArcPath(VanChartRadarAxisGlyph.this.centerPoint, d5, d6, d3, d4);
        }

        @Override
        public void drawAlertValueGlyph(Graphics2D graphics2D, int n) {
            Paint paint = graphics2D.getPaint();
            Stroke stroke = graphics2D.getStroke();
            Composite composite = graphics2D.getComposite();
            for (ChartAlertValueGlyph chartAlertValueGlyph : this.getAlertValues()) {
                double d;
                double d2;
                VanChartAlertValueGlyph vanChartAlertValueGlyph = (VanChartAlertValueGlyph)chartAlertValueGlyph;
                Color color = vanChartAlertValueGlyph.getLineColor().getSeriesColor();
                if (color == null || (d2 = this.getRadiusWithValue(d = vanChartAlertValueGlyph.getAlertValue())) > VanChartRadarAxisGlyph.this.radius) continue;
                graphics2D.setComposite(AlphaComposite.getInstance(3, vanChartAlertValueGlyph.getAlertLineAlpha()));
                graphics2D.setPaint(color);
                graphics2D.setStroke(GraphHelper.getStroke((int)vanChartAlertValueGlyph.getLineStyle().getLineStyle()));
                Shape shape = VanChartRadarAxisGlyph.this.getCircleOrPolygonGridLine(d);
                graphics2D.draw(shape);
                TextAttr textAttr = new TextAttr();
                textAttr.setFRFont(vanChartAlertValueGlyph.getAlertFont());
                String string = vanChartAlertValueGlyph.getAlertContent();
                Point2D point2D = VanChartRadarAxisGlyph.this.getPoint2DWithAngleAndRadius(90.0, d2);
                Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithRotation((String)string, (TextAttr)textAttr, (int)n);
                Rectangle2D.Double double_ = vanChartAlertValueGlyph.getAlertPosition() == 2 ? new Rectangle2D.Double(point2D.getX() - 2.0 - dimension2D.getWidth(), point2D.getY() - dimension2D.getHeight(), dimension2D.getWidth(), dimension2D.getHeight()) : new Rectangle2D.Double(point2D.getX() + 2.0, point2D.getY() - dimension2D.getHeight(), dimension2D.getWidth(), dimension2D.getHeight());
                GlyphUtils.drawStrings((Graphics)graphics2D, (String)string, (TextAttr)textAttr, (Rectangle2D)double_, (int)n);
            }
            graphics2D.setComposite(composite);
            graphics2D.setStroke(stroke);
            graphics2D.setPaint(paint);
        }
    }

    private class VanChartRadarXAxisGlyph
    extends VanChartCategoryAxisGlyph {
        private static final long serialVersionUID = -3624844525338565417L;

        private VanChartRadarXAxisGlyph() {
        }

        private double getAngleWithCateIndex(int n) {
            return 90.0 - ((double)n - this.getCrossValue()) * VanChartRadarAxisGlyph.this.eachAngle;
        }

        private void adjustRadius(int n) {
            int n2 = this.getCategoryCount();
            VanChartRadarAxisGlyph.this.eachAngle = 360.0 / (double)n2;
            boolean bl = this.isToNumber();
            int n3 = this.getLabelNumber() > 0 ? this.getLabelNumber() : this.getTickSamplingTime();
            for (int i = 0; i < n2; i += n3) {
                String string = this.getLabelString(i, bl);
                Rectangle2D rectangle2D = this.getLabelBounds(i, 0.0, string, n);
                double d = this.getAngleWithCateIndex(i);
                double d2 = d == 90.0 ? VanChartRadarAxisGlyph.this.bounds.getY() - rectangle2D.getY() : (d < 90.0 && d > -90.0 ? rectangle2D.getMaxX() - VanChartRadarAxisGlyph.this.bounds.getMaxX() : (d == -90.0 ? rectangle2D.getMaxY() - VanChartRadarAxisGlyph.this.bounds.getMaxY() : VanChartRadarAxisGlyph.this.bounds.getX() - rectangle2D.getX()));
                if (!(d2 > 0.0)) continue;
                VanChartRadarAxisGlyph.this.radius -= d2;
            }
        }

        protected Rectangle2D getLabelBounds(double d, double d2, String string, int n) {
            Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithRotation((String)string, (TextAttr)this.getTextAttr(), (int)n);
            return this.getLabelBoundsOut(dimension2D, (int)d, VanChartRadarAxisGlyph.this.radius + 10.0);
        }

        private Rectangle2D getLabelBoundsOut(Dimension2D dimension2D, int n, double d) {
            double d2 = this.getAngleWithCateIndex(n);
            Point2D point2D = VanChartRadarAxisGlyph.this.getPoint2DWithCateIndexAndRadius(n, d);
            double d3 = point2D.getX();
            double d4 = point2D.getY();
            if (d2 == 90.0) {
                d3 -= dimension2D.getWidth() / 2.0;
                d4 -= dimension2D.getHeight();
            } else if (d2 < 90.0 && d2 > -90.0) {
                d4 -= dimension2D.getHeight() / 2.0;
            } else if (d2 == -90.0) {
                d3 -= dimension2D.getWidth() / 2.0;
            } else {
                d3 -= dimension2D.getWidth();
                d4 -= dimension2D.getHeight() / 2.0;
            }
            return new Rectangle2D.Double(d3, d4, dimension2D.getWidth(), dimension2D.getHeight());
        }

        private Rectangle2D getLabelBoundsIn(Dimension2D dimension2D, int n, double d) {
            double d2 = this.getAngleWithCateIndex(n);
            Point2D point2D = VanChartRadarAxisGlyph.this.getPoint2DWithCateIndexAndRadius(n, d);
            double d3 = point2D.getX();
            double d4 = point2D.getY();
            if (d2 == 90.0) {
                d3 -= dimension2D.getWidth() / 2.0;
            } else if (d2 < 90.0 && d2 > -90.0) {
                d3 -= dimension2D.getWidth();
                d4 -= dimension2D.getHeight() / 2.0;
            } else if (d2 == -90.0) {
                d3 -= dimension2D.getWidth() / 2.0;
                d4 -= dimension2D.getHeight();
            } else {
                d4 -= dimension2D.getHeight() / 2.0;
            }
            return new Rectangle2D.Double(d3, d4, dimension2D.getWidth(), dimension2D.getHeight());
        }

        @Override
        public void draw(Graphics graphics, int n) {
        }

        private void drawInfo(Graphics graphics, int n) {
            this.drawAxisLine(graphics, n);
            this.drawTickLabel(graphics, n, 1, this.isToNumber(), 0.0);
        }

        @Override
        protected void drawLabel(Graphics graphics, double d, double d2, String string, int n) {
            if (!this.isShowAxisLabel) {
                return;
            }
            Graphics graphics2 = graphics.create();
            this.textAttr.setRotation(-this.textAttr.getRotation());
            TitleGlyph titleGlyph = new TitleGlyph(string, this.textAttr);
            Rectangle2D rectangle2D = this.getLabelBounds(d, d2, string, n);
            titleGlyph.setPosition(4);
            titleGlyph.setBounds((RectangularShape)this.getNiceLabelBounds(rectangle2D));
            titleGlyph.draw(graphics2, n);
            this.textAttr.setRotation(-this.textAttr.getRotation());
        }

        private Rectangle2D getNiceLabelBounds(Rectangle2D rectangle2D) {
            double d = rectangle2D.getX();
            double d2 = rectangle2D.getWidth();
            if (rectangle2D.getMinX() < 0.0) {
                d = 0.0;
                d2 += rectangle2D.getMinX();
            }
            if (rectangle2D.getMaxX() > this.bounds.getWidth()) {
                d2 = this.bounds.getWidth() - d;
            }
            double d3 = 4.0;
            double d4 = 4.0;
            if (this.textAttr.getRotation() != 0) {
                d3 += 4.0;
            }
            return new Rectangle2D.Double(d - d3, rectangle2D.getY() - d4, d2 + 2.0 * d3, VanChartRadarAxisGlyph.this.bounds.getHeight());
        }

        @Override
        protected void drawAxisLine(Graphics graphics, int n) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Paint paint = graphics2D.getPaint();
            Stroke stroke = graphics2D.getStroke();
            int n2 = this.getLineStyle();
            Color color = this.getLineColor();
            VanChartRadarAxisGlyph.this.outerPath = VanChartRadarAxisGlyph.this.getXAxisLine();
            if (color != null && n2 != 0) {
                graphics2D.setStroke(GraphHelper.getStroke((int)n2));
                graphics2D.setPaint(color);
                graphics2D.draw(VanChartRadarAxisGlyph.this.outerPath);
            }
            graphics2D.setStroke(stroke);
            graphics2D.setPaint(paint);
        }
    }
}

