/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.glyph.axis;

import com.fr.base.Formula;
import com.fr.base.GraphHelper;
import com.fr.chart.base.ChartUtils;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartglyph.AxisGlyph;
import com.fr.chart.chartglyph.ChartAlertValueGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.plugin.chart.attr.VanChartAttrHelper;
import com.fr.plugin.chart.attr.VanChartHtmlLabel;
import com.fr.plugin.chart.attr.axis.AxisTickLineType;
import com.fr.plugin.chart.attr.axis.AxisType;
import com.fr.plugin.chart.attr.axis.VanChartCustomIntervalBackground;
import com.fr.plugin.chart.glyph.axis.VanChartTimeAxisGlyph;
import com.fr.stable.StableUtils;
import com.fr.stable.web.Repository;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public abstract class VanChartBaseAxisGlyph
extends AxisGlyph {
    private static final long serialVersionUID = 5027277827821496923L;
    public static final double TICK_COUNT = 5.0;
    private static final double D3_TICK_COUNT = 10.0;
    public static final int DEFAULT_MAX = 100;
    private static final double STEP10 = 10.0;
    private static final double STEP5 = 5.0;
    private static final double STEP2 = 2.0;
    private static final double ERROR15 = 0.15;
    private static final double ERROR35 = 0.35;
    private static final double ERROR75 = 0.75;
    private String vanAxisName;
    private AxisType vanAxisType;
    protected boolean isXAxis = true;
    private Rectangle2D chartBounds;
    private Rectangle2D plotProcessBounds;
    private boolean titleUseHtml = false;
    private boolean autoLabelGap = true;
    private boolean limitSize = false;
    private double maxHeight = 15.0;
    private boolean commonValueFormat = true;
    private VanChartHtmlLabel htmlLabel;
    private List<ChartAlertValueGlyph> alertValues = new ArrayList<ChartAlertValueGlyph>();
    private Color defaultIntervalBackgroundColor = null;
    private List<VanChartCustomIntervalBackground> customIntervalBackgroundArray = new ArrayList<VanChartCustomIntervalBackground>();
    private AxisTickLineType mainTickLine = AxisTickLineType.TICK_LINE_OUTSIDE;
    private AxisTickLineType secTickLine = AxisTickLineType.TICK_LINE_NONE;
    protected double niceMinValue;
    protected double niceMaxValue;

    public void setNiceMinValue(double d) {
        this.niceMinValue = d;
    }

    public void setNiceMaxValue(double d) {
        this.niceMaxValue = d;
    }

    public void setMainTickLine(AxisTickLineType axisTickLineType) {
        this.mainTickLine = axisTickLineType;
    }

    public void setSecTickLine(AxisTickLineType axisTickLineType) {
        this.secTickLine = axisTickLineType;
    }

    public AxisTickLineType getSecTickLine() {
        return this.secTickLine;
    }

    public AxisTickLineType getMainTickLine() {
        return this.mainTickLine;
    }

    public void setVanAxisName(String string) {
        this.vanAxisName = string;
    }

    public String getVanAxisName() {
        return this.vanAxisName;
    }

    public void setISXAxis(boolean bl) {
        this.isXAxis = bl;
    }

    public void setChartBounds(Rectangle2D rectangle2D) {
        this.chartBounds = rectangle2D;
    }

    public void setTitleUseHtml(boolean bl) {
        this.titleUseHtml = bl;
    }

    public boolean isTitleUseHtml() {
        return this.titleUseHtml;
    }

    public void setAutoLabelGap(boolean bl) {
        this.autoLabelGap = bl;
    }

    public boolean isAutoLabelGap() {
        return this.autoLabelGap;
    }

    public void setCommonValueFormat(boolean bl) {
        this.commonValueFormat = bl;
    }

    public boolean isCommonValueFormat() {
        return this.commonValueFormat;
    }

    public void setHtmlLabel(VanChartHtmlLabel vanChartHtmlLabel) {
        this.htmlLabel = vanChartHtmlLabel;
    }

    public void setAlertValues(List<ChartAlertValueGlyph> list) {
        this.alertValues = list;
    }

    public List<ChartAlertValueGlyph> getAlertValues() {
        return this.alertValues;
    }

    public void setCustomIntervalBackgroundArray(List<VanChartCustomIntervalBackground> list) {
        this.customIntervalBackgroundArray = list;
    }

    public void setDefaultIntervalBackgroundColor(Color color) {
        this.defaultIntervalBackgroundColor = color;
    }

    public List<VanChartCustomIntervalBackground> getCustomIntervalBackgroundArray() {
        return this.customIntervalBackgroundArray;
    }

    public Color getDefaultIntervalBackgroundColor() {
        return this.defaultIntervalBackgroundColor;
    }

    public void setLimitSize(boolean bl) {
        this.limitSize = bl;
    }

    public boolean isLimitSize() {
        return this.limitSize;
    }

    public void setMaxHeight(double d) {
        this.maxHeight = d;
    }

    public double getMaxHeight() {
        return this.maxHeight;
    }

    public void setVanAxisType(AxisType axisType) {
        this.vanAxisType = axisType;
    }

    public AxisType getVanAxisType() {
        return this.vanAxisType;
    }

    public double getDefaultTickCount() {
        return 5.0;
    }

    public void draw(Graphics graphics, int n) {
        if (this.getBounds() == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        this.drawAxisGrid(graphics2D);
        this.drawIntervalBackground(graphics2D);
        this.drawAlertValueGlyph(graphics2D, n);
        this.drawAxisLine(graphics2D, n);
        this.drawAxisTitle(graphics2D, n);
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
    }

    public void initMinMaxValue(double d, double d2, boolean bl) {
        this.initMinMaxValue(d, d2);
    }

    public Point2D getPoint2D(double d) {
        Point2D.Double double_ = null;
        d -= this.getCrossValue();
        if (this.getPosition() == 2) {
            double d2 = this.getBounds().getY();
            double_ = d2 == this.originPoint.getY() || this.hasAxisReversed() ? new Point2D.Double(this.originPoint.getX(), this.originPoint.getY() + this.unitLength * d) : new Point2D.Double(this.originPoint.getX(), this.originPoint.getY() - this.unitLength * d);
        } else if (this.getPosition() == 4) {
            double d3 = this.hasAxisReversed() ? this.unitLength * d : -this.unitLength * d;
            double_ = new Point2D.Double(this.originPoint.getX(), this.originPoint.getY() + d3);
        } else if (this.getPosition() == 1 || this.getPosition() == 3) {
            double d4 = this.hasAxisReversed() ? -this.unitLength * d : this.unitLength * d;
            double_ = new Point2D.Double(this.originPoint.getX() + d4, this.originPoint.getY());
        } else if (this.isXAxis) {
            double d5 = this.hasAxisReversed() ? -this.unitLength * d : this.unitLength * d;
            double_ = new Point2D.Double(this.originPoint.getX() + d5, this.originPoint.getY());
        } else {
            double d6 = this.getBounds().getY();
            double_ = d6 == this.originPoint.getY() || this.hasAxisReversed() ? new Point2D.Double(this.originPoint.getX(), this.originPoint.getY() + this.unitLength * d) : new Point2D.Double(this.originPoint.getX(), this.originPoint.getY() - this.unitLength * d);
        }
        return double_;
    }

    protected Line2D getOtherPositionGridLine(Point2D point2D) {
        if (this.getPosition() == 3) {
            return super.getOtherPositionGridLine(point2D);
        }
        if (this.isXAxis) {
            return new Line2D.Double(point2D.getX(), -this.getBounds().getY(), point2D.getX(), -this.getBounds().getY() + this.getPlotLastBounds().getHeight());
        }
        return new Line2D.Double(-this.getBounds().getX(), point2D.getY(), -this.getBounds().getX() + this.getPlotLastBounds().getWidth(), point2D.getY());
    }

    protected Rectangle2D getOtherPositionTitleBounds(Dimension2D dimension2D, int n) {
        if (this.isXAxis) {
            return this.getBottomTitleBounds(dimension2D, n);
        }
        return this.getLeftTitleBounds(dimension2D, n);
    }

    protected Line2D getOtherPositionTickLine(Point2D point2D, Point2D point2D2, Point2D point2D3) {
        if (this.getPosition() == 3) {
            return super.getOtherPositionTickLine(point2D, point2D2, point2D3);
        }
        if (this.isXAxis) {
            return super.getOtherPositionTickLine(point2D, point2D2, point2D3);
        }
        return new Line2D.Double(point2D, point2D3);
    }

    protected Rectangle2D getOtherPositionLabelBounds(Point2D point2D, double d, double d2, double d3) {
        if (this.getPosition() == 3) {
            return super.getOtherPositionLabelBounds(point2D, d, d2, d3);
        }
        if (this.isXAxis) {
            return super.getOtherPositionLabelBounds(point2D, d, d2, d3);
        }
        return new Rectangle2D.Double(point2D.getX() - d - d3, point2D.getY() - d2 / 2.0, d, d2);
    }

    protected double getOtherPoint2ValueLength(Point2D point2D, Point2D point2D2) {
        if (this.getPosition() == 3 || this.getPosition() == 1) {
            return super.getOtherPoint2ValueLength(point2D, point2D2);
        }
        if (this.isXAxis) {
            return super.getOtherPoint2ValueLength(point2D, point2D2);
        }
        return Math.abs(point2D.getY() - point2D2.getY());
    }

    protected double getLeftRightY(int n) {
        double d = (this.axisLength - this.titleDim.getHeight()) / 2.0;
        if (n == 1) {
            d = -8.0;
        } else if (n == 3) {
            d = this.axisLength - this.titleDim.getHeight() + 8.0;
        }
        return d;
    }

    protected boolean shouldBeHeight() {
        return this.isXAxis;
    }

    protected double getCateLabelWidth(Rectangle2D rectangle2D, int n) {
        return this.getMaxLabelWidthAndInitStartEndLabelDim(n);
    }

    public void calculateBoundsWidthOrientationAndTitle(Rectangle2D rectangle2D, double d, Dimension2D dimension2D) {
        double d2;
        double d3;
        double d4 = rectangle2D.getX();
        double d5 = rectangle2D.getY();
        double d6 = rectangle2D.getWidth();
        double d7 = rectangle2D.getHeight();
        double d8 = dimension2D.getWidth() > 0.0 ? dimension2D.getWidth() + 4.0 : 0.0;
        double d9 = d3 = dimension2D.getHeight() > 0.0 ? dimension2D.getHeight() + 4.0 : 0.0;
        if (this.limitSize) {
            d2 = this.shouldBeHeight() ? this.chartBounds.getHeight() * this.maxHeight / 100.0 : this.chartBounds.getWidth() * this.maxHeight / 100.0;
            d3 = Math.min(d2, d + d3);
            d8 = Math.min(d2, d + d8);
            d = 0.0;
        }
        d2 = this.getTickLengthShow();
        switch (this.getPosition()) {
            case 2: {
                d4 += d + d2 + d8;
                d6 -= d + d2 + d8;
                break;
            }
            case 3: {
                d7 -= d + d2 + d3;
                break;
            }
            case 4: {
                d6 -= d + d2 + d8;
                break;
            }
            case 1: {
                d5 += d + d2 + d3;
                d7 -= d + d2 + d3;
                break;
            }
        }
        rectangle2D.setRect(d4, d5, d6, d7);
    }

    public void initAxisGlyphStartPoint(Rectangle2D rectangle2D) {
        this.plotProcessBounds = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public void dealOnZeroAxisGlyphLocation(double d) {
        if (this.getPosition() != 5) {
            return;
        }
        if (this.isXAxis) {
            this.setBounds(new Rectangle2D.Double(this.getBounds().getX(), d, this.getBounds().getWidth(), this.getBounds().getHeight()));
        } else {
            this.setBounds(new Rectangle2D.Double(d - this.getBounds().getWidth(), this.getBounds().getY(), this.getBounds().getWidth(), this.getBounds().getHeight()));
        }
    }

    public void finallyUpdateAxisGridLength(double d) {
        this.setAxisGridLength(d);
    }

    protected void init(Rectangle2D rectangle2D) {
        switch (this.getPosition()) {
            case 2: {
                this.leftCase(rectangle2D);
                break;
            }
            case 3: {
                this.bottomCase(rectangle2D);
                break;
            }
            case 4: {
                this.rightCase(rectangle2D);
                break;
            }
            case 1: {
                this.topCase(rectangle2D);
                break;
            }
            case 5: {
                this.zeroCase(rectangle2D);
                break;
            }
        }
    }

    private void zeroCase(Rectangle2D rectangle2D) {
        if (this.isXAxis) {
            this.bottomCase(rectangle2D);
        } else {
            this.leftCase(rectangle2D);
        }
    }

    private void topCase(Rectangle2D rectangle2D) {
        double d = rectangle2D.getWidth();
        double d2 = rectangle2D.getHeight();
        double d3 = rectangle2D.getY() - this.plotProcessBounds.getY();
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, -this.axisLabelWidth - d3, rectangle2D.getWidth(), this.axisLabelWidth);
        Point2D.Double double_2 = !this.hasAxisReversed() ? new Point2D.Double(0.0, this.axisLabelWidth) : new Point2D.Double(rectangle2D.getWidth(), this.axisLabelWidth);
        this.setAttr(double_, double_2, d, d2);
    }

    private void rightCase(Rectangle2D rectangle2D) {
        double d = rectangle2D.getHeight();
        double d2 = rectangle2D.getWidth();
        double d3 = this.plotProcessBounds.getWidth() - (rectangle2D.getX() - this.plotProcessBounds.getX());
        Rectangle2D.Double double_ = new Rectangle2D.Double(d3, 0.0, this.axisLabelWidth, rectangle2D.getHeight());
        Point2D.Double double_2 = !this.hasAxisReversed() ? new Point2D.Double(0.0, rectangle2D.getHeight()) : new Point2D.Double(0.0, 0.0);
        this.setAttr(double_, double_2, d, d2);
    }

    private void bottomCase(Rectangle2D rectangle2D) {
        double d = rectangle2D.getWidth();
        double d2 = rectangle2D.getHeight();
        double d3 = this.plotProcessBounds.getHeight() + this.plotProcessBounds.getY() - (rectangle2D.getY() + rectangle2D.getHeight());
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, d3 + rectangle2D.getHeight(), rectangle2D.getWidth(), this.axisLabelWidth);
        Point2D.Double double_2 = !this.hasAxisReversed() ? new Point2D.Double(0.0, 0.0) : new Point2D.Double(rectangle2D.getWidth(), 0.0);
        this.setAttr(double_, double_2, d, d2);
    }

    private void leftCase(Rectangle2D rectangle2D) {
        double d = rectangle2D.getHeight();
        double d2 = rectangle2D.getWidth();
        double d3 = rectangle2D.getX() - this.plotProcessBounds.getX();
        Rectangle2D.Double double_ = new Rectangle2D.Double(-this.axisLabelWidth - d3, 0.0, this.axisLabelWidth, rectangle2D.getHeight());
        Point2D.Double double_2 = !this.hasAxisReversed() ? new Point2D.Double(this.axisLabelWidth, rectangle2D.getHeight()) : new Point2D.Double(this.axisLabelWidth, 0.0);
        this.setAttr(double_, double_2, d, d2);
    }

    public void drawAlertValueGlyph(Graphics2D graphics2D, int n) {
        for (ChartAlertValueGlyph chartAlertValueGlyph : this.alertValues) {
            chartAlertValueGlyph.dealWithAlertLine();
            chartAlertValueGlyph.draw((Graphics)graphics2D, n);
        }
    }

    protected void drawIntervalBackground(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.getDefaultIntervalBackgroundColor() != null) {
            Paint paint = graphics2D.getPaint();
            graphics2D.setColor(this.getDefaultIntervalBackgroundColor());
            if (this.isLog()) {
                this.drawDefaultIntervalBackgroundWithLog(graphics2D);
            } else {
                this.drawDefaultIntervalBackgroundWithGeneral(graphics2D);
            }
            graphics2D.setPaint(paint);
        } else {
            this.drawCustomBackground(graphics2D);
        }
    }

    private void drawDefaultIntervalBackgroundWithLog(Graphics2D graphics2D) {
        if (this.getMainUnit() > 1.0) {
            double d = this.getCrossValue();
            double d2 = Math.log(d) / Math.log(this.getMainUnit());
            double d3 = Math.log(this.maxValue) / Math.log(this.getMainUnit()) - Math.log(this.minValue) / Math.log(this.getMainUnit());
            if (d3 / 2.0 == Math.ceil(d3 / 2.0)) {
                d = Math.pow(this.getMainUnit(), d2 += 1.0);
            }
            while (d <= this.maxValue) {
                double d4 = d;
                d = Math.exp((d2 += 1.0) * Math.log(this.getMainUnit()));
                if (d > this.maxValue + 1.0E-10) {
                    d = this.maxValue;
                }
                this.drawDefaultIntervalBackgroundWithValue(graphics2D, d4, d);
                d = Math.exp((d2 += 1.0) * Math.log(this.getMainUnit()));
            }
        }
    }

    private void drawDefaultIntervalBackgroundWithGeneral(Graphics2D graphics2D) {
        BigDecimal bigDecimal = new BigDecimal(Double.toString(this.minValue));
        BigDecimal bigDecimal2 = new BigDecimal(Double.toString(this.getMainUnit() * (double)this.getTickSamplingTime()));
        BigDecimal bigDecimal3 = new BigDecimal(Double.toString(this.maxValue));
        double d = Math.ceil(bigDecimal3.subtract(bigDecimal).divide(bigDecimal2).doubleValue());
        if (d / 2.0 == Math.ceil(d / 2.0)) {
            bigDecimal = bigDecimal.add(bigDecimal2);
        }
        while (bigDecimal.compareTo(bigDecimal3) <= 0) {
            double d2 = bigDecimal.doubleValue();
            if ((bigDecimal = bigDecimal.add(bigDecimal2)).compareTo(bigDecimal3) > 0) {
                bigDecimal = bigDecimal3;
            }
            this.drawDefaultIntervalBackgroundWithValue(graphics2D, d2, bigDecimal.doubleValue());
            bigDecimal = bigDecimal.add(bigDecimal2);
        }
    }

    private void drawDefaultIntervalBackgroundWithValue(Graphics2D graphics2D, double d, double d2) {
        Shape shape = this.getCustomBackgroundShape(d, d2, false);
        graphics2D.fill(shape);
    }

    private void drawCustomBackground(Graphics2D graphics2D) {
        if (this.customIntervalBackgroundArray == null || this.customIntervalBackgroundArray.isEmpty()) {
            return;
        }
        Paint paint = graphics2D.getPaint();
        Composite composite = graphics2D.getComposite();
        for (VanChartCustomIntervalBackground vanChartCustomIntervalBackground : this.customIntervalBackgroundArray) {
            double d = 0.0;
            double d2 = 0.0;
            if (vanChartCustomIntervalBackground.getFromFormula() != null && vanChartCustomIntervalBackground.getToFormula() != null) {
                d = this.getObjectValue(this.getObjectFromFormula(vanChartCustomIntervalBackground.getFromFormula()));
                d2 = this.getObjectValue(this.getObjectFromFormula(vanChartCustomIntervalBackground.getToFormula()));
            }
            Shape shape = this.getCustomBackgroundShape(d, d2);
            graphics2D.setColor(vanChartCustomIntervalBackground.getBackgroundColor());
            graphics2D.setComposite(AlphaComposite.getInstance(3, (float)vanChartCustomIntervalBackground.getAlpha()));
            graphics2D.fill(shape);
        }
        graphics2D.setPaint(paint);
        graphics2D.setComposite(composite);
    }

    public Object getObjectFromFormula(Formula formula) {
        if (formula == null) {
            return null;
        }
        if (formula.getResult() == null) {
            String string = formula.getContent();
            if (string.startsWith("=")) {
                string = string.substring(1);
            }
            return string;
        }
        return formula.getResult();
    }

    private Shape getCustomBackgroundShape(double d, double d2) {
        return this.getCustomBackgroundShape(d, d2, true);
    }

    protected Shape getCustomBackgroundShape(double d, double d2, boolean bl) {
        boolean bl2;
        Point2D point2D = this.getPointInBounds(d);
        Point2D point2D2 = this.getPointInBounds(d2);
        if (this.isXAxis) {
            boolean bl3;
            double d3 = Math.min(point2D2.getX(), point2D.getX());
            double d4 = Math.abs(point2D2.getX() - point2D.getX());
            boolean bl4 = bl3 = this.getPosition() == 1;
            if (this.isDrawBetweenTick() && bl) {
                d4 += this.getUnitLen();
            }
            double d5 = bl3 ? point2D.getY() : point2D.getY() - this.getAxisGridLength();
            return new Rectangle2D.Double(d3, d5, d4, this.getAxisGridLength());
        }
        double d6 = Math.min(point2D.getY(), point2D2.getY());
        double d7 = Math.abs(point2D2.getY() - point2D.getY());
        boolean bl5 = bl2 = this.getPosition() == 4;
        if (this.isDrawBetweenTick() && bl) {
            d6 -= this.getUnitLen();
            d7 += this.getUnitLen();
        }
        double d8 = bl2 ? point2D.getX() - this.getAxisGridLength() : point2D.getX();
        return new Rectangle2D.Double(d8, d6, this.getAxisGridLength(), d7);
    }

    public Point2D getAlertValuePoint(Object object) {
        return this.getPointInBounds(this.getObjectValue(object));
    }

    public Point2D getValuePoint(Object object) {
        return this.getPointInBounds(this.getObjectValue(object));
    }

    public double getObjectValue(Object object) {
        return 0.0;
    }

    protected void drawAfterPlot4AlertValues(Graphics2D graphics2D, int n) {
    }

    protected boolean isRevertAndArrow() {
        return false;
    }

    protected Line2D getTickLine(double d, int n, AxisTickLineType axisTickLineType) {
        Point2D point2D = this.getPoint2D(d);
        return this.getTickLineByCenterPoint(point2D, n, axisTickLineType);
    }

    protected Line2D getTickLineByCenterPoint(Point2D point2D, int n, AxisTickLineType axisTickLineType) {
        Point2D.Double double_ = new Point2D.Double(point2D.getX() - (double)n, point2D.getY());
        Point2D.Double double_2 = new Point2D.Double(point2D.getX() + (double)n, point2D.getY());
        Point2D.Double double_3 = new Point2D.Double(point2D.getX(), point2D.getY() - (double)n);
        Point2D.Double double_4 = new Point2D.Double(point2D.getX(), point2D.getY() + (double)n);
        if (ComparatorUtils.equals((Object)((Object)axisTickLineType), (Object)((Object)AxisTickLineType.TICK_LINE_OUTSIDE))) {
            if (this.getPosition() == 2) {
                return new Line2D.Double(point2D, double_);
            }
            if (this.getPosition() == 1) {
                return new Line2D.Double(point2D, double_3);
            }
            if (this.getPosition() == 4) {
                return new Line2D.Double(point2D, double_2);
            }
            return this.getOtherPositionTickLine(point2D, double_4, double_);
        }
        return null;
    }

    protected double getTickLengthShow() {
        return Math.max(this.getTickLength4Type(this.getMainTickLine(), 5), this.getTickLength4Type(this.getSecTickLine(), 3));
    }

    private double getTickLength4Type(AxisTickLineType axisTickLineType, int n) {
        switch (axisTickLineType) {
            case TICK_LINE_OUTSIDE: {
                return n;
            }
        }
        return 0.0;
    }

    protected void drawAxisLine(Graphics graphics, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        Stroke stroke = graphics2D.getStroke();
        int n2 = this.getLineStyle();
        if (this.getLineColor() != null && n2 != 0) {
            graphics2D.setStroke(GraphHelper.getStroke((int)n2));
            graphics2D.setPaint(this.lineColor);
            Line2D.Double double_ = new Line2D.Double(this.getPoint2D(this.getMinValue()), this.getPoint2D(this.getMaxTickValue()));
            graphics2D.draw(double_);
            this.drawArrow(graphics2D, this.axisReversed ? double_.getP2() : double_.getP1(), this.axisReversed ? double_.getP1() : double_.getP2());
        }
        this.drawTicks(graphics2D, n);
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
    }

    protected double getMaxTickValue() {
        return this.getMaxValue();
    }

    protected boolean shouldDrawTickLine(Line2D line2D) {
        return line2D != null && this.lineColor != null;
    }

    protected void drawAxisTitle(Graphics graphics, int n) {
        if (this.titleGlyph != null) {
            Rectangle2D rectangle2D = this.calculatorTitleBounds(n);
            this.titleGlyph.getTextAttr().setRotation(-this.titleGlyph.getTextAttr().getRotation());
            GlyphUtils.drawStrings((Graphics)graphics, (String)this.titleGlyph.getText(), (TextAttr)this.titleGlyph.getTextAttr(), (Rectangle2D)rectangle2D, (int)n);
            this.titleGlyph.getTextAttr().setRotation(-this.titleGlyph.getTextAttr().getRotation());
        }
    }

    protected void drawLabel(Graphics graphics, double d, double d2, String string, int n) {
        this.textAttr.setRotation(-this.textAttr.getRotation());
        super.drawLabel(graphics, d, d2, string, n);
        this.textAttr.setRotation(-this.textAttr.getRotation());
    }

    protected void drawLabel(Graphics graphics, double d, double d2, String string, GeneralPath generalPath, int n) {
        this.textAttr.setRotation(-this.textAttr.getRotation());
        super.drawLabel(graphics, d, d2, string, generalPath, n);
        this.textAttr.setRotation(-this.textAttr.getRotation());
    }

    protected void setMinMaxTickInterval(double d, double d2, double d3) {
        this.setMinValue(d);
        this.setMaxValue(d2);
        this.setMainUnit(new BigDecimal(d3));
    }

    protected void calculateValueTimeNiceDomain(boolean bl, boolean bl2, double d, double d2) {
        double d3 = this.getDefaultTickCount();
        boolean bl3 = bl2;
        if (bl) {
            bl3 = bl3 && d <= 0.0;
            d = Math.min(0.0, d);
        }
        d = this.isCustomMinValue ? this.getMinValue() : d;
        double d4 = d2 = this.isCustomMaxValue ? this.getMaxValue() : d2;
        if (d >= d2) {
            d = bl ? Math.min(0.0, d2) : d2;
            d2 = d + 100.0;
        }
        double d5 = this.isCustomMainUnit() ? this.getTickInterval(bl) : this.linearTickInterval(d, d2, d3);
        double[] dArray = this.linearNiceDomain(d, d2, d5, bl2, bl3);
        this.setNiceMinValue(dArray[0]);
        this.setNiceMaxValue(dArray[1]);
        d = this.isCustomMinValue ? this.getMinValue() : dArray[0];
        double d6 = d2 = this.isCustomMaxValue ? this.getMaxValue() : dArray[1];
        if (d >= d2) {
            d = bl ? Math.min(0.0, d2) : d2;
            d2 = d + 100.0;
        }
        this.setMinMaxTickInterval(d, d2, d5);
    }

    private double getTickInterval(boolean bl) {
        if (bl) {
            return this.getMainUnit();
        }
        long l = VanChartAttrHelper.getTimeTypeSecond(((VanChartTimeAxisGlyph)this).getMainType());
        return this.getMainUnit() * (double)l;
    }

    private double linearTickInterval(double d, double d2, double d3) {
        double d4;
        double d5;
        double d6;
        if (d3 == 0.0) {
            d3 = 10.0;
        }
        if ((d6 = d3 / (d5 = d2 - d) * (d4 = Math.pow(10.0, Math.floor(Math.log(d5 / d3) / Math.log(10.0))))) <= 0.15) {
            d4 *= 10.0;
        } else if (d6 <= 0.35) {
            d4 *= 5.0;
        } else if (d6 <= 0.75) {
            d4 *= 2.0;
        }
        return d4;
    }

    private double[] linearNiceDomain(double d, double d2, double d3, boolean bl, boolean bl2) {
        d = Math.floor(d / d3) * d3;
        d2 = Math.ceil(d2 / d3) * d3;
        return new double[]{d, d2};
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("type", (Object)this.vanAxisType.getAxisType());
        if (this.position == 5) {
            jSONObject.put("onZero", true);
        } else {
            jSONObject.put("position", (Object)ChartUtils.getPositionString((int)this.position));
        }
        if (this.isLimitSize()) {
            jSONObject.put(this.isXAxis ? "maxHeight" : "maxWidth", (Object)(this.getMaxHeight() + "%"));
        }
        String string = StableUtils.javaColorToCSSColor((Color)this.lineColor);
        jSONObject.put("lineColor", (Object)string);
        jSONObject.put("lineWidth", VanChartAttrHelper.getAxisLineStyle(this.lineStyle));
        jSONObject.put("showArrow", this.isArrowShow);
        jSONObject.put("enableTick", ComparatorUtils.equals((Object)((Object)this.getMainTickLine()), (Object)((Object)AxisTickLineType.TICK_LINE_OUTSIDE)));
        jSONObject.put("enableMinorTick", ComparatorUtils.equals((Object)((Object)this.getSecTickLine()), (Object)((Object)AxisTickLineType.TICK_LINE_OUTSIDE)));
        jSONObject.put("tickColor", (Object)string);
        jSONObject.put("minorTickColor", (Object)string);
        if (this.getMainGridColor() == null) {
            jSONObject.put("gridLineWidth", 0);
        } else {
            jSONObject.put("gridLineColor", (Object)StableUtils.javaColorToCSSColor((Color)this.getMainGridColor()));
            jSONObject.put("gridLineWidth", 1);
        }
        jSONObject.put("reversed", this.axisReversed);
        this.addValueFormat(jSONObject, repository);
        this.addAxisLabelJSON(jSONObject, repository);
        this.addAxisTitleJSON(jSONObject, repository);
        this.addAlertJSON(jSONObject, repository);
        this.addIntervalBackgroundJSON(jSONObject, repository);
        this.addMinMaxValue(jSONObject, repository);
        return jSONObject;
    }

    protected void addMinMaxValue(JSONObject jSONObject, Repository repository) throws JSONException {
        if (this.isCustomMaxValue) {
            jSONObject.put("max", this.getMaxValue());
        }
        if (this.isCustomMinValue) {
            jSONObject.put("min", this.getMinValue());
        }
        if (this.isCustomMainUnit()) {
            jSONObject.put("tickInterval", this.getMainUnit());
        }
        if (this.isCustomSecUnit()) {
            jSONObject.put("minorTickInterval", this.getSecUnit());
        }
    }

    protected void addValueFormat(JSONObject jSONObject, Repository repository) throws JSONException {
        if (this.isCommonValueFormat()) {
            jSONObject.put("formatter", (Object)VanChartAttrHelper.getFormatFunction(this.getFormat()));
        } else if (this.htmlLabel != null) {
            this.htmlLabel.addToJSONObject(jSONObject);
        }
    }

    protected void addAxisLabelJSON(JSONObject jSONObject, Repository repository) throws JSONException {
        if (this.isShowAxisLabel) {
            jSONObject.put("showLabel", true);
            jSONObject.put("labelStyle", (Object)VanChartAttrHelper.getCSSFontJSONWithFont(this.textAttr.getFRFont()));
            jSONObject.put("labelRotation", this.textAttr.getRotation());
            if (!this.isAutoLabelGap()) {
                jSONObject.put("step", this.getLabelNumber());
            }
        } else {
            jSONObject.put("showLabel", false);
            jSONObject.put("labelStyle", (Object)VanChartAttrHelper.getCSSFontJSONWithFont(this.textAttr.getFRFont()));
        }
    }

    private void addAxisTitleJSON(JSONObject jSONObject, Repository repository) throws JSONException {
        if (this.titleGlyph != null && !this.titleGlyph.getText().isEmpty()) {
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("useHtml", this.titleUseHtml);
            jSONObject2.put("text", (Object)this.titleGlyph.getText());
            jSONObject2.put("style", (Object)VanChartAttrHelper.getCSSFontJSONWithFont(this.titleGlyph.getTextAttr().getFRFont()));
            jSONObject2.put("align", (Object)ChartUtils.getPositionString((int)this.titleGlyph.getPosition()));
            jSONObject2.put("rotation", this.titleGlyph.getTextAttr().getRotation());
            jSONObject.put("title", (Object)jSONObject2);
        }
    }

    private void addAlertJSON(JSONObject jSONObject, Repository repository) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (ChartAlertValueGlyph chartAlertValueGlyph : this.alertValues) {
            jSONArray.put((Object)chartAlertValueGlyph.toJSONObject(repository));
        }
        jSONObject.put("plotLines", (Object)jSONArray);
    }

    private void addIntervalBackgroundJSON(JSONObject jSONObject, Repository repository) throws JSONException {
        if (this.defaultIntervalBackgroundColor != null) {
            jSONObject.put("plotBands", (Object)StableUtils.javaColor2JSColorWithAlpha((Color)this.defaultIntervalBackgroundColor));
        } else {
            JSONArray jSONArray = new JSONArray();
            for (VanChartCustomIntervalBackground vanChartCustomIntervalBackground : this.customIntervalBackgroundArray) {
                jSONArray.put((Object)vanChartCustomIntervalBackground.toJSONObject(repository));
            }
            jSONObject.put("plotBands", (Object)jSONArray);
        }
    }
}

