/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.glyph;

import com.fr.base.background.ColorBackground;
import com.fr.chart.base.AttrAlpha;
import com.fr.chart.base.AttrBackground;
import com.fr.chart.base.ChartConstants;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.FoldLine;
import com.fr.data.condition.CommonCondition;
import com.fr.data.core.Compare;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.plugin.chart.attr.AttrBand;
import com.fr.plugin.chart.attr.VanChartAttrHelper;
import com.fr.plugin.chart.base.AttrAreaSeriesFillColorBackground;
import com.fr.plugin.chart.base.AttrSeriesStackAndAxis;
import com.fr.plugin.chart.base.VanChartAttrLine;
import com.fr.plugin.chart.base.VanChartAttrMarker;
import com.fr.plugin.chart.base.VanChartAttrTrendLine;
import com.fr.plugin.chart.bubble.attr.VanChartAttrBubble;
import com.fr.plugin.chart.glyph.VanChartBandGlyph;
import com.fr.plugin.chart.glyph.VanChartDataPoint;
import com.fr.stable.ArrayUtils;
import com.fr.stable.web.Repository;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class VanChartDataSeries
extends DataSeries {
    private static final long serialVersionUID = 2578466024949051678L;
    private VanChartAttrLine attrLine;
    private AttrBackground color;
    private AttrAlpha alpha;
    private VanChartAttrMarker marker;
    private AttrAreaSeriesFillColorBackground fillColorBackground;
    private AttrSeriesStackAndAxis attrSeriesStackAndAxis;
    private VanChartAttrTrendLine attrTrendLine;
    private List<AttrBand> bands = new ArrayList<AttrBand>();
    private List<VanChartBandGlyph> bandGlyphs = new ArrayList<VanChartBandGlyph>();
    private VanChartAttrBubble attrBubble;
    private boolean evalValue = false;
    private FoldLine areaTopLine = null;

    public void setAreaTopLine(FoldLine foldLine) {
        this.areaTopLine = foldLine;
    }

    public void setAttrTrendLine(VanChartAttrTrendLine vanChartAttrTrendLine) {
        this.attrTrendLine = vanChartAttrTrendLine;
    }

    public void setAttrSeriesStackAndAxis(AttrSeriesStackAndAxis attrSeriesStackAndAxis) {
        this.attrSeriesStackAndAxis = attrSeriesStackAndAxis;
    }

    public AttrSeriesStackAndAxis getAttrSeriesStackAndAxis() {
        return this.attrSeriesStackAndAxis;
    }

    public void setAttrLine(VanChartAttrLine vanChartAttrLine) {
        this.attrLine = vanChartAttrLine;
    }

    public void setColor(AttrBackground attrBackground) {
        this.color = attrBackground;
    }

    public void setAlpha(AttrAlpha attrAlpha) {
        this.alpha = attrAlpha;
    }

    public void setMarker(VanChartAttrMarker vanChartAttrMarker) {
        this.marker = vanChartAttrMarker;
    }

    public AttrBackground getColor() {
        return this.color;
    }

    public void setAttrBubble(VanChartAttrBubble vanChartAttrBubble) {
        this.attrBubble = vanChartAttrBubble;
    }

    public VanChartAttrBubble getAttrBubble() {
        return this.attrBubble;
    }

    public void setFillColorBackground(AttrAreaSeriesFillColorBackground attrAreaSeriesFillColorBackground) {
        this.fillColorBackground = attrAreaSeriesFillColorBackground;
    }

    public AttrAreaSeriesFillColorBackground getFillColorBackground() {
        return this.fillColorBackground;
    }

    public VanChartAttrLine getAttrLine() {
        return this.attrLine;
    }

    public VanChartAttrMarker getMarker() {
        return this.marker;
    }

    public VanChartAttrTrendLine getAttrTrendLine() {
        return this.attrTrendLine;
    }

    public AttrAlpha getAlpha() {
        return this.alpha;
    }

    public void addAttrBands(AttrBand attrBand) {
        this.bands.add(attrBand);
    }

    public void addBandGlyph(VanChartBandGlyph vanChartBandGlyph) {
        this.bandGlyphs.add(vanChartBandGlyph);
    }

    public List<AttrBand> getBands() {
        return this.bands;
    }

    public void setEvalValue(boolean bl) {
        this.evalValue = bl;
    }

    public void initBandsDefaultMinMaxValue(double d, double d2) {
        if (this.bands == null || this.bands.size() < 1) {
            return;
        }
        for (AttrBand attrBand : this.bands) {
            attrBand.setMaxEval(d);
            attrBand.setMinEval(d2);
        }
    }

    public VanChartDataSeries(int n) {
        super(n);
    }

    public void draw(Graphics graphics, int n) {
        Rectangle rectangle = graphics.getClipBounds();
        List<Rectangle2D> list = this.getDataSeriesRecs(rectangle);
        if (list.isEmpty()) {
            this.drawImplAndAreaTopLine(graphics, n);
        } else {
            for (Rectangle2D object : list) {
                Shape shape = graphics.getClip();
                graphics.clipRect((int)object.getX(), (int)object.getY(), (int)object.getWidth(), (int)object.getHeight());
                this.drawImplAndAreaTopLine(graphics, n);
                graphics.setClip(shape);
            }
        }
        for (VanChartBandGlyph vanChartBandGlyph : this.bandGlyphs) {
            vanChartBandGlyph.draw(graphics, n);
        }
        int n2 = this.getDataPointCount();
        for (int i = 0; i < n2; ++i) {
            this.getDataPoint(i).draw(graphics, n);
        }
    }

    private void drawImplAndAreaTopLine(Graphics graphics, int n) {
        if (this.drawImpl != null) {
            this.drawImpl.draw(graphics, n);
        }
        if (this.areaTopLine != null) {
            this.areaTopLine.draw(graphics, n);
        }
    }

    private List<Rectangle2D> getDataSeriesRecs(Rectangle2D rectangle2D) {
        ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
        List<VanChartBandGlyph> list = this.dealBandsBoundsList();
        if (list.isEmpty()) {
            return arrayList;
        }
        double[] dArray = this.sortY(list);
        double d = rectangle2D.getWidth();
        double d2 = rectangle2D.getX();
        double d3 = rectangle2D.getMinY();
        double d4 = rectangle2D.getMaxY();
        int n = dArray.length;
        arrayList.add(new Rectangle2D.Double(d2, d3, d, dArray[0] - d3));
        arrayList.add(new Rectangle2D.Double(d2, dArray[n - 1], d, d4 - dArray[n - 1]));
        for (int i = 1; i < n - 1; i += 2) {
            double d5 = dArray[i];
            double d6 = dArray[i + 1];
            arrayList.add(new Rectangle2D.Double(d2, d5, d, d6 - d5));
        }
        return arrayList;
    }

    private List<VanChartBandGlyph> dealBandsBoundsList() {
        ArrayList<VanChartBandGlyph> arrayList = new ArrayList<VanChartBandGlyph>();
        for (VanChartBandGlyph vanChartBandGlyph : this.bandGlyphs) {
            if (vanChartBandGlyph.getAreaGlyph() == null) continue;
            Rectangle2D rectangle2D = vanChartBandGlyph.getClipBounds();
            double d = rectangle2D.getMinY();
            double d2 = rectangle2D.getMaxY();
            ArrayList<VanChartBandGlyph> arrayList2 = new ArrayList<VanChartBandGlyph>();
            for (VanChartBandGlyph vanChartBandGlyph2 : arrayList) {
                Rectangle2D.Double double_;
                Rectangle2D rectangle2D2 = vanChartBandGlyph2.getClipBounds();
                double d3 = rectangle2D2.getMinY();
                double d4 = rectangle2D2.getMaxY();
                if (d < d3) {
                    if (d2 <= d3) continue;
                    if (d2 < d4) {
                        double_ = new Rectangle2D.Double(rectangle2D2.getX(), d2, rectangle2D2.getWidth(), d4 - d2);
                        vanChartBandGlyph2.setClipBounds(double_);
                        continue;
                    }
                    vanChartBandGlyph2.setAreaGlyph(null);
                    arrayList2.add(vanChartBandGlyph2);
                    continue;
                }
                if (d == d3) {
                    if (d2 < d4) {
                        double_ = new Rectangle2D.Double(rectangle2D2.getX(), d2, rectangle2D2.getWidth(), d4 - d2);
                        vanChartBandGlyph2.setClipBounds(double_);
                        continue;
                    }
                    if (!(d2 >= d4)) continue;
                    vanChartBandGlyph2.setAreaGlyph(null);
                    arrayList2.add(vanChartBandGlyph2);
                    continue;
                }
                if (!(d < d4)) continue;
                if (d2 < d4) {
                    vanChartBandGlyph.setAreaGlyph(null);
                    arrayList2.add(vanChartBandGlyph);
                    break;
                }
                double_ = new Rectangle2D.Double(rectangle2D2.getX(), d3, rectangle2D2.getWidth(), d);
                vanChartBandGlyph2.setClipBounds(double_);
            }
            arrayList.add(vanChartBandGlyph);
            for (VanChartBandGlyph vanChartBandGlyph2 : arrayList2) {
                arrayList.remove((Object)vanChartBandGlyph2);
            }
        }
        return arrayList;
    }

    protected double[] sortY(List<VanChartBandGlyph> list) {
        int n;
        int n2 = list.size();
        double[] dArray = new double[n2 * 2];
        for (n = 0; n < n2; ++n) {
            Rectangle2D rectangle2D = list.get(n).getClipBounds();
            dArray[2 * n] = rectangle2D.getMinY();
            dArray[2 * n + 1] = rectangle2D.getMaxY();
        }
        int n3 = n2 * 2 - 1;
        for (n = 0; n < n3; ++n) {
            double d;
            int n4;
            for (n4 = n; n4 < n3; ++n4) {
                if (!(dArray[n4] > dArray[n4 + 1])) continue;
                d = dArray[n4];
                dArray[n4] = dArray[n4 + 1];
                dArray[n4 + 1] = d;
            }
            for (n4 = --n3; n4 > n; --n4) {
                if (!(dArray[n4] < dArray[n4 - 1])) continue;
                d = dArray[n4];
                dArray[n4] = dArray[n4 - 1];
                dArray[n4 - 1] = d;
            }
        }
        return dArray;
    }

    public Object toResult(CommonCondition commonCondition) {
        boolean bl;
        String string = commonCondition.getColumnName();
        boolean bl2 = bl = ComparatorUtils.equals((Object)string, (Object)ChartConstants.VALUE) || ArrayUtils.contains((Object[])ChartConstants.PROJECT_ID_KEYS, (Object)string);
        if (this.evalValue && bl) {
            Compare compare = commonCondition.getCompare();
            if (compare.getOp() == 4 || compare.getOp() == 5) {
                return Double.MIN_VALUE;
            }
            if (compare.getOp() == 2 || compare.getOp() == 3) {
                return Double.MAX_VALUE;
            }
        }
        return super.toResult(commonCondition);
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        ColorBackground colorBackground;
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("name", (Object)this.getSeriesName());
        int n = this.getDataPointCount();
        if (n <= 0) {
            return jSONObject;
        }
        this.addDataJSON(jSONObject, repository, n);
        if (this.attrSeriesStackAndAxis != null) {
            jSONObject.put("xAxis", this.attrSeriesStackAndAxis.getXAxisIndex());
            jSONObject.put("yAxis", this.attrSeriesStackAndAxis.getYAxisIndex());
            if (this.attrSeriesStackAndAxis.isStacked()) {
                jSONObject.put("stack", (Object)this.attrSeriesStackAndAxis.getStackID());
                jSONObject.put("stackByPercent", this.attrSeriesStackAndAxis.isPercentStacked());
            }
        }
        if (this.attrTrendLine != null) {
            jSONObject.put("trendLine", (Object)this.attrTrendLine.toJSONObject(repository));
        }
        if (this.attrLine != null) {
            this.attrLine.addToJSONObject(jSONObject);
        }
        Color color = ((VanChartDataPoint)this.getDataPoint(0)).getDefaultColor();
        if (this.color != null) {
            colorBackground = (ColorBackground)this.color.getSeriesBackground();
            color = colorBackground.getColor();
        }
        if (this.bands != null && !this.bands.isEmpty()) {
            colorBackground = new JSONArray();
            for (AttrBand attrBand : this.bands) {
                colorBackground.put((Object)attrBand.toJSONObject(repository, color));
            }
            jSONObject.put("bands", (Object)colorBackground);
        }
        this.addColorAndAlphaJSON(jSONObject, color, n);
        if (this.marker != null) {
            jSONObject.put("marker", (Object)this.marker.toJSONObject(repository));
        }
        if (this.fillColorBackground != null) {
            this.fillColorBackground.addToJSONObject(jSONObject, color);
        }
        if (this.attrBubble != null) {
            this.attrBubble.toJSONObject(jSONObject, repository);
        }
        return jSONObject;
    }

    protected void addColorAndAlphaJSON(JSONObject jSONObject, Color color, int n) throws JSONException {
        if (this.color != null) {
            float f = this.alpha == null ? 1.0f : this.alpha.getAlpha();
            jSONObject.put("color", (Object)VanChartAttrHelper.getRGBAColorWithColorAndAlpha(color, f));
        } else if (this.alpha != null && n > 0 && ((VanChartDataPoint)this.getDataPoint(0)).getDefaultColor() != null) {
            jSONObject.put("color", (Object)VanChartAttrHelper.getRGBAColorWithColorAndAlpha(color, this.alpha.getAlpha()));
        }
    }

    private void addDataJSON(JSONObject jSONObject, Repository repository, int n) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (int i = 0; i < n; ++i) {
            jSONArray.put((Object)this.getDataPoint(i).toJSONObject(repository));
        }
        jSONObject.put("data", (Object)jSONArray);
    }
}

