/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.gauge.glyph;

import com.fr.chart.base.AreaColor;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.SpecialGlyph;
import com.fr.plugin.chart.attr.VanChartAttrHelper;
import com.fr.plugin.chart.base.AttrLabel;
import com.fr.plugin.chart.base.AttrLabelDetail;
import com.fr.plugin.chart.gauge.GaugeDetailStyle;
import com.fr.plugin.chart.gauge.glyph.GaugeGlyphHelper;
import com.fr.plugin.chart.glyph.axis.VanChartGaugeAxisGlyph;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public abstract class GaugeGlyph
extends SpecialGlyph {
    private static final long serialVersionUID = -6454068778509007571L;
    public static final int DEFAULT_COLOR_NUMBER = 3;
    public static final int CATEGORY_LABEL_GAP = 20;
    protected static final int GAP = 5;
    protected static final double PIE = 180.0;
    private static final int START_ANGLE = 90;
    private static final int EXTENT = 360;
    protected Rectangle2D bounds;
    protected Point2D centerPoint;
    protected double radius;
    protected int startAngle;
    protected int extent;
    protected AttrLabel attrLabel;
    protected GaugeDetailStyle gaugeDetailStyle;
    protected VanChartGaugeAxisGlyph gaugeAxisGlyph;
    protected Color[] defaultColors = new Color[3];
    protected List colorList = new ArrayList();
    protected String cateOrPercentLabelString;
    protected String valueLabelString;
    protected List<Number> valueList = new ArrayList<Number>();

    public void setDefaultColors(Color[] colorArray) {
        this.defaultColors = colorArray;
    }

    public void setColorList(List list) {
        this.colorList = list;
    }

    public void setCateOrPercentLabelString(DataPoint dataPoint) {
        this.cateOrPercentLabelString = this.getCateOrPercentLabelWithDataPoint(dataPoint);
    }

    public void setValueLabelString(String string) {
        this.valueLabelString = string;
    }

    public void addValue(Double d) {
        this.valueList.add(d);
    }

    public GaugeGlyph(Rectangle2D rectangle2D, AttrLabel attrLabel, GaugeDetailStyle gaugeDetailStyle, VanChartGaugeAxisGlyph vanChartGaugeAxisGlyph) {
        this.bounds = rectangle2D;
        this.attrLabel = attrLabel;
        this.gaugeDetailStyle = gaugeDetailStyle;
        this.gaugeAxisGlyph = vanChartGaugeAxisGlyph;
    }

    public void doLayout(double d, int n) {
        this.initStartAngleAndExtent();
        this.calculateRadiusAndCenterPoint(this.bounds.getWidth(), this.bounds.getHeight(), d);
    }

    protected void initStartAngleAndExtent() {
        this.startAngle = 90;
        this.extent = 360;
    }

    protected void calculateRadiusAndCenterPoint(double d, double d2, double d3) {
        this.radius = Math.min(d, d2) / 2.0;
        this.radius = this.radius > 5.0 ? this.radius - 5.0 : this.radius;
        this.centerPoint = new Point2D.Double(d / 2.0, d2 / 2.0);
    }

    public void draw(Graphics graphics, int n) {
        if (this.radius <= 0.0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.bounds.getX(), this.bounds.getY());
        Paint paint = graphics2D.getPaint();
        Stroke stroke = graphics2D.getStroke();
        this.drawInfo(graphics2D, n);
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        graphics2D.translate(-this.bounds.getX(), -this.bounds.getY());
    }

    protected abstract void drawInfo(Graphics2D var1, int var2);

    protected void drawPaneBackground(Graphics2D graphics2D) {
        GaugeGlyphHelper.drawCircle(graphics2D, this.centerPoint, this.radius, this.gaugeDetailStyle.getPaneBackgroundColor());
    }

    protected void drawCateOrPercentageLabel(Graphics2D graphics2D, int n) {
        if (this.attrLabel != null && this.attrLabel.isEnable()) {
            AttrLabelDetail attrLabelDetail = this.attrLabel.getAttrLabelDetail();
            if (!attrLabelDetail.isCustom()) {
                this.setCateOrPercentLabelAutoFont(attrLabelDetail.getTextAttr());
            }
            Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation((String)this.cateOrPercentLabelString, (TextAttr)attrLabelDetail.getTextAttr(), (int)n);
            Rectangle2D rectangle2D = this.getCateOrPercentLabelBounds(attrLabelDetail.getPosition(), dimension2D);
            GlyphUtils.drawStrings((Graphics)graphics2D, (String)this.cateOrPercentLabelString, (TextAttr)attrLabelDetail.getTextAttr(), (Rectangle2D)rectangle2D, (int)n);
        }
    }

    protected void setCateOrPercentLabelAutoFont(TextAttr textAttr) {
    }

    protected Rectangle2D getCateOrPercentLabelBounds(int n, Dimension2D dimension2D) {
        double d = this.centerPoint.getX() - dimension2D.getWidth() / 2.0;
        double d2 = n == 3 ? this.centerPoint.getY() + this.radius + 20.0 : this.centerPoint.getY() - this.radius - 20.0;
        return new Rectangle2D.Double(d, d2, dimension2D.getWidth(), dimension2D.getHeight());
    }

    protected void drawValueLabel(Graphics2D graphics2D, int n) {
        if (this.attrLabel != null && this.attrLabel.isEnable()) {
            AttrLabelDetail attrLabelDetail = this.attrLabel.getGaugeValueLabelDetail();
            TextAttr textAttr = attrLabelDetail.getTextAttr();
            Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation((String)this.valueLabelString, (TextAttr)textAttr, (int)n);
            Rectangle2D rectangle2D = this.getValueLabelBounds(attrLabelDetail.getPosition(), dimension2D);
            GaugeGlyphHelper.drawStrings(graphics2D, this.valueLabelString, textAttr, rectangle2D, n);
        }
    }

    protected Rectangle2D getValueLabelBounds(int n, Dimension2D dimension2D) {
        double d = this.centerPoint.getX() - dimension2D.getWidth() / 2.0;
        double d2 = this.centerPoint.getY() + (this.radius - dimension2D.getHeight()) / 2.0;
        return new Rectangle2D.Double(d, d2, dimension2D.getWidth(), dimension2D.getHeight());
    }

    protected Color getValueColor(double d, double d2, double d3) {
        for (Object e : this.colorList) {
            boolean bl;
            AreaColor areaColor = (AreaColor)e;
            double d4 = areaColor.getMinNum();
            double d5 = areaColor.getMaxNum();
            boolean bl2 = d >= d4 && d <= d5;
            boolean bl3 = bl = d <= d4 && d >= d5;
            if (!bl2 && !bl) continue;
            return areaColor.getAreaColor();
        }
        return this.getDefaultValueColor(d, d2, d3);
    }

    protected Color getDefaultValueColor(double d, double d2, double d3) {
        if (d >= d3) {
            return this.defaultColors[2];
        }
        if (d <= d2) {
            return this.defaultColors[0];
        }
        double d4 = (d3 - d2) / 3.0;
        for (int i = 0; i < 3; ++i) {
            double d5 = d2 + d4 * (double)i;
            double d6 = d2 + d4 * (double)(i + 1);
            if (!(d >= d5) || !(d <= d6)) continue;
            return this.defaultColors[i];
        }
        return this.defaultColors[0];
    }

    public String getCateOrPercentLabelWithDataPoint(DataPoint dataPoint) {
        return VanChartAttrHelper.getPercent(this.attrLabel.getAttrLabelDetail().getContent(), dataPoint);
    }

    public String getValueLabelWithDataPoint(DataPoint dataPoint) {
        return VanChartAttrHelper.getCateAndValue(this.attrLabel.getGaugeValueLabelDetail().getContent(), dataPoint);
    }

    public Shape getShape() {
        return this.bounds;
    }
}

