/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.designer.style.tooltip;

import com.fr.chart.chartattr.Plot;
import com.fr.design.dialog.BasicPane;
import com.fr.design.gui.ibutton.UIButtonGroup;
import com.fr.design.gui.ibutton.UIToggleButton;
import com.fr.design.gui.icheckbox.UICheckBox;
import com.fr.design.layout.TableLayoutHelper;
import com.fr.design.mainframe.chart.gui.style.ChartTextAttrPane;
import com.fr.general.Inter;
import com.fr.plugin.chart.base.AttrTooltip;
import com.fr.plugin.chart.designer.TableLayout4VanChartHelper;
import com.fr.plugin.chart.designer.component.VanChartTooltipContentPane;
import com.fr.plugin.chart.designer.component.background.VanChartBackgroundWithOutImagePane;
import com.fr.plugin.chart.designer.component.border.VanChartBorderWithRadiusPane;
import com.fr.plugin.chart.designer.style.VanChartStylePane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class VanChartPlotTooltipPane
extends BasicPane {
    private static final long serialVersionUID = 6087381131907589370L;
    protected UICheckBox isTooltipShow;
    protected VanChartTooltipContentPane tooltipContentPane;
    protected UIButtonGroup<Integer> style;
    protected ChartTextAttrPane textFontPane;
    protected VanChartBorderWithRadiusPane borderPane;
    protected VanChartBackgroundWithOutImagePane backgroundPane;
    protected UIToggleButton showAllSeries;
    protected UIButtonGroup followMouse;
    protected VanChartStylePane parent;
    protected JPanel tooltipPane;

    public VanChartPlotTooltipPane(Plot plot, VanChartStylePane vanChartStylePane) {
        this.parent = vanChartStylePane;
        this.addComponents(plot);
    }

    protected void addComponents(Plot plot) {
        this.isTooltipShow = new UICheckBox(Inter.getLocText((String)"Plugin-ChartF_UseTooltip"));
        this.tooltipPane = this.createTooltipPane(plot);
        double d = -2.0;
        double d2 = -1.0;
        double[] dArray = new double[]{d2};
        double[] dArray2 = new double[]{d, d, d};
        Component[][] componentArray = new Component[][]{{this.isTooltipShow}, {new JSeparator()}, {this.tooltipPane}};
        JPanel jPanel = TableLayoutHelper.createTableLayoutPane((Component[][])componentArray, (double[])dArray2, (double[])dArray);
        this.setLayout(new BorderLayout());
        this.add(jPanel, "Center");
        this.isTooltipShow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VanChartPlotTooltipPane.this.checkBoxUse();
            }
        });
    }

    protected JPanel createTooltipPane(Plot plot) {
        this.borderPane = new VanChartBorderWithRadiusPane();
        this.backgroundPane = new VanChartBackgroundWithOutImagePane();
        this.initTooltipContentPane(plot);
        double d = -2.0;
        double d2 = -1.0;
        double[] dArray = new double[]{d, d2};
        double[] dArray2 = new double[]{d, d, d, d, d, d, d, d, d};
        Component[][] componentArray = this.createComponents(plot);
        return TableLayoutHelper.createTableLayoutPane((Component[][])componentArray, (double[])dArray2, (double[])dArray);
    }

    protected Component[][] createComponents(Plot plot) {
        Component[][] componentArray = new Component[][]{{this.tooltipContentPane, null}, {new JSeparator(), null}, {this.createLabelStylePane(), null}, {new JSeparator(), null}, {this.borderPane, null}, {this.backgroundPane, null}, {this.createDisplayStrategy(plot), null}};
        return componentArray;
    }

    protected void initTooltipContentPane(Plot plot) {
        this.tooltipContentPane = new VanChartTooltipContentPane(this.parent, (JPanel)((Object)this));
    }

    protected JPanel createLabelStylePane() {
        this.style = new UIButtonGroup(new String[]{Inter.getLocText((String)"Plugin-ChartF_Automatic"), Inter.getLocText((String)"Plugin-ChartF_Custom")});
        this.textFontPane = new ChartTextAttrPane();
        double d = -2.0;
        double d2 = -1.0;
        double[] dArray = new double[]{d, d2};
        double[] dArray2 = new double[]{d, d};
        Component[][] componentArray = new Component[][]{{this.style, null}, {this.textFontPane, null}};
        this.initStyleListener();
        JPanel jPanel = TableLayoutHelper.createTableLayoutPane((Component[][])componentArray, (double[])dArray2, (double[])dArray);
        return TableLayout4VanChartHelper.createTableLayoutPaneWithTitle(Inter.getLocText((String)"FR-Designer-Widget_Style"), jPanel);
    }

    private void initStyleListener() {
        this.style.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VanChartPlotTooltipPane.this.checkStyleUse();
            }
        });
    }

    protected JPanel createDisplayStrategy(Plot plot) {
        this.showAllSeries = new UIToggleButton(Inter.getLocText((String)"Plugin-ChartF_ShowAllSeries"));
        this.followMouse = new UIButtonGroup(new String[]{Inter.getLocText((String)"Plugin-ChartF_FollowMouse"), Inter.getLocText((String)"Plugin-ChartF_NotFollowMouse")});
        JPanel jPanel = new JPanel(new BorderLayout(0, 4));
        if (plot.isSupportTooltipSeriesType()) {
            jPanel.add((Component)this.showAllSeries, "North");
        }
        jPanel.add((Component)this.followMouse, "South");
        return TableLayout4VanChartHelper.createTableLayoutPaneWithTitle(Inter.getLocText((String)"Plugin-ChartF_DisplayStrategy"), jPanel);
    }

    protected String title4PopupWindow() {
        return null;
    }

    private void checkAllUse() {
        this.checkBoxUse();
        this.checkStyleUse();
    }

    private void checkBoxUse() {
        this.tooltipPane.setVisible(this.isTooltipShow.isSelected());
    }

    private void checkStyleUse() {
        this.textFontPane.setEnabled(this.style.getSelectedIndex() == 1);
    }

    public void populate(AttrTooltip attrTooltip) {
        if (attrTooltip == null) {
            attrTooltip = new AttrTooltip();
        }
        this.isTooltipShow.setSelected(attrTooltip.isEnable());
        this.tooltipContentPane.populateBean(attrTooltip.getContent());
        this.style.setSelectedIndex(attrTooltip.isCustom() ? 1 : 0);
        this.textFontPane.populate(attrTooltip.getTextAttr());
        this.borderPane.populate(attrTooltip.getGeneralInfo());
        this.backgroundPane.populate(attrTooltip.getGeneralInfo());
        this.showAllSeries.setSelected(attrTooltip.isShowMutiSeries());
        this.followMouse.setSelectedIndex(attrTooltip.isFollowMouse() ? 0 : 1);
        this.checkAllUse();
    }

    public AttrTooltip update() {
        AttrTooltip attrTooltip = new AttrTooltip();
        attrTooltip.setEnable(this.isTooltipShow.isSelected());
        attrTooltip.setContent(this.tooltipContentPane.updateBean());
        attrTooltip.setCustom(this.style.getSelectedIndex() == 1);
        if (this.textFontPane != null) {
            attrTooltip.setTextAttr(this.textFontPane.update());
        }
        this.borderPane.update(attrTooltip.getGeneralInfo());
        this.backgroundPane.update(attrTooltip.getGeneralInfo());
        attrTooltip.setShowMutiSeries(this.showAllSeries.isSelected());
        attrTooltip.setFollowMouse(this.followMouse.getSelectedIndex() == 0);
        return attrTooltip;
    }
}

