/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.designer.style.label;

import com.fr.chart.base.DataSeriesCondition;
import com.fr.chart.chartattr.Chart;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartglyph.ConditionAttr;
import com.fr.design.dialog.BasicScrollPane;
import com.fr.design.mainframe.chart.PaneTitleConstants;
import com.fr.plugin.chart.attr.plot.VanChartPlot;
import com.fr.plugin.chart.base.AttrLabel;
import com.fr.plugin.chart.designer.PlotFactory;
import com.fr.plugin.chart.designer.style.VanChartStylePane;
import com.fr.plugin.chart.designer.style.label.VanChartPlotLabelPane;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;

public class VanChartLabelPane
extends BasicScrollPane<Chart> {
    private VanChartPlotLabelPane labelPane;
    private Chart chart;
    protected VanChartStylePane parent;
    private static final long serialVersionUID = -5449293740965811991L;

    public VanChartLabelPane(VanChartStylePane vanChartStylePane) {
        this.parent = vanChartStylePane;
    }

    protected JPanel createContentPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        if (this.chart == null) {
            return jPanel;
        }
        this.labelPane = this.getLabelPane(this.chart.getPlot());
        jPanel.add((Component)((Object)this.labelPane), "North");
        return jPanel;
    }

    public void populateBean(Chart chart) {
        this.chart = chart;
        if (this.labelPane == null) {
            this.remove(this.leftcontentPane);
            this.layoutContentPane();
            this.parent.initAllListeners();
        }
        Plot plot = this.chart.getPlot();
        DataSeriesCondition dataSeriesCondition = ((VanChartPlot)plot).getAttrLabelFromConditionCollection();
        if (this.labelPane != null) {
            this.labelPane.populate((AttrLabel)dataSeriesCondition);
        }
    }

    public void updateBean(Chart chart) {
        AttrLabel attrLabel;
        if (chart == null) {
            return;
        }
        ConditionAttr conditionAttr = chart.getPlot().getConditionCollection().getDefaultAttr();
        DataSeriesCondition dataSeriesCondition = ((VanChartPlot)chart.getPlot()).getAttrLabelFromConditionCollection();
        if (dataSeriesCondition != null) {
            conditionAttr.remove(dataSeriesCondition);
        }
        if ((attrLabel = this.labelPane.update()) != null) {
            conditionAttr.addDataSeriesCondition((DataSeriesCondition)attrLabel);
        }
    }

    protected String title4PopupWindow() {
        return PaneTitleConstants.CHART_STYLE_LABEL_TITLE;
    }

    protected VanChartPlotLabelPane getLabelPane(Plot plot) {
        return PlotFactory.createPlotLabelPane(plot, this.parent);
    }
}

