/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.designer.style.background;

import com.fr.base.Formula;
import com.fr.base.Utils;
import com.fr.design.beans.BasicBeanPane;
import com.fr.design.formula.TinyFormulaPane;
import com.fr.design.gui.ibutton.UIButtonGroup;
import com.fr.design.gui.icombobox.LineComboBox;
import com.fr.design.gui.icombobox.UIComboBox;
import com.fr.design.gui.ilable.UILabel;
import com.fr.design.gui.style.FRFontPane;
import com.fr.design.layout.FRGUIPaneFactory;
import com.fr.design.layout.TableLayoutHelper;
import com.fr.design.style.color.ColorSelectBox;
import com.fr.design.utils.gui.GUICoreUtils;
import com.fr.general.FRFont;
import com.fr.general.Inter;
import com.fr.plugin.chart.attr.VanChartAttrHelper;
import com.fr.plugin.chart.attr.axis.VanChartAlertValue;
import com.fr.plugin.chart.base.VanChartConstants;
import com.fr.stable.StableUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VanChartAlertValuePane
extends BasicBeanPane<VanChartAlertValue> {
    private static final long serialVersionUID = -1208941770684286439L;
    private UIButtonGroup alertAxis;
    protected TinyFormulaPane alertValue;
    protected LineComboBox alertLineStyle;
    protected ColorSelectBox alertLineColor;
    private UIButtonGroup alertTextPosition;
    private TinyFormulaPane alertText;
    private UIComboBox fontSize;
    private UIComboBox fontName;
    private ColorSelectBox fontColor;

    public VanChartAlertValuePane() {
        this.initComponents();
    }

    private void initComponents() {
        this.alertValue = new TinyFormulaPane();
        this.alertLineStyle = new LineComboBox(VanChartConstants.ALERT_LINE_STYLE);
        this.alertLineColor = new ColorSelectBox(100);
        this.alertTextPosition = new UIButtonGroup(new String[]{Inter.getLocText((String)"Plugin-ChartF_AxisTop"), Inter.getLocText((String)"Plugin-ChartF_AxisBottom")});
        this.alertText = new TinyFormulaPane();
        this.fontSize = new UIComboBox((Object[])FRFontPane.FONT_SIZES);
        this.fontName = new UIComboBox((Object[])Utils.getAvailableFontFamilyNames4Report());
        this.fontColor = new ColorSelectBox(100);
    }

    private void doLayoutPane() {
        this.removeAll();
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        JPanel jPanel = FRGUIPaneFactory.createBorderLayout_L_Pane();
        this.add(jPanel);
        jPanel.setBorder(GUICoreUtils.createTitledBorder((String)(Inter.getLocText((String)"Plugin-ChartF_AlertSet") + ":"), null));
        jPanel.add(this.createTopPane());
        JPanel jPanel2 = FRGUIPaneFactory.createBorderLayout_L_Pane();
        this.add(jPanel2);
        jPanel2.setBorder(GUICoreUtils.createTitledBorder((String)(Inter.getLocText((String)"Plugin-ChartF_AlertText") + ":"), null));
        jPanel2.add(this.createBottomPane());
    }

    protected JPanel createTopPane() {
        double d = -2.0;
        double[] dArray = new double[]{d, d};
        double[] dArray2 = new double[]{d, d, d, d};
        Component[][] componentArray = this.getTopPaneComponents();
        return TableLayoutHelper.createTableLayoutPane((Component[][])componentArray, (double[])dArray2, (double[])dArray);
    }

    protected Component[][] getTopPaneComponents() {
        return new Component[][]{{new UILabel(Inter.getLocText((String)"Chart-Layout_Position")), this.alertAxis}, {new UILabel(Inter.getLocText((String)"Chart-Use_Value")), this.alertValue}, {new UILabel(Inter.getLocText((String)"Plugin-ChartF_LineStyle")), this.alertLineStyle}, {new UILabel(Inter.getLocText((String)"FR-Chart-Color_Color")), this.alertLineColor}};
    }

    private JPanel createBottomPane() {
        this.alertTextPosition.setSelectedIndex(0);
        double d = -2.0;
        double[] dArray = new double[]{d, d};
        double[] dArray2 = new double[]{d, d, d, d, d};
        Component[][] componentArray = new Component[][]{{new UILabel(Inter.getLocText((String)"Chart-Layout_Position")), this.alertTextPosition}, {new UILabel(Inter.getLocText((String)"Plugin-ChartF_Content")), this.alertText}, {new UILabel(Inter.getLocText((String)"FR-Designer_Font")), this.fontName}, {new UILabel(Inter.getLocText((String)"FR-Designer-FRFont_Size")), this.fontSize}, {new UILabel(Inter.getLocText((String)"FR-Chart-Color_Color")), this.fontColor}};
        return TableLayoutHelper.createTableLayoutPane((Component[][])componentArray, (double[])dArray2, (double[])dArray);
    }

    private void checkPositionPane() {
        boolean bl = VanChartAttrHelper.isXAxis(this.alertAxis.getSelectedItem().toString());
        this.alertTextPosition = bl ? new UIButtonGroup(new String[]{Inter.getLocText((String)"Plugin-ChartF_AxisTop"), Inter.getLocText((String)"Plugin-ChartF_AxisBottom")}) : new UIButtonGroup(new String[]{Inter.getLocText((String)"Plugin-ChartF_AlertLeft"), Inter.getLocText((String)"Plugin-ChartF_AlertRight")});
        this.doLayoutPane();
    }

    protected String title4PopupWindow() {
        return Inter.getLocText((String)"Plugin-ChartF_AlertLine");
    }

    public void populateBean(VanChartAlertValue vanChartAlertValue) {
        this.alertAxis = new UIButtonGroup(vanChartAlertValue.getAxisNamesArray(), (Object[])vanChartAlertValue.getAxisNamesArray());
        this.alertAxis.setSelectedItem((Object)vanChartAlertValue.getAxisName());
        this.alertAxis.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                VanChartAlertValuePane.this.checkPositionPane();
            }
        });
        this.checkPositionPane();
        this.alertValue.populateBean(Utils.objectToString((Object)vanChartAlertValue.getAlertValueFormula()));
        this.alertLineStyle.setSelectedLineStyle(vanChartAlertValue.getLineStyle().getLineStyle());
        this.alertLineColor.setSelectObject(vanChartAlertValue.getLineColor().getSeriesColor());
        if (VanChartAttrHelper.isXAxis(vanChartAlertValue.getAxisName())) {
            this.alertTextPosition.setSelectedIndex(vanChartAlertValue.getAlertPosition() == 1 ? 0 : 1);
        } else {
            this.alertTextPosition.setSelectedIndex(vanChartAlertValue.getAlertPosition() == 2 ? 0 : 1);
        }
        if (vanChartAlertValue.getAlertContentFormula() instanceof Formula) {
            this.alertText.populateBean(((Formula)vanChartAlertValue.getAlertContentFormula()).getContent());
        } else {
            this.alertText.populateBean(Utils.objectToString((Object)vanChartAlertValue.getAlertContentFormula()));
        }
        this.fontName.setSelectedItem((Object)vanChartAlertValue.getAlertFont().getName());
        this.fontSize.setSelectedItem((Object)vanChartAlertValue.getAlertFont().getSize());
        this.fontColor.setSelectObject(vanChartAlertValue.getAlertFont().getForeground());
    }

    public void updateBean(VanChartAlertValue vanChartAlertValue) {
        vanChartAlertValue.setAxisName(this.alertAxis.getSelectedItem().toString());
        vanChartAlertValue.setAlertValueFormula(new Formula(this.alertValue.updateBean()));
        vanChartAlertValue.getLineColor().setSeriesColor(this.alertLineColor.getSelectObject());
        vanChartAlertValue.getLineStyle().setLineStyle(this.alertLineStyle.getSelectedLineStyle());
        String string = this.alertText.updateBean();
        String string2 = StableUtils.maybeFormula((String)string) ? new Formula(string) : string;
        vanChartAlertValue.setAlertContentFormula(string2);
        String string3 = Utils.objectToString((Object)this.fontName.getSelectedItem());
        int n = Utils.objectToNumber((Object)this.fontSize.getSelectedItem(), (boolean)true).intValue();
        Color color = this.fontColor.getSelectObject();
        vanChartAlertValue.setAlertFont(FRFont.getInstance((String)string3, (int)0, (float)n, (Color)color));
        if (VanChartAttrHelper.isXAxis(Utils.objectToString((Object)this.alertAxis.getSelectedItem()))) {
            vanChartAlertValue.setAlertPosition(this.alertTextPosition.getSelectedIndex() == 0 ? 1 : 3);
        } else {
            vanChartAlertValue.setAlertPosition(this.alertTextPosition.getSelectedIndex() == 0 ? 2 : 4);
        }
    }

    public VanChartAlertValue updateBean() {
        return null;
    }
}

