/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.designer.style.axis.component;

import com.fr.base.BaseUtils;
import com.fr.design.beans.BasicBeanPane;
import com.fr.design.gui.ibutton.UIButton;
import com.fr.design.gui.ibutton.UIToggleButton;
import com.fr.design.gui.imenu.UIMenuItem;
import com.fr.design.gui.imenu.UIPopupMenu;
import com.fr.design.utils.gui.GUICoreUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.plugin.chart.attr.VanChartAttrHelper;
import com.fr.plugin.chart.attr.axis.VanChartAxis;
import com.fr.plugin.chart.attr.plot.VanChartAxisPlot;
import com.fr.plugin.chart.designer.style.axis.VanChartAxisPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class VanChartAxisButtonPane
extends BasicBeanPane<VanChartAxisPlot> {
    private static final long serialVersionUID = -7423971487378453235L;
    private static final int B_W = 52;
    private static final int B_H = 21;
    private static final int COL_COUNT = 3;
    private UIButton addButton;
    private UIPopupMenu popupMenu;
    private List<ChartAxisButton> indexList_X = new ArrayList<ChartAxisButton>();
    private List<ChartAxisButton> indexList_Y = new ArrayList<ChartAxisButton>();
    private JPanel buttonPane;
    private VanChartAxisPane parent;
    ActionListener addListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (VanChartAxisButtonPane.this.popupMenu == null) {
                VanChartAxisButtonPane.this.popupMenu = new UIPopupMenu();
                UIMenuItem uIMenuItem = new UIMenuItem(VanChartAttrHelper.X_AXIS_PREFIX);
                uIMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        VanChartAxisButtonPane.this.addXAxis();
                    }
                });
                UIMenuItem uIMenuItem2 = new UIMenuItem(VanChartAttrHelper.Y_AXIS_PREFIX);
                uIMenuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        VanChartAxisButtonPane.this.addYAxis();
                    }
                });
                VanChartAxisButtonPane.this.popupMenu.add((JMenuItem)uIMenuItem);
                VanChartAxisButtonPane.this.popupMenu.add((JMenuItem)uIMenuItem2);
            }
            VanChartAxisButtonPane.this.popupMenu.setVisible(true);
            GUICoreUtils.showPopupMenu((JPopupMenu)VanChartAxisButtonPane.this.popupMenu, (Component)VanChartAxisButtonPane.this.addButton, (int)(VanChartAxisButtonPane.this.addButton.getWidth() - ((VanChartAxisButtonPane)VanChartAxisButtonPane.this).popupMenu.getPreferredSize().width), (int)(VanChartAxisButtonPane.this.addButton.getY() - 1 + VanChartAxisButtonPane.this.addButton.getHeight()));
        }
    };

    public VanChartAxisButtonPane(VanChartAxisPane vanChartAxisPane) {
        this.parent = vanChartAxisPane;
        this.setLayout(new BorderLayout());
        this.addButton = new AddButton(BaseUtils.readIcon((String)"/com/fr/design/images/control/addPopup.png"));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 20));
        jPanel.add((Component)this.addButton, "North");
        this.addButton.setVisible(false);
        this.add(jPanel, "East");
        this.buttonPane = new JPanel();
        this.buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 0));
        this.add(this.buttonPane, "Center");
        this.addButton.addActionListener(this.addListener);
    }

    private void layoutPane() {
        int n;
        if (this.buttonPane == null) {
            return;
        }
        this.buttonPane.removeAll();
        this.buttonPane.setLayout(new BoxLayout(this.buttonPane, 1));
        Container container = null;
        int n2 = this.indexList_X.size();
        int n3 = this.indexList_Y.size();
        for (n = 0; n < n2; ++n) {
            if (n % 3 == 0) {
                container = new JPanel(new FlowLayout(0, 0, 0));
                this.buttonPane.add(container);
            }
            container.add((Component)((Object)this.indexList_X.get(n)));
        }
        for (n = 0; n < n3; ++n) {
            if ((n + n2) % 3 == 0) {
                container = new JPanel(new FlowLayout(0, 0, 0));
                this.buttonPane.add(container);
            }
            container.add((Component)((Object)this.indexList_Y.get(n)));
        }
        this.revalidate();
    }

    protected String title4PopupWindow() {
        return Inter.getLocText((String)"FR-Chart-Types_Switch");
    }

    public void populateBean(VanChartAxisPlot vanChartAxisPlot) {
        Object object;
        this.indexList_X.clear();
        this.indexList_Y.clear();
        List<VanChartAxis> list = vanChartAxisPlot.getXAxisList();
        for (VanChartAxis object22 : list) {
            object = new ChartAxisButton(object22.getAxisName());
            this.indexList_X.add((ChartAxisButton)((Object)object));
        }
        List<VanChartAxis> list2 = vanChartAxisPlot.getYAxisList();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            object = (VanChartAxis)((Object)iterator.next());
            ChartAxisButton chartAxisButton = new ChartAxisButton(((VanChartAxis)((Object)object)).getAxisName());
            this.indexList_Y.add(chartAxisButton);
        }
        if (this.indexList_X.isEmpty()) {
            this.removeAll();
        } else {
            this.indexList_X.get(0).setSelected(true);
            this.addButton.setVisible(vanChartAxisPlot.isCustomChart());
        }
        this.layoutPane();
    }

    public VanChartAxisPlot updateBean() {
        return null;
    }

    public String getNewChartName(List<ChartAxisButton> list, String string) {
        int n = list.size() + 1;
        while (true) {
            String string2 = string + n;
            boolean bl = false;
            for (ChartAxisButton chartAxisButton : list) {
                if (!ComparatorUtils.equals((Object)chartAxisButton.getButtonName(), (Object)string2)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return string2;
            }
            ++n;
        }
    }

    private void addXAxis() {
        String string = this.getNewChartName(this.indexList_X, VanChartAttrHelper.X_AXIS_PREFIX);
        ChartAxisButton chartAxisButton = new ChartAxisButton(string);
        this.indexList_X.add(chartAxisButton);
        this.parent.addXAxis(string);
        this.layoutPane();
    }

    private void addYAxis() {
        String string = this.getNewChartName(this.indexList_Y, VanChartAttrHelper.Y_AXIS_PREFIX);
        ChartAxisButton chartAxisButton = new ChartAxisButton(string);
        this.indexList_Y.add(chartAxisButton);
        this.parent.addYAxis(string);
        this.layoutPane();
    }

    private void changeAxisSelected(String string) {
        this.parent.changeAxisSelected(string);
    }

    private class ChartAxisButton
    extends UIToggleButton {
        private static final double DEL_WIDTH = 10.0;
        private static final long serialVersionUID = -3701452534814584608L;
        private BufferedImage closeIcon;
        private boolean isMoveOn;
        private String buttonName;

        public ChartAxisButton(String string) {
            super(string);
            this.closeIcon = BaseUtils.readImageWithCache((String)"com/fr/design/images/toolbarbtn/chartChangeClose.png");
            this.isMoveOn = false;
            this.buttonName = "";
            this.buttonName = string;
        }

        public String getButtonName() {
            return this.buttonName;
        }

        public Dimension getPreferredSize() {
            return new Dimension(52, 21);
        }

        private void paintDeleteButton(Graphics graphics) {
            Rectangle rectangle = this.getBounds();
            int n = (int)(((RectangularShape)rectangle).getWidth() - 10.0);
            int n2 = 1;
            graphics.drawImage(this.closeIcon, n, n2, this.closeIcon.getWidth(), this.closeIcon.getHeight(), null);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.isMoveOn && this.getButtonList().size() > 1 && !VanChartAttrHelper.isDefaultAxis(this.buttonName)) {
                this.paintDeleteButton(graphics);
            }
        }

        private boolean isXAxis() {
            return VanChartAttrHelper.isXAxis(this.buttonName);
        }

        private List<ChartAxisButton> getButtonList() {
            return this.isXAxis() ? VanChartAxisButtonPane.this.indexList_X : VanChartAxisButtonPane.this.indexList_Y;
        }

        private void noSelected() {
            for (ChartAxisButton chartAxisButton : VanChartAxisButtonPane.this.indexList_X) {
                chartAxisButton.setSelected(false);
            }
            for (ChartAxisButton chartAxisButton : VanChartAxisButtonPane.this.indexList_Y) {
                chartAxisButton.setSelected(false);
            }
        }

        private void checkMoveOn(boolean bl) {
            for (ChartAxisButton chartAxisButton : VanChartAxisButtonPane.this.indexList_X) {
                chartAxisButton.isMoveOn = false;
            }
            for (ChartAxisButton chartAxisButton : VanChartAxisButtonPane.this.indexList_Y) {
                chartAxisButton.isMoveOn = false;
            }
            this.isMoveOn = bl;
        }

        private Rectangle2D getRectBounds() {
            return this.getBounds();
        }

        private void deleteAButton() {
            List<ChartAxisButton> list = this.getButtonList();
            if (list.contains((Object)this) && list.size() > 1) {
                list.remove((Object)this);
                VanChartAxisButtonPane.this.parent.removeAxis(this.buttonName);
                if (this.isSelected()) {
                    list.get(0).setSelected(true);
                    VanChartAxisButtonPane.this.changeAxisSelected(list.get(0).getButtonName());
                }
            }
            this.reLayoutPane();
        }

        private void reLayoutPane() {
            VanChartAxisButtonPane.this.layoutPane();
        }

        protected MouseListener getMouseListener() {
            return new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    ChartAxisButton.this.mouseClick(mouseEvent);
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    ChartAxisButton.this.checkMoveOn(true);
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    ChartAxisButton.this.checkMoveOn(false);
                }
            };
        }

        public void mouseClick(MouseEvent mouseEvent) {
            Rectangle2D rectangle2D = this.getRectBounds();
            if (rectangle2D == null) {
                return;
            }
            if ((double)mouseEvent.getX() >= rectangle2D.getWidth() - 10.0 && !VanChartAttrHelper.isDefaultAxis(this.buttonName)) {
                this.deleteAButton();
                this.fireSelectedChanged();
                return;
            }
            if (this.isEnabled()) {
                this.noSelected();
                VanChartAxisButtonPane.this.changeAxisSelected(this.getButtonName());
                this.setSelectedWithFireListener(true);
                this.fireSelectedChanged();
            }
        }
    }

    private class AddButton
    extends UIButton {
        public AddButton(Icon icon) {
            super(icon);
        }

        public boolean shouldResponseChangeListener() {
            return false;
        }
    }
}

