/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.designer.style.axis;

import com.fr.base.Formula;
import com.fr.base.Utils;
import com.fr.design.chart.ChartSwingUtils;
import com.fr.design.editor.ValueEditorPane;
import com.fr.design.editor.editor.DateEditor;
import com.fr.design.editor.editor.Editor;
import com.fr.design.editor.editor.FormulaEditor;
import com.fr.design.gui.icheckbox.UICheckBox;
import com.fr.design.gui.icombobox.UIComboBox;
import com.fr.design.gui.itextfield.UITextField;
import com.fr.design.layout.FRGUIPaneFactory;
import com.fr.design.layout.TableLayoutHelper;
import com.fr.general.DateUtils;
import com.fr.general.FRLogger;
import com.fr.general.Inter;
import com.fr.plugin.chart.attr.axis.TimeType;
import com.fr.plugin.chart.attr.axis.VanChartAxis;
import com.fr.plugin.chart.attr.axis.VanChartTimeAxis;
import com.fr.plugin.chart.designer.TableLayout4VanChartHelper;
import com.fr.plugin.chart.designer.style.axis.VanChartBaseAxisPane;
import com.fr.stable.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.Date;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class VanChartTimeAxisPane
extends VanChartBaseAxisPane {
    private static final long serialVersionUID = 1371126030195384450L;
    private static final String[] TYPES = new String[]{TimeType.TIME_YEAR.getLocText(), TimeType.TIME_MONTH.getLocText(), TimeType.TIME_DAY.getLocText(), TimeType.TIME_HOUR.getLocText(), TimeType.TIME_MINUTE.getLocText(), TimeType.TIME_SECOND.getLocText()};
    private TimeMinMaxValuePane timeMinMaxValuePane;

    public VanChartTimeAxisPane(boolean bl) {
        super(bl);
    }

    @Override
    protected JPanel createContentPane(boolean bl) {
        double d = -2.0;
        double d2 = -1.0;
        double[] dArray = new double[]{d, d2};
        double[] dArray2 = new double[]{d, d, d, d, d, d, d, d, d, d, d, d, d, d};
        Component[][] componentArray = new Component[][]{{new JSeparator(), null}, {this.createTitlePane(new double[]{d, d, d, d, d}, dArray, bl), null}, {new JSeparator(), null}, {this.createLabelPane(new double[]{d, d, d}, dArray), null}, {new JSeparator(), null}, {this.createValueDefinition(), null}, {new JSeparator(), null}, {this.createLineStylePane(new double[]{d, d, d, d}, dArray), null}, {new JSeparator(), null}, {this.createAxisPositionPane(new double[]{d, d}, dArray, bl), null}, {new JSeparator(), null}, {this.createDisplayStrategy(new double[]{d, d}, dArray), null}, {new JSeparator(), null}, {this.createValueStylePane(), null}};
        return TableLayoutHelper.createTableLayoutPane((Component[][])componentArray, (double[])dArray2, (double[])dArray);
    }

    private JPanel createValueDefinition() {
        this.timeMinMaxValuePane = new TimeMinMaxValuePane();
        return TableLayout4VanChartHelper.createTableLayoutPaneWithTitle(Inter.getLocText((String)"Plugin-ChartF_ValueDefinition"), this.timeMinMaxValuePane);
    }

    @Override
    protected void checkFormatType() {
        this.valueFormat.setComboBoxModel(true);
    }

    @Override
    public void updateBean(VanChartAxis vanChartAxis) {
        VanChartTimeAxis vanChartTimeAxis = (VanChartTimeAxis)vanChartAxis;
        super.updateBean(vanChartTimeAxis);
        this.timeMinMaxValuePane.update(vanChartTimeAxis);
    }

    @Override
    public VanChartTimeAxis updateBean(String string, int n) {
        VanChartTimeAxis vanChartTimeAxis = new VanChartTimeAxis(string, 3);
        this.updateBean(vanChartTimeAxis);
        return vanChartTimeAxis;
    }

    @Override
    public void populateBean(VanChartAxis vanChartAxis) {
        VanChartTimeAxis vanChartTimeAxis = (VanChartTimeAxis)vanChartAxis;
        super.populateBean(vanChartTimeAxis);
        this.timeMinMaxValuePane.populate(vanChartTimeAxis);
    }

    @Override
    public String title4PopupWindow() {
        return Inter.getLocText((String)"Plugin-ChartF_TimeAxis");
    }

    private class TimeMinMaxValuePane
    extends JPanel {
        private static final long serialVersionUID = 5910309251773119715L;
        private UICheckBox maxCheckBox;
        private ValueEditorPane maxValueField;
        private UICheckBox minCheckBox;
        private ValueEditorPane minValueField;
        private UICheckBox mainTickBox;
        private UITextField mainUnitField;
        private UIComboBox mainType;
        private UICheckBox secondTickBox;
        private UITextField secondUnitField;
        private UIComboBox secondType;

        public TimeMinMaxValuePane() {
            this.setLayout(FRGUIPaneFactory.createBorderLayout());
            this.initMin();
            this.initMax();
            this.initMain();
            this.initSecond();
            double d = -2.0;
            double d2 = -1.0;
            double[] dArray = new double[]{d, d, d};
            double[] dArray2 = new double[]{d, d2};
            Component[][] componentArray = new Component[][]{{this.minCheckBox, this.minValueField}, {this.maxCheckBox, this.maxValueField}};
            JPanel jPanel = TableLayoutHelper.createTableLayoutPane((Component[][])componentArray, (double[])dArray, (double[])dArray2);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout(0, 0, 0));
            jPanel2.add((Component)this.mainTickBox);
            jPanel2.add((Component)this.mainUnitField);
            jPanel2.add((Component)this.mainType);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new FlowLayout(0, 0, 0));
            jPanel3.add((Component)this.secondTickBox);
            jPanel3.add((Component)this.secondUnitField);
            jPanel3.add((Component)this.secondType);
            Component[][] componentArray2 = new Component[][]{{jPanel, null}, {jPanel2, null}, {jPanel3, null}};
            this.add(TableLayoutHelper.createTableLayoutPane((Component[][])componentArray2, (double[])dArray, (double[])dArray2));
        }

        private void initMin() {
            this.minCheckBox = new UICheckBox(Inter.getLocText((String)"FR-Chart-Data_Min"));
            Date date = null;
            DateEditor dateEditor = new DateEditor(date, true, Inter.getLocText((String)"FR-Designer_Date"), 3);
            FormulaEditor formulaEditor = new FormulaEditor(Inter.getLocText((String)"Plugin-ChartF_Formula"));
            Editor[] editorArray = new Editor[]{dateEditor, formulaEditor};
            this.minValueField = new ValueEditorPane(editorArray);
            this.minValueField.setEnabled(false);
            this.minCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TimeMinMaxValuePane.this.checkBoxUse();
                }
            });
        }

        private void initMax() {
            this.maxCheckBox = new UICheckBox(Inter.getLocText((String)"FR-Chart-Data_Max"));
            Date date = null;
            DateEditor dateEditor = new DateEditor(date, true, Inter.getLocText((String)"FR-Designer_Date"), 3);
            FormulaEditor formulaEditor = new FormulaEditor(Inter.getLocText((String)"Plugin-ChartF_Formula"));
            Editor[] editorArray = new Editor[]{dateEditor, formulaEditor};
            this.maxValueField = new ValueEditorPane(editorArray);
            this.maxValueField.setEnabled(false);
            this.maxCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TimeMinMaxValuePane.this.checkBoxUse();
                }
            });
        }

        private void initMain() {
            this.mainTickBox = new UICheckBox(Inter.getLocText((String)"Plugin-ChartF_MainType"));
            this.mainUnitField = new UITextField();
            this.mainUnitField.setPreferredSize(new Dimension(20, 20));
            this.mainUnitField.setEditable(false);
            this.mainType = new UIComboBox((Object[])TYPES);
            this.mainType.setEnabled(false);
            this.mainTickBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TimeMinMaxValuePane.this.checkBoxUse();
                }
            });
            ChartSwingUtils.addListener((UICheckBox)this.mainTickBox, (UITextField)this.mainUnitField);
        }

        private void initSecond() {
            this.secondTickBox = new UICheckBox(Inter.getLocText((String)"Plugin-ChartF_SecType"));
            this.secondUnitField = new UITextField();
            this.secondUnitField.setPreferredSize(new Dimension(20, 20));
            this.secondUnitField.setEditable(false);
            this.secondType = new UIComboBox((Object[])TYPES);
            this.secondType.setEnabled(false);
            this.secondTickBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TimeMinMaxValuePane.this.checkBoxUse();
                }
            });
            ChartSwingUtils.addListener((UICheckBox)this.secondTickBox, (UITextField)this.secondUnitField);
        }

        private void checkBoxUse() {
            FormulaEditor formulaEditor;
            this.minValueField.setEnabled(this.minCheckBox.isSelected());
            this.maxValueField.setEnabled(this.maxCheckBox.isSelected());
            if (this.minValueField.getCurrentEditor() instanceof FormulaEditor) {
                formulaEditor = (FormulaEditor)this.minValueField.getCurrentEditor();
                formulaEditor.enableEditor(this.minCheckBox.isSelected());
            }
            if (this.maxValueField.getCurrentEditor() instanceof FormulaEditor) {
                formulaEditor = (FormulaEditor)this.maxValueField.getCurrentEditor();
                formulaEditor.enableEditor(this.maxCheckBox.isSelected());
            }
            this.mainType.setEnabled(this.mainTickBox.isSelected());
            this.mainUnitField.setEnabled(this.mainTickBox.isSelected());
            this.secondType.setEnabled(this.secondTickBox.isSelected());
            this.secondUnitField.setEnabled(this.secondTickBox.isSelected());
        }

        public void update(VanChartTimeAxis vanChartTimeAxis) {
            String string;
            DateEditor dateEditor;
            Object object;
            if (this.minCheckBox.isSelected()) {
                if (this.minValueField.getCurrentEditor() instanceof FormulaEditor) {
                    object = (Formula)this.minValueField.update();
                    vanChartTimeAxis.setMinValue((Formula)object);
                    vanChartTimeAxis.setCustomMinValue(!StringUtils.isEmpty((String)object.getPureContent()));
                } else {
                    object = (Date)this.minValueField.update();
                    dateEditor = (DateEditor)this.minValueField.getCurrentEditor();
                    string = dateEditor.getUIDatePickerFormat().format((Date)object);
                    vanChartTimeAxis.setCustomMinValue(!StringUtils.isEmpty((String)string));
                    vanChartTimeAxis.setMinValue(new Formula(string));
                }
            } else {
                vanChartTimeAxis.setCustomMinValue(false);
            }
            if (this.maxCheckBox.isSelected()) {
                if (this.maxValueField.getCurrentEditor() instanceof FormulaEditor) {
                    object = (Formula)this.maxValueField.update();
                    vanChartTimeAxis.setMaxValue((Formula)object);
                    vanChartTimeAxis.setCustomMaxValue(!StringUtils.isEmpty((String)object.getPureContent()));
                } else {
                    object = (Date)this.maxValueField.update();
                    dateEditor = (DateEditor)this.maxValueField.getCurrentEditor();
                    string = dateEditor.getUIDatePickerFormat().format((Date)object);
                    vanChartTimeAxis.setCustomMaxValue(!StringUtils.isEmpty((String)string));
                    vanChartTimeAxis.setMaxValue(new Formula(string));
                }
            } else {
                vanChartTimeAxis.setCustomMaxValue(false);
            }
            if (this.mainTickBox.isSelected() && StringUtils.isNotEmpty((String)this.mainUnitField.getText())) {
                vanChartTimeAxis.setCustomMainUnit(true);
                vanChartTimeAxis.setMainUnit(new Formula(this.mainUnitField.getText()));
                object = this.mainType.getSelectedItem().toString();
                vanChartTimeAxis.setMainType(TimeType.parseString((String)object));
            } else {
                vanChartTimeAxis.setCustomMainUnit(false);
            }
            if (this.secondTickBox.isSelected() && StringUtils.isNotEmpty((String)this.secondUnitField.getText())) {
                vanChartTimeAxis.setCustomSecUnit(true);
                vanChartTimeAxis.setSecUnit(new Formula(this.secondUnitField.getText()));
                object = this.secondType.getSelectedItem().toString();
                vanChartTimeAxis.setSecondType(TimeType.parseString((String)object));
            } else {
                vanChartTimeAxis.setCustomSecUnit(false);
            }
            this.checkBoxUse();
        }

        public void populate(VanChartTimeAxis vanChartTimeAxis) {
            Date date;
            String string;
            if (vanChartTimeAxis.isCustomMinValue() && vanChartTimeAxis.getMinValue() != null) {
                this.minCheckBox.setSelected(true);
                string = vanChartTimeAxis.getMinValue().getPureContent();
                if (!this.isDateForm(string)) {
                    this.minValueField.populate((Object)vanChartTimeAxis.getMinValue());
                } else {
                    date = this.getDateFromFormula(vanChartTimeAxis.getMinValue());
                    this.minValueField.populate((Object)date);
                }
            }
            if (vanChartTimeAxis.isCustomMaxValue() && vanChartTimeAxis.getMaxValue() != null) {
                this.maxCheckBox.setSelected(true);
                string = vanChartTimeAxis.getMaxValue().getPureContent();
                if (!this.isDateForm(string)) {
                    this.maxValueField.populate((Object)vanChartTimeAxis.getMaxValue());
                } else {
                    date = this.getDateFromFormula(vanChartTimeAxis.getMaxValue());
                    this.maxValueField.populate((Object)date);
                }
            }
            if (vanChartTimeAxis.isCustomMainUnit() && vanChartTimeAxis.getMainUnit() != null) {
                this.mainTickBox.setSelected(true);
                this.mainUnitField.setText(Utils.objectToString((Object)vanChartTimeAxis.getMainUnit()));
                this.mainType.setSelectedItem((Object)vanChartTimeAxis.getMainType().getLocText());
            }
            if (vanChartTimeAxis.isCustomSecUnit() && vanChartTimeAxis.getSecUnit() != null) {
                this.secondTickBox.setSelected(true);
                this.secondUnitField.setText(Utils.objectToString((Object)vanChartTimeAxis.getSecUnit()));
                this.secondType.setSelectedItem((Object)vanChartTimeAxis.getSecondType().getLocText());
            }
            this.checkBoxUse();
        }

        private boolean isDateForm(String string) {
            string = Pattern.compile("\"").matcher(string).replaceAll("");
            if (string.matches("^[+-]?[0-9]*[0-9]$")) {
                return false;
            }
            return DateUtils.string2Date((String)string, (boolean)true) != null;
        }

        private Date getDateFromFormula(Formula formula) {
            String string = formula.getPureContent();
            string = Pattern.compile("\"").matcher(string).replaceAll("");
            Date date = DateUtils.string2Date((String)string, (boolean)true);
            try {
                String string2 = DateUtils.getDate2LStr((Date)date);
                date = DateUtils.DATETIMEFORMAT2.parse(string2);
            }
            catch (ParseException parseException) {
                FRLogger.getLogger().error("cannot get date");
            }
            return date;
        }
    }
}

