/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.designer.component;

import com.fr.base.background.ImageBackground;
import com.fr.chart.chartglyph.MarkerFactory;
import com.fr.design.dialog.BasicPane;
import com.fr.design.gui.ibutton.UIButtonGroup;
import com.fr.design.gui.ilable.UILabel;
import com.fr.design.gui.ispinner.UISpinner;
import com.fr.design.gui.xcombox.MarkerComboBox;
import com.fr.design.layout.TableLayoutHelper;
import com.fr.design.mainframe.backgroundpane.ImageBackgroundQuickPane;
import com.fr.general.Background;
import com.fr.general.Inter;
import com.fr.plugin.chart.attr.MarkerType;
import com.fr.plugin.chart.base.VanChartAttrMarker;
import com.fr.plugin.chart.designer.component.background.VanChartMarkerBackgroundPane;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VanChartMarkerPane
extends BasicPane {
    private static final long serialVersionUID = 7206339620703021514L;
    private UIButtonGroup<String> commonORCustom;
    protected JPanel centerPane;
    private CardLayout cardLayout;
    private MarkerComboBox markerPane;
    private VanChartMarkerBackgroundPane markerFillColor;
    private UISpinner radius;
    private ImageBackgroundQuickPane imageBackgroundPane;
    private UISpinner width;
    private UISpinner height;

    public VanChartMarkerPane() {
        this.setLayout(new BorderLayout(0, 4));
        Object[] objectArray = new String[]{Inter.getLocText((String)"Plugin-ChartF_Rule"), Inter.getLocText((String)"Plugin-ChartF_Custom")};
        this.commonORCustom = new UIButtonGroup((String[])objectArray, objectArray);
        this.commonORCustom.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                VanChartMarkerPane.this.checkCenterPane();
            }
        });
        final JPanel jPanel = this.getCommonPane();
        final JPanel jPanel2 = this.getCustomPane();
        this.cardLayout = new CardLayout();
        this.centerPane = new JPanel(this.cardLayout){

            @Override
            public Dimension getPreferredSize() {
                if (VanChartMarkerPane.this.commonORCustom.getSelectedIndex() == 0) {
                    return jPanel.getPreferredSize();
                }
                return jPanel2.getPreferredSize();
            }
        };
        this.centerPane.add((Component)jPanel, Inter.getLocText((String)"Plugin-ChartF_Rule"));
        this.centerPane.add((Component)jPanel2, Inter.getLocText((String)"Plugin-ChartF_Custom"));
        this.layoutComponents();
    }

    protected void layoutComponents() {
        this.add((Component)this.commonORCustom, "North");
        this.add(this.centerPane, "Center");
    }

    private JPanel getCommonPane() {
        this.markerPane = new MarkerComboBox(MarkerType.getMarkers());
        this.markerFillColor = new VanChartMarkerBackgroundPane();
        this.radius = new UISpinner(0.0, 100.0, 0.5, 0.0);
        double d = -2.0;
        double d2 = -1.0;
        double[] dArray = new double[]{d, d, d};
        double[] dArray2 = new double[]{d, d2};
        Component[][] componentArray = new Component[][]{{new UILabel(Inter.getLocText((String)"Plugin-ChartF_type")), this.markerPane}, {new UILabel(Inter.getLocText((String)"Plugin-ChartF_FillColor")), this.markerFillColor}, {new UILabel(Inter.getLocText((String)"Plugin-ChartF_Radius")), this.radius}};
        return TableLayoutHelper.createTableLayoutPane((Component[][])componentArray, (double[])dArray, (double[])dArray2);
    }

    private JPanel getCustomPane() {
        this.imageBackgroundPane = new ImageBackgroundQuickPane(false);
        this.width = new UISpinner(0.0, 100.0, 0.5, 0.0);
        this.height = new UISpinner(0.0, 100.0, 0.5, 0.0);
        double d = -2.0;
        double d2 = -1.0;
        double[] dArray = new double[]{d, d, d};
        double[] dArray2 = new double[]{d, d2};
        Component[][] componentArray = new Component[][]{{new UILabel(Inter.getLocText((String)"Plugin-ChartF_Width")), this.width}, {new UILabel(Inter.getLocText((String)"Plugin-ChartF_Height")), this.height}};
        JPanel jPanel = TableLayoutHelper.createTableLayoutPane((Component[][])componentArray, (double[])dArray, (double[])dArray2);
        JPanel jPanel2 = new JPanel(new BorderLayout(0, 4));
        jPanel2.add((Component)this.imageBackgroundPane, "Center");
        jPanel2.add((Component)jPanel, "South");
        return jPanel2;
    }

    private void checkCenterPane() {
        this.cardLayout.show(this.centerPane, (String)this.commonORCustom.getSelectedItem());
    }

    protected String title4PopupWindow() {
        return Inter.getLocText((String)"Plugin-ChartF_Marker");
    }

    public void populate(VanChartAttrMarker vanChartAttrMarker) {
        if (vanChartAttrMarker == null) {
            vanChartAttrMarker = new VanChartAttrMarker();
        }
        this.commonORCustom.setSelectedIndex(vanChartAttrMarker.isCommon() ? 0 : 1);
        if (vanChartAttrMarker.isCommon()) {
            this.markerPane.setSelectedMarker(MarkerFactory.createMarker((String)vanChartAttrMarker.getMarkerType().getType()));
            this.markerFillColor.populate(vanChartAttrMarker.getColorBackground());
        } else if (vanChartAttrMarker.getImageBackground() != null) {
            this.imageBackgroundPane.populateBean((Background)vanChartAttrMarker.getImageBackground());
        }
        this.radius.setValue(vanChartAttrMarker.getRadius());
        this.width.setValue(vanChartAttrMarker.getWidth());
        this.height.setValue(vanChartAttrMarker.getHeight());
        this.checkCenterPane();
    }

    public VanChartAttrMarker update() {
        VanChartAttrMarker vanChartAttrMarker = new VanChartAttrMarker();
        vanChartAttrMarker.setCommon(this.commonORCustom.getSelectedIndex() == 0);
        if (vanChartAttrMarker.isCommon()) {
            vanChartAttrMarker.setColorBackground(this.markerFillColor.update());
            vanChartAttrMarker.setRadius(this.radius.getValue());
            vanChartAttrMarker.setMarkerType(MarkerType.parse(this.markerPane.getSelectedMarkder().getMarkerType()));
        } else {
            vanChartAttrMarker.setMarkerType(MarkerType.MARKER_NULL);
            ImageBackground imageBackground = (ImageBackground)this.imageBackgroundPane.updateBean();
            imageBackground.setLayout(2);
            vanChartAttrMarker.setImageBackground(imageBackground);
            vanChartAttrMarker.setWidth(this.width.getValue());
            vanChartAttrMarker.setHeight(this.height.getValue());
        }
        return vanChartAttrMarker;
    }
}

