/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.designer.component;

import com.fr.design.dialog.BasicPane;
import com.fr.design.gui.ibutton.UIButtonGroup;
import com.fr.design.gui.icombobox.LineComboBox;
import com.fr.design.gui.ilable.UILabel;
import com.fr.design.layout.TableLayoutHelper;
import com.fr.general.Inter;
import com.fr.plugin.chart.attr.LineStyle;
import com.fr.plugin.chart.base.VanChartAttrLine;
import com.fr.stable.CoreConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;

public class VanChartLineTypePane
extends BasicPane {
    private static final long serialVersionUID = -6581862503009962973L;
    protected LineComboBox lineWidth = new LineComboBox(CoreConstants.STRIKE_LINE_STYLE_ARRAY_4_CHART);
    protected UIButtonGroup<LineStyle> lineStyle;
    protected UIButtonGroup nullValueBreak;

    public VanChartLineTypePane() {
        this.createLineStyle();
        this.nullValueBreak = new UIButtonGroup(new String[]{Inter.getLocText((String)"Plugin-ChartF_Open"), Inter.getLocText((String)"Plugin-ChartF_Close")});
        this.setLayout(new BorderLayout());
        double d = -2.0;
        double d2 = -1.0;
        this.add(this.createContentPane(d, d2), "Center");
    }

    protected void createLineStyle() {
        String[] stringArray = new String[]{Inter.getLocText((String)"Plugin-ChartF_NormalLine"), Inter.getLocText((String)"Plugin-ChartF_StepLine"), Inter.getLocText((String)"Plugin-ChartF_CurveLine")};
        this.lineStyle = new UIButtonGroup(stringArray, (Object[])LineStyle.values());
    }

    protected JPanel createContentPane(double d, double d2) {
        double[] dArray = new double[]{d, d, d};
        double[] dArray2 = new double[]{d, d2};
        Component[][] componentArray = new Component[][]{{new UILabel(Inter.getLocText((String)"Plugin-ChartF_LineStyle")), this.lineWidth}, {new UILabel(Inter.getLocText((String)"FR-Chart-Style_Present")), this.lineStyle}, {new UILabel(Inter.getLocText((String)"Plugin-ChartF_Null_Value_Break")), this.nullValueBreak}};
        return TableLayoutHelper.createTableLayoutPane((Component[][])componentArray, (double[])dArray, (double[])dArray2);
    }

    protected String title4PopupWindow() {
        return Inter.getLocText((String)"Plugin-ChartF_Line");
    }

    public void populate(VanChartAttrLine vanChartAttrLine) {
        if (vanChartAttrLine == null) {
            vanChartAttrLine = this.initVanChartAttrLine();
        }
        this.lineWidth.setSelectedLineStyle(vanChartAttrLine.getLineWidth());
        this.lineStyle.setSelectedItem((Object)vanChartAttrLine.getLineStyle());
        this.nullValueBreak.setSelectedIndex(vanChartAttrLine.isNullValueBreak() ? 0 : 1);
    }

    protected VanChartAttrLine initVanChartAttrLine() {
        return new VanChartAttrLine();
    }

    public VanChartAttrLine update() {
        VanChartAttrLine vanChartAttrLine = new VanChartAttrLine();
        vanChartAttrLine.setLineWidth(this.lineWidth.getSelectedLineStyle());
        vanChartAttrLine.setLineStyle((LineStyle)((Object)this.lineStyle.getSelectedItem()));
        vanChartAttrLine.setNullValueBreak(this.nullValueBreak.getSelectedIndex() == 0);
        return vanChartAttrLine;
    }
}

