/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.data.table;

import com.fr.base.chart.chartdata.TopDefinitionProvider;
import com.fr.chart.base.ChartConstants;
import com.fr.chart.chartattr.BubblePlot;
import com.fr.chart.chartattr.ChartCollection;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartdata.BubbleTableDefinition;
import com.fr.design.gui.icombobox.UIComboBox;
import com.fr.design.gui.ilable.BoldFontTextLabel;
import com.fr.design.gui.ilable.UILabel;
import com.fr.design.layout.TableLayoutHelper;
import com.fr.design.mainframe.chart.gui.ChartDataPane;
import com.fr.design.mainframe.chart.gui.data.ChartDataFilterPane;
import com.fr.design.mainframe.chart.gui.data.table.AbstractTableDataContentPane;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.stable.ArrayUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class VanChartBubblePlotTableDataContentPane
extends AbstractTableDataContentPane {
    private static final Dimension PREFERRED_SIZE = new Dimension(100, 20);
    protected UIComboBox seriesName = new UIComboBox();
    protected UIComboBox xCombox = new UIComboBox();
    protected UIComboBox yCombox = new UIComboBox();
    protected UIComboBox bubbleSize;
    private ChartDataFilterPane dataScreeningPane;

    public VanChartBubblePlotTableDataContentPane(ChartDataPane chartDataPane) {
        this.dataScreeningPane = new ChartDataFilterPane((Plot)new BubblePlot(), chartDataPane);
        this.seriesName.setPreferredSize(PREFERRED_SIZE);
        this.xCombox.setPreferredSize(PREFERRED_SIZE);
        this.yCombox.setPreferredSize(PREFERRED_SIZE);
        this.seriesName.addItem((Object)Inter.getLocText((String)"Chart-Use_None"));
        this.initBubbleSize();
        double d = -2.0;
        double d2 = -1.0;
        double[] dArray = new double[]{d2};
        double[] dArray2 = new double[]{d, d, d, d};
        double[] dArray3 = new double[]{d, d2};
        double[] dArray4 = new double[]{d, d, d, d};
        Component[][] componentArray = new Component[][]{{new UILabel(Inter.getLocText((String)"Chart-Series_Name") + ":", 4), this.seriesName}, {new UILabel("x :", 4), this.xCombox}, {new UILabel("y :", 4), this.yCombox}, {new UILabel(Inter.getLocText((String)"FR-Chart_Bubble_Size") + ":", 4), this.bubbleSize}};
        JPanel jPanel = TableLayoutHelper.createTableLayoutPane((Component[][])componentArray, (double[])dArray4, (double[])dArray3);
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 1));
        Component[][] componentArray2 = new Component[][]{{jPanel}, {new JSeparator()}, {new BoldFontTextLabel(Inter.getLocText((String)"Chart-Data_Filter"))}, {this.dataScreeningPane}};
        JPanel jPanel2 = TableLayoutHelper.createTableLayoutPane((Component[][])componentArray2, (double[])dArray2, (double[])dArray);
        this.setLayout(new BorderLayout());
        this.add(jPanel2, "Center");
        this.seriesName.addItemListener(this.tooltipListener);
        this.xCombox.addItemListener(this.tooltipListener);
        this.yCombox.addItemListener(this.tooltipListener);
        this.bubbleSize.addItemListener(this.tooltipListener);
    }

    protected void initBubbleSize() {
        this.bubbleSize = new UIComboBox();
        this.bubbleSize.setPreferredSize(new Dimension(100, 20));
    }

    public void checkBoxUse(boolean bl) {
    }

    protected void refreshBoxListWithSelectTableData(List list) {
        this.refreshBoxItems(this.seriesName, list);
        this.seriesName.addItem((Object)Inter.getLocText((String)"Chart-Use_None"));
        this.refreshBoxItems(this.xCombox, list);
        this.refreshBoxItems(this.yCombox, list);
        this.refreshBoxItems(this.bubbleSize, list);
    }

    public void clearAllBoxList() {
        this.clearBoxItems(this.seriesName);
        this.seriesName.addItem((Object)Inter.getLocText((String)"Chart-Use_None"));
        this.clearBoxItems(this.xCombox);
        this.clearBoxItems(this.yCombox);
        this.clearBoxItems(this.bubbleSize);
    }

    public void populateBean(ChartCollection chartCollection) {
        super.populateBean(chartCollection);
        TopDefinitionProvider topDefinitionProvider = chartCollection.getSelectedChart().getFilterDefinition();
        if (!(topDefinitionProvider instanceof BubbleTableDefinition)) {
            return;
        }
        BubbleTableDefinition bubbleTableDefinition = (BubbleTableDefinition)topDefinitionProvider;
        if (bubbleTableDefinition.getSeriesName() == null || ComparatorUtils.equals((Object)"", (Object)bubbleTableDefinition.getSeriesName())) {
            this.seriesName.setSelectedItem((Object)Inter.getLocText((String)"Chart-Use_None"));
        } else {
            this.combineCustomEditValue(this.seriesName, bubbleTableDefinition.getSeriesName());
        }
        this.combineCustomEditValue(this.xCombox, bubbleTableDefinition.getBubbleX());
        this.combineCustomEditValue(this.yCombox, bubbleTableDefinition.getBubbleY());
        this.populateBubbleSize(bubbleTableDefinition);
        this.dataScreeningPane.populateBean(chartCollection);
    }

    protected void populateBubbleSize(BubbleTableDefinition bubbleTableDefinition) {
        if (ComparatorUtils.equals((Object)bubbleTableDefinition.getBubbleSize(), (Object)Inter.getLocText((String)"Chart-Use_None"))) {
            this.combineCustomEditValue(this.bubbleSize, "");
        } else {
            this.combineCustomEditValue(this.bubbleSize, bubbleTableDefinition.getBubbleSize());
        }
    }

    public void updateBean(ChartCollection chartCollection) {
        BubbleTableDefinition bubbleTableDefinition = new BubbleTableDefinition();
        chartCollection.getSelectedChart().setFilterDefinition((TopDefinitionProvider)bubbleTableDefinition);
        Object object = this.seriesName.getSelectedItem();
        Object object2 = this.xCombox.getSelectedItem();
        Object object3 = this.yCombox.getSelectedItem();
        Object object4 = this.bubbleSize.getSelectedItem();
        if (object == null || ArrayUtils.contains((Object[])ChartConstants.NONE_KEYS, (Object)object)) {
            bubbleTableDefinition.setSeriesName("");
        } else {
            bubbleTableDefinition.setSeriesName(object.toString());
        }
        if (object2 != null) {
            bubbleTableDefinition.setBubbleX(object2.toString());
        }
        if (object3 != null) {
            bubbleTableDefinition.setBubbleY(object3.toString());
        }
        if (object4 != null) {
            bubbleTableDefinition.setBubbleSize(object4.toString());
        }
        this.dataScreeningPane.updateBean(chartCollection);
    }

    public void redoLayoutPane() {
        this.dataScreeningPane.relayoutPane(this.isNeedSummaryCaculateMethod());
    }
}

