/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.column;

import com.fr.base.chart.chartdata.ChartData;
import com.fr.chart.base.ChartFunctionProcessor;
import com.fr.chart.base.ChartUtils;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartdata.NormalChartData;
import com.fr.chart.chartglyph.ConditionCollection;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.data.condition.Result;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.general.Inter;
import com.fr.plugin.chart.attr.VanChartAttrHelper;
import com.fr.plugin.chart.attr.VanChartPlotType;
import com.fr.plugin.chart.attr.axis.AxisTickLineType;
import com.fr.plugin.chart.attr.axis.AxisType;
import com.fr.plugin.chart.attr.axis.VanChartAxis;
import com.fr.plugin.chart.attr.axis.VanChartValueAxis;
import com.fr.plugin.chart.attr.plot.VanChartLabelPositionPlot;
import com.fr.plugin.chart.attr.plot.VanChartRectanglePlot;
import com.fr.plugin.chart.bar.VanChartBarDataPoint;
import com.fr.plugin.chart.base.AttrSeriesImageBackground;
import com.fr.plugin.chart.base.AttrSeriesStackAndAxis;
import com.fr.plugin.chart.column.VanChartColumnDataPoint;
import com.fr.plugin.chart.column.VanChartColumnPlotGlyph;
import com.fr.plugin.chart.glyph.VanChartDataPoint;
import com.fr.plugin.chart.glyph.VanChartDataSeries;
import com.fr.stable.fun.FunctionProcessor;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.List;

public class VanChartColumnPlot
extends VanChartRectanglePlot
implements VanChartLabelPositionPlot {
    private static final long serialVersionUID = 2328721012110296113L;
    public static final String VAN_CHART_COLUMN_PLOT_ID = "VanChartColumnPlot";
    public static final String VAN_CHART_BAR_PLOT_ID = "VanChartBarPlot";
    private boolean isBar = false;
    private double seriesOverlapPercent = 20.0;
    private double categoryIntervalPercent = 20.0;
    private boolean fixedWidth = false;
    private int columnWidth = 0;
    private boolean filledWithImage = false;
    private static final Object[] NORMAL_SERIES_NAME = new Object[]{Inter.getLocText((String)"FR-Chart-Data_Series") + "1", Inter.getLocText((String)"FR-Chart-Data_Series") + "2", Inter.getLocText((String)"FR-Chart-Data_Series") + "3"};
    public static final Object[][] NORMAL_VALUES = new Object[][]{{"40", "50", "30"}, {"35", "25", "15"}, {"25", "45", "55"}};
    private static final Object[] VALUE_SERIES_NAME = new Object[]{Inter.getLocText((String)"FR-Chart-Data_Series") + "1"};
    public static final Object[][] VALUE_TIME_VALUES = new Object[][]{{"40", "50", "30"}};
    public static final Object[] AXIS_DATE = new Object[]{DateUtils.createDate((int)2001, (int)1, (int)3), DateUtils.createDate((int)2001, (int)1, (int)1), DateUtils.createDate((int)2001, (int)1, (int)7)};
    public static final Object[] AXIS_VALUE = new Object[]{"10", "20", "30"};
    public static final Object[] AXIS_CATEGORY = ChartUtils.CATEGORY_STRING;

    public void setBar(boolean bl) {
        this.isBar = bl;
    }

    public boolean isBar() {
        return this.isBar;
    }

    public void setSeriesOverlapPercent(double d) {
        this.seriesOverlapPercent = d;
    }

    public double getSeriesOverlapPercent() {
        return this.seriesOverlapPercent;
    }

    public void setCategoryIntervalPercent(double d) {
        this.categoryIntervalPercent = d;
    }

    public double getCategoryIntervalPercent() {
        return this.categoryIntervalPercent;
    }

    public void setColumnWidth(int n) {
        this.columnWidth = n;
    }

    public void setFilledWithImage(boolean bl) {
        this.filledWithImage = bl;
    }

    public void setFixedWidth(boolean bl) {
        this.fixedWidth = bl;
    }

    public boolean isFilledWithImage() {
        return this.filledWithImage;
    }

    public boolean isFixedWidth() {
        return this.fixedWidth;
    }

    public int getColumnWidth() {
        return this.columnWidth;
    }

    public VanChartColumnPlot() {
        this(VanChartPlotType.NORMAL);
    }

    public VanChartColumnPlot(VanChartPlotType vanChartPlotType) {
        this(false, vanChartPlotType);
    }

    public VanChartColumnPlot(boolean bl, VanChartPlotType vanChartPlotType) {
        super(vanChartPlotType);
        this.isBar = bl;
        if (bl) {
            this.xAxisList = VanChartAttrHelper.createDefaultBarXAxisList();
            this.yAxisList = VanChartAttrHelper.createDefaultBarYAxisList();
        }
    }

    @Override
    public VanChartAxis createXAxis(String string, int n) {
        VanChartAxis vanChartAxis;
        VanChartAxis vanChartAxis2 = vanChartAxis = this.isBar() ? new VanChartValueAxis(string, n) : new VanChartAxis(string, n);
        if (this.isBar()) {
            vanChartAxis.setAxisStyle(0);
            vanChartAxis.setMainTickLine(AxisTickLineType.TICK_LINE_NONE);
        }
        return vanChartAxis;
    }

    @Override
    public VanChartAxis createYAxis(String string, int n) {
        VanChartAxis vanChartAxis;
        VanChartAxis vanChartAxis2 = vanChartAxis = this.isBar() ? new VanChartAxis(string, n) : new VanChartValueAxis(string, n);
        if (!this.isBar()) {
            vanChartAxis.setAxisStyle(0);
            vanChartAxis.setMainTickLine(AxisTickLineType.TICK_LINE_NONE);
        }
        return vanChartAxis;
    }

    public PlotGlyph createPlotGlyph(ChartData chartData) {
        VanChartColumnPlotGlyph vanChartColumnPlotGlyph = new VanChartColumnPlotGlyph();
        this.install4PlotGlyph(vanChartColumnPlotGlyph, chartData);
        this.installAxisGlyph(vanChartColumnPlotGlyph, chartData);
        return vanChartColumnPlotGlyph;
    }

    public void install4PlotGlyph(VanChartColumnPlotGlyph vanChartColumnPlotGlyph, ChartData chartData) {
        super.install4PlotGlyph(vanChartColumnPlotGlyph, chartData);
        vanChartColumnPlotGlyph.setSeriesOverlapPercent(this.getSeriesOverlapPercent());
        vanChartColumnPlotGlyph.setCategoryIntervalPercent(this.getCategoryIntervalPercent());
        vanChartColumnPlotGlyph.setFixedWidth(this.isFixedWidth());
        vanChartColumnPlotGlyph.setColumnWidth(this.getColumnWidth());
        vanChartColumnPlotGlyph.setFilledWithImage(this.isFilledWithImage());
        vanChartColumnPlotGlyph.setBar(this.isBar());
    }

    @Override
    protected List<VanChartAxis> getValueAxisList() {
        return this.isBar ? this.xAxisList : this.yAxisList;
    }

    @Override
    protected VanChartAxis getDefaultValueAxis() {
        return this.isBar ? this.getDefaultXAxis() : this.getDefaultYAxis();
    }

    @Override
    protected VanChartAxis getDefaultValueAxis(AttrSeriesStackAndAxis attrSeriesStackAndAxis) {
        return this.isBar ? this.getXAxisList().get(attrSeriesStackAndAxis.getXAxisIndex()) : this.getYAxisList().get(attrSeriesStackAndAxis.getYAxisIndex());
    }

    @Override
    protected void dealDataSeriesCustomCondition(VanChartDataSeries vanChartDataSeries, ConditionCollection conditionCollection) {
        this.dealDataSeriesAttrTrendLineCustomCondition(vanChartDataSeries, conditionCollection);
        this.dealDataSeriesAttrBackgroundCustomCondition(vanChartDataSeries, conditionCollection);
        this.dealDataSeriesAttrAlphaCustomCondition(vanChartDataSeries, conditionCollection);
    }

    @Override
    protected void dealDataPointCustomCondition(VanChartDataPoint vanChartDataPoint, ConditionCollection conditionCollection) {
        this.dealDataPointAttrFloatColorCustomCondition(vanChartDataPoint, conditionCollection);
        this.dealDataPointAttrTooltipCustomCondition(vanChartDataPoint, conditionCollection);
        this.dealDataPointAttrLabelCustomCondition(vanChartDataPoint, conditionCollection);
        this.dealDataPointAttrBackgroundCustomCondition(vanChartDataPoint, conditionCollection);
        this.dealDataPointAttrAlphaCustomCondition(vanChartDataPoint, conditionCollection);
        this.dealDataPointAttrBorderCustomCondition(vanChartDataPoint, conditionCollection);
        AttrSeriesImageBackground attrSeriesImageBackground = (AttrSeriesImageBackground)conditionCollection.getCustomDataSeriesCondition(AttrSeriesImageBackground.class, (Result)vanChartDataPoint);
        ((VanChartColumnDataPoint)vanChartDataPoint).setImageBackground(attrSeriesImageBackground);
    }

    @Override
    protected DataPoint createDataPoint() {
        return this.isBar ? new VanChartBarDataPoint() : new VanChartColumnDataPoint();
    }

    public ChartData defaultChartData() {
        VanChartAxis vanChartAxis;
        VanChartAxis vanChartAxis2 = vanChartAxis = this.isBar() ? this.getDefaultYAxis() : this.getDefaultXAxis();
        if (ComparatorUtils.equals((Object)((Object)vanChartAxis.getAxisType()), (Object)((Object)AxisType.AXIS_CATEGORY))) {
            return new NormalChartData(AXIS_CATEGORY, NORMAL_SERIES_NAME, NORMAL_VALUES);
        }
        if (ComparatorUtils.equals((Object)((Object)vanChartAxis.getAxisType()), (Object)((Object)AxisType.AXIS_VALUE))) {
            return new NormalChartData(AXIS_VALUE, VALUE_SERIES_NAME, VALUE_TIME_VALUES);
        }
        return new NormalChartData(AXIS_DATE, VALUE_SERIES_NAME, VALUE_TIME_VALUES);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof VanChartColumnPlot && super.equals(object) && ComparatorUtils.equals((Object)((VanChartColumnPlot)object).isBar(), (Object)this.isBar()) && ComparatorUtils.equals((Object)((VanChartColumnPlot)object).getCategoryIntervalPercent(), (Object)this.getCategoryIntervalPercent()) && ComparatorUtils.equals((Object)((VanChartColumnPlot)object).getSeriesOverlapPercent(), (Object)this.getSeriesOverlapPercent()) && ComparatorUtils.equals((Object)((VanChartColumnPlot)object).isFixedWidth(), (Object)this.isFixedWidth()) && ComparatorUtils.equals((Object)((VanChartColumnPlot)object).getColumnWidth(), (Object)this.getColumnWidth()) && ComparatorUtils.equals((Object)((VanChartColumnPlot)object).isFilledWithImage(), (Object)this.isFilledWithImage());
    }

    @Override
    protected void readPlotXML(XMLableReader xMLableReader) {
        super.readPlotXML(xMLableReader);
        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("VanChartColumnPlotAttr")) {
            this.isBar = xMLableReader.getAttrAsBoolean("isBar", false);
            this.seriesOverlapPercent = xMLableReader.getAttrAsDouble("seriesOverlapPercent", 0.0);
            this.categoryIntervalPercent = xMLableReader.getAttrAsDouble("categoryIntervalPercent", 0.0);
            this.fixedWidth = xMLableReader.getAttrAsBoolean("fixedWidth", false);
            this.columnWidth = xMLableReader.getAttrAsInt("columnWidth", 0);
            this.filledWithImage = xMLableReader.getAttrAsBoolean("filledWithImage", false);
            String string = xMLableReader.getAttrAsString("columnType", "old");
            if (!ComparatorUtils.equals((Object)string, (Object)"old")) {
                this.vanChartPlotType = VanChartPlotType.parse(string.toLowerCase().replace("column", ""));
            }
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("VanChartColumnPlotAttr").attr("seriesOverlapPercent", this.seriesOverlapPercent).attr("categoryIntervalPercent", this.categoryIntervalPercent).attr("fixedWidth", this.fixedWidth).attr("columnWidth", this.columnWidth).attr("filledWithImage", this.filledWithImage).attr("isBar", this.isBar);
        xMLPrintWriter.end();
    }

    @Override
    public String[] getLabelLocationNameArray() {
        return new String[]{Inter.getLocText((String)"Plugin-ChartF_Inside"), Inter.getLocText((String)"Plugin-ChartF_Outside"), Inter.getLocText((String)"Plugin-ChartF_Center")};
    }

    @Override
    public Integer[] getLabelLocationValueArray() {
        return new Integer[]{5, 6, 0};
    }

    public String getPlotName() {
        return Inter.getLocText((String)(this.isBar() ? "Plugin-ChartF_NewBar" : "Plugin-ChartF_NewColumn"));
    }

    public String getPlotID() {
        return this.isBar() ? VAN_CHART_BAR_PLOT_ID : VAN_CHART_COLUMN_PLOT_ID;
    }

    @Override
    public boolean isSupportDataSheet() {
        return !this.isBar;
    }

    @Override
    public boolean isSupportZoomCategoryAxis() {
        return !this.isBar();
    }

    public boolean matchPlotType(Plot plot) {
        return plot instanceof VanChartColumnPlot;
    }

    public boolean accept(Class<? extends Plot> clazz) {
        return ComparatorUtils.equals(VanChartColumnPlot.class, clazz);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        VanChartColumnPlot vanChartColumnPlot = (VanChartColumnPlot)super.clone();
        vanChartColumnPlot.setBar(this.isBar());
        return vanChartColumnPlot;
    }

    public FunctionProcessor getFunctionToRecord() {
        return this.isBar ? ChartFunctionProcessor.BAR_VAN_CHART : ChartFunctionProcessor.COLUMN_VAN_CHART;
    }
}

