/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.column;

import com.fr.chart.chartglyph.TopDownShadeChart;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.RectangularShape;

public class ColumnTopDownShadeStyle
extends TopDownShadeChart {
    protected RectangularShape rect;
    private boolean isHorizontal;
    private boolean axisReversed;
    private static final double NUM = 0.9;

    public ColumnTopDownShadeStyle(Color color, RectangularShape rectangularShape, boolean bl) {
        this(color, rectangularShape, bl, true, false);
    }

    public ColumnTopDownShadeStyle(Color color, RectangularShape rectangularShape, boolean bl, boolean bl2, boolean bl3) {
        this.baseColor = color;
        this.rect = rectangularShape;
        this.isHorizontal = bl;
        this.avoidOriginDraw = bl2;
        this.axisReversed = bl3;
    }

    public void paintStyle(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.drawColumn(graphics2D);
        this.drawBorder(graphics2D);
    }

    protected Color getEndColor() {
        return this.baseColor;
    }

    protected Color getStartColor() {
        this.baseColor = this.baseColor == null ? new Color(255, 255, 255, 0) : this.baseColor;
        return new Color(Math.min(255, (int)((double)this.baseColor.getRed() / 0.9)), Math.min(255, (int)((double)this.baseColor.getGreen() / 0.9)), Math.min(255, (int)((double)this.baseColor.getBlue() / 0.9)), this.baseColor.getAlpha());
    }

    private GradientPaint getGradientPaint() {
        Color color = this.getStartColor();
        Color color2 = this.getEndColor();
        if (this.isHorizontal) {
            if (this.axisReversed) {
                return new GradientPaint((float)this.rect.getX(), (float)this.rect.getY(), color, (float)(this.rect.getX() + this.rect.getWidth()), (float)this.rect.getY(), color2);
            }
            return new GradientPaint((float)(this.rect.getX() + this.rect.getWidth()), (float)this.rect.getY(), color, (float)this.rect.getX(), (float)this.rect.getY(), color2);
        }
        if (this.axisReversed) {
            return new GradientPaint((float)this.rect.getX(), (float)(this.rect.getY() + this.rect.getHeight()), color, (float)this.rect.getX(), (float)this.rect.getY(), color2);
        }
        return new GradientPaint((float)this.rect.getX(), (float)this.rect.getY(), color, (float)this.rect.getX(), (float)(this.rect.getY() + this.rect.getHeight()), color2);
    }

    protected void drawColumn(Graphics2D graphics2D) {
        Paint paint = graphics2D.getPaint();
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.alpha >= 0.0f ? this.alpha : 1.0f));
        graphics2D.setPaint(this.getGradientPaint());
        graphics2D.fill(this.rect);
        graphics2D.setComposite(composite);
        graphics2D.setPaint(paint);
    }

    protected void drawBorder(Graphics2D graphics2D) {
        if (this.borderColor == null || this.borderWidth == 0.0f) {
            return;
        }
        Stroke stroke = graphics2D.getStroke();
        BasicStroke basicStroke = new BasicStroke((int)this.borderWidth, 0, 1);
        graphics2D.setStroke(basicStroke);
        graphics2D.setPaint(this.borderColor);
        graphics2D.draw(this.rect);
        graphics2D.setStroke(stroke);
    }
}

