/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.bubble;

import com.fr.chart.chartglyph.ConditionAttr;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.Marker;
import com.fr.chart.chartglyph.MarkerGlyph;
import com.fr.general.Background;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.plugin.chart.attr.VanChartAttrHelper;
import com.fr.plugin.chart.base.AttrLabel;
import com.fr.plugin.chart.base.AttrTooltip;
import com.fr.plugin.chart.base.VanChartAttrMarker;
import com.fr.plugin.chart.bubble.VanChartBubbleDataPoint;
import com.fr.plugin.chart.bubble.attr.MaxAndMinDisplay;
import com.fr.plugin.chart.bubble.attr.VanChartAttrBubble;
import com.fr.plugin.chart.bubble.utils.DisplayType;
import com.fr.plugin.chart.bubble.utils.MaxAndMin;
import com.fr.plugin.chart.glyph.VanChartDataPoint;
import com.fr.plugin.chart.glyph.VanChartDataSeries;
import com.fr.plugin.chart.scatter.VanChartScatterDataPoint;
import com.fr.plugin.chart.scatter.VanChartScatterPlotGlyph;
import com.fr.plugin.chart.scatter.attr.ScatterAttrLabel;
import com.fr.plugin.chart.scatter.attr.ScatterAttrTooltip;
import com.fr.stable.web.Repository;
import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class VanChartBubblePlotGlyph
extends VanChartScatterPlotGlyph {
    private boolean forceBubble = false;
    protected VanChartAttrBubble defaultAttrBubble;
    private MaxAndMinDisplay maxAndMinDisplay = new MaxAndMinDisplay();
    private Map<String, VanChartBubbleDataPoint> seriesClusterMap = new HashMap<String, VanChartBubbleDataPoint>();

    public boolean isForceBubble() {
        return this.forceBubble;
    }

    public void setForceBubble(boolean bl) {
        this.forceBubble = bl;
    }

    @Override
    public String getChartType() {
        return "bubble";
    }

    @Override
    public JSONObject getPlotOptionsJSON(Repository repository, boolean bl) throws JSONException {
        JSONObject jSONObject = super.getPlotOptionsJSON(repository, bl);
        jSONObject.put("force", this.isForceBubble());
        VanChartAttrBubble vanChartAttrBubble = this.getDefaultAttrBubble();
        if (vanChartAttrBubble != null) {
            vanChartAttrBubble.toJSONObject(jSONObject, repository);
        } else {
            this.addNullBubbleJSON(jSONObject);
        }
        return jSONObject;
    }

    protected void addNullBubbleJSON(JSONObject jSONObject) throws JSONException {
    }

    public VanChartAttrBubble getDefaultAttrBubble() {
        if (this.defaultAttrBubble == null) {
            ConditionAttr conditionAttr = this.getConditionCollection().getDefaultAttr();
            this.defaultAttrBubble = (VanChartAttrBubble)conditionAttr.getExisted(VanChartAttrBubble.class);
        }
        return this.defaultAttrBubble;
    }

    @Override
    protected String getLabelText(AttrLabel attrLabel, VanChartDataPoint vanChartDataPoint) {
        if (this.forceBubble) {
            return VanChartAttrHelper.getLabelText(attrLabel.getContent(), vanChartDataPoint);
        }
        return VanChartAttrHelper.getScatterLabelText(attrLabel.getContent(), vanChartDataPoint);
    }

    @Override
    protected AttrLabel getDefaultAttrLabel() {
        if (this.defaultAttrLabel == null) {
            ConditionAttr conditionAttr = this.getConditionCollection().getDefaultAttr();
            this.defaultAttrLabel = this.isForceBubble() ? (AttrLabel)conditionAttr.getExisted(AttrLabel.class) : (ScatterAttrLabel)conditionAttr.getExisted(ScatterAttrLabel.class);
        }
        return this.defaultAttrLabel;
    }

    @Override
    protected AttrTooltip getDefaultAttrTooltip() {
        if (this.defaultAttrTooltip == null) {
            ConditionAttr conditionAttr = this.getConditionCollection().getDefaultAttr();
            this.defaultAttrTooltip = this.isForceBubble() ? (AttrTooltip)conditionAttr.getExisted(AttrTooltip.class) : (ScatterAttrTooltip)conditionAttr.getExisted(ScatterAttrTooltip.class);
        }
        return this.defaultAttrTooltip;
    }

    private double getDataPointRadius(VanChartBubbleDataPoint vanChartBubbleDataPoint, double d, double d2, VanChartAttrBubble vanChartAttrBubble) {
        if (d2 == d) {
            return vanChartAttrBubble.getMinDiameter() / 2.0;
        }
        double d3 = Math.abs(this.getDataPointValue(vanChartBubbleDataPoint));
        double d4 = vanChartAttrBubble.getMinDiameter() / 2.0;
        double d5 = vanChartAttrBubble.getMaxDiameter() / 2.0;
        return d4 + (d5 - d4) / (Math.sqrt(d2) - Math.sqrt(d)) * (Math.sqrt(d3) - Math.sqrt(d));
    }

    @Override
    public boolean isDisplayDataPointWithAttrBubble(VanChartScatterDataPoint vanChartScatterDataPoint) {
        VanChartBubbleDataPoint vanChartBubbleDataPoint = (VanChartBubbleDataPoint)vanChartScatterDataPoint;
        VanChartAttrBubble vanChartAttrBubble = vanChartBubbleDataPoint.getAttrBubble();
        double d = this.getDataPointValue(vanChartBubbleDataPoint);
        if (vanChartAttrBubble != null) {
            return this.isAvailable(vanChartAttrBubble, d);
        }
        vanChartAttrBubble = ((VanChartDataSeries)this.getSeries(vanChartBubbleDataPoint.getSeriesIndex())).getAttrBubble();
        if (vanChartAttrBubble != null) {
            return this.isAvailable(vanChartAttrBubble, d);
        }
        vanChartAttrBubble = (VanChartAttrBubble)this.getConditionCollection().getDefaultAttr().getExisted(VanChartAttrBubble.class);
        if (vanChartAttrBubble != null) {
            return this.isAvailable(vanChartAttrBubble, d);
        }
        return true;
    }

    @Override
    protected boolean isNullDisplay(VanChartScatterDataPoint vanChartScatterDataPoint) {
        return !this.isDataPointValueIsNull(vanChartScatterDataPoint);
    }

    @Override
    public boolean isDataPointValueIsNull(VanChartScatterDataPoint vanChartScatterDataPoint) {
        return this.isForceBubble() ? vanChartScatterDataPoint.isValueIsNull() : vanChartScatterDataPoint.isSizeIsNull();
    }

    private boolean isAvailable(VanChartAttrBubble vanChartAttrBubble, double d) {
        return vanChartAttrBubble.isDisplayNegative() || !(d < 0.0);
    }

    @Override
    protected void initAllBubbleDataPoint() {
        this.initAllDataPointDisplay();
        this.intMinAndMaxDisplay();
        this.initAllDataPointRadius();
        this.initAllDataPointPosition4ForceBubble();
    }

    private void intMinAndMaxDisplay() {
        int n = this.getSeriesSize();
        for (int i = 0; i < n; ++i) {
            VanChartDataSeries vanChartDataSeries = (VanChartDataSeries)this.getSeries(i);
            MaxAndMin maxAndMin = new MaxAndMin(-100.0, 100.0);
            this.maxAndMinDisplay.getSeriesMaxAndMinMap().put(vanChartDataSeries.getSeriesName(), maxAndMin);
            int n2 = vanChartDataSeries.getDataPointCount();
            for (int j = 0; j < n2; ++j) {
                double d;
                VanChartBubbleDataPoint vanChartBubbleDataPoint = (VanChartBubbleDataPoint)vanChartDataSeries.getDataPoint(j);
                if (vanChartBubbleDataPoint.getBubbleDisplay() == DisplayType.NO_DISPLAY) continue;
                VanChartAttrBubble vanChartAttrBubble = vanChartBubbleDataPoint.getAttrBubble();
                VanChartAttrBubble vanChartAttrBubble2 = vanChartDataSeries.getAttrBubble();
                if (vanChartAttrBubble != null) {
                    vanChartBubbleDataPoint.setBubbleDisplay(DisplayType.INDEPENDENT);
                    continue;
                }
                if (vanChartAttrBubble2 != null) {
                    vanChartBubbleDataPoint.setBubbleDisplay(DisplayType.IN_SERIES);
                    d = Math.abs(this.getDataPointValue(vanChartBubbleDataPoint));
                    if (d > maxAndMin.getMax()) {
                        maxAndMin.setMax(d);
                    }
                    if (!(d < maxAndMin.getMin())) continue;
                    maxAndMin.setMin(d);
                    continue;
                }
                vanChartBubbleDataPoint.setBubbleDisplay(DisplayType.IN_ALL);
                d = Math.abs(this.getDataPointValue(vanChartBubbleDataPoint));
                if (d > this.maxAndMinDisplay.getMaxAndMin().getMax()) {
                    this.maxAndMinDisplay.getMaxAndMin().setMax(d);
                }
                if (!(d < this.maxAndMinDisplay.getMaxAndMin().getMin())) continue;
                this.maxAndMinDisplay.getMaxAndMin().setMin(d);
            }
        }
    }

    private void initAllDataPointRadius() {
        int n = this.getSeriesSize();
        for (int i = 0; i < n; ++i) {
            VanChartDataSeries vanChartDataSeries = (VanChartDataSeries)this.getSeries(i);
            int n2 = vanChartDataSeries.getDataPointCount();
            for (int j = 0; j < n2; ++j) {
                MaxAndMin maxAndMin;
                VanChartAttrBubble vanChartAttrBubble;
                VanChartBubbleDataPoint vanChartBubbleDataPoint = (VanChartBubbleDataPoint)vanChartDataSeries.getDataPoint(j);
                if (vanChartBubbleDataPoint.getBubbleDisplay() == DisplayType.NO_DISPLAY) {
                    vanChartBubbleDataPoint.setRadius(0.0);
                    continue;
                }
                if (vanChartBubbleDataPoint.getBubbleDisplay() == DisplayType.IN_SERIES) {
                    vanChartAttrBubble = vanChartDataSeries.getAttrBubble();
                    maxAndMin = this.maxAndMinDisplay.getSeriesMaxAndMinMap().get(vanChartBubbleDataPoint.getSeriesName());
                    vanChartBubbleDataPoint.setRadius(this.getDataPointRadius(vanChartBubbleDataPoint, maxAndMin.getMin(), maxAndMin.getMax(), vanChartAttrBubble));
                    continue;
                }
                if (vanChartBubbleDataPoint.getBubbleDisplay() == DisplayType.IN_ALL) {
                    vanChartAttrBubble = this.getDefaultAttrBubble();
                    maxAndMin = this.maxAndMinDisplay.getMaxAndMin();
                    vanChartBubbleDataPoint.setRadius(this.getDataPointRadius(vanChartBubbleDataPoint, maxAndMin.getMin(), maxAndMin.getMax(), vanChartAttrBubble));
                    continue;
                }
                if (vanChartBubbleDataPoint.getBubbleDisplay() != DisplayType.INDEPENDENT) continue;
                vanChartAttrBubble = vanChartBubbleDataPoint.getAttrBubble();
                vanChartBubbleDataPoint.setRadius(vanChartAttrBubble.getMinDiameter() / 2.0);
            }
        }
    }

    private void initAllDataPointDisplay() {
        int n = this.getSeriesSize();
        for (int i = 0; i < n; ++i) {
            VanChartDataSeries vanChartDataSeries = (VanChartDataSeries)this.getSeries(i);
            int n2 = vanChartDataSeries.getDataPointCount();
            for (int j = 0; j < n2; ++j) {
                VanChartBubbleDataPoint vanChartBubbleDataPoint;
                vanChartBubbleDataPoint.setBubbleDisplay(this.isDisplayDataPoint(vanChartBubbleDataPoint = (VanChartBubbleDataPoint)vanChartDataSeries.getDataPoint(j)) ? DisplayType.IN_ALL : DisplayType.NO_DISPLAY);
            }
        }
    }

    @Override
    protected Rectangle2D getDataPointLabelBoundsWithPosition(Dimension2D dimension2D, Rectangle2D rectangle2D, int n, DataPoint dataPoint) {
        if (this.isForceBubble() && (dimension2D.getWidth() > Math.floor(Math.sqrt(2.0) * dataPoint.getShape().getBounds().getWidth() / 2.0) || dimension2D.getHeight() > Math.floor(Math.sqrt(2.0) * dataPoint.getShape().getBounds().getHeight() / 2.0))) {
            return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }
        double d = rectangle2D.getX() + (rectangle2D.getWidth() - dimension2D.getWidth()) / 2.0;
        double d2 = rectangle2D.getY() + (rectangle2D.getWidth() - dimension2D.getHeight()) / 2.0;
        return new Rectangle2D.Double(d, d2, dimension2D.getWidth(), dimension2D.getHeight());
    }

    @Override
    public double getDataPointValue(VanChartScatterDataPoint vanChartScatterDataPoint) {
        if (this.isForceBubble()) {
            return vanChartScatterDataPoint.getValue();
        }
        return vanChartScatterDataPoint.getSizeValue();
    }

    protected void initAllDataPointPosition4ForceBubble() {
        if (!this.isForceBubble()) {
            return;
        }
        this.calculateForceBubblePosition();
    }

    private void calculateForceBubblePosition() {
        int n = this.getSeriesSize();
        for (int i = 0; i < n; ++i) {
            this.seriesClusterMap.put(this.getSeries(i).getSeriesName(), this.getMaxForceBubble(i));
        }
        ArrayList<VanChartBubbleDataPoint> arrayList = new ArrayList<VanChartBubbleDataPoint>();
        for (int i = 0; i < n; ++i) {
            VanChartDataSeries vanChartDataSeries = (VanChartDataSeries)this.getSeries(i);
            int n2 = vanChartDataSeries.getDataPointCount();
            for (int j = 0; j < n2; ++j) {
                VanChartBubbleDataPoint vanChartBubbleDataPoint = (VanChartBubbleDataPoint)vanChartDataSeries.getDataPoint(j);
                arrayList.add(vanChartBubbleDataPoint);
            }
        }
        double[] dArray = new double[]{this.getBounds().getWidth(), this.getBounds().getHeight()};
        double d = 0.1;
        double d2 = 0.005;
        int n3 = 2;
        int n4 = 2;
        double d3 = 0.5;
        double d4 = 0.02;
        double d5 = 0.9;
        int n5 = (int)Math.ceil(this.getBounds().getWidth() / this.getBounds().getWidth());
        int n6 = (int)Math.ceil(Math.sqrt(arrayList.size() / n5));
        int n7 = n5 * n6;
        int n8 = (int)Math.floor(this.getBounds().getWidth() / (double)n7);
        int n9 = (int)Math.floor(this.getBounds().getHeight() / (double)n6);
        for (int i = 0; i < arrayList.size(); ++i) {
            ((VanChartBubbleDataPoint)((Object)arrayList.get(i))).setPosX(this.getBounds().getX() + (double)(i % n6 * n8));
            ((VanChartBubbleDataPoint)((Object)arrayList.get(i))).setPosY(this.getBounds().getY() + (double)(i / n7 * n9));
            ((VanChartBubbleDataPoint)((Object)arrayList.get(i))).setPx(((VanChartBubbleDataPoint)((Object)arrayList.get(i))).getPosX());
            ((VanChartBubbleDataPoint)((Object)arrayList.get(i))).setPy(((VanChartBubbleDataPoint)((Object)arrayList.get(i))).getPosY());
        }
        for (double d6 = d; d6 >= d2; d6 -= d6 > 0.07 ? 0.001 : (d6 > 0.01 ? 5.0E-4 : 5.0E-5)) {
            double d7;
            VanChartBubbleDataPoint vanChartBubbleDataPoint;
            double d8 = arrayList.size();
            double d9 = d6 * d4;
            double d10 = dArray[0] / 2.0;
            double d11 = dArray[1] / 2.0;
            int n10 = -1;
            while ((double)(++n10) < d8) {
                vanChartBubbleDataPoint = (VanChartBubbleDataPoint)((Object)arrayList.get(n10));
                vanChartBubbleDataPoint.setPosX(vanChartBubbleDataPoint.getPosX() + (d10 - vanChartBubbleDataPoint.getPosX()) * d9);
                vanChartBubbleDataPoint.setPosY(vanChartBubbleDataPoint.getPosY() + (d11 - vanChartBubbleDataPoint.getPosY()) * d9);
            }
            n10 = -1;
            while ((double)(++n10) < d8) {
                vanChartBubbleDataPoint = (VanChartBubbleDataPoint)((Object)arrayList.get(n10));
                double d12 = vanChartBubbleDataPoint.getPx();
                d7 = vanChartBubbleDataPoint.getPy();
                vanChartBubbleDataPoint.setPx(vanChartBubbleDataPoint.getPosX());
                vanChartBubbleDataPoint.setPy(vanChartBubbleDataPoint.getPosY());
                vanChartBubbleDataPoint.setPosX(vanChartBubbleDataPoint.getPosX() - (d12 - vanChartBubbleDataPoint.getPx()) * d5);
                vanChartBubbleDataPoint.setPosY(vanChartBubbleDataPoint.getPosY() - (d7 - vanChartBubbleDataPoint.getPy()) * d5);
            }
            for (n10 = 0; n10 < arrayList.size(); ++n10) {
                double d13;
                double d14;
                vanChartBubbleDataPoint = (VanChartBubbleDataPoint)((Object)arrayList.get(n10));
                VanChartBubbleDataPoint vanChartBubbleDataPoint2 = this.seriesClusterMap.get(vanChartBubbleDataPoint.getSeriesName());
                if (this.dataPointEquals(vanChartBubbleDataPoint2, vanChartBubbleDataPoint) || (d14 = Math.sqrt((d10 = vanChartBubbleDataPoint.getPosX() - vanChartBubbleDataPoint2.getPosX()) * d10 + (d11 = vanChartBubbleDataPoint.getPosY() - vanChartBubbleDataPoint2.getPosY()) * d11)) == (d13 = vanChartBubbleDataPoint.getRadius() + vanChartBubbleDataPoint2.getRadius())) continue;
                if (d14 != 0.0) {
                    d14 = (d14 - d13) / d14 * d6;
                }
                vanChartBubbleDataPoint.setPosX(vanChartBubbleDataPoint.getPosX() - (d10 *= d14));
                vanChartBubbleDataPoint.setPosY(vanChartBubbleDataPoint.getPosY() - (d11 *= d14));
                vanChartBubbleDataPoint2.setPosX(vanChartBubbleDataPoint2.getPosX() + d10);
                vanChartBubbleDataPoint2.setPosY(vanChartBubbleDataPoint2.getPosY() + d11);
            }
            for (n10 = 0; n10 < arrayList.size(); ++n10) {
                vanChartBubbleDataPoint = (VanChartBubbleDataPoint)((Object)arrayList.get(n10));
                for (int i = 0; i < arrayList.size(); ++i) {
                    double d15;
                    VanChartBubbleDataPoint vanChartBubbleDataPoint3 = (VanChartBubbleDataPoint)((Object)arrayList.get(i));
                    if (this.dataPointEquals(vanChartBubbleDataPoint3, vanChartBubbleDataPoint) || !((d7 = Math.sqrt((d10 = vanChartBubbleDataPoint.getPosX() - vanChartBubbleDataPoint3.getPosX()) * d10 + (d11 = vanChartBubbleDataPoint.getPosY() - vanChartBubbleDataPoint3.getPosY()) * d11)) < (d15 = vanChartBubbleDataPoint.getRadius() + vanChartBubbleDataPoint3.getRadius() + (double)(this.dataPointEquals(this.seriesClusterMap.get(vanChartBubbleDataPoint.getSeriesName()), this.seriesClusterMap.get(vanChartBubbleDataPoint3.getSeriesName())) ? n3 : n4)))) continue;
                    if (d7 != 0.0) {
                        d7 = (d7 - d15) / d7 * d3;
                    }
                    vanChartBubbleDataPoint.setPosX(vanChartBubbleDataPoint.getPosX() - (d10 *= d7));
                    vanChartBubbleDataPoint.setPosY(vanChartBubbleDataPoint.getPosY() - (d11 *= d7));
                    vanChartBubbleDataPoint3.setPosX(vanChartBubbleDataPoint3.getPosX() + d10);
                    vanChartBubbleDataPoint3.setPosY(vanChartBubbleDataPoint3.getPosY() + d11);
                }
            }
        }
    }

    private boolean dataPointEquals(VanChartBubbleDataPoint vanChartBubbleDataPoint, VanChartBubbleDataPoint vanChartBubbleDataPoint2) {
        return vanChartBubbleDataPoint.getSeriesIndex() == vanChartBubbleDataPoint2.getSeriesIndex() && vanChartBubbleDataPoint.getCategoryIndex() == vanChartBubbleDataPoint2.getCategoryIndex();
    }

    private VanChartBubbleDataPoint getMaxForceBubble(int n) {
        double d = -100.0;
        int n2 = 0;
        VanChartDataSeries vanChartDataSeries = (VanChartDataSeries)this.getSeries(n);
        int n3 = vanChartDataSeries.getDataPointCount();
        for (int i = 0; i < n3; ++i) {
            VanChartBubbleDataPoint vanChartBubbleDataPoint = (VanChartBubbleDataPoint)vanChartDataSeries.getDataPoint(i);
            double d2 = vanChartBubbleDataPoint.getValue();
            if (!(d2 > d)) continue;
            d = d2;
            n2 = i;
        }
        return (VanChartBubbleDataPoint)vanChartDataSeries.getDataPoint(n2);
    }

    @Override
    protected void dealMarkerShapeAndColor(Marker marker, VanChartAttrMarker vanChartAttrMarker, MarkerGlyph markerGlyph, VanChartScatterDataPoint vanChartScatterDataPoint, Color color, float f, float f2) {
        this.dealMarkerBackGround(marker, vanChartScatterDataPoint, color);
        double d = ((VanChartBubbleDataPoint)vanChartScatterDataPoint).getRadius();
        marker.setSize(d);
        this.setMakerGlyphShapeWithDataPoint(markerGlyph, f, f2, d, vanChartScatterDataPoint);
    }

    @Override
    protected void setMakerGlyphShapeWithDataPoint(MarkerGlyph markerGlyph, float f, float f2, double d, VanChartScatterDataPoint vanChartScatterDataPoint) {
        if (this.isForceBubble()) {
            VanChartBubbleDataPoint vanChartBubbleDataPoint = (VanChartBubbleDataPoint)vanChartScatterDataPoint;
            markerGlyph.setShape((Rectangle2D)new Rectangle2D.Double(vanChartBubbleDataPoint.getPosX() - d, vanChartBubbleDataPoint.getPosY() - d, d * 2.0, d * 2.0));
        } else {
            markerGlyph.setShape((Rectangle2D)new Rectangle2D.Double((double)f - d, (double)f2 - d, d * 2.0, d * 2.0));
        }
    }

    @Override
    protected Background getMarkerBackground() {
        return Marker.SCATTER_PLOT_BACKROUNG;
    }

    @Override
    protected boolean isNegative(VanChartScatterDataPoint vanChartScatterDataPoint) {
        return this.getDataPointValue(vanChartScatterDataPoint) < 0.0;
    }
}

