/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.base;

import com.fr.base.background.ColorBackground;
import com.fr.base.background.GradientBackground;
import com.fr.chart.base.DataSeriesCondition;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartglyph.GeneralInfo;
import com.fr.general.Background;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.plugin.chart.attr.VanChartAttrHelper;
import com.fr.plugin.chart.base.AttrTooltipContent;
import com.fr.stable.StableUtils;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;

public class AttrTooltip
extends DataSeriesCondition {
    public static final String XML_TAG = "AttrTooltip";
    private static final long serialVersionUID = 3276836768506510374L;
    private static final int DEFAULT_PADDING = 5;
    private boolean enable = true;
    protected AttrTooltipContent content;
    private boolean isCustom = false;
    private TextAttr textAttr = new TextAttr();
    private GeneralInfo generalInfo = VanChartAttrHelper.createDefaultTooltipBackground();
    private boolean isShowMutiSeries = false;
    private boolean followMouse = false;

    public AttrTooltip() {
        this.initAttrTooltipContent();
    }

    public void initAttrTooltipContent() {
        this.content = new AttrTooltipContent();
    }

    public void setEnable(boolean bl) {
        this.enable = bl;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setContent(AttrTooltipContent attrTooltipContent) {
        this.content = attrTooltipContent;
    }

    public void setCustom(boolean bl) {
        this.isCustom = bl;
    }

    public void setTextAttr(TextAttr textAttr) {
        this.textAttr = textAttr;
    }

    public void setGeneralInfo(GeneralInfo generalInfo) {
        this.generalInfo = generalInfo;
    }

    public void setFollowMouse(boolean bl) {
        this.followMouse = bl;
    }

    public void setShowMutiSeries(boolean bl) {
        this.isShowMutiSeries = bl;
    }

    public TextAttr getTextAttr() {
        return this.textAttr;
    }

    public boolean isCustom() {
        return this.isCustom;
    }

    public AttrTooltipContent getContent() {
        return this.content;
    }

    public GeneralInfo getGeneralInfo() {
        return this.generalInfo;
    }

    public boolean isShowMutiSeries() {
        return this.isShowMutiSeries;
    }

    public boolean isFollowMouse() {
        return this.followMouse;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Attr")) {
                this.enable = xMLableReader.getAttrAsBoolean("enable", true);
                this.isCustom = xMLableReader.getAttrAsBoolean("isCustom", true);
                this.followMouse = xMLableReader.getAttrAsBoolean("followMouse", false);
                this.isShowMutiSeries = xMLableReader.getAttrAsBoolean("showMutiSeries", false);
            } else if ("TextAttr".equals(string)) {
                this.setTextAttr((TextAttr)xMLableReader.readXMLObject((XMLReadable)new TextAttr()));
            } else if ("AttrToolTipContent".equals(string)) {
                this.readAttrTooltipContent(xMLableReader);
            } else if ("GI".equals(string)) {
                this.setGeneralInfo((GeneralInfo)xMLableReader.readXMLObject((XMLReadable)new GeneralInfo()));
            }
        }
    }

    protected void readAttrTooltipContent(XMLableReader xMLableReader) {
        this.setContent((AttrTooltipContent)xMLableReader.readXMLObject((XMLReadable)new AttrTooltipContent()));
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("Attr").attr("enable", this.enable).attr("followMouse", this.followMouse).attr("showMutiSeries", this.isShowMutiSeries).attr("isCustom", this.isCustom);
        xMLPrintWriter.end();
        if (this.textAttr != null) {
            this.textAttr.writeXML(xMLPrintWriter);
        }
        this.content.writeXML(xMLPrintWriter);
        this.generalInfo.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        Background background;
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("enabled", this.enable && this.content.hasLabelContent());
        jSONObject.put("animation", true);
        this.content.toJSONObject(jSONObject);
        jSONObject.put("follow", this.followMouse);
        jSONObject.put("shared", this.isShowMutiSeries);
        if (this.isCustom) {
            jSONObject.put("style", (Object)VanChartAttrHelper.getCSSFontJSONWithFont(this.textAttr.getFRFont()));
        }
        if ((background = this.generalInfo.getBackground()) != null && ComparatorUtils.equals((Object)background.getBackgroundType(), (Object)"ColorBackground")) {
            jSONObject.put("backgroundColor", (Object)VanChartAttrHelper.getRGBAColorWithColorAndAlpha(((ColorBackground)background).getColor(), this.generalInfo.getAlpha()));
        } else if (background != null && ComparatorUtils.equals((Object)background.getBackgroundType(), (Object)"GradientBackground")) {
            jSONObject.put("backgroundColor", (Object)VanChartAttrHelper.getGradientBackgroundJSON((GradientBackground)background, this.generalInfo.getAlpha()));
        }
        jSONObject.put("shadow", this.generalInfo.isShadow());
        if (this.generalInfo.getBorderColor() != null) {
            jSONObject.put("borderColor", (Object)StableUtils.javaColorToCSSColor((Color)this.generalInfo.getBorderColor()));
        } else {
            jSONObject.put("borderColor", (Object)"rgba(255,255,255,0)");
        }
        jSONObject.put("borderWidth", VanChartAttrHelper.getAxisLineStyle(this.generalInfo.getBorderStyle()));
        jSONObject.put("borderRadius", this.generalInfo.getRoundRadius());
        jSONObject.put("padding", 5);
        return jSONObject;
    }

    public boolean equals(Object object) {
        return object instanceof AttrTooltip && ComparatorUtils.equals((Object)((AttrTooltip)((Object)object)).isEnable(), (Object)this.isEnable()) && ComparatorUtils.equals((Object)((AttrTooltip)((Object)object)).getContent(), (Object)this.getContent()) && ComparatorUtils.equals((Object)((AttrTooltip)((Object)object)).isFollowMouse(), (Object)this.isFollowMouse()) && ComparatorUtils.equals((Object)((AttrTooltip)((Object)object)).isShowMutiSeries(), (Object)this.isShowMutiSeries()) && ComparatorUtils.equals((Object)((AttrTooltip)((Object)object)).getGeneralInfo(), (Object)this.getGeneralInfo()) && ComparatorUtils.equals((Object)((AttrTooltip)((Object)object)).isCustom(), (Object)this.isCustom()) && ComparatorUtils.equals((Object)((AttrTooltip)((Object)object)).getTextAttr(), (Object)this.getTextAttr());
    }

    public String getConditionType() {
        return XML_TAG;
    }
}

