/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.base;

import com.fr.chart.base.ChartUtils;
import com.fr.chart.base.DataSeriesCondition;
import com.fr.chart.base.TextAttr;
import com.fr.general.ComparatorUtils;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.plugin.chart.attr.VanChartAttrHelper;
import com.fr.plugin.chart.base.AttrLabelDetail;
import com.fr.plugin.chart.base.AttrTooltipContent;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;

public class AttrLabel
extends DataSeriesCondition {
    public static final String XML_TAG = "AttrLabel";
    private static final long serialVersionUID = 3276836768506510374L;
    private boolean enable = false;
    protected AttrLabelDetail attrLabelDetail;
    private AttrLabelDetail gaugeValueLabelDetail;

    public AttrLabel() {
        this.initAttrLabelDetail();
    }

    public void initAttrLabelDetail() {
        this.attrLabelDetail = new AttrLabelDetail();
    }

    public void setEnable(boolean bl) {
        this.enable = bl;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setGaugeValueLabelDetail(AttrLabelDetail attrLabelDetail) {
        this.gaugeValueLabelDetail = attrLabelDetail;
    }

    public AttrLabelDetail getGaugeValueLabelDetail() {
        return this.gaugeValueLabelDetail;
    }

    public AttrLabelDetail getAttrLabelDetail() {
        return this.attrLabelDetail;
    }

    public TextAttr getTextAttr() {
        return this.attrLabelDetail.getTextAttr();
    }

    public int getPosition() {
        return this.attrLabelDetail.getPosition();
    }

    public boolean isShowGuidLine() {
        return this.attrLabelDetail.isShowGuidLine();
    }

    public boolean isCustom() {
        return this.attrLabelDetail.isCustom();
    }

    public AttrTooltipContent getContent() {
        return this.attrLabelDetail.getContent();
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("labelAttr")) {
                this.enable = xMLableReader.getAttrAsBoolean("enable", false);
            } else if (string.equals("labelDetail")) {
                this.attrLabelDetail = (AttrLabelDetail)GeneralXMLTools.readXMLable((XMLableReader)xMLableReader);
            } else if (string.equals("gaugeValueLabel")) {
                this.gaugeValueLabelDetail = (AttrLabelDetail)GeneralXMLTools.readXMLable((XMLableReader)xMLableReader);
            } else if (string.equals("Attr")) {
                this.enable = xMLableReader.getAttrAsBoolean("enable", false);
                this.attrLabelDetail.setShowGuidLine(xMLableReader.getAttrAsBoolean("showLine", false));
                this.attrLabelDetail.setPosition(xMLableReader.getAttrAsInt("position", 1));
                this.attrLabelDetail.setCustom(xMLableReader.getAttrAsBoolean("isCustom", true));
            } else if ("TextAttr".equals(string)) {
                this.attrLabelDetail.setTextAttr((TextAttr)xMLableReader.readXMLObject((XMLReadable)new TextAttr()));
            } else if ("AttrToolTipContent".equals(string)) {
                this.attrLabelDetail.setContent((AttrTooltipContent)xMLableReader.readXMLObject((XMLReadable)new AttrTooltipContent()));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("labelAttr").attr("enable", this.enable).end();
        if (this.attrLabelDetail != null) {
            GeneralXMLTools.writeXMLable((XMLPrintWriter)xMLPrintWriter, (XMLable)this.attrLabelDetail, (String)"labelDetail");
        }
        if (this.gaugeValueLabelDetail != null) {
            GeneralXMLTools.writeXMLable((XMLPrintWriter)xMLPrintWriter, (XMLable)this.gaugeValueLabelDetail, (String)"gaugeValueLabel");
        }
        xMLPrintWriter.end();
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("enabled", this.enable && this.getContent().hasLabelContent());
        this.getContent().toJSONObject(jSONObject);
        jSONObject.put("align", (Object)ChartUtils.getPositionString((int)this.getPosition()));
        if (this.isCustom()) {
            jSONObject.put("style", (Object)VanChartAttrHelper.getCSSFontJSONWithFont(this.getTextAttr().getFRFont()));
        }
        if (this.getPosition() == 6) {
            jSONObject.put("connectorWidth", this.isShowGuidLine() ? 1 : 0);
        }
        return jSONObject;
    }

    public JSONObject toGaugeValueLabelJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("enabled", this.enable && this.getGaugeValueLabelDetail().getContent().hasLabelContent());
        this.getGaugeValueLabelDetail().getContent().toJSONObject(jSONObject);
        jSONObject.put("align", (Object)ChartUtils.getPositionString((int)this.getGaugeValueLabelDetail().getPosition()));
        if (this.getGaugeValueLabelDetail().isCustom()) {
            jSONObject.put("style", (Object)VanChartAttrHelper.getCSSFontJSONWithFont(this.getGaugeValueLabelDetail().getTextAttr().getFRFont()));
        }
        jSONObject.put("backgroundColor", (Object)VanChartAttrHelper.getStringColor(this.getGaugeValueLabelDetail().getBackgroundColor()));
        return jSONObject;
    }

    public boolean equals(Object object) {
        return object instanceof AttrLabel && ComparatorUtils.equals((Object)((AttrLabel)((Object)object)).isEnable(), (Object)this.isEnable()) && ComparatorUtils.equals((Object)((AttrLabel)((Object)object)).getAttrLabelDetail(), (Object)this.getAttrLabelDetail()) && ComparatorUtils.equals((Object)((AttrLabel)((Object)object)).getGaugeValueLabelDetail(), (Object)this.getGaugeValueLabelDetail());
    }

    public String getConditionType() {
        return XML_TAG;
    }
}

