/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.attr;

import com.fr.chart.chartattr.Legend;
import com.fr.chart.chartglyph.GeneralInfo;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.general.FRFont;
import com.fr.plugin.chart.glyph.VanChartLegendGlyph;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;

public class VanChartLegend
extends Legend {
    private static final long serialVersionUID = -338653804642389849L;
    public static final String XML_TAG = "Legend4VanChart";
    private boolean floating = false;
    private double floatPercentX;
    private double floatPercentY;
    private boolean limitSize = false;
    private double maxHeight = 15.0;

    public VanChartLegend() {
        this.setFRFont(FRFont.getInstance((String)"Microsoft YaHei", (int)0, (float)11.0f, (Color)new Color(102, 102, 102)));
        this.setBorderColor(new Color(204, 204, 204));
        this.setBorderStyle(0);
    }

    public void setFloating(boolean bl) {
        this.floating = bl;
    }

    public boolean isFloating() {
        return this.floating;
    }

    public void setFloatPercentX(double d) {
        this.floatPercentX = d;
    }

    public double getFloatPercentX() {
        return this.floatPercentX;
    }

    public void setFloatPercentY(double d) {
        this.floatPercentY = d;
    }

    public double getFloatPercentY() {
        return this.floatPercentY;
    }

    public void setLimitSize(boolean bl) {
        this.limitSize = bl;
    }

    public boolean isLimitSize() {
        return this.limitSize;
    }

    public void setMaxHeight(double d) {
        this.maxHeight = d;
    }

    public double getMaxHeight() {
        return this.maxHeight;
    }

    public VanChartLegendGlyph createLegendGlyph(PlotGlyph plotGlyph) {
        VanChartLegendGlyph vanChartLegendGlyph = new VanChartLegendGlyph();
        vanChartLegendGlyph.setFont(this.getFRFont());
        vanChartLegendGlyph.setGeneralInfo((GeneralInfo)this);
        vanChartLegendGlyph.setPosition(this.getPosition());
        vanChartLegendGlyph.setVisible(this.isLegendVisible());
        vanChartLegendGlyph.setFloating(this.isFloating());
        vanChartLegendGlyph.setFloatPercentX(this.getFloatPercentX());
        vanChartLegendGlyph.setFloatPercentY(this.getFloatPercentY());
        vanChartLegendGlyph.setMaxHeight(this.getMaxHeight());
        vanChartLegendGlyph.setLimitSize(this.isLimitSize());
        return vanChartLegendGlyph;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            this.readAttrXML(xMLableReader);
        }
    }

    protected void readAttrXML(XMLableReader xMLableReader) {
        String string = xMLableReader.getTagName();
        if ("Attr4VanChart".equals(string)) {
            this.setFloating(xMLableReader.getAttrAsBoolean("floating", false));
            this.setFloatPercentX(xMLableReader.getAttrAsInt("x", 0));
            this.setFloatPercentY(xMLableReader.getAttrAsInt("y", 0));
            this.setLimitSize(xMLableReader.getAttrAsBoolean("limitSize", false));
            this.setMaxHeight(xMLableReader.getAttrAsFloat("maxHeight", 0.0f));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        this.writeAttrXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    protected void writeAttrXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Attr4VanChart").attr("floating", this.isFloating()).attr("x", this.getFloatPercentX()).attr("y", this.getFloatPercentY()).attr("limitSize", this.isLimitSize()).attr("maxHeight", this.getMaxHeight()).end();
    }

    public boolean equals(Object object) {
        return object instanceof VanChartLegend && super.equals(object) && ((VanChartLegend)((Object)object)).isFloating() == this.isFloating() && ((VanChartLegend)((Object)object)).getFloatPercentX() == this.getFloatPercentX() && ((VanChartLegend)((Object)object)).getFloatPercentY() == this.getFloatPercentY() && ((VanChartLegend)((Object)object)).isLimitSize() == this.isLimitSize() && ((VanChartLegend)((Object)object)).getMaxHeight() == this.getMaxHeight();
    }

    public Object clone() throws CloneNotSupportedException {
        VanChartLegend vanChartLegend = (VanChartLegend)((Object)super.clone());
        vanChartLegend.setFloating(this.isFloating());
        vanChartLegend.setFloatPercentX(this.getFloatPercentX());
        vanChartLegend.setFloatPercentY(this.getFloatPercentY());
        vanChartLegend.setLimitSize(this.isLimitSize());
        vanChartLegend.setMaxHeight(this.getMaxHeight());
        return vanChartLegend;
    }
}

