/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.attr;

import com.fr.chart.chartglyph.Marker;
import com.fr.general.ComparatorUtils;
import com.fr.plugin.chart.glyph.marker.VanChartDiamondFilledMarker;
import com.fr.plugin.chart.glyph.marker.VanChartDiamondMarker;
import com.fr.plugin.chart.glyph.marker.VanChartNullMarker;
import com.fr.plugin.chart.glyph.marker.VanChartRoundFilledMarker;
import com.fr.plugin.chart.glyph.marker.VanChartRoundMarker;
import com.fr.plugin.chart.glyph.marker.VanChartSquareFilledMarker;
import com.fr.plugin.chart.glyph.marker.VanChartSquareMarker;
import com.fr.plugin.chart.glyph.marker.VanChartTriangleFilledMarker;
import com.fr.plugin.chart.glyph.marker.VanChartTriangleMarker;

public enum MarkerType {
    MARKER_NULL((Marker)new VanChartNullMarker()),
    MARKER_CIRCLE((Marker)new VanChartRoundFilledMarker()),
    MARKER_SQUARE((Marker)new VanChartSquareFilledMarker()),
    MARKER_DIAMOND((Marker)new VanChartDiamondFilledMarker()),
    MARKER_TRIANGLE((Marker)new VanChartTriangleFilledMarker()),
    MARKER_CIRCLE_HOLLOW((Marker)new VanChartRoundMarker()),
    MARKER_SQUARE_HOLLOW((Marker)new VanChartSquareMarker()),
    MARKER_DIAMOND_HOLLOW((Marker)new VanChartDiamondMarker()),
    MARKER_TRIANGLE_HOLLOW((Marker)new VanChartTriangleMarker());

    private Marker marker;
    private static MarkerType[] types;
    private static Marker[] markers;

    private MarkerType(Marker marker) {
        this.marker = marker;
    }

    public String getType() {
        return this.marker.getMarkerType();
    }

    private static MarkerType[] getTypes() {
        if (types == null) {
            types = MarkerType.values();
        }
        return types;
    }

    public static MarkerType parse(String string) {
        for (MarkerType markerType : MarkerType.getTypes()) {
            if (!ComparatorUtils.equals((Object)markerType.marker.getMarkerType(), (Object)string)) continue;
            return markerType;
        }
        return MARKER_NULL;
    }

    public static Marker[] getMarkers() {
        if (markers == null) {
            markers = new Marker[MarkerType.getTypes().length];
            int n = 0;
            for (MarkerType markerType : MarkerType.getTypes()) {
                MarkerType.markers[n++] = markerType.getMarker();
            }
        }
        return markers;
    }

    public Marker getMarker() {
        try {
            return (Marker)this.marker.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return new VanChartNullMarker();
        }
    }

    static {
        markers = null;
    }
}

