/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.area;

import com.fr.base.background.ColorBackground;
import com.fr.base.chart.Glyph;
import com.fr.chart.base.AttrColor;
import com.fr.chart.base.AttrLineStyle;
import com.fr.chart.base.ChartUtils;
import com.fr.chart.base.LineStyleInfo;
import com.fr.chart.chartglyph.ConditionAttr;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.FoldLine;
import com.fr.chart.chartglyph.MarkerGlyph;
import com.fr.chart.chartglyph.ShapeGlyph;
import com.fr.general.Background;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.plugin.chart.attr.AttrBand;
import com.fr.plugin.chart.base.AttrAreaSeriesFillColorBackground;
import com.fr.plugin.chart.glyph.VanChartBandGlyph;
import com.fr.plugin.chart.glyph.VanChartDataSeries;
import com.fr.plugin.chart.glyph.axis.VanChartBaseAxisGlyph;
import com.fr.plugin.chart.glyph.marker.VanChartMarkerGlyph;
import com.fr.plugin.chart.line.VanChartLinePlotGlyph;
import com.fr.stable.web.Repository;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;

public class VanChartAreaPlotGlyph
extends VanChartLinePlotGlyph {
    private static final long serialVersionUID = 7221168915757808571L;
    private AttrAreaSeriesFillColorBackground defaultAttrAreaSeriesFillColorBackground;

    private AttrAreaSeriesFillColorBackground getDefaultAttrAreaSeriesFillColorBackground() {
        if (this.defaultAttrAreaSeriesFillColorBackground == null) {
            ConditionAttr conditionAttr = this.getConditionCollection().getDefaultAttr();
            this.defaultAttrAreaSeriesFillColorBackground = (AttrAreaSeriesFillColorBackground)conditionAttr.getExisted(AttrAreaSeriesFillColorBackground.class);
        }
        return this.defaultAttrAreaSeriesFillColorBackground;
    }

    @Override
    public String getChartType() {
        return "area";
    }

    private AttrAreaSeriesFillColorBackground getAreaFillColorAndAlpha(VanChartDataSeries vanChartDataSeries) {
        AttrAreaSeriesFillColorBackground attrAreaSeriesFillColorBackground = vanChartDataSeries.getFillColorBackground();
        if (attrAreaSeriesFillColorBackground == null) {
            attrAreaSeriesFillColorBackground = this.getDefaultAttrAreaSeriesFillColorBackground();
        }
        return attrAreaSeriesFillColorBackground;
    }

    @Override
    protected void initXAxisLabelDrawPosition(VanChartBaseAxisGlyph vanChartBaseAxisGlyph) {
    }

    @Override
    protected void initDataSeriesGlyph(VanChartDataSeries vanChartDataSeries, GeneralPath generalPath, GeneralPath generalPath2, Color color, VanChartBaseAxisGlyph vanChartBaseAxisGlyph, int[] nArray, Point2D[] point2DArray, Point2D[] point2DArray2, Point2D[] point2DArray3) {
        boolean bl = this.isCurve(vanChartDataSeries);
        if (bl) {
            ChartUtils.curveTo((GeneralPath)generalPath, (GeneralPath)generalPath2);
            generalPath2.reset();
        }
        GeneralPath generalPath3 = (GeneralPath)generalPath.clone();
        this.dealAreaPath(bl, vanChartDataSeries, nArray, generalPath2, generalPath3, vanChartBaseAxisGlyph, point2DArray, point2DArray2, point2DArray3);
        this.dealLinePath(generalPath3, generalPath, vanChartDataSeries, color, vanChartBaseAxisGlyph);
    }

    private void dealAreaPath(boolean bl, VanChartDataSeries vanChartDataSeries, int[] nArray, GeneralPath generalPath, GeneralPath generalPath2, VanChartBaseAxisGlyph vanChartBaseAxisGlyph, Point2D[] point2DArray, Point2D[] point2DArray2, Point2D[] point2DArray3) {
        int n;
        double d = vanChartBaseAxisGlyph.getPoint2D(0.0).getY();
        boolean bl2 = this.isStep(vanChartDataSeries);
        boolean bl3 = this.isNullValueBreak(vanChartDataSeries);
        double d2 = 0.0;
        boolean bl4 = false;
        Point2D point2D = null;
        for (int i = n = nArray.length - 1; i >= 0; --i) {
            Point2D point2D2;
            int n2 = nArray[i];
            DataPoint dataPoint = vanChartDataSeries.getDataPoint(n2);
            Point2D point2D3 = point2D2 = dataPoint.getValue() < 0.0 ? point2DArray3[n2] : point2DArray2[n2];
            if (point2D2 == null) {
                point2D2 = new Point2D.Double(point2DArray[n2].getX(), d);
            }
            if (this.isDataPointXNotInPlotBounds((float)point2D2.getX())) continue;
            if (dataPoint.isValueIsNull() && !bl4 && bl3) {
                bl4 = true;
                this.completeAreaPath(bl, point2D, generalPath2, generalPath);
            } else if (bl4) {
                bl4 = false;
                Point2D point2D4 = point2DArray[n2];
                generalPath2.moveTo(point2D4.getX(), point2D4.getY());
                generalPath2.lineTo(point2D2.getX(), point2D2.getY());
                if (bl) {
                    generalPath.moveTo(point2D2.getX(), point2D2.getY());
                }
            } else {
                this.dealAreaPoint4EveryDataPoint(bl, bl2, i, n, point2D2, generalPath2, generalPath, d2);
                d2 = point2D2.getX();
            }
            if (i == 0) {
                this.completeAreaPath(bl, point2DArray[n2], generalPath2, generalPath);
            }
            if (dataPoint.isValueIsNull()) continue;
            point2D = point2DArray[n2];
        }
    }

    private void dealAreaPoint4EveryDataPoint(boolean bl, boolean bl2, int n, int n2, Point2D point2D, GeneralPath generalPath, GeneralPath generalPath2, double d) {
        if (bl) {
            if (n == n2) {
                generalPath.lineTo(point2D.getX(), point2D.getY());
                generalPath2.moveTo(point2D.getX(), point2D.getY());
            } else {
                generalPath2.lineTo(point2D.getX(), point2D.getY());
            }
        } else if (bl2) {
            if (n != n2) {
                generalPath.lineTo(d, point2D.getY());
            }
            generalPath.lineTo(point2D.getX(), point2D.getY());
        } else {
            generalPath.lineTo(point2D.getX(), point2D.getY());
        }
    }

    private void completeAreaPath(boolean bl, Point2D point2D, GeneralPath generalPath, GeneralPath generalPath2) {
        if (point2D != null) {
            if (bl) {
                ChartUtils.curveTo((GeneralPath)generalPath, (GeneralPath)generalPath2);
                generalPath2.reset();
            }
            generalPath.lineTo(point2D.getX(), point2D.getY());
        }
    }

    protected void dealLinePath(GeneralPath generalPath, GeneralPath generalPath2, VanChartDataSeries vanChartDataSeries, Color color, VanChartBaseAxisGlyph vanChartBaseAxisGlyph) {
        ColorBackground colorBackground;
        FoldLine foldLine = new FoldLine(generalPath2);
        vanChartDataSeries.setAreaTopLine(foldLine);
        ShapeGlyph shapeGlyph = new ShapeGlyph((Shape)generalPath);
        vanChartDataSeries.setDrawImpl((Glyph)shapeGlyph);
        LineStyleInfo lineStyleInfo = foldLine.getLineStyleInfo();
        AttrLineStyle attrLineStyle = new AttrLineStyle(this.getAttrLineWidth(vanChartDataSeries));
        lineStyleInfo.changeStyleAttrLineStyle(attrLineStyle);
        lineStyleInfo.changeStyleAttrColor(new AttrColor(color));
        AttrAreaSeriesFillColorBackground attrAreaSeriesFillColorBackground = this.getAreaFillColorAndAlpha(vanChartDataSeries);
        if (attrAreaSeriesFillColorBackground == null) {
            colorBackground = ColorBackground.getInstance((Color)color);
        } else {
            colorBackground = attrAreaSeriesFillColorBackground.getColorBackground();
            if (colorBackground == null) {
                colorBackground = ColorBackground.getInstance((Color)color);
            }
            shapeGlyph.setAlpha((float)attrAreaSeriesFillColorBackground.getAlpha());
        }
        shapeGlyph.setBackground((Background)colorBackground);
        this.dealBands(generalPath, generalPath2, vanChartDataSeries, color, vanChartBaseAxisGlyph, attrLineStyle);
    }

    @Override
    protected MarkerGlyph createMarkerGlyph() {
        return new VanChartMarkerGlyph(){

            protected boolean isNeedBorderBG() {
                return false;
            }
        };
    }

    protected void dealBands(GeneralPath generalPath, GeneralPath generalPath2, VanChartDataSeries vanChartDataSeries, Color color, VanChartBaseAxisGlyph vanChartBaseAxisGlyph, AttrLineStyle attrLineStyle) {
        List<AttrBand> list = vanChartDataSeries.getBands();
        for (AttrBand attrBand : list) {
            double d = vanChartBaseAxisGlyph.getPointInBounds(attrBand.getMinEval()).getY();
            double d2 = vanChartBaseAxisGlyph.getPointInBounds(attrBand.getMaxEval()).getY();
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, Math.min(d, d2), this.getBounds().getWidth(), Math.abs(d - d2));
            VanChartBandGlyph vanChartBandGlyph = new VanChartBandGlyph(generalPath2, double_);
            LineStyleInfo lineStyleInfo = vanChartBandGlyph.getLineStyleInfo();
            lineStyleInfo.changeStyleAttrLineStyle(attrLineStyle);
            Color color2 = attrBand.getColor();
            if (color2 == null) {
                color2 = color;
            }
            lineStyleInfo.changeStyleAttrColor(new AttrColor(color2));
            AttrAreaSeriesFillColorBackground attrAreaSeriesFillColorBackground = attrBand.getFillColorBackground();
            if (attrAreaSeriesFillColorBackground != null) {
                ShapeGlyph shapeGlyph = new ShapeGlyph((Shape)generalPath);
                shapeGlyph.setAlpha((float)attrAreaSeriesFillColorBackground.getAlpha());
                ColorBackground colorBackground = attrAreaSeriesFillColorBackground.getColorBackground();
                if (colorBackground == null) {
                    colorBackground = ColorBackground.getInstance((Color)color);
                }
                shapeGlyph.setBackground((Background)colorBackground);
                vanChartBandGlyph.setAreaGlyph(shapeGlyph);
            }
            vanChartDataSeries.addBandGlyph(vanChartBandGlyph);
        }
    }

    @Override
    public JSONObject getPlotOptionsJSON(Repository repository, boolean bl) throws JSONException {
        JSONObject jSONObject = super.getPlotOptionsJSON(repository, bl);
        AttrAreaSeriesFillColorBackground attrAreaSeriesFillColorBackground = this.getDefaultAttrAreaSeriesFillColorBackground();
        if (attrAreaSeriesFillColorBackground != null) {
            attrAreaSeriesFillColorBackground.addToJSONObject(jSONObject, null);
        }
        return jSONObject;
    }
}

