/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart;

import com.fr.base.chart.chartdata.ChartData;
import com.fr.chart.base.AttrBorder;
import com.fr.chart.base.ChartFunctionProcessor;
import com.fr.chart.base.DataSeriesCondition;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartdata.NormalChartData;
import com.fr.chart.chartglyph.ConditionAttr;
import com.fr.chart.chartglyph.ConditionCollection;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.plugin.chart.attr.VanChartLegend;
import com.fr.plugin.chart.attr.plot.VanChartLabelPositionPlot;
import com.fr.plugin.chart.attr.plot.VanChartPlot;
import com.fr.plugin.chart.base.AttrTooltip;
import com.fr.plugin.chart.base.ChartRoseType;
import com.fr.plugin.chart.glyph.VanChartDataPoint;
import com.fr.plugin.chart.glyph.VanChartDataSeries;
import com.fr.plugin.chart.pie.VanChartPieDataPoint;
import com.fr.plugin.chart.pie.VanChartPiePlotGlyph;
import com.fr.stable.fun.FunctionProcessor;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;

public class PiePlot4VanChart
extends VanChartPlot
implements VanChartLabelPositionPlot {
    private static final long serialVersionUID = 4333286862213569516L;
    public static final String VAN_CHART_PIE_PLOT = "VanChartPiePlot";
    public static final double START_ANGLE = 0.0;
    public static final double END_ANGLE = 360.0;
    private ChartRoseType roseType = ChartRoseType.PIE;
    private double innerRadiusPercent = 0.0;
    private double startAngle = 0.0;
    private double endAngle = 360.0;
    private boolean supportRotation = false;
    private static final String[] PIE_CATE = new String[]{"Pie1"};
    private static final String[] PIE_SERIES = new String[]{"PS1", "PS2", "PS3", "PS4", "PS5", "PS6"};
    private static final String[][] PIE_VALUE = new String[][]{{"45"}, {"26"}, {"13"}, {"9"}, {"6"}, {"1"}};
    private static final String[][] SAME_VALUE = new String[][]{{"50"}, {"40"}, {"32"}, {"25"}, {"20"}, {"16"}};
    private static final String[][] DIFFERENT_VALUE = new String[][]{{"50"}, {"40"}, {"32"}, {"25"}, {"20"}, {"16"}};
    private static final NormalChartData PIE_DATA = new NormalChartData((Object[])PIE_CATE, (Object[])PIE_SERIES, (Object[][])PIE_VALUE);
    private static final NormalChartData SAME_ARC_DATA = new NormalChartData((Object[])PIE_CATE, (Object[])PIE_SERIES, (Object[][])SAME_VALUE);
    private static final NormalChartData DIFFERENT_ARC_DATA = new NormalChartData((Object[])PIE_CATE, (Object[])PIE_SERIES, (Object[][])DIFFERENT_VALUE);

    public void setEndAngle(double d) {
        this.endAngle = d;
    }

    public void setInnerRadiusPercent(double d) {
        this.innerRadiusPercent = d;
    }

    public void setRoseType(ChartRoseType chartRoseType) {
        this.roseType = chartRoseType;
    }

    public void setStartAngle(double d) {
        this.startAngle = d;
    }

    public ChartRoseType getRoseType() {
        return this.roseType;
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public double getInnerRadiusPercent() {
        return this.innerRadiusPercent;
    }

    public double getEndAngle() {
        return this.endAngle;
    }

    public void setSupportRotation(boolean bl) {
        this.supportRotation = bl;
    }

    public boolean isSupportRotation() {
        return this.supportRotation;
    }

    public PiePlot4VanChart() {
        this.setLegend(new VanChartLegend());
        this.setBorderColor(new Color(238, 238, 238));
        this.setBorderStyle(0);
    }

    public String getPlotName() {
        return Inter.getLocText((String)"Plugin-ChartF_NewPie");
    }

    public PlotGlyph createPlotGlyph(ChartData chartData) {
        VanChartPiePlotGlyph vanChartPiePlotGlyph = new VanChartPiePlotGlyph();
        this.install4PlotGlyph(vanChartPiePlotGlyph, chartData);
        return vanChartPiePlotGlyph;
    }

    public void install4PlotGlyph(VanChartPiePlotGlyph vanChartPiePlotGlyph, ChartData chartData) {
        super.install4PlotGlyph(vanChartPiePlotGlyph, chartData);
        vanChartPiePlotGlyph.setRoseType(this.getRoseType());
        vanChartPiePlotGlyph.setStartAngle(this.getStartAngle());
        vanChartPiePlotGlyph.setEndAngle(this.getEndAngle());
        vanChartPiePlotGlyph.setInnerRadiusPercent(this.getInnerRadiusPercent());
        vanChartPiePlotGlyph.setSupportRotation(this.isSupportRotation());
    }

    @Override
    protected void dealDataSeriesCustomCondition(VanChartDataSeries vanChartDataSeries, ConditionCollection conditionCollection) {
        this.dealDataSeriesAttrBackgroundCustomCondition(vanChartDataSeries, conditionCollection);
        this.dealDataSeriesAttrAlphaCustomCondition(vanChartDataSeries, conditionCollection);
    }

    @Override
    protected void dealDataPointCustomCondition(VanChartDataPoint vanChartDataPoint, ConditionCollection conditionCollection) {
        this.dealDataPointAttrLabelCustomCondition(vanChartDataPoint, conditionCollection);
        this.dealDataPointAttrTooltipCustomCondition(vanChartDataPoint, conditionCollection);
        this.dealDataPointAttrAlphaCustomCondition(vanChartDataPoint, conditionCollection);
        this.dealDataPointAttrBorderCustomCondition(vanChartDataPoint, conditionCollection);
        this.dealDataPointAttrBackgroundCustomCondition(vanChartDataPoint, conditionCollection);
        this.dealDataPointAttrFloatColorCustomCondition(vanChartDataPoint, conditionCollection);
    }

    @Override
    protected DataPoint createDataPoint() {
        return new VanChartPieDataPoint();
    }

    public ChartData defaultChartData() {
        if (ComparatorUtils.equals((Object)((Object)this.getRoseType()), (Object)((Object)ChartRoseType.PIE_SAME_ARC))) {
            return SAME_ARC_DATA;
        }
        if (ComparatorUtils.equals((Object)((Object)this.getRoseType()), (Object)((Object)ChartRoseType.PIE_DIFFERENT_ARC))) {
            return DIFFERENT_ARC_DATA;
        }
        return PIE_DATA;
    }

    public boolean equals(Object object) {
        return object instanceof PiePlot4VanChart && super.equals(object) && ((PiePlot4VanChart)object).getRoseType() == this.getRoseType() && ((PiePlot4VanChart)object).getInnerRadiusPercent() == this.getInnerRadiusPercent() && ((PiePlot4VanChart)object).getStartAngle() == this.getStartAngle() && ((PiePlot4VanChart)object).getEndAngle() == this.getEndAngle() && ((PiePlot4VanChart)object).isSupportRotation() == this.isSupportRotation();
    }

    @Override
    protected void readPlotXML(XMLableReader xMLableReader) {
        String string;
        super.readPlotXML(xMLableReader);
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("PieAttr4VanChart")) {
            this.setRoseType(ChartRoseType.parse(xMLableReader.getAttrAsString("roseType", "")));
            this.setStartAngle(xMLableReader.getAttrAsDouble("startAngle", 0.0));
            this.setEndAngle(xMLableReader.getAttrAsDouble("endAngle", 0.0));
            this.setInnerRadiusPercent(xMLableReader.getAttrAsDouble("innerRadius", 0.0));
            this.setSupportRotation(xMLableReader.getAttrAsBoolean("supportRotation", false));
            xMLableReader.readXMLObject(new XMLReadable(){

                public void readXML(XMLableReader xMLableReader) {
                    if (xMLableReader.isChildNode()) {
                        AttrBorder attrBorder = (AttrBorder)xMLableReader.readXMLObject((XMLReadable)new AttrBorder());
                        if (PiePlot4VanChart.this.getConditionCollection() != null && PiePlot4VanChart.this.getConditionCollection().getDefaultAttr() != null && attrBorder != null) {
                            ConditionAttr conditionAttr = PiePlot4VanChart.this.getConditionCollection().getDefaultAttr();
                            if (conditionAttr.getExisted(AttrBorder.class) != null) {
                                conditionAttr.remove(AttrBorder.class);
                            }
                            conditionAttr.addDataSeriesCondition((DataSeriesCondition)attrBorder);
                        }
                    }
                }
            });
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("PieAttr4VanChart").attr("roseType", this.getRoseType().getRoseType()).attr("startAngle", this.getStartAngle()).attr("endAngle", this.getEndAngle()).attr("innerRadius", this.getInnerRadiusPercent()).attr("supportRotation", this.isSupportRotation());
        xMLPrintWriter.end();
    }

    @Override
    public String[] getLabelLocationNameArray() {
        return new String[]{Inter.getLocText((String)"Chart-In_Pie"), Inter.getLocText((String)"Chart-Out_Pie")};
    }

    @Override
    public Integer[] getLabelLocationValueArray() {
        return new Integer[]{5, 6};
    }

    public boolean matchPlotType(Plot plot) {
        return plot instanceof PiePlot4VanChart;
    }

    public boolean accept(Class<? extends Plot> clazz) {
        return ComparatorUtils.equals(PiePlot4VanChart.class, clazz);
    }

    public boolean isSupportCate() {
        return true;
    }

    public String getPlotID() {
        return VAN_CHART_PIE_PLOT;
    }

    public FunctionProcessor getFunctionToRecord() {
        return ChartFunctionProcessor.PIE_VAN_CHARTS;
    }

    public boolean isSupportLeadLine() {
        return true;
    }

    public boolean isHaveAxis() {
        return false;
    }

    @Override
    public AttrTooltip getDefaultAttrTooltip() {
        AttrTooltip attrTooltip = new AttrTooltip();
        attrTooltip.getContent().getSeriesFormat().setEnable(true);
        return attrTooltip;
    }
}

