/*
 * Decompiled with CFR 0.152.
 */
package com.fr.write.web.excel;

import com.fr.base.ExcelUtils;
import com.fr.base.Utils;
import com.fr.main.TemplateWorkBook;
import com.fr.report.ExtraReportClassManager;
import com.fr.report.fun.ExcelImportProcessor;
import com.fr.stable.StringUtils;
import com.fr.web.core.upload.SmartFile;
import com.fr.web.core.upload.SmartFiles;
import com.fr.web.core.upload.SmartUpload;
import com.fr.web.utils.WebUtils;
import com.fr.write.web.excel.DefaultExcelImporterProcessor;
import com.fr.write.web.excel.ExcelImportPlusProcessor;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebExcelUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TemplateWorkBook dealWithUploadExcel(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map<String, Object> map) throws Exception {
        int n2;
        ServletContext servletContext = httpServletRequest.getSession().getServletContext();
        SmartUpload smartUpload = new SmartUpload();
        smartUpload.initialize(servletContext, httpServletRequest, httpServletResponse);
        smartUpload.upload();
        SmartFiles smartFiles = smartUpload.getFiles();
        if (smartFiles.getSize() == 0L) {
            return null;
        }
        String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"fileIndex");
        int n3 = n2 = string == null ? 0 : Integer.parseInt(Utils.objectToString((Object)string));
        if (n2 < 0 || (long)n2 >= smartFiles.getSize()) {
            n2 = 0;
        }
        SmartFile smartFile = smartFiles.getFile(n2);
        String string2 = smartFile.getContentType();
        ByteArrayInputStream byteArrayInputStream = null;
        TemplateWorkBook templateWorkBook = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(smartFile.getBytes());
            if (StringUtils.isBlank((String)string2)) {
                throw new ExcelUploadException("typewrong");
            }
            String string3 = smartFile.getFileName().toLowerCase();
            ExcelImportProcessor excelImportProcessor = (ExcelImportProcessor)ExtraReportClassManager.getInstance().getSingle("ExcelImportProcessor");
            if (excelImportProcessor == null) {
                excelImportProcessor = ExcelUtils.checkThirdJarSupportPOI() ? new ExcelImportPlusProcessor() : new DefaultExcelImporterProcessor();
            }
            templateWorkBook = excelImportProcessor.generateWorkBookByStream(byteArrayInputStream, string3, map);
        }
        finally {
            if (byteArrayInputStream != null) {
                ((InputStream)byteArrayInputStream).close();
            }
        }
        return templateWorkBook;
    }

    public static TemplateWorkBook dealWithUploadExcel(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        return WebExcelUtils.dealWithUploadExcel(httpServletRequest, httpServletResponse, new HashMap<String, Object>());
    }

    public static class ExcelUploadException
    extends Exception {
        private ExcelUploadException(String string) {
            super(string);
        }
    }
}

