/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.output.json;

import com.fr.base.Base64;
import com.fr.base.DynamicNumberList;
import com.fr.base.FRContext;
import com.fr.base.chart.BaseChartPainter;
import com.fr.general.Background;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.json.JSONUtils;
import com.fr.page.ClippedPageProvider;
import com.fr.page.ReportHFProvider;
import com.fr.page.ReportPageAttrProvider;
import com.fr.page.ReportPageProvider;
import com.fr.page.ReportSettingsProvider;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.DefaultTemplateCellElement;
import com.fr.report.cell.FloatElement;
import com.fr.stable.ColumnRow;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.unit.UNIT;
import com.fr.stable.web.Repository;
import com.fr.web.output.AbstractOutlet;
import com.fr.web.output.Outlet;
import com.fr.web.output.common.ReportHFUtils;
import com.fr.web.output.exception.OutputException;
import com.fr.web.output.json.cell.CellBuildAction;
import com.fr.web.output.json.cell.CellColRowBuildAction;
import com.fr.web.output.json.cell.CellNameHyperlinkGroupBuildAction;
import com.fr.web.output.json.cell.CellStyleBuildAction;
import com.fr.web.output.json.cell.JSONCellOutlet;
import com.fr.web.output.json.cell.PageCellValueBuildAction;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONOutlet
extends AbstractOutlet<JSONObject> {
    private JSONObject output = new JSONObject();
    private JSONCellOutlet cellOutlet = this.createPageJSONCellOutlet();
    private ReportPageProvider reportPage;
    public Repository repo;
    private boolean showHeaderAndFooter;

    public JSONOutlet(ReportPageProvider reportPageProvider, Repository repository) {
        this.reportPage = reportPageProvider;
        this.repo = repository;
        this.cellOutlet.setRepository(repository);
    }

    public JSONObject out() throws Exception {
        this.reportPage.writePageIndex(this.output);
        ReportSettingsProvider reportSettingsProvider = this.reportPage.getReportSettings();
        int n2 = this.repo.getResolution();
        int n3 = this.reportPage.getWebPageWidth();
        int n4 = this.reportPage.getWebPageHeight();
        int n5 = this.reportPage.getMarginTop().toPixI(n2);
        int n6 = this.reportPage.getMarginLeft().toPixI(n2);
        int n7 = this.reportPage.getMarginBottom().toPixI(n2);
        int n8 = this.reportPage.getMarginRight().toPixI(n2);
        int n9 = n5 + (this.showHeaderAndFooter ? reportSettingsProvider.getHeaderHeight().toPixI(n2) : 0);
        this.output.putOpt("header", (Object)this.headerOutput(reportSettingsProvider, n5, n6, n8, n3));
        double d2 = n3 - n6 - n8;
        double d3 = (double)(n4 - n5 - n7) - reportSettingsProvider.getHeaderHeight().toPixD(n2) + reportSettingsProvider.getFooterHeight().toPixD(n2);
        Rectangle2D.Double double_ = new Rectangle2D.Double(n6, n9, d2, d3);
        NodeVisitor nodeVisitor = new NodeVisitor();
        this.output.putOpt("pageContent", (Object)this.pageContentOutput(double_, nodeVisitor));
        this.output.putOpt("charts", (Object)nodeVisitor.findsToJSONArray("simplechart"));
        this.output.putOpt("sessionID", (Object)this.repo.getSessionID());
        this.output.putOpt("footer", (Object)this.footerOutput(reportSettingsProvider, n6, n7, n8, n3, n4));
        return this.output;
    }

    private JSONObject pageLayoutInfoOutput(ClippedPageProvider clippedPageProvider) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        this.fillRowHeightAndColWidth(clippedPageProvider, jSONObject);
        this.fillRowAndColCount(clippedPageProvider, jSONObject);
        this.fillFrozenInfo(jSONObject);
        return jSONObject;
    }

    @Override
    public JSONObject headerOutput(ReportSettingsProvider reportSettingsProvider, int n2, int n3, int n4, int n5) throws JSONException {
        Rectangle2D.Double double_;
        ReportHFProvider reportHFProvider = this.reportPage.getHeader();
        if (reportHFProvider != null && ((RectangularShape)(double_ = new Rectangle2D.Double(n3, n2, n5 - n3 - n4, reportSettingsProvider.getHeaderHeight().toPixD(this.repo.getResolution())))).getWidth() > 0.0 && ((RectangularShape)double_).getHeight() > 0.0) {
            return this.createReportHF(reportHFProvider, double_, this.reportPage, this.repo);
        }
        return null;
    }

    @Override
    public JSONObject footerOutput(ReportSettingsProvider reportSettingsProvider, int n2, int n3, int n4, int n5, int n6) throws JSONException {
        Rectangle2D.Double double_;
        ReportHFProvider reportHFProvider = this.reportPage.getFooter();
        if (reportHFProvider != null && ((RectangularShape)(double_ = new Rectangle2D.Double(n2, (double)(n6 - n3) - reportSettingsProvider.getFooterHeight().toPixD(this.repo.getResolution()), n5 - n2 - n4, reportSettingsProvider.getFooterHeight().toPixD(this.repo.getResolution())))).getWidth() > 0.0 && ((RectangularShape)double_).getHeight() > 0.0) {
            this.createReportHF(reportHFProvider, double_, this.reportPage, this.repo);
        }
        return null;
    }

    public JSONObject pageContentOutput(Rectangle2D rectangle2D, NodeVisitor nodeVisitor) throws Exception {
        ClippedPageProvider[] clippedPageProviderArray;
        JSONObject jSONObject = new JSONObject();
        jSONObject.putOpt("background", (Object)this.createBackground(rectangle2D));
        JSONArray jSONArray = new JSONArray();
        jSONObject.put("detail", (Object)jSONArray);
        for (ClippedPageProvider clippedPageProvider : clippedPageProviderArray = this.reportPage.getPages()) {
            JSONObject jSONObject2 = (JSONObject)clippedPageProvider.output((Outlet)this, null, this.repo, "", nodeVisitor);
            jSONArray.put((Object)jSONObject2);
        }
        return jSONObject;
    }

    private JSONObject createReportHF(ReportHFProvider reportHFProvider, Rectangle2D rectangle2D, ReportPageProvider reportPageProvider, Repository repository) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        JSONUtils.putRectangle((JSONObject)jSONObject, (double)rectangle2D.getX(), (double)rectangle2D.getY(), (double)rectangle2D.getWidth(), (double)rectangle2D.getHeight());
        BufferedImage bufferedImage = ReportHFUtils.createReportHFBufferedImage(reportHFProvider, rectangle2D, reportPageProvider, repository);
        jSONObject.put("image", (Object)Base64.encode((Image)bufferedImage, (String)"png"));
        return jSONObject;
    }

    @Override
    public JSONObject clippedPageOutput(ClippedPageProvider clippedPageProvider, JSONObject jSONObject, String string, NodeVisitor nodeVisitor) throws JSONException, OutputException {
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("pageLayoutInfo", (Object)this.pageLayoutInfoOutput(clippedPageProvider));
        jSONObject2.put("cellData", (Object)this.cellsOutput(clippedPageProvider, nodeVisitor));
        JSONArray jSONArray = new JSONArray();
        jSONObject2.put("floats", (Object)jSONArray);
        Iterator iterator = clippedPageProvider.floatIterator();
        while (iterator.hasNext()) {
            FloatElement floatElement = (FloatElement)iterator.next();
            jSONArray.put((Object)this.writeFloatElement(floatElement));
        }
        this.fillClippedPageXY(clippedPageProvider, jSONObject2);
        return jSONObject2;
    }

    private JSONObject cellsOutput(ClippedPageProvider clippedPageProvider, NodeVisitor nodeVisitor) throws OutputException, JSONException {
        JSONObject jSONObject = new JSONObject();
        this.fillRowsInfo(clippedPageProvider, jSONObject, nodeVisitor);
        return jSONObject;
    }

    private void fillRowsInfo(ClippedPageProvider clippedPageProvider, JSONObject jSONObject, NodeVisitor nodeVisitor) throws OutputException, JSONException {
        JSONArray jSONArray = new JSONArray();
        for (int i2 = 0; i2 < clippedPageProvider.getRowCount(); ++i2) {
            JSONObject jSONObject2 = this.rowOutput(clippedPageProvider, i2, nodeVisitor);
            jSONArray.put((Object)jSONObject2);
        }
        jSONObject.put("rows", (Object)jSONArray);
    }

    private void fillFrozenInfo(JSONObject jSONObject) throws JSONException {
        ReportPageAttrProvider reportPageAttrProvider = this.reportPage.getReportPageAttr();
        if (reportPageAttrProvider == null) {
            return;
        }
        ColumnRow columnRow = reportPageAttrProvider.getFreezeColumnRow();
        if (columnRow != null) {
            jSONObject.put("frozenColumn", columnRow.getColumn());
            jSONObject.put("frozenRow", columnRow.getRow());
        }
    }

    private void fillRowHeightAndColWidth(ClippedPageProvider clippedPageProvider, JSONObject jSONObject) throws JSONException {
        jSONObject.put("rowHeight", (Object)this.getPixJsonArray(clippedPageProvider.getRowHeightDynamicPixList()));
        jSONObject.put("colWidth", (Object)this.getPixJsonArray(clippedPageProvider.getColumnWidthDynamicPixList()));
    }

    private void fillRowAndColCount(ClippedPageProvider clippedPageProvider, JSONObject jSONObject) throws JSONException {
        jSONObject.put("rowCount", clippedPageProvider.getRowCount());
        jSONObject.put("colCount", clippedPageProvider.getColumnCount());
    }

    private JSONArray getPixJsonArray(DynamicNumberList dynamicNumberList) {
        JSONArray jSONArray = new JSONArray();
        for (int i2 = 0; i2 < dynamicNumberList.size(); ++i2) {
            jSONArray.put(dynamicNumberList.get(i2));
        }
        return jSONArray;
    }

    private JSONObject rowOutput(ClippedPageProvider clippedPageProvider, int n2, NodeVisitor nodeVisitor) throws OutputException, JSONException {
        Object object;
        Iterator iterator = clippedPageProvider.getRow(n2);
        JSONObject jSONObject = new JSONObject();
        HashMap<Integer, DefaultTemplateCellElement> hashMap = new HashMap<Integer, DefaultTemplateCellElement>();
        for (int i2 = 0; i2 < clippedPageProvider.getColumnCount(); ++i2) {
            hashMap.put(i2, new DefaultTemplateCellElement(i2, n2, 1, 1, null));
        }
        JSONArray jSONArray = new JSONArray();
        while (iterator.hasNext()) {
            object = (CellElement)iterator.next();
            for (int i3 = object.getColumn(); i3 < object.getColumn() + object.getColumnSpan(); ++i3) {
                if (!hashMap.containsKey(i3)) continue;
                hashMap.remove(i3);
            }
            jSONArray.put((Object)this.createCellJson((CellElement)object, clippedPageProvider, nodeVisitor));
        }
        object = hashMap.values().iterator();
        while (object.hasNext()) {
            jSONArray.put((Object)this.createCellJson((CellElement)object.next(), clippedPageProvider, nodeVisitor));
        }
        List list = JSONUtils.JSONArrayToList((JSONArray)jSONArray);
        Collections.sort(list, new Comparator(){

            public int compare(Object object, Object object2) {
                try {
                    return ((JSONObject)object).getInt("col") - ((JSONObject)object2).getInt("col");
                }
                catch (JSONException jSONException) {
                    return -1;
                }
            }
        });
        hashMap.clear();
        jSONObject.put("row", n2);
        jSONObject.put("cells", (Object)new JSONArray((Collection)list));
        return jSONObject;
    }

    private JSONObject createCellJson(CellElement cellElement, ClippedPageProvider clippedPageProvider, NodeVisitor nodeVisitor) throws JSONException, OutputException {
        int n2 = this.sumPix(clippedPageProvider.getColumnWidthDynamicPixList(), cellElement.getColumn(), cellElement.getColumnSpan());
        int n3 = this.sumPix(clippedPageProvider.getRowHeightDynamicPixList(), cellElement.getRow(), cellElement.getRowSpan());
        Dimension dimension = new Dimension(n2, n3);
        this.cellOutlet.setCellDimension(dimension);
        this.cellOutlet.resetCell(cellElement);
        return this.cellOutlet.out(nodeVisitor);
    }

    private int sumPix(DynamicNumberList dynamicNumberList, int n2, int n3) {
        int n4 = 0;
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            n4 += dynamicNumberList.get(i2);
        }
        return n4;
    }

    @Override
    public JSONObject chartOutput(ClippedPageProvider clippedPageProvider, JSONObject jSONObject, BaseChartPainter baseChartPainter, Dimension dimension, NodeVisitor nodeVisitor) throws JSONException {
        JSONObject jSONObject2 = baseChartPainter.createJSONConfig(nodeVisitor, this.repo, dimension.width, dimension.height);
        this.fillClippedPageXY(clippedPageProvider, jSONObject2);
        return jSONObject2;
    }

    private void fillClippedPageXY(ClippedPageProvider clippedPageProvider, JSONObject jSONObject) throws JSONException {
        jSONObject.put("x", this.unitToPix(clippedPageProvider.getOffsetX()));
        jSONObject.put("y", this.unitToPix(clippedPageProvider.getOffsetY()));
        jSONObject.put("width", this.unitToPix(clippedPageProvider.getActualWidth()));
        jSONObject.put("height", this.unitToPix(clippedPageProvider.getActualHeight()));
    }

    private int unitToPix(UNIT uNIT) {
        return uNIT.toPixI(96);
    }

    private JSONObject writeFloatElement(FloatElement floatElement) {
        try {
            return floatElement.toJSONObject(this.repo);
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().error(jSONException.getMessage(), (Throwable)jSONException);
            return new JSONObject();
        }
    }

    private JSONObject createBackground(Rectangle2D rectangle2D) throws JSONException {
        ReportSettingsProvider reportSettingsProvider = this.reportPage.getReportSettings();
        Background background = reportSettingsProvider.getBackground();
        return background == null ? JSONObject.EMPTY : background.toJSONObject(this.repo, new Dimension((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight()));
    }

    private JSONCellOutlet createPageJSONCellOutlet() {
        CellBuildAction[] cellBuildActionArray;
        JSONCellOutlet jSONCellOutlet = new JSONCellOutlet();
        for (CellBuildAction cellBuildAction : cellBuildActionArray = new CellBuildAction[]{new CellColRowBuildAction(), new PageCellValueBuildAction(), new CellStyleBuildAction(), new CellNameHyperlinkGroupBuildAction()}) {
            jSONCellOutlet.addCellPutAction(cellBuildAction);
        }
        return jSONCellOutlet;
    }
}

