/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.process.reportprocess.operator;

import com.fr.base.FRContext;
import com.fr.json.JSONObject;
import com.fr.report.ExtraReportClassManager;
import com.fr.report.utils.ReportDelimiter;
import com.fr.stable.ArrayUtils;
import com.fr.web.core.process.ProcessUtils;
import com.fr.web.core.process.reportprocess.operator.ProcessOperator;
import com.fr.web.core.process.reportprocess.operator.creator.DefaultProcessOperatorCreator;
import com.fr.web.core.process.reportprocess.operator.creator.ProcessOperatorCreator;

public abstract class ProcessOperatorManager {
    private static final ProcessOperatorCreator DEFAULT_OPERATOR = new DefaultProcessOperatorCreator();

    public static ProcessOperator createOperator() {
        return ProcessOperatorManager.getCreator().createOperator();
    }

    public static ProcessOperator createOperator(String string) {
        return ProcessOperatorManager.getCreator().createOperator(string);
    }

    public static ProcessOperator createOperator(String string, String string2) {
        return ProcessOperatorManager.getCreator().createOperator(string, string2);
    }

    public static ProcessOperator createOperator(String string, int n2) {
        return ProcessOperatorManager.getCreator().createOperator(string, n2);
    }

    private static ProcessOperatorCreator getCreator() {
        ProcessOperatorCreator processOperatorCreator = (ProcessOperatorCreator)ExtraReportClassManager.getInstance().getSingle("ProcessOperatorCreator");
        if (processOperatorCreator == null) {
            processOperatorCreator = DEFAULT_OPERATOR;
        }
        return processOperatorCreator;
    }

    public static long[] getAllUserId(String string) {
        if (string == null) {
            return new long[0];
        }
        if (ReportDelimiter.containsRoleDelimiter(string)) {
            return ProcessOperatorManager.getRoleUserId(string);
        }
        return new long[]{ProcessUtils.getUserIdFromStr(string)};
    }

    public static long[] getRoleUserId(String string) {
        if (string == null || !ReportDelimiter.containsRoleDelimiter(string)) {
            return new long[0];
        }
        long[] lArray = new long[]{};
        String string2 = ReportDelimiter.getRoleId(string);
        if (ProcessOperatorManager.isCompanyRole(string)) {
            lArray = ArrayUtils.addAll((long[])lArray, (long[])ProcessUtils.P().getUsersByCompanyRoleId(ProcessUtils.getIdFromStr(string2)));
        } else if (ProcessOperatorManager.isCustomRole(string)) {
            lArray = ArrayUtils.addAll((long[])lArray, (long[])ProcessUtils.P().getUsersByCustomRoleId(ProcessUtils.getIdFromStr(string2)));
        }
        return lArray;
    }

    public static JSONObject getOperatorJSON(String string) {
        JSONObject jSONObject = new JSONObject();
        if (string == null) {
            return jSONObject;
        }
        try {
            String string2 = "";
            if (ReportDelimiter.containsRoleDelimiter(string)) {
                string2 = ProcessOperatorManager.getRoleName(string);
            } else {
                long l2 = ProcessUtils.getUserIdFromStr(string);
                string2 = ProcessUtils.getUserName(l2);
            }
            jSONObject.put("value", (Object)string);
            jSONObject.put("text", (Object)string2);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        return jSONObject;
    }

    public static boolean isCompanyRole(String string) {
        if (string == null) {
            return false;
        }
        if (!ReportDelimiter.containsRoleDelimiter(string)) {
            return false;
        }
        return Integer.parseInt(ReportDelimiter.getRoleType(string)) == 1;
    }

    public static boolean isCustomRole(String string) {
        if (string == null) {
            return false;
        }
        if (!ReportDelimiter.containsRoleDelimiter(string)) {
            return false;
        }
        return Integer.parseInt(ReportDelimiter.getRoleType(string)) == 2;
    }

    public static String getOperatorName(String string) {
        if (string == null) {
            return null;
        }
        if (!ReportDelimiter.containsRoleDelimiter(string)) {
            return ProcessUtils.getUserName(ProcessUtils.getUserIdFromStr(string));
        }
        return ProcessOperatorManager.getRoleName(string);
    }

    public static String getRoleName(String string) {
        long l2 = ProcessUtils.getIdFromStr(ReportDelimiter.getRoleId(string));
        if (ProcessOperatorManager.isCompanyRole(string)) {
            return ProcessUtils.getCompanyRoleName(l2);
        }
        return ProcessUtils.getCustomRoleName(l2);
    }

    public static int getOperatorType(String string) {
        if (string != null) {
            if (ReportDelimiter.containsRoleDelimiter(string)) {
                return 2;
            }
            return 1;
        }
        return -1;
    }
}

