/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.process.reportprocess;

import com.fr.base.FRContext;
import com.fr.base.platform.PlatformProvider;
import com.fr.base.platform.msg.MessageDataAccessObject;
import com.fr.base.platform.msg.MessageHelper;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.report.utils.ReportDelimiter;
import com.fr.stable.ArrayUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.web.ServletContext;
import com.fr.stable.web.ServletContextAdapter;
import com.fr.stable.web.ServletContextListener;
import com.fr.web.core.process.ProcessUtils;
import com.fr.web.core.process.reportprocess.AdvancedTaskQuery;
import com.fr.web.core.process.reportprocess.BaseTaskQuery;
import com.fr.web.core.process.reportprocess.IssueControl;
import com.fr.web.core.process.reportprocess.ProcessElement;
import com.fr.web.core.process.reportprocess.ProcessLog;
import com.fr.web.core.process.reportprocess.ProcessTask;
import com.fr.web.core.process.reportprocess.ProcessTaskImpl;
import com.fr.web.core.process.reportprocess.ReportProcess;
import com.fr.web.core.process.reportprocess.dao.AlertToastDAO;
import com.fr.web.core.process.reportprocess.dao.ProcessLogDAO;
import com.fr.web.core.process.reportprocess.dao.ProcessTaskDAO;
import com.fr.web.core.process.reportprocess.dao.ProcessTaskImplDAO;
import com.fr.web.core.process.reportprocess.dao.RemindToastDAO;
import com.fr.web.core.process.reportprocess.dao.ReportProcessDAO;
import com.fr.web.core.process.reportprocess.register.AlertToastRegister;
import com.fr.web.core.process.reportprocess.register.RemindToastRegister;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessManager {
    public static Map<Long, ProcessTaskImpl> REPORT_PROCESS_TABLE = new HashMap<Long, ProcessTaskImpl>(64);
    private static Map<Long, Timer> ISSUE_TIMER_TABLE = new HashMap<Long, Timer>(64);
    public static boolean cacheTask = true;
    public static final int CACHE_TASK_LIMIT = 1000;
    public static boolean initialized = false;
    public static final int TASK_ID_EXPEND = 1000000;
    public static final String START_TIME = "startTime";
    public static final String ONLY_ONCE = "onlyOnce";
    public static final long END_TIME = 157680000000L;

    public static void init() {
        if (initialized) {
            return;
        }
        ProcessManager.initTask();
        ProcessManager.initTaskImpl();
        ProcessManager.initOnComplete();
        initialized = true;
    }

    private static void initTask() {
        try {
            List<ProcessTask> list = ProcessTaskDAO.getInstance().listByFieldValue("issueOver", false);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                ProcessTask processTask = list.get(i2);
                processTask.onResume();
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
        }
    }

    private static void initTaskImpl() {
        try {
            List<ProcessTaskImpl> list = ProcessTaskImplDAO.getInstance().listByFieldValue("state", 4, 1);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                ProcessTaskImpl processTaskImpl = list.get(i2);
                ProcessManager.compatibleFlag(processTaskImpl);
                ProcessManager.addTask(processTaskImpl);
                processTaskImpl.onResume();
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
        }
    }

    private static void compatibleFlag(ProcessTaskImpl processTaskImpl) throws Exception {
        String string = String.valueOf(processTaskImpl.getTaskId());
        String string2 = String.valueOf(processTaskImpl.getFrTaskId());
        if (string.contains("123456789")) {
            processTaskImpl.setTaskId(Long.parseLong(string.replace("123456789", "00000")));
            processTaskImpl.setFrTaskId(Long.parseLong(string2.replace("123456789", "00000")));
            ProcessTaskImplDAO.getInstance().saveOrUpdate(processTaskImpl);
        }
    }

    private static void initOnComplete() {
        try {
            ProcessManager.initToast();
            initialized = true;
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
        }
    }

    private static void initToast() {
        MessageHelper.registerMessageDataAccessObject((String)"process_alert", (MessageDataAccessObject)AlertToastDAO.getInstance());
        MessageHelper.registerMessageDataAccessObject((String)"process_remind", (MessageDataAccessObject)RemindToastDAO.getInstance());
        AlertToastRegister.getInstance().registerMessages();
        RemindToastRegister.getInstance().registerMessages();
    }

    public static ProcessTaskImpl getTask(long l2) {
        ProcessTaskImpl processTaskImpl = REPORT_PROCESS_TABLE.get(l2);
        if (processTaskImpl != null) {
            return processTaskImpl;
        }
        try {
            return (ProcessTaskImpl)ProcessTaskImplDAO.getInstance().findByID(l2);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    public static void addTask(ProcessTaskImpl processTaskImpl) {
        if (cacheTask) {
            REPORT_PROCESS_TABLE.put(processTaskImpl.getId(), processTaskImpl);
        }
        if (REPORT_PROCESS_TABLE.size() > 1000) {
            REPORT_PROCESS_TABLE.clear();
            cacheTask = false;
        }
    }

    public static void removeTask(long l2) {
        REPORT_PROCESS_TABLE.remove(l2);
    }

    public static List<ProcessTaskImpl> getActiveTaskFromDB() {
        try {
            return ProcessTaskImplDAO.getInstance().listByFieldValue("state", 4, 1);
        }
        catch (Exception exception) {
            return new ArrayList<ProcessTaskImpl>();
        }
    }

    public static void issue(String string, ProcessTask processTask) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            String string2 = jSONObject.getString(START_TIME);
            Boolean bl = jSONObject.getBoolean(ONLY_ONCE);
            if (string != null && (StringUtils.isNotEmpty((String)string2) || !bl.booleanValue())) {
                IssueControl issueControl = new IssueControl(jSONObject);
                issueControl.issueTask(processTask);
            } else {
                processTask.issue();
                processTask.makeIssueOver();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void registerIssue(long l2, Timer timer) {
        Timer timer2 = ISSUE_TIMER_TABLE.get(l2);
        if (timer2 != null) {
            timer2.cancel();
        }
        ISSUE_TIMER_TABLE.put(l2, timer);
    }

    public static void clearIssue(long l2) {
        Timer timer = ISSUE_TIMER_TABLE.get(l2);
        if (timer != null) {
            timer.cancel();
        }
        ISSUE_TIMER_TABLE.remove(l2);
    }

    public static JSONArray getAllReportProcess(BaseTaskQuery baseTaskQuery, String string) throws Exception {
        return ProcessManager.getAllProcessOrTask(true, baseTaskQuery, string);
    }

    private static boolean matchWord(ProcessElement processElement, String string) {
        return string == null || string.length() == 0 || processElement.getName().contains(string) || ProcessUtils.getUserName(processElement.getCreatorId()).contains(string) || ProcessUtils.getUserDepartmentName(processElement.getCreatorId()).contains(string);
    }

    private static boolean matchWord(ProcessTaskImpl processTaskImpl, String string) {
        return string == null || string.length() == 0 || processTaskImpl.getName().contains(string) || ProcessUtils.getUserName(processTaskImpl.getCreatorId()).contains(string) || processTaskImpl.getAllSenderStr(true).contains(string) || ProcessManager.getTaskStateName(processTaskImpl.getState()).contains(string);
    }

    public static JSONArray getAllReportProcess(AdvancedTaskQuery advancedTaskQuery, String string) throws Exception {
        return ProcessManager.getAllProcessOrTask(true, advancedTaskQuery, string);
    }

    private static void addGroupInfo(List<String> list, List<Object> list2, List<Integer> list3, String string, Object object, Integer n2) {
        list.add(string);
        list2.add(object);
        list3.add(n2);
    }

    public static Map<Long, Boolean> getLockedProcessMap() throws Exception {
        return ProcessManager.getLockedProcessOrTask(true);
    }

    public static Map<Long, Boolean> getLockedTaskMap() throws Exception {
        return ProcessManager.getLockedProcessOrTask(false);
    }

    public static Map<Long, Boolean> getLockedProcessOrTask(boolean bl) {
        HashMap<Long, Boolean> hashMap = new HashMap<Long, Boolean>();
        if (cacheTask) {
            for (Long l2 : REPORT_PROCESS_TABLE.keySet()) {
                if (REPORT_PROCESS_TABLE.get(l2).isClosed()) continue;
                if (bl) {
                    hashMap.put(REPORT_PROCESS_TABLE.get(l2).getProcessId(), Boolean.TRUE);
                    continue;
                }
                hashMap.put(ProcessUtils.getTreatedTaskId(REPORT_PROCESS_TABLE.get(l2).getTaskId()), Boolean.TRUE);
            }
        } else {
            List<ProcessTaskImpl> list = ProcessManager.getActiveTaskFromDB();
            for (ProcessTaskImpl processTaskImpl : list) {
                if (processTaskImpl.isClosed()) continue;
                if (bl) {
                    hashMap.put(processTaskImpl.getProcessId(), Boolean.TRUE);
                    continue;
                }
                hashMap.put(ProcessUtils.getTreatedTaskId(processTaskImpl.getTaskId()), Boolean.TRUE);
            }
        }
        return hashMap;
    }

    public static JSONArray getAllTask(BaseTaskQuery baseTaskQuery, String string) throws Exception {
        return ProcessManager.getAllProcessOrTask(false, baseTaskQuery, string);
    }

    public static JSONArray getAllTask(AdvancedTaskQuery advancedTaskQuery, String string) throws Exception {
        return ProcessManager.getAllProcessOrTask(false, advancedTaskQuery, string);
    }

    private static JSONArray getAllProcessOrTask(boolean bl, BaseTaskQuery baseTaskQuery, String string) throws Exception {
        Object object;
        List<ProcessTask> list;
        boolean bl2;
        JSONArray jSONArray = new JSONArray();
        Map<Long, Boolean> map = bl ? ProcessManager.getLockedProcessMap() : ProcessManager.getLockedTaskMap();
        String string2 = "createTime";
        boolean bl3 = bl2 = ComparatorUtils.equals((String)baseTaskQuery.getSortBy(), (String)"createTime") && baseTaskQuery.isAsc();
        if (baseTaskQuery.isGetAll()) {
            list = bl ? ReportProcessDAO.getInstance().listByFieldsAndSort(null, null, null, string2, bl2) : ProcessTaskDAO.getInstance().listByFieldsAndSort(null, null, null, string2, bl2);
        } else {
            String[] stringArray = new String[]{"creatorId"};
            object = new Object[]{baseTaskQuery.getCreatorId()};
            int[] nArray = new int[]{0};
            list = bl ? ReportProcessDAO.getInstance().listByFieldsAndSort(stringArray, (Object[])object, nArray, string2, baseTaskQuery.isAsc()) : ProcessTaskDAO.getInstance().listByFieldsAndSort(stringArray, (Object[])object, nArray, string2, baseTaskQuery.isAsc());
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            object = list.get(i2);
            if (ProcessManager.matchWord((ProcessElement)object, string)) continue;
            list.remove(i2);
            --i2;
        }
        ProcessManager.sortAndPut(jSONArray, list, map, baseTaskQuery);
        return jSONArray;
    }

    private static JSONArray getAllProcessOrTask(boolean bl, AdvancedTaskQuery advancedTaskQuery, String string) throws Exception {
        JSONArray jSONArray = new JSONArray();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        if (advancedTaskQuery.getCreatorId() >= 0L) {
            ProcessManager.addGroupInfo(arrayList, arrayList2, arrayList3, "creatorId", advancedTaskQuery.getCreatorId(), 0);
        }
        if (advancedTaskQuery.getStartTime() != null) {
            ProcessManager.addGroupInfo(arrayList, arrayList2, arrayList3, "createTime", advancedTaskQuery.getStartTime(), 2);
        }
        if (advancedTaskQuery.getEndTime() != null) {
            ProcessManager.addGroupInfo(arrayList, arrayList2, arrayList3, "createTime", advancedTaskQuery.getEndTime(), 4);
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        Object[] objectArray = arrayList2.toArray(new Object[arrayList2.size()]);
        int[] nArray = ArrayUtils.toPrimitive((Integer[])arrayList3.toArray(new Integer[arrayList3.size()]));
        String string2 = "createTime";
        boolean bl2 = ComparatorUtils.equals((String)advancedTaskQuery.getSortBy(), (String)"createTime") && advancedTaskQuery.isAsc();
        List<ProcessTask> list = bl ? ReportProcessDAO.getInstance().listByFieldsAndSort(stringArray, objectArray, nArray, string2, bl2) : ProcessTaskDAO.getInstance().listByFieldsAndSort(stringArray, objectArray, nArray, string2, bl2);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ProcessElement processElement = list.get(i2);
            if (advancedTaskQuery.getDepartmentid() >= 0L && !ArrayUtils.contains((long[])ProcessUtils.getUserDepartmentIds(processElement.getCreatorId()), (long)advancedTaskQuery.getDepartmentid())) {
                list.remove(i2);
                --i2;
            }
            if (string == null || processElement.getName().contains(string)) continue;
            list.remove(i2);
            --i2;
        }
        ProcessManager.sortAndPut(jSONArray, list, ProcessManager.getLockedProcessMap(), advancedTaskQuery);
        return jSONArray;
    }

    private static void sortAndPut(JSONArray jSONArray, List list, Map<Long, Boolean> map, final BaseTaskQuery baseTaskQuery) throws Exception {
        if (ComparatorUtils.equals((String)baseTaskQuery.getSortBy(), (String)"creatorName")) {
            Collections.sort(list, new Comparator(){

                public int compare(Object object, Object object2) {
                    int n2 = ProcessUtils.getUserName(((ProcessElement)object).getCreatorId()).compareTo(ProcessUtils.getUserName(((ProcessElement)object2).getCreatorId()));
                    return baseTaskQuery.isAsc() ? n2 : n2 * -1;
                }
            });
        } else if (ComparatorUtils.equals((String)baseTaskQuery.getSortBy(), (String)"department")) {
            Collections.sort(list, new Comparator(){

                public int compare(Object object, Object object2) {
                    int n2 = ProcessUtils.getUserDepartmentName(((ProcessElement)object).getCreatorId()).compareTo(ProcessUtils.getUserDepartmentName(((ProcessElement)object2).getCreatorId()));
                    return baseTaskQuery.isAsc() ? n2 : n2 * -1;
                }
            });
        }
        Collections.sort(list, new Comparator(){

            public int compare(Object object, Object object2) {
                long l2;
                long l3 = ((ProcessElement)object).getCreatorId();
                if (l3 == (l2 = ((ProcessElement)object2).getCreatorId())) {
                    return 0;
                }
                if (l3 == baseTaskQuery.getUserid()) {
                    return -1;
                }
                if (l2 == baseTaskQuery.getUserid()) {
                    return 1;
                }
                return 0;
            }
        });
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ProcessElement processElement = (ProcessElement)list.get(i2);
            JSONObject jSONObject = processElement.createJSONObject();
            jSONObject.put("isSelfCreate", processElement.getCreatorId() == baseTaskQuery.getUserid());
            jSONObject.put("isLocked", map.get(processElement.getId()) != null);
            jSONArray.put((Object)jSONObject);
        }
    }

    public static JSONArray getAllTaskImpl(int n2, long l2, String string, String string2, boolean bl) throws Exception {
        if (n2 == 2) {
            return ProcessManager.getAllToDoTaskImpl(l2, string, string2, bl);
        }
        boolean bl2 = n2 == 0;
        List<ProcessTaskImpl> list = bl2 ? ProcessManager.getAllProcessTaskImplList(n2, l2, string, string2, bl) : ProcessManager.getAllProcessTaskImplHadDoneList(n2, l2, string, string2, bl);
        JSONArray jSONArray = new JSONArray();
        ProcessManager.sortAndPutTaskImpl(jSONArray, list, l2, string2, bl, false);
        return jSONArray;
    }

    private static List<ProcessTaskImpl> getAllProcessTaskImplHadDoneList(int n2, long l2, String string, String string2, boolean bl) throws Exception {
        List<ProcessTaskImpl> list = ProcessManager.getAllToDoTaskImplList(l2, string, string2, bl);
        List<ProcessTaskImpl> list2 = ProcessManager.getAllProcessTaskImplList(n2, l2, string, string2, bl);
        return ProcessManager.getTaskImplListHadDone(list, list2);
    }

    private static HashSet<Long> getTaskImplIds(List<ProcessTaskImpl> list) {
        HashSet<Long> hashSet = new HashSet<Long>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ProcessTaskImpl processTaskImpl = list.get(i2);
            hashSet.add(processTaskImpl.getId());
        }
        return hashSet;
    }

    private static List<ProcessTaskImpl> getAllProcessTaskImplList(int n2, long l2, String string, String string2, boolean bl) throws Exception {
        JSONArray jSONArray = new JSONArray();
        String string3 = "sendTime";
        boolean bl2 = ComparatorUtils.equals((String)string2, (String)"sendTime") && bl;
        List<ProcessTaskImpl> list = ProcessTaskImplDAO.getInstance().listAndSort(string3, bl2);
        if (l2 == -999L) {
            return ProcessManager.getFilterTaskImplListUnderAdmin(list, l2, string);
        }
        return ProcessManager.getFilterTaskImplListUnderUser(list, l2, string);
    }

    private static List<ProcessTaskImpl> getFilterTaskImplListUnderAdmin(List<ProcessTaskImpl> list, long l2, String string) throws Exception {
        HashSet<Long> hashSet = new HashSet<Long>();
        Iterator<ProcessTaskImpl> iterator = list.iterator();
        while (iterator.hasNext()) {
            boolean bl;
            ProcessTaskImpl processTaskImpl = iterator.next();
            long l3 = processTaskImpl.getFrTaskId();
            long l4 = l3 < 0L ? processTaskImpl.getTaskId() : l3;
            boolean bl2 = bl = l3 < 0L ? ProcessManager.findRepeat(hashSet, l4, processTaskImpl) : ProcessManager.fastFindRepeat(hashSet, l4, processTaskImpl);
            if (ProcessManager.notMatchTask(processTaskImpl, l2, true, string) || bl) {
                iterator.remove();
                continue;
            }
            hashSet.add(l4);
        }
        return list;
    }

    private static List<ProcessTaskImpl> getFilterTaskImplListUnderUser(List<ProcessTaskImpl> list, long l2, String string) throws Exception {
        ProcessTaskImpl processTaskImpl;
        HashSet<Long> hashSet = new HashSet<Long>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            processTaskImpl = list.get(i2);
            hashSet.add(processTaskImpl.getTaskId());
        }
        Iterator<ProcessTaskImpl> iterator = list.iterator();
        while (iterator.hasNext()) {
            processTaskImpl = iterator.next();
            long l3 = processTaskImpl.getTaskId();
            if (!ProcessManager.notMatchTask(processTaskImpl, l2, true, string) && !ProcessManager.findRepeat(hashSet, l3, processTaskImpl, l2)) continue;
            iterator.remove();
        }
        return ProcessManager.getFilterTaskImplListNotUnderTaker(list);
    }

    private static List<ProcessTaskImpl> getFilterTaskImplListNotUnderTaker(List<ProcessTaskImpl> list) {
        HashSet<Long> hashSet = new HashSet<Long>();
        Iterator<ProcessTaskImpl> iterator = list.iterator();
        while (iterator.hasNext()) {
            ProcessTaskImpl processTaskImpl = iterator.next();
            if (hashSet.contains(processTaskImpl.getTaskId()) && processTaskImpl.isNeedAllComplete()) {
                iterator.remove();
                continue;
            }
            hashSet.add(processTaskImpl.getTaskId());
        }
        return list;
    }

    private static List<ProcessTaskImpl> getAllToDoTaskImplList(long l2, String string, String string2, boolean bl) throws Exception {
        String string3 = "sendTime";
        boolean bl2 = ComparatorUtils.equals((String)string2, (String)"sendTime") && bl;
        List<ProcessTaskImpl> list = ProcessTaskImplDAO.getInstance().listByFieldsAndSort(new String[]{"state"}, new Object[]{4}, new int[]{1}, string3, bl2);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ProcessTaskImpl processTaskImpl = list.get(i2);
            if (ProcessManager.matchWord(processTaskImpl, string) && processTaskImpl.isUnderTakeBy(l2)) continue;
            list.remove(i2);
            --i2;
        }
        return list;
    }

    private static boolean findRepeat(HashSet<Long> hashSet, long l2, ProcessTaskImpl processTaskImpl, long l3) throws Exception {
        if (processTaskImpl.isNeedAllComplete() && !ArrayUtils.contains((long[])processTaskImpl.getCurrentNodeOperatorIds(), (long)l3)) {
            return false;
        }
        return hashSet.contains(l2) && !ArrayUtils.contains((Object[])processTaskImpl.getRouteNodeOperatorIds(), (Object)l3);
    }

    private static boolean findRepeat(HashSet<Long> hashSet, long l2, ProcessTaskImpl processTaskImpl) throws Exception {
        return hashSet.contains(l2) && processTaskImpl.isNeedAllComplete() && processTaskImpl.getOperatorNumFromCurrentNodeIdx() > 1;
    }

    private static boolean fastFindRepeat(HashSet<Long> hashSet, long l2, ProcessTaskImpl processTaskImpl) throws Exception {
        return hashSet.contains(l2) && processTaskImpl.isNeedAllComplete();
    }

    private static boolean notMatchTask(ProcessTaskImpl processTaskImpl, long l2, boolean bl, String string) throws Exception {
        return l2 != -999L && !processTaskImpl.isRelatedWith(l2) || !ProcessManager.matchWord(processTaskImpl, string) || !bl && !processTaskImpl.isCompletedBy(l2);
    }

    private static JSONArray getAllToDoTaskImpl(long l2, String string, String string2, boolean bl) throws Exception {
        JSONArray jSONArray = new JSONArray();
        List<ProcessTaskImpl> list = ProcessManager.getAllToDoTaskImplList(l2, string, string2, bl);
        ProcessManager.sortAndPutTaskImpl(jSONArray, list, l2, string2, bl, true);
        return jSONArray;
    }

    public static JSONArray getAllTaskImpl(int n2, long l2, long l3, long l4, String string, Date date, Date date2, Date date3, Date date4, int n3, int n4, String string2, boolean bl) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        if (n2 == 2) {
            ProcessManager.addGroupInfo(arrayList, arrayList2, arrayList3, "state", 4, 1);
        }
        if (date != null) {
            ProcessManager.addGroupInfo(arrayList, arrayList2, arrayList3, "sendTime", date, 2);
        }
        if (date2 != null) {
            ProcessManager.addGroupInfo(arrayList, arrayList2, arrayList3, "sendTime", date2, 4);
        }
        if (n3 >= 0) {
            ProcessManager.addGroupInfo(arrayList, arrayList2, arrayList3, "state", n3, 0);
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        Object[] objectArray = arrayList2.toArray(new Object[arrayList2.size()]);
        int[] nArray = ArrayUtils.toPrimitive((Integer[])arrayList3.toArray(new Integer[arrayList3.size()]));
        List<ProcessTaskImpl> list = ProcessTaskImplDAO.getInstance().listByFieldsAndSort(stringArray, objectArray, nArray, string2, bl);
        if (l4 != -1L) {
            Iterator<ProcessTaskImpl> iterator = list.iterator();
            while (iterator.hasNext()) {
                ProcessTaskImpl processTaskImpl = iterator.next();
                String string3 = processTaskImpl.getAllSender(true).toString();
                if (string3.indexOf(ProcessUtils.getUserNameById(l4)) >= 0) continue;
                iterator.remove();
            }
        }
        return ProcessManager.filterTaskImpl(list, l3, string, date3, date4, n4, l2, n2, string2, bl);
    }

    private static JSONArray filterTaskImpl(List<ProcessTaskImpl> list, long l2, String string, Date date, Date date2, int n2, long l3, int n3, String string2, boolean bl) throws Exception {
        JSONArray jSONArray = new JSONArray();
        list = l3 == -999L ? ProcessManager.getFilterTaskImplListUnderAdmin(list, l2, string, date, date2, n2, l3, n3, string2, bl) : ProcessManager.getFilterTaskImplListUnderUser(list, l2, string, date, date2, n2, l3, n3, string2, bl);
        ProcessManager.sortAndPutTaskImpl(jSONArray, list, l3, string2, bl, false);
        return jSONArray;
    }

    private static List<ProcessTaskImpl> getFilterTaskImplListUnderAdmin(List<ProcessTaskImpl> list, long l2, String string, Date date, Date date2, int n2, long l3, int n3, String string2, boolean bl) throws Exception {
        HashSet<Long> hashSet = new HashSet<Long>();
        Iterator<ProcessTaskImpl> iterator = list.iterator();
        while (iterator.hasNext()) {
            boolean bl2;
            ProcessTaskImpl processTaskImpl = iterator.next();
            long l4 = processTaskImpl.getTaskId();
            long l5 = ProcessUtils.getTreatedTaskId(l4);
            ProcessTask processTask = (ProcessTask)ProcessTaskDAO.getInstance().findByID(l5);
            long l6 = processTaskImpl.getFrTaskId() < 0L ? processTaskImpl.getTaskId() : processTaskImpl.getFrTaskId();
            boolean bl3 = bl2 = processTaskImpl.getFrTaskId() < 0L ? ProcessManager.findRepeat(hashSet, l6, processTaskImpl) : ProcessManager.fastFindRepeat(hashSet, l6, processTaskImpl);
            if (ProcessManager.notMatchTask(processTaskImpl, processTask, l2, l3, string, n3, n2, date, date2) || bl2) {
                iterator.remove();
                continue;
            }
            hashSet.add(l6);
        }
        return list;
    }

    private static List<ProcessTaskImpl> getTaskImplListHadDone(List<ProcessTaskImpl> list, List<ProcessTaskImpl> list2) {
        if (list.isEmpty()) {
            return list2;
        }
        HashSet<Long> hashSet = ProcessManager.getTaskImplIds(list);
        Iterator<ProcessTaskImpl> iterator = list2.iterator();
        while (iterator.hasNext()) {
            ProcessTaskImpl processTaskImpl = iterator.next();
            if (!hashSet.contains(processTaskImpl.getId())) continue;
            iterator.remove();
        }
        return list2;
    }

    private static List<ProcessTaskImpl> getFilterTaskImplListUnderUser(List<ProcessTaskImpl> list, long l2, String string, Date date, Date date2, int n2, long l3, int n3, String string2, boolean bl) throws Exception {
        Object object;
        HashSet<Long> hashSet = new HashSet<Long>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            object = list.get(i2);
            hashSet.add(((ProcessTaskImpl)object).getTaskId());
        }
        if (n3 != 1) {
            return ProcessManager.getFilterTaskImplList(list, l2, string, date, date2, n2, l3, n3, string2, bl, hashSet);
        }
        ArrayList<ProcessTaskImpl> arrayList = new ArrayList<ProcessTaskImpl>(list);
        object = ProcessManager.getFilterTaskImplList(list, l2, string, date, date2, n2, l3, 2, string2, bl, hashSet);
        List<ProcessTaskImpl> list2 = ProcessManager.getFilterTaskImplList(arrayList, l2, string, date, date2, n2, l3, 0, string2, bl, hashSet);
        return ProcessManager.getTaskImplListHadDone((List<ProcessTaskImpl>)object, list2);
    }

    private static List<ProcessTaskImpl> getFilterTaskImplList(List<ProcessTaskImpl> list, long l2, String string, Date date, Date date2, int n2, long l3, int n3, String string2, boolean bl, HashSet hashSet) throws Exception {
        Iterator<ProcessTaskImpl> iterator = list.iterator();
        while (iterator.hasNext()) {
            ProcessTaskImpl processTaskImpl = iterator.next();
            long l4 = processTaskImpl.getTaskId();
            long l5 = ProcessUtils.getTreatedTaskId(l4);
            ProcessTask processTask = (ProcessTask)ProcessTaskDAO.getInstance().findByID(l5);
            if (!ProcessManager.notMatchTask(processTaskImpl, processTask, l2, l3, string, n3, n2, date, date2) && !ProcessManager.findRepeat(hashSet, l4, processTaskImpl, l3)) continue;
            iterator.remove();
        }
        return ProcessManager.getFilterTaskImplListNotUnderTaker(list);
    }

    private static boolean notMatchTask(ProcessTaskImpl processTaskImpl, ProcessTask processTask, long l2, long l3, String string, int n2, int n3, Date date, Date date2) throws Exception {
        return processTaskImpl == null || processTask == null || l2 >= 0L && processTask.getCreatorId() != l2 || string != null && !processTask.getName().contains(string) || !ProcessManager.matchDeadLine(processTaskImpl, date, date2) || n3 >= 0 && processTaskImpl.getCurrentOperator().charAt(n3) != '1' || l3 != -999L && !processTaskImpl.isRelatedWith(l3) || n2 == 1 && !processTaskImpl.isCompletedBy(l3) || n2 == 2 && !processTaskImpl.isUnderTakeBy(l3);
    }

    private static boolean matchDeadLine(ProcessTaskImpl processTaskImpl, Date date, Date date2) {
        return processTaskImpl.getDeadLine() == null || (date == null || processTaskImpl.getDeadLine().after(date)) && (date2 == null || processTaskImpl.getDeadLine().before(date2));
    }

    private static void sortAndPutTaskImpl(JSONArray jSONArray, List<ProcessTaskImpl> list, long l2, String string, final boolean bl, boolean bl2) throws Exception {
        if (ComparatorUtils.equals((String)string, (String)"creatorName")) {
            Collections.sort(list, new Comparator<ProcessTaskImpl>(){

                @Override
                public int compare(ProcessTaskImpl processTaskImpl, ProcessTaskImpl processTaskImpl2) {
                    int n2 = ProcessUtils.getUserName(processTaskImpl.getCreatorId()).compareTo(ProcessUtils.getUserName(processTaskImpl2.getCreatorId()));
                    return bl ? n2 : n2 * -1;
                }
            });
        } else if (ComparatorUtils.equals((String)string, (String)"sender")) {
            Collections.sort(list, new Comparator<ProcessTaskImpl>(){

                @Override
                public int compare(ProcessTaskImpl processTaskImpl, ProcessTaskImpl processTaskImpl2) {
                    int n2 = processTaskImpl.getAllSenderStr(true).compareTo(processTaskImpl2.getAllSenderStr(true));
                    return bl ? n2 : n2 * -1;
                }
            });
        } else if (ComparatorUtils.equals((String)string, (String)"deadLine")) {
            Collections.sort(list, new Comparator<ProcessTaskImpl>(){

                @Override
                public int compare(ProcessTaskImpl processTaskImpl, ProcessTaskImpl processTaskImpl2) {
                    int n2 = processTaskImpl.getDeadLine() == null ? 0 : processTaskImpl.getDeadLine().compareTo(processTaskImpl2.getDeadLine());
                    return bl ? n2 : n2 * -1;
                }
            });
        } else if (ComparatorUtils.equals((String)string, (String)"stateName")) {
            Collections.sort(list, new Comparator<ProcessTaskImpl>(){

                @Override
                public int compare(ProcessTaskImpl processTaskImpl, ProcessTaskImpl processTaskImpl2) {
                    int n2 = processTaskImpl.getStateName().compareTo(processTaskImpl2.getStateName());
                    return bl ? n2 : n2 * -1;
                }
            });
        } else if (ComparatorUtils.equals((String)string, (String)"taskOpt")) {
            Collections.sort(list, new Comparator<ProcessTaskImpl>(){

                @Override
                public int compare(ProcessTaskImpl processTaskImpl, ProcessTaskImpl processTaskImpl2) {
                    int n2 = processTaskImpl.getCurrentOperatorName().compareTo(processTaskImpl2.getCurrentOperatorName());
                    return bl ? n2 : n2 * -1;
                }
            });
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ProcessTaskImpl processTaskImpl = list.get(i2);
            JSONObject jSONObject = processTaskImpl.createJSONObject(l2);
            if (!jSONObject.has("id")) continue;
            jSONObject.put("isTodo", bl2 || processTaskImpl.isUnderTakeBy(l2));
            jSONArray.put((Object)jSONObject);
        }
    }

    public static List<String> getUserOps(long l2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(ProcessUtils.getUserNameById(l2));
        PlatformProvider platformProvider = ProcessUtils.P();
        long[] lArray = platformProvider.getCompanyRolesByUserIdWithAllDepartment(l2);
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            arrayList.add(ReportDelimiter.getUserAndRoleString(1L, lArray[i2]));
        }
        long[] lArray2 = platformProvider.getCustomRolesByUserId(l2);
        for (int i3 = 0; i3 < lArray2.length; ++i3) {
            arrayList.add(ReportDelimiter.getUserAndRoleString(2L, lArray2[i3]));
        }
        return arrayList;
    }

    public static Date getDefaultEndTime() {
        Date date = new Date();
        date.setTime(date.getTime() + 157680000000L);
        return date;
    }

    public static void checkAlert(long l2) {
    }

    public static void checkRemind(long l2) {
    }

    public static void checkRemind(String string) {
    }

    public static void log(String string) {
        ProcessManager.log(null, string);
    }

    public static void log(String string, String string2) {
        ProcessManager.log(string, null, null, string2);
    }

    public static void log(long l2, ProcessTaskImpl processTaskImpl, String string) {
        ProcessManager.log(l2, processTaskImpl.getProcessId(), processTaskImpl.getTaskId(), string);
    }

    public static void log(long l2, String string, String string2, String string3) {
        ProcessManager.log(ProcessUtils.getUserName(l2), string, string2, string3);
    }

    public static void log(long l2, long l3, String string, String string2) {
        ProcessManager.log(ProcessUtils.getUserName(l2), ProcessManager.getProcessName(l3), string, string2);
    }

    public static void log(long l2, long l3, long l4, String string) {
        ProcessManager.log(ProcessUtils.getUserName(l2), ProcessManager.getProcessName(l3), ProcessManager.getTaskName(l4), string);
    }

    public static void log(String string, String string2, String string3, String string4) {
        ProcessLog processLog = new ProcessLog(string, string2, string3, string4);
        try {
            long l2 = ProcessLogDAO.getInstance().save(processLog);
            if (l2 <= 0L) {
                FRContext.getLogger().info("error on process log");
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
        }
    }

    public static void error(String string) {
        ProcessManager.error(null, null, null, string);
    }

    public static void error(long l2, ProcessTaskImpl processTaskImpl, String string) {
        ProcessManager.log(l2, processTaskImpl.getProcessId(), processTaskImpl.getTaskId(), string);
    }

    public static void error(long l2, String string, String string2, String string3) {
        ProcessManager.error(ProcessUtils.getUserName(l2), string, string2, string3);
    }

    public static void error(String string, String string2, String string3, String string4) {
        try {
            ProcessManager.log(string, string2, string3, string4);
            FRContext.getLogger().getRecordManager().recordErrorInfo(string2, (short)11, null, string4, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getTaskStateName(int n2) {
        switch (n2) {
            case 0: {
                return Inter.getLocText((String)"FR-Engine_Process_RP_To_Report");
            }
            case 1: {
                return Inter.getLocText((String)"FR-Engine_RP_To_Check");
            }
            case 2: {
                return Inter.getLocText((String)"FR-Engine_RP_Pass");
            }
            case 3: {
                return Inter.getLocText((String)"FR-Engine_RP_Rollback");
            }
            case 5: {
                return Inter.getLocText((String)"FR-Engine_RP_Overtime");
            }
            case 4: {
                return Inter.getLocText((String)"FR-Engine_Closed");
            }
        }
        return "";
    }

    public static String getTaskAuthorityName(int n2) {
        switch (n2) {
            case 0: {
                return Inter.getLocText((String)"FR-Engine_RP_Report");
            }
            case 1: {
                return Inter.getLocText((String)"FR-Engine_RP_Review");
            }
            case 2: {
                return Inter.getLocText((String)"FR-Engine_RP_Deliver");
            }
            case 3: {
                return Inter.getLocText((String)"FR-Engine_Close");
            }
            case 4: {
                return Inter.getLocText((String)"FR-Engine_Face_View");
            }
            case 5: {
                return Inter.getLocText((String)"FR-Engine_Note");
            }
            case 6: {
                return Inter.getLocText((String)"FR-Engine_RP_Process_View");
            }
            case 7: {
                return Inter.getLocText((String)"FR-Engine_Save");
            }
            case 8: {
                return Inter.getLocText((String)"FR-Engine_RP_Pass");
            }
            case 9: {
                return Inter.getLocText((String)"FR-Engine_RP_Rollback");
            }
            case 10: {
                return Inter.getLocText((String)"FR-Engine_RP_Report");
            }
        }
        return "";
    }

    public static String getTaskAuthorityName(String string, boolean bl) {
        if (string == null) {
            return "";
        }
        String string2 = "";
        int n2 = Math.min(5, string.length());
        for (int i2 = 0; i2 <= n2; ++i2) {
            if (string.charAt(i2) == '1') {
                string2 = string2 + ProcessManager.getTaskAuthorityName(i2);
            }
            string2 = string2 + " ";
        }
        if (bl) {
            string2 = string2 + Inter.getLocText((String)"FR-Engine_Offline");
        }
        return string2;
    }

    public static int getStateByAuthority(String string) {
        if (string == null || string.length() <= 5) {
            return -1;
        }
        if (string.charAt(0) == '1') {
            return 0;
        }
        if (string.charAt(1) == '1') {
            return 1;
        }
        return -1;
    }

    public static String getProcessName(long l2) {
        try {
            ReportProcess reportProcess = (ReportProcess)ReportProcessDAO.getInstance().findByID(l2);
            return reportProcess.getName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getTaskName(long l2) {
        try {
            long l3 = ProcessUtils.getTreatedTaskId(l2);
            ProcessTask processTask = (ProcessTask)ProcessTaskDAO.getInstance().findByID(l3);
            return processTask.getName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        ServletContext.addServletContextListener((ServletContextListener)new ServletContextAdapter(){

            public void onServletStop() {
                try {
                    for (Long l2 : ISSUE_TIMER_TABLE.keySet()) {
                        Timer timer = (Timer)ISSUE_TIMER_TABLE.get(l2);
                        timer.cancel();
                    }
                }
                catch (Throwable throwable) {
                    FRContext.getLogger().error("cancel timer-2 failed");
                }
            }
        });
    }
}

